/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Range;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.asJava.finder.JavaElementFinder;
import org.jetbrains.kotlin.idea.core.KotlinFileTypeFactoryUtils;
import org.jetbrains.kotlin.idea.debugger.FileRankingCalculatorForIde;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.stubindex.PackageIndexUtil;
import org.jetbrains.kotlin.idea.stubindex.StaticFacadeIndexUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J8\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J4\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u000e\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u0012\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u001f*\u00020 J\f\u0010!\u001a\u00020\u0011*\u00020\u0011H\u0002J\n\u0010\"\u001a\u00020\u0006*\u00020\u0011J\u0012\u0010#\u001a\u00020\u0011*\u00020\u00112\u0006\u0010$\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u00020\u00068GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/DebuggerUtils;", "", "()V", "IR_BACKEND_LAMBDA_REGEX", "Lkotlin/text/Regex;", "forceRanking", "", "getForceRanking", "()Z", "setForceRanking", "(Z)V", "findFilesByNameInPackage", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "fileName", "", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findSourceFileForClass", "scopes", "location", "Lcom/sun/jdi/Location;", "findSourceFileForClassIncludeLibrarySources", "scope", "isKotlinFakeLineNumber", "isKotlinSourceFile", "getBorders", "Lkotlin/ranges/ClosedRange;", "Lcom/sun/jdi/LocalVariable;", "getMethodNameWithoutMangling", "isGeneratedIrBackendLambdaMethodName", "trimIfMangledInBytecode", "isMangledInBytecode", "kotlin.jvm-debugger.util"})
public final class DebuggerUtils {
    private static boolean forceRanking;
    private static final Regex IR_BACKEND_LAMBDA_REGEX;
    @NotNull
    public static final DebuggerUtils INSTANCE;

    @TestOnly
    public final boolean getForceRanking() {
        return forceRanking;
    }

    public final void setForceRanking(boolean bl) {
        forceRanking = bl;
    }

    @Nullable
    public final KtFile findSourceFileForClassIncludeLibrarySources(@NotNull Project project2, @NotNull GlobalSearchScope scope2, @NotNull JvmClassName className2, @NotNull String fileName, @Nullable Location location2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return (KtFile)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtFile>(project2, scope2, className2, fileName, location2){
            final /* synthetic */ Project $project;
            final /* synthetic */ GlobalSearchScope $scope;
            final /* synthetic */ JvmClassName $className;
            final /* synthetic */ String $fileName;
            final /* synthetic */ Location $location;

            @Nullable
            public final KtFile invoke() {
                Object[] objectArray = new GlobalSearchScope[2];
                objectArray[0] = this.$scope;
                GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(project)");
                objectArray[1] = KotlinSourceFilterScope.Companion.librarySources(globalSearchScope, this.$project);
                return DebuggerUtils.INSTANCE.findSourceFileForClass(this.$project, CollectionsKt.listOf((Object[])objectArray), this.$className, this.$fileName, this.$location);
            }
            {
                this.$project = project2;
                this.$scope = globalSearchScope;
                this.$className = jvmClassName;
                this.$fileName = string;
                this.$location = location2;
                super(0);
            }
        });
    }

    public static /* synthetic */ KtFile findSourceFileForClassIncludeLibrarySources$default(DebuggerUtils debuggerUtils, Project project2, GlobalSearchScope globalSearchScope, JvmClassName jvmClassName, String string, Location location2, int n, Object object) {
        if ((n & 0x10) != 0) {
            location2 = null;
        }
        return debuggerUtils.findSourceFileForClassIncludeLibrarySources(project2, globalSearchScope, jvmClassName, string, location2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final KtFile findSourceFileForClass(@NotNull Project project2, @NotNull List<? extends GlobalSearchScope> scopes, @NotNull JvmClassName className2, @NotNull String fileName, @Nullable Location location2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
        Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (!this.isKotlinSourceFile(fileName)) {
            return null;
        }
        DumbService dumbService = DumbService.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)dumbService, (String)"DumbService.getInstance(project)");
        if (dumbService.isDumb()) {
            return null;
        }
        FqName fqName2 = className2.getFqNameForClassNameWithoutDollars();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"className.fqNameForClassNameWithoutDollars");
        FqName partFqName = fqName2;
        for (GlobalSearchScope globalSearchScope : scopes) {
            Object v2;
            List files2;
            Iterable iterable;
            block8: {
                void $this$singleOrNull$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                iterable = this.findFilesByNameInPackage(className2, fileName, project2, globalSearchScope);
                boolean $i$f$filter = false;
                void var12_13 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    KtFile it = (KtFile)element$iv$iv;
                    boolean bl = false;
                    if (!(JvmPlatformKt.isJvm((TargetPlatform)PlatformKt.getPlatform((KtElement)it)) || TargetPlatformKt.isCommon((TargetPlatform)PlatformKt.getPlatform((KtElement)it)))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                files2 = (List)destination$iv$iv;
                if (files2.isEmpty()) continue;
                if (files2.size() == 1 && !forceRanking || location2 == null) {
                    return (KtFile)CollectionsKt.first((List)files2);
                }
                $this$filter$iv = StaticFacadeIndexUtil.findFilesForFilePart(partFqName, globalSearchScope, project2);
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    KtFile it = (KtFile)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)fileName)) continue;
                    if (found$iv) {
                        v2 = null;
                        break block8;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v2 = !found$iv ? null : single$iv;
            }
            KtFile ktFile = v2;
            if (ktFile != null) {
                Iterable it = iterable = ktFile;
                boolean bl = false;
                return it;
            }
            return FileRankingCalculatorForIde.INSTANCE.findMostAppropriateSource(files2, location2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtFile> findFilesByNameInPackage(JvmClassName className2, String fileName, Project project2, GlobalSearchScope searchScope2) {
        void $this$filterTo$iv$iv;
        FqName fqName2 = className2.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"className.packageFqName");
        Iterable $this$filter$iv = PackageIndexUtil.INSTANCE.findFilesWithExactPackage(fqName2, searchScope2, project2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)fileName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List files2 = (List)destination$iv$iv;
        return CollectionsKt.sortedWith((Iterable)files2, (Comparator)JavaElementFinder.Companion.byClasspathComparator(searchScope2));
    }

    public final boolean isKotlinSourceFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String string = FileUtilRt.getExtension((String)fileName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtilRt.getExtension(fileName)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
        Locale locale2 = locale;
        String string3 = string2.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        String extension = string3;
        Intrinsics.checkNotNullExpressionValue((Object)KotlinFileTypeFactoryUtils.KOTLIN_EXTENSIONS, (String)"KotlinFileTypeFactoryUtils.KOTLIN_EXTENSIONS");
        return ArraysKt.contains((Object[])KotlinFileTypeFactoryUtils.KOTLIN_EXTENSIONS, (Object)extension);
    }

    @NotNull
    public final String trimIfMangledInBytecode(@NotNull String $this$trimIfMangledInBytecode, boolean isMangledInBytecode) {
        Intrinsics.checkNotNullParameter((Object)$this$trimIfMangledInBytecode, (String)"$this$trimIfMangledInBytecode");
        return isMangledInBytecode ? this.getMethodNameWithoutMangling($this$trimIfMangledInBytecode) : $this$trimIfMangledInBytecode;
    }

    private final String getMethodNameWithoutMangling(String $this$getMethodNameWithoutMangling) {
        return StringsKt.substringBefore$default((String)$this$getMethodNameWithoutMangling, (char)'-', null, (int)2, null);
    }

    public final boolean isKotlinFakeLineNumber(@NotNull Location location2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        try {
            if (location2.lineNumber("Kotlin") == 1 && Intrinsics.areEqual((Object)location2.sourceName("Kotlin"), (Object)"fake.kt") && Intrinsics.areEqual((Object)Path.of(location2.sourcePath("Kotlin"), new String[0]), (Object)Path.of("kotlin/jvm/internal/FakeKt", new String[0]))) {
                return true;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return false;
    }

    public final boolean isGeneratedIrBackendLambdaMethodName(@NotNull String $this$isGeneratedIrBackendLambdaMethodName) {
        Intrinsics.checkNotNullParameter((Object)$this$isGeneratedIrBackendLambdaMethodName, (String)"$this$isGeneratedIrBackendLambdaMethodName");
        CharSequence charSequence = $this$isGeneratedIrBackendLambdaMethodName;
        Regex regex = IR_BACKEND_LAMBDA_REGEX;
        return regex.matches(charSequence);
    }

    @Nullable
    public final ClosedRange<Location> getBorders(@NotNull LocalVariable $this$getBorders) {
        Intrinsics.checkNotNullParameter((Object)$this$getBorders, (String)"$this$getBorders");
        Range range2 = DebuggerUtilsImpl.getLocalVariableBorders((LocalVariable)$this$getBorders);
        if (range2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)range2, (String)"getLocalVariableBorders(this) ?: return null");
        Range range3 = range2;
        Comparable comparable = range3.getFrom();
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"range.from");
        Comparable comparable2 = range3.getTo();
        Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"range.to");
        return RangesKt.rangeTo((Comparable)comparable, (Comparable)comparable2);
    }

    private DebuggerUtils() {
    }

    static {
        DebuggerUtils debuggerUtils;
        INSTANCE = debuggerUtils = new DebuggerUtils();
        String string = ".+\\$lambda-\\d+";
        IR_BACKEND_LAMBDA_REGEX = new Regex(string);
    }
}

