/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.util.IncorrectOperationException;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.TemplateKind;
import org.jetbrains.kotlin.idea.core.TemplatesKt$WhenMappings;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\u00012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"ATTRIBUTE_FUNCTION_NAME", "", "ATTRIBUTE_PROPERTY_NAME", "FUNCTION_BODY_TEMPLATE", "PROPERTY_INITIALIZER_TEMPLATE", "SECONDARY_CONSTRUCTOR_BODY_TEMPLATE", "getFunctionBodyTextFromTemplate", "project", "Lcom/intellij/openapi/project/Project;", "kind", "Lorg/jetbrains/kotlin/idea/core/TemplateKind;", "name", "returnType", "classFqName", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin.fir.frontend-independent"})
public final class TemplatesKt {
    private static final String FUNCTION_BODY_TEMPLATE = "New Kotlin Function Body.kt";
    private static final String PROPERTY_INITIALIZER_TEMPLATE = "New Kotlin Property Initializer.kt";
    private static final String SECONDARY_CONSTRUCTOR_BODY_TEMPLATE = "New Kotlin Secondary Constructor Body.kt";
    private static final String ATTRIBUTE_FUNCTION_NAME = "FUNCTION_NAME";
    private static final String ATTRIBUTE_PROPERTY_NAME = "PROPERTY_NAME";

    @NotNull
    public static final String getFunctionBodyTextFromTemplate(@NotNull Project project2, @NotNull TemplateKind kind2, @Nullable String name2, @NotNull String returnType2, @Nullable FqName classFqName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)returnType2, (String)"returnType");
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)project2);
        Intrinsics.checkNotNull((Object)fileTemplateManager);
        FileTemplate fileTemplate = fileTemplateManager.getCodeTemplate(kind2.getTemplateFileName());
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"FileTemplateManager.getI\u2026te(kind.templateFileName)");
        FileTemplate fileTemplate2 = fileTemplate;
        Properties properties2 = new Properties();
        properties2.setProperty("RETURN_TYPE", returnType2);
        if (classFqName != null) {
            properties2.setProperty("CLASS_NAME", classFqName.asString());
            properties2.setProperty("SIMPLE_CLASS_NAME", classFqName.shortName().asString());
        }
        if (name2 != null) {
            String string2;
            switch (TemplatesKt$WhenMappings.$EnumSwitchMapping$0[kind2.ordinal()]) {
                case 1: 
                case 2: {
                    string2 = ATTRIBUTE_FUNCTION_NAME;
                    break;
                }
                case 3: {
                    string2 = ATTRIBUTE_PROPERTY_NAME;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String attribute = string2;
            properties2.setProperty(attribute, name2);
        }
        try {
            String string3 = fileTemplate2.getText(properties2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"fileTemplate.getText(properties)");
            string = string3;
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (Throwable e) {
            throw (Throwable)new IncorrectOperationException("Failed to parse file template", e);
        }
        return string;
    }

    public static /* synthetic */ String getFunctionBodyTextFromTemplate$default(Project project2, TemplateKind templateKind, String string, String string2, FqName fqName2, int n, Object object) {
        if ((n & 0x10) != 0) {
            fqName2 = null;
        }
        return TemplatesKt.getFunctionBodyTextFromTemplate(project2, templateKind, string, string2, fqName2);
    }
}

