/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.conversion.copy;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.actions.JavaToKotlinAction;
import org.jetbrains.kotlin.idea.configuration.ExperimentalFeatures;
import org.jetbrains.kotlin.idea.conversion.copy.ConversionResult;
import org.jetbrains.kotlin.idea.conversion.copy.ConvertJavaCopyPasteProcessorKt;
import org.jetbrains.kotlin.idea.conversion.copy.ElementAndTextList;
import org.jetbrains.kotlin.idea.conversion.copy.ElementsAndTextsProcessor;
import org.jetbrains.kotlin.idea.conversion.copy.KotlinPasteFromJavaDialog;
import org.jetbrains.kotlin.idea.editor.KotlinEditorOptions;
import org.jetbrains.kotlin.idea.j2k.IdeaJavaToKotlinServices;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.j2k.AfterConversionPass;
import org.jetbrains.kotlin.j2k.ConverterContext;
import org.jetbrains.kotlin.j2k.ConverterSettings;
import org.jetbrains.kotlin.j2k.ElementResult;
import org.jetbrains.kotlin.j2k.J2kConverterExtension;
import org.jetbrains.kotlin.j2k.JavaToKotlinConverter;
import org.jetbrains.kotlin.j2k.ParseContext;
import org.jetbrains.kotlin.j2k.PostProcessor;
import org.jetbrains.kotlin.j2k.Result;
import org.jetbrains.kotlin.j2k.WithProgressProcessor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a2\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0001\u001a&\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u0001H\u0000\u001a\n\u0010\u0018\u001a\u00020\u000b*\u00020\u0015\u00a8\u0006\u0019"}, d2={"checkUseNewJ2k", "", "targetFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "confirmConvertJavaOnPaste", "project", "Lcom/intellij/openapi/project/Project;", "isPlainText", "isNoConversionPosition", "file", "offset", "", "runPostProcessing", "", "bounds", "Lcom/intellij/openapi/util/TextRange;", "converterContext", "Lorg/jetbrains/kotlin/j2k/ConverterContext;", "useNewJ2k", "convertCodeToKotlin", "Lorg/jetbrains/kotlin/idea/conversion/copy/ConversionResult;", "Lorg/jetbrains/kotlin/idea/conversion/copy/ElementAndTextList;", "targetModule", "Lcom/intellij/openapi/module/Module;", "linesCount", "kotlin.idea"})
public final class ConvertJavaCopyPasteProcessorKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConversionResult convertCodeToKotlin(@NotNull ElementAndTextList $this$convertCodeToKotlin, @NotNull Project project2, @Nullable Module targetModule, boolean useNewJ2k) {
        void parseContext;
        void resultIndex;
        void results2;
        Object element$iv$iv;
        Result $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$convertCodeToKotlin, (String)"$this$convertCodeToKotlin");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        JavaToKotlinConverter converter = J2kConverterExtension.Companion.extension(useNewJ2k).createJavaToKotlinConverter(project2, targetModule, ConverterSettings.Companion.getDefaultSettings(), IdeaJavaToKotlinServices.INSTANCE);
        List<ElementResult> $this$filterIsInstance$iv = (List<ElementResult>)$this$convertCodeToKotlin.toList();
        boolean $i$f$filterIsInstance = false;
        List<ElementResult> list2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        Iterator iterator = $this$filterIsInstanceTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            if (!(element$iv$iv instanceof PsiElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List inputElements = (List)destination$iv$iv;
        $this$filterIsInstanceTo$iv$iv = (Result)ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(converter, inputElements){
            final /* synthetic */ JavaToKotlinConverter $converter;
            final /* synthetic */ List $inputElements;

            public final Result compute() {
                return (Result)ApplicationUtilsKt.runReadAction((Function0)new Function0<Result>(this){
                    final /* synthetic */ convertCodeToKotlin.1 this$0;

                    @NotNull
                    public final Result invoke() {
                        return this.this$0.$converter.elementsToKotlin(this.this$0.$inputElements);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.$converter = javaToKotlinConverter;
                this.$inputElements = list2;
            }
        }, JavaToKotlinAction.Companion.getTitle(), false, project2);
        $this$filterIsInstance$iv = $this$filterIsInstanceTo$iv$iv.component1();
        ConverterContext converterContext = $this$filterIsInstanceTo$iv$iv.component3();
        LinkedHashSet importsToAdd = new LinkedHashSet();
        destination$iv$iv = new Ref.IntRef();
        ((Ref.IntRef)destination$iv$iv).element = 0;
        StringBuilder convertedCodeBuilder = new StringBuilder();
        StringBuilder originalCodeBuilder = new StringBuilder();
        element$iv$iv = new Ref.ObjectRef();
        ((Ref.ObjectRef)element$iv$iv).element = null;
        $this$convertCodeToKotlin.process(new ElementsAndTextsProcessor(originalCodeBuilder, (List)results2, (Ref.IntRef)resultIndex, convertedCodeBuilder, (Ref.ObjectRef)parseContext, importsToAdd){
            final /* synthetic */ StringBuilder $originalCodeBuilder;
            final /* synthetic */ List $results;
            final /* synthetic */ Ref.IntRef $resultIndex;
            final /* synthetic */ StringBuilder $convertedCodeBuilder;
            final /* synthetic */ Ref.ObjectRef $parseContext;
            final /* synthetic */ LinkedHashSet $importsToAdd;

            public void processElement(@NotNull PsiElement element3) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                String originalText = element3.getText();
                this.$originalCodeBuilder.append(originalText);
                int n = this.$resultIndex.element;
                this.$resultIndex.element = n + 1;
                ElementResult result2 = (ElementResult)this.$results.get(n);
                if (result2 != null) {
                    this.$convertedCodeBuilder.append(result2.getText());
                    if ((ParseContext)((Object)this.$parseContext.element) == null) {
                        this.$parseContext.element = result2.getParseContext();
                    }
                    this.$importsToAdd.addAll((Collection)result2.getImportsToAdd());
                } else {
                    this.$convertedCodeBuilder.append(originalText);
                }
            }

            public void processText(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"string");
                this.$originalCodeBuilder.append(string);
                this.$convertedCodeBuilder.append(string);
            }
            {
                this.$originalCodeBuilder = $captured_local_variable$0;
                this.$results = $captured_local_variable$1;
                this.$resultIndex = $captured_local_variable$2;
                this.$convertedCodeBuilder = $captured_local_variable$3;
                this.$parseContext = $captured_local_variable$4;
                this.$importsToAdd = $captured_local_variable$5;
            }
        });
        String string = convertedCodeBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertedCodeBuilder.toString()");
        String convertedCode = string;
        String string2 = originalCodeBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"originalCodeBuilder.toString()");
        String originalCode = string2;
        ParseContext parseContext2 = (ParseContext)((Object)parseContext.element);
        if (parseContext2 == null) {
            parseContext2 = ParseContext.CODE_BLOCK;
        }
        return new ConversionResult(convertedCode, parseContext2, importsToAdd, Intrinsics.areEqual((Object)convertedCode, (Object)originalCode) ^ true, converterContext);
    }

    public static final boolean isNoConversionPosition(@NotNull KtFile file2, int offset2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (offset2 == 0) {
            return false;
        }
        PsiElement psiElement2 = file2.findElementAt(offset2 - 1);
        if (psiElement2 == null) {
            return true;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"file.findElementAt(offset - 1) ?: return true");
        PsiElement token = psiElement2;
        if (!(token instanceof PsiWhiteSpace) && PsiUtilsKt.getEndOffset((PsiElement)token) != offset2) {
            return true;
        }
        for (PsiElement element3 : PsiUtilsKt.getParentsWithSelf((PsiElement)token)) {
            PsiElement psiElement3 = element3;
            if (psiElement3 instanceof PsiComment) {
                ASTNode aSTNode = ((PsiComment)element3).getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"element.node");
                return Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)KtTokens.EOL_COMMENT) || offset2 != PsiUtilsKt.getEndOffset((PsiElement)element3);
            }
            if (psiElement3 instanceof KtStringTemplateEntryWithExpression) {
                return false;
            }
            if (!(psiElement3 instanceof KtStringTemplateExpression)) continue;
            return true;
        }
        return false;
    }

    public static final boolean confirmConvertJavaOnPaste(@NotNull Project project2, boolean isPlainText) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        KotlinEditorOptions kotlinEditorOptions = KotlinEditorOptions.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinEditorOptions, (String)"KotlinEditorOptions.getInstance()");
        if (kotlinEditorOptions.isDonTShowConversionDialog()) {
            return true;
        }
        KotlinPasteFromJavaDialog dialog2 = new KotlinPasteFromJavaDialog(project2, isPlainText);
        dialog2.show();
        return dialog2.isOK();
    }

    /*
     * WARNING - void declaration
     */
    public static final int linesCount(@NotNull ElementAndTextList $this$linesCount) {
        void var3_4;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$linesCount, (String)"$this$linesCount");
        Iterable $this$filterIsInstance$iv = $this$linesCount.toList();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sumBy$iv = (List)destination$iv$iv;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            void it;
            PsiElement psiElement2 = (PsiElement)element$iv;
            int n = sum$iv;
            boolean bl = false;
            int n2 = StringUtil.getLineBreakCount((CharSequence)it.getText());
            sum$iv = n + n2;
        }
        return (int)var3_4;
    }

    public static final boolean checkUseNewJ2k(@NotNull KtFile targetFile2) {
        Intrinsics.checkNotNullParameter((Object)targetFile2, (String)"targetFile");
        if (targetFile2 instanceof KtCodeFragment) {
            return false;
        }
        return ExperimentalFeatures.INSTANCE.getNewJ2k().isEnabled();
    }

    public static final void runPostProcessing(@NotNull Project project2, @NotNull KtFile file2, @Nullable TextRange bounds, @Nullable ConverterContext converterContext, boolean useNewJ2k) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        PostProcessor postProcessor = J2kConverterExtension.Companion.extension(useNewJ2k).createPostProcessor(true);
        if (useNewJ2k) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(useNewJ2k, postProcessor, project2, file2, converterContext, bounds){
                final /* synthetic */ boolean $useNewJ2k;
                final /* synthetic */ PostProcessor $postProcessor;
                final /* synthetic */ Project $project;
                final /* synthetic */ KtFile $file;
                final /* synthetic */ ConverterContext $converterContext;
                final /* synthetic */ TextRange $bounds;

                public final void run() {
                    J2kConverterExtension j2kConverterExtension = J2kConverterExtension.Companion.extension(this.$useNewJ2k);
                    ProgressManager progressManager = ProgressManager.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
                    ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
                    Intrinsics.checkNotNull((Object)progressIndicator);
                    WithProgressProcessor processor2 = j2kConverterExtension.createWithProgressProcessor(progressIndicator, CollectionsKt.emptyList(), this.$postProcessor.getPhasesCount());
                    new AfterConversionPass(this.$project, this.$postProcessor).run(this.$file, this.$converterContext, this.$bounds, (Function2<? super Integer, ? super String, Unit>)((Function2)new Function2<Integer, String, Unit>(processor2){
                        final /* synthetic */ WithProgressProcessor $processor;

                        public final void invoke(int phase, @NotNull String description2) {
                            Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
                            this.$processor.updateState(0, phase, description2);
                        }
                        {
                            this.$processor = withProgressProcessor;
                            super(2);
                        }
                    }));
                }
                {
                    this.$useNewJ2k = bl;
                    this.$postProcessor = postProcessor;
                    this.$project = project2;
                    this.$file = ktFile;
                    this.$converterContext = converterContext;
                    this.$bounds = textRange;
                }
            }, KotlinBundle.message("copy.text.convert.java.to.kotlin.title", new Object[0]), true, project2);
        } else {
            AfterConversionPass.run$default(new AfterConversionPass(project2, postProcessor), file2, converterContext, bounds, null, 8, null);
        }
    }
}

