/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.ui.notifications;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.ui.notifications.ConfigureKotlinNotificationState;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotification;", "Lcom/intellij/notification/Notification;", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "Lcom/intellij/openapi/module/Module;", "notificationState", "Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotificationState;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotificationState;)V", "getNotificationState", "()Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotificationState;", "equals", "", "other", "", "hashCode", "", "Companion", "kotlin.jvm"})
public final class ConfigureKotlinNotification
extends Notification {
    @NotNull
    private final ConfigureKotlinNotificationState notificationState;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConfigureKotlinNotification)) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.getContent(), (Object)((ConfigureKotlinNotification)((Object)other)).getContent()) ^ true);
    }

    public int hashCode() {
        return this.getContent().hashCode();
    }

    @NotNull
    public final ConfigureKotlinNotificationState getNotificationState() {
        return this.notificationState;
    }

    public ConfigureKotlinNotification(final @NotNull Project project2, final @NotNull List<? extends Module> excludeModules, @NotNull ConfigureKotlinNotificationState notificationState) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(excludeModules, (String)"excludeModules");
        Intrinsics.checkNotNullParameter((Object)notificationState, (String)"notificationState");
        super("Configure Kotlin in Project", KotlinJvmBundle.message("configure.kotlin", new Object[0]), notificationState.getNotificationString(), NotificationType.WARNING);
        this.notificationState = notificationState;
        this.setListener(new NotificationListener(){

            public final void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
                Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                    String string = event.getDescription();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.description");
                    KotlinProjectConfigurator kotlinProjectConfigurator = ConfigureKotlinInProjectUtilsKt.getConfiguratorByName(string);
                    if (kotlinProjectConfigurator == null) {
                        throw (Throwable)((Object)new AssertionError((Object)("Missed action: " + event.getDescription())));
                    }
                    KotlinProjectConfigurator configurator = kotlinProjectConfigurator;
                    notification2.expire();
                    configurator.configure(project2, excludeModules);
                }
            }
        });
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotification$Companion;", "", "()V", "getLink", "", "configurator", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "isOnlyOneModule", "", "getNotificationState", "Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotificationState;", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "Lcom/intellij/openapi/module/Module;", "kotlin.jvm"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public final ConfigureKotlinNotificationState getNotificationState(@NotNull Project project2, @NotNull Collection<? extends Module> excludeModules) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String string;
            boolean isOnlyOneModule;
            void configurableModules;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(excludeModules, (String)"excludeModules");
            Pair<Collection<ModuleSourceRootGroup>, Collection<KotlinProjectConfigurator>> pair = ConfigureKotlinInProjectUtilsKt.getConfigurationPossibilitiesForConfigureNotification(project2, excludeModules);
            Collection collection2 = (Collection)pair.component1();
            Collection ableToRunConfigurators = (Collection)pair.component2();
            if (ableToRunConfigurators.isEmpty() || configurableModules.isEmpty()) {
                return null;
            }
            boolean bl = isOnlyOneModule = configurableModules.size() == 1;
            if (isOnlyOneModule) {
                Object[] objectArray = new Object[1];
                String string2 = ((ModuleSourceRootGroup)CollectionsKt.first((Iterable)((Iterable)configurableModules))).getBaseModule().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"configurableModules.first().baseModule.name");
                objectArray[0] = string2;
                string = KotlinJvmBundle.message("configure.0.module", objectArray);
            } else {
                string = KotlinJvmBundle.message("configure.modules", new Object[0]);
            }
            String modulesString = string;
            String links2 = CollectionsKt.joinToString$default((Iterable)ableToRunConfigurators, (CharSequence)"<br/>", null, null, (int)0, null, (Function1)((Function1)new Function1<KotlinProjectConfigurator, CharSequence>(isOnlyOneModule){
                final /* synthetic */ boolean $isOnlyOneModule;

                @NotNull
                public final CharSequence invoke(@NotNull KotlinProjectConfigurator configurator) {
                    Intrinsics.checkNotNullParameter((Object)configurator, (String)"configurator");
                    return org.jetbrains.kotlin.idea.configuration.ui.notifications.ConfigureKotlinNotification$Companion.access$getLink(ConfigureKotlinNotification.Companion, configurator, this.$isOnlyOneModule);
                }
                {
                    this.$isOnlyOneModule = bl;
                    super(1);
                }
            }), (int)30, null);
            String string3 = project2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"project.name");
            Object[] objectArray = new Object[3];
            objectArray[0] = modulesString;
            String string4 = project2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"project.name");
            objectArray[1] = string4;
            objectArray[2] = links2;
            Iterable iterable = (Iterable)configurableModules;
            String string5 = KotlinJvmBundle.message("configure.0.in.1.project.br.2", objectArray);
            String string6 = string3;
            boolean $i$f$map = false;
            void var10_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string7;
                void it;
                ModuleSourceRootGroup moduleSourceRootGroup = (ModuleSourceRootGroup)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.getBaseModule().getName(), (String)"it.baseModule.name");
                collection.add(string7);
            }
            collection = (List)destination$iv$iv;
            Collection collection3 = collection;
            String string8 = string5;
            String string9 = string6;
            return new ConfigureKotlinNotificationState(string9, string8, collection3);
        }

        private final String getLink(KotlinProjectConfigurator configurator, boolean isOnlyOneModule) {
            Object[] objectArray = new Object[2];
            objectArray[0] = configurator.getPresentableText();
            Integer n = 1;
            int n2 = ((Number)n).intValue();
            int n3 = 1;
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = objectArray;
            String string = "as.kotlin.1.module";
            String string2 = configurator.getName();
            boolean bl = false;
            boolean bl2 = isOnlyOneModule;
            Integer n4 = bl2 ? n : null;
            objectArray2[n3] = n4 != null ? n4 : 2;
            return "<a href=\"" + string2 + "\">" + KotlinJvmBundle.message(string, objectArray3) + "</a>";
        }

        private Companion() {
        }

        public static final /* synthetic */ String access$getLink(Companion $this, KotlinProjectConfigurator configurator, boolean isOnlyOneModule) {
            return $this.getLink(configurator, isOnlyOneModule);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

