/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.artifacts.LazyFileOutputProducer;
import org.jetbrains.kotlin.idea.base.plugin.KotlinBasePluginBundle;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.compiler.configuration.LazyKotlinJpsPluginClasspathDownloaderKt;
import org.jetbrains.kotlin.idea.compiler.configuration.LazyKotlinMavenArtifactDownloader;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0012\u001a\u00020\u0003J#\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/LazyKotlinJpsPluginClasspathDownloader;", "Lorg/jetbrains/kotlin/idea/artifacts/LazyFileOutputProducer;", "", "Lorg/jetbrains/kotlin/idea/compiler/configuration/LazyKotlinJpsPluginClasspathDownloader$Context;", "version", "", "(Ljava/lang/String;)V", "newDownloader", "Lorg/jetbrains/kotlin/idea/compiler/configuration/LazyKotlinMavenArtifactDownloader;", "oldDownloader", "getDownloadedIfUpToDateOrEmpty", "", "Ljava/io/File;", "isUpToDate", "", "input", "(Lkotlin/Unit;)Z", "lazyDownload", "computationContext", "lazyProduceOutput", "(Lkotlin/Unit;Lorg/jetbrains/kotlin/idea/compiler/configuration/LazyKotlinJpsPluginClasspathDownloader$Context;)Ljava/util/List;", "Context", "kotlin.base.plugin"})
public final class LazyKotlinJpsPluginClasspathDownloader
implements LazyFileOutputProducer<Unit, Context> {
    private final LazyKotlinMavenArtifactDownloader newDownloader;
    private final LazyKotlinMavenArtifactDownloader oldDownloader;
    private final String version;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isUpToDate(@NotNull Unit input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (Intrinsics.areEqual((Object)IdeKotlinVersion.Companion.get(this.version), (Object)KotlinPluginLayout.Companion.getInstance().getStandaloneCompilerVersion())) {
            return true;
        }
        if (this.newDownloader.isUpToDate()) return true;
        LazyKotlinMavenArtifactDownloader lazyKotlinMavenArtifactDownloader = this.oldDownloader;
        if (lazyKotlinMavenArtifactDownloader == null) return false;
        if (!lazyKotlinMavenArtifactDownloader.isUpToDate()) return false;
        return true;
    }

    @Override
    @NotNull
    public List<File> lazyProduceOutput(@NotNull Unit input, @NotNull Context computationContext) {
        List<File> list2;
        List<File> list3;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)computationContext, (String)"computationContext");
        if (Intrinsics.areEqual((Object)IdeKotlinVersion.Companion.get(this.version), (Object)KotlinPluginLayout.Companion.getInstance().getStandaloneCompilerVersion())) {
            return KotlinPluginLayout.Companion.getInstance().getJpsPluginClasspath();
        }
        Object object = this.oldDownloader;
        if (object != null && (object = ((LazyKotlinMavenArtifactDownloader)object).getDownloadedIfUpToDateOrEmpty()) != null) {
            Object object2;
            Object it = object2 = object;
            boolean bl = false;
            Collection collection = (Collection)it;
            object = !collection.isEmpty() ? object2 : null;
            if (object != null) {
                it = object2 = object;
                boolean bl2 = false;
                return it;
            }
        }
        LazyKotlinMavenArtifactDownloader.DownloadContext downloadContext = new LazyKotlinMavenArtifactDownloader.DownloadContext(computationContext.getProject(), computationContext.getIndicator(), KotlinBasePluginBundle.message("progress.text.downloading.kotlin.jps.plugin", new Object[0]));
        List<File> it = list3 = this.newDownloader.lazyDownload(downloadContext);
        boolean bl = false;
        Collection collection = it;
        List<File> list4 = !collection.isEmpty() ? list3 : null;
        if (list4 == null) {
            LazyKotlinMavenArtifactDownloader lazyKotlinMavenArtifactDownloader = this.oldDownloader;
            list4 = list2 = lazyKotlinMavenArtifactDownloader != null ? lazyKotlinMavenArtifactDownloader.lazyDownload(downloadContext) : null;
        }
        if (list4 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public final List<File> getDownloadedIfUpToDateOrEmpty() {
        List<File> list2;
        if (Intrinsics.areEqual((Object)IdeKotlinVersion.Companion.get(this.version), (Object)KotlinPluginLayout.Companion.getInstance().getStandaloneCompilerVersion())) {
            list2 = KotlinPluginLayout.Companion.getInstance().getJpsPluginClasspath();
        } else {
            List<File> list3;
            List<File> it = list3 = this.newDownloader.getDownloadedIfUpToDateOrEmpty();
            boolean bl = false;
            Collection collection = it;
            List<File> list4 = !collection.isEmpty() ? list3 : null;
            if (list4 == null) {
                LazyKotlinMavenArtifactDownloader lazyKotlinMavenArtifactDownloader = this.oldDownloader;
                list4 = list2 = lazyKotlinMavenArtifactDownloader != null ? lazyKotlinMavenArtifactDownloader.getDownloadedIfUpToDateOrEmpty() : null;
            }
            if (list4 == null) {
                list2 = CollectionsKt.emptyList();
            }
        }
        return list2;
    }

    @NotNull
    public final List<File> lazyDownload(@NotNull Context computationContext) {
        Intrinsics.checkNotNullParameter((Object)computationContext, (String)"computationContext");
        return this.lazyProduceOutput(Unit.INSTANCE, computationContext);
    }

    public LazyKotlinJpsPluginClasspathDownloader(@NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        this.version = version2;
        this.newDownloader = new LazyKotlinMavenArtifactDownloader("kotlin-jps-plugin", this.version, false, 4, null);
        this.oldDownloader = IdeKotlinVersion.Companion.get(this.version).compareTo(LazyKotlinJpsPluginClasspathDownloaderKt.access$getVERSION_UNTIL_OLD_FAT_JAR_IS_AVAILABLE$p()) < 0 ? new LazyKotlinMavenArtifactDownloader("kotlin-jps-plugin-classpath", this.version, false, 4, null) : null;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/LazyKotlinJpsPluginClasspathDownloader$Context;", "", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "getIndicator", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "getProject", "()Lcom/intellij/openapi/project/Project;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.base.plugin"})
    public static final class Context {
        @NotNull
        private final Project project;
        @NotNull
        private final ProgressIndicator indicator;

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final ProgressIndicator getIndicator() {
            return this.indicator;
        }

        public Context(@NotNull Project project2, @NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            this.project = project2;
            this.indicator = indicator;
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @NotNull
        public final ProgressIndicator component2() {
            return this.indicator;
        }

        @NotNull
        public final Context copy(@NotNull Project project2, @NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            return new Context(project2, indicator);
        }

        public static /* synthetic */ Context copy$default(Context context2, Project project2, ProgressIndicator progressIndicator, int n, Object object) {
            if ((n & 1) != 0) {
                project2 = context2.project;
            }
            if ((n & 2) != 0) {
                progressIndicator = context2.indicator;
            }
            return context2.copy(project2, progressIndicator);
        }

        @NotNull
        public String toString() {
            return "Context(project=" + this.project + ", indicator=" + this.indicator + ")";
        }

        public int hashCode() {
            Project project2 = this.project;
            ProgressIndicator progressIndicator = this.indicator;
            return (project2 != null ? project2.hashCode() : 0) * 31 + (progressIndicator != null ? progressIndicator.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Context)) break block3;
                    Context context2 = (Context)object;
                    if (!Intrinsics.areEqual((Object)this.project, (Object)context2.project) || !Intrinsics.areEqual((Object)this.indicator, (Object)context2.indicator)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

