/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.JDOMUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinMavenArtifactFinder;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\u001e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinMavenUtils;", "", "()V", "findArtifact", "Ljava/nio/file/Path;", "groupId", "", "artifactId", "version", "findArtifactOrFail", "findLibraryVersion", "libraryFileName", "kotlin.base.plugin"})
public final class KotlinMavenUtils {
    @NotNull
    public static final KotlinMavenUtils INSTANCE;

    @Nullable
    public final String findLibraryVersion(@NotNull String libraryFileName) {
        List urlChunks;
        Object object;
        String firstRootUrl;
        CharSequence mavenId;
        Intrinsics.checkNotNullParameter((Object)libraryFileName, (String)"libraryFileName");
        Path librariesDir = Paths.get(PathManager.getHomePath(), ".idea/libraries");
        Path libraryFile = librariesDir.resolve(libraryFileName);
        Element element3 = JDOMUtil.load((Path)libraryFile);
        Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"JDOMUtil.load(libraryFile)");
        Element libraryDocument = element3;
        Element element4 = libraryDocument.getChild("library");
        if (element4 == null) {
            String string = "Invalid library file: " + libraryFile;
            throw new IllegalStateException(string.toString());
        }
        Element libraryElement = element4;
        if (Intrinsics.areEqual((Object)libraryElement.getAttributeValue("type"), (Object)"repository")) {
            List mavenIdChunks;
            Element propertiesElement;
            Element element5 = propertiesElement = libraryElement.getChild("properties");
            mavenId = element5 != null ? element5.getAttributeValue("maven-id") : null;
            CharSequence charSequence = mavenId;
            if (!(charSequence == null || charSequence.length() == 0) && (mavenIdChunks = StringsKt.split$default((CharSequence)mavenId, (char[])new char[]{':'}, (boolean)false, (int)0, (int)6, null)).size() == 3) {
                return (String)mavenIdChunks.get(2);
            }
        }
        if (!((mavenId = (CharSequence)(firstRootUrl = (object = libraryElement.getChild("CLASSES")) != null && (object = object.getChild("root")) != null && (object = object.getAttributeValue("url")) != null ? StringsKt.substringBefore$default((String)object, (String)"!/", null, (int)2, null) : null)) == null || mavenId.length() == 0) && (urlChunks = StringsKt.split$default((CharSequence)firstRootUrl, (char[])new char[]{'/'}, (boolean)false, (int)0, (int)6, null)).size() >= 3) {
            String fileName = (String)urlChunks.get(CollectionsKt.getLastIndex((List)urlChunks));
            String version2 = (String)urlChunks.get(CollectionsKt.getLastIndex((List)urlChunks) - 1);
            String artifactId2 = (String)urlChunks.get(CollectionsKt.getLastIndex((List)urlChunks) - 2);
            if (StringsKt.startsWith$default((String)fileName, (String)(artifactId2 + "-" + version2), (boolean)false, (int)2, null) && StringsKt.endsWith((String)fileName, (String)".jar", (boolean)true)) {
                return version2;
            }
        }
        return null;
    }

    @NotNull
    public final Path findArtifactOrFail(@NotNull String groupId2, @NotNull String artifactId2, @NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)groupId2, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId2, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Path path2 = this.findArtifact(groupId2, artifactId2, version2);
        if (path2 == null) {
            String string = "Artifact " + groupId2 + ":" + artifactId2 + ":" + version2 + " not found";
            throw new IllegalStateException(string.toString());
        }
        return path2;
    }

    @Nullable
    public final Path findArtifact(@NotNull String groupId2, @NotNull String artifactId2, @NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)groupId2, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId2, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        return KotlinMavenArtifactFinder.Companion.getInstance().findArtifact(groupId2, artifactId2, version2);
    }

    private KotlinMavenUtils() {
    }

    static {
        KotlinMavenUtils kotlinMavenUtils;
        INSTANCE = kotlinMavenUtils = new KotlinMavenUtils();
    }
}

