/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.JpsPluginSettings;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettingsKt;
import org.jetbrains.kotlin.idea.base.plugin.KotlinBasePluginBundle;
import org.jetbrains.kotlin.idea.compiler.configuration.BaseKotlinCompilerSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinArtifactsDownloader;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettingsKt;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.compiler.configuration.NewCompilerVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.OutdatedCompilerVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.ParsingError;
import org.jetbrains.kotlin.idea.compiler.configuration.UnsupportedJpsVersionError;

@State(name="KotlinJpsPluginSettings", storages={@Storage(value="kotlinc.xml")})
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0002H\u0014J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinJpsPluginSettings;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/BaseKotlinCompilerSettings;", "Lorg/jetbrains/kotlin/config/JpsPluginSettings;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createSettings", "dropExplicitVersion", "", "setVersion", "jpsVersion", "", "Companion", "kotlin.base.plugin"})
public final class KotlinJpsPluginSettings
extends BaseKotlinCompilerSettings<JpsPluginSettings> {
    @NotNull
    private static final KotlinVersion jpsMinimumSupportedVersion;
    @NotNull
    private static final KotlinVersion jpsMaximumSupportedVersion;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    protected JpsPluginSettings createSettings() {
        return new JpsPluginSettings();
    }

    public final void setVersion(@NotNull String jpsVersion2) {
        Intrinsics.checkNotNullParameter((Object)jpsVersion2, (String)"jpsVersion");
        if (Intrinsics.areEqual((Object)jpsVersion2, (Object)((JpsPluginSettings)this.getSettings()).getVersion())) {
            return;
        }
        this.update((Function1)new Function1<JpsPluginSettings, Unit>(jpsVersion2){
            final /* synthetic */ String $jpsVersion;

            public final void invoke(@NotNull JpsPluginSettings $this$update) {
                Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$receiver");
                $this$update.setVersion(this.$jpsVersion);
            }
            {
                this.$jpsVersion = string;
                super(1);
            }
        });
    }

    public final void dropExplicitVersion() {
        this.setVersion("");
    }

    public KotlinJpsPluginSettings(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2);
    }

    static {
        Companion = new Companion(null);
        jpsMinimumSupportedVersion = IdeKotlinVersion.Companion.get("1.6.0").getKotlinVersion();
        jpsMaximumSupportedVersion = LanguageVersionSettingsKt.toKotlinVersion((LanguageVersion)((LanguageVersion)ArraysKt.last((Object[])LanguageVersion.values())));
    }

    @NotNull
    public static final String getRawBundledVersion() {
        return Companion.getRawBundledVersion();
    }

    @NotNull
    public static final String getFallbackVersionForOutdatedCompiler() {
        return Companion.getFallbackVersionForOutdatedCompiler();
    }

    @NotNull
    public static final IdeKotlinVersion getBundledVersion() {
        return Companion.getBundledVersion();
    }

    @NotNull
    public static final KotlinVersion getJpsMinimumSupportedVersion() {
        Companion companion = Companion;
        return jpsMinimumSupportedVersion;
    }

    @NotNull
    public static final KotlinVersion getJpsMaximumSupportedVersion() {
        Companion companion = Companion;
        return jpsMaximumSupportedVersion;
    }

    @JvmStatic
    @Nullable
    public static final KotlinJpsPluginSettings getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @JvmStatic
    public static final boolean isUnbundledJpsExperimentalFeatureEnabled(@NotNull Project project2) {
        return Companion.isUnbundledJpsExperimentalFeatureEnabled(project2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\t2\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0007J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\tH\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u001e\u0010$\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u001cJ\u0010\u0010'\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001f\u001a\u00020 J\u0015\u0010(\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b)J$\u0010*\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001e0,J\u000e\u0010-\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u0002\u001a\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\u0002\u001a\u0004\b\u0017\u0010\f\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinJpsPluginSettings$Companion;", "", "()V", "bundledVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "getBundledVersion$annotations", "getBundledVersion", "()Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "fallbackVersionForOutdatedCompiler", "", "getFallbackVersionForOutdatedCompiler$annotations", "getFallbackVersionForOutdatedCompiler", "()Ljava/lang/String;", "jpsMaximumSupportedVersion", "Lkotlin/KotlinVersion;", "getJpsMaximumSupportedVersion$annotations", "getJpsMaximumSupportedVersion", "()Lkotlin/KotlinVersion;", "jpsMinimumSupportedVersion", "getJpsMinimumSupportedVersion$annotations", "getJpsMinimumSupportedVersion", "rawBundledVersion", "getRawBundledVersion$annotations", "getRawBundledVersion", "checkJpsVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/UnsupportedJpsVersionError;", "jpsVersion", "fromFile", "", "downloadKotlinJpsInBackground", "", "project", "Lcom/intellij/openapi/project/Project;", "version", "getInstance", "Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinJpsPluginSettings;", "importKotlinJpsVersionFromExternalBuildSystem", "rawVersion", "isDelegatedToExtBuild", "isUnbundledJpsExperimentalFeatureEnabled", "shouldImportKotlinJpsPluginVersionFromExternalBuildSystem", "shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$kotlin_base_plugin", "supportedJpsVersion", "onUnsupportedVersion", "Lkotlin/Function1;", "validateSettings", "kotlin.base.plugin"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getRawBundledVersion$annotations() {
        }

        @NotNull
        public final String getRawBundledVersion() {
            return Companion.getBundledVersion().getRawVersion();
        }

        @JvmStatic
        public static /* synthetic */ void getFallbackVersionForOutdatedCompiler$annotations() {
        }

        @NotNull
        public final String getFallbackVersionForOutdatedCompiler() {
            return "1.6.21";
        }

        @JvmStatic
        public static /* synthetic */ void getBundledVersion$annotations() {
        }

        @NotNull
        public final IdeKotlinVersion getBundledVersion() {
            return KotlinPluginLayout.Companion.getInstance().getStandaloneCompilerVersion();
        }

        @JvmStatic
        public static /* synthetic */ void getJpsMinimumSupportedVersion$annotations() {
        }

        @NotNull
        public final KotlinVersion getJpsMinimumSupportedVersion() {
            return jpsMinimumSupportedVersion;
        }

        @JvmStatic
        public static /* synthetic */ void getJpsMaximumSupportedVersion$annotations() {
        }

        @NotNull
        public final KotlinVersion getJpsMaximumSupportedVersion() {
            return jpsMaximumSupportedVersion;
        }

        public final void validateSettings(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Project $this$service$iv = project2;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(KotlinJpsPluginSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            KotlinJpsPluginSettings jpsPluginSettings = (KotlinJpsPluginSettings)object;
            if (!this.isUnbundledJpsExperimentalFeatureEnabled(project2)) {
                jpsPluginSettings.dropExplicitVersion();
                return;
            }
            CharSequence charSequence = ((JpsPluginSettings)jpsPluginSettings.getSettings()).getVersion();
            if (charSequence.length() == 0 && this.getBundledVersion().getBuildNumber() == null) {
                jpsPluginSettings.setVersion(this.getRawBundledVersion());
            }
        }

        @Nullable
        public final String jpsVersion(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            KotlinJpsPluginSettings kotlinJpsPluginSettings = this.getInstance(project2);
            return kotlinJpsPluginSettings != null && (kotlinJpsPluginSettings = (JpsPluginSettings)kotlinJpsPluginSettings.getSettings()) != null ? KotlinJpsPluginSettingsKt.getVersionWithFallback((JpsPluginSettings)kotlinJpsPluginSettings) : null;
        }

        @JvmStatic
        @Nullable
        public final KotlinJpsPluginSettings getInstance(@NotNull Project project2) {
            KotlinJpsPluginSettings kotlinJpsPluginSettings;
            Project project3;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Project it = project3 = project2;
            boolean bl = false;
            Object object = Companion.isUnbundledJpsExperimentalFeatureEnabled(it) ? project3 : null;
            if (object != null) {
                Project $this$service$iv = object;
                boolean $i$f$service = false;
                Object object2 = $this$service$iv.getService(KotlinJpsPluginSettings.class);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getService(T::class.java)");
                kotlinJpsPluginSettings = (KotlinJpsPluginSettings)object2;
            } else {
                kotlinJpsPluginSettings = null;
            }
            return kotlinJpsPluginSettings;
        }

        @JvmStatic
        public final boolean isUnbundledJpsExperimentalFeatureEnabled(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            boolean $i$f$isUnitTestMode = false;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            return application.isUnitTestMode() || !project2.isDefault();
        }

        @Nls
        @Nullable
        public final UnsupportedJpsVersionError checkJpsVersion(@NotNull String jpsVersion2, boolean fromFile) {
            KotlinVersion parsedKotlinVersion;
            Intrinsics.checkNotNullParameter((Object)jpsVersion2, (String)"jpsVersion");
            IdeKotlinVersion ideKotlinVersion = IdeKotlinVersion.Companion.opt(jpsVersion2);
            Object object = parsedKotlinVersion = ideKotlinVersion != null ? ideKotlinVersion.getKotlinVersion() : null;
            if (parsedKotlinVersion == null) {
                return new ParsingError(fromFile ? KotlinBasePluginBundle.message("failed.to.parse.kotlin.version.0.from.1", jpsVersion2, "kotlinc.xml") : KotlinBasePluginBundle.message("failed.to.parse.kotlin.version.0", jpsVersion2));
            }
            if (parsedKotlinVersion.compareTo(this.getJpsMinimumSupportedVersion()) < 0) {
                return new OutdatedCompilerVersion(KotlinBasePluginBundle.message("kotlin.jps.compiler.minimum.supported.version.not.satisfied", this.getJpsMinimumSupportedVersion(), jpsVersion2));
            }
            if (parsedKotlinVersion.compareTo(this.getJpsMaximumSupportedVersion()) > 0) {
                return new NewCompilerVersion(KotlinBasePluginBundle.message("kotlin.jps.compiler.maximum.supported.version.not.satisfied", this.getJpsMaximumSupportedVersion(), jpsVersion2));
            }
            return null;
        }

        public static /* synthetic */ UnsupportedJpsVersionError checkJpsVersion$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.checkJpsVersion(string, bl);
        }

        @Nullable
        public final String supportedJpsVersion(@NotNull Project project2, @NotNull Function1<? super String, Unit> onUnsupportedVersion) {
            String string;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(onUnsupportedVersion, (String)"onUnsupportedVersion");
            String string2 = this.jpsVersion(project2);
            if (string2 == null) {
                return null;
            }
            String version2 = string2;
            UnsupportedJpsVersionError error2 = this.checkJpsVersion(version2, true);
            if (error2 instanceof OutdatedCompilerVersion) {
                string = this.getFallbackVersionForOutdatedCompiler();
            } else if (error2 instanceof NewCompilerVersion || error2 instanceof ParsingError) {
                onUnsupportedVersion.invoke((Object)error2.getMessage());
                string = null;
            } else if (error2 == null) {
                string = version2;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        public final void importKotlinJpsVersionFromExternalBuildSystem(@NotNull Project project2, @NotNull String rawVersion, boolean isDelegatedToExtBuild) {
            String string;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)rawVersion, (String)"rawVersion");
            KotlinJpsPluginSettings kotlinJpsPluginSettings = this.getInstance(project2);
            if (kotlinJpsPluginSettings == null) {
                return;
            }
            KotlinJpsPluginSettings instance2 = kotlinJpsPluginSettings;
            if (Intrinsics.areEqual((Object)rawVersion, (Object)this.getRawBundledVersion())) {
                instance2.setVersion(rawVersion);
                return;
            }
            UnsupportedJpsVersionError error2 = org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettings$Companion.checkJpsVersion$default(this, rawVersion, false, 2, null);
            UnsupportedJpsVersionError unsupportedJpsVersionError = error2;
            if (unsupportedJpsVersionError instanceof OutdatedCompilerVersion) {
                string = this.getFallbackVersionForOutdatedCompiler();
            } else if (unsupportedJpsVersionError instanceof NewCompilerVersion || unsupportedJpsVersionError instanceof ParsingError) {
                string = this.getRawBundledVersion();
            } else if (unsupportedJpsVersionError == null) {
                string = rawVersion;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String version2 = string;
            if (error2 != null && !isDelegatedToExtBuild) {
                KotlinJpsPluginSettingsKt.access$showNotificationUnsupportedJpsPluginVersion(project2, KotlinBasePluginBundle.message("notification.title.unsupported.kotlin.jps.plugin.version", new Object[0]), KotlinBasePluginBundle.message("notification.content.bundled.version.0.will.be.used.reason.1", version2, error2.getMessage()));
            }
            if ((unsupportedJpsVersionError = error2) instanceof ParsingError || unsupportedJpsVersionError instanceof NewCompilerVersion) {
                instance2.dropExplicitVersion();
                return;
            }
            if (unsupportedJpsVersionError == null || unsupportedJpsVersionError instanceof OutdatedCompilerVersion) {
                // empty if block
            }
            if (!this.shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$kotlin_base_plugin(IdeKotlinVersion.Companion.get(version2))) {
                instance2.dropExplicitVersion();
                return;
            }
            if (!isDelegatedToExtBuild) {
                this.downloadKotlinJpsInBackground(project2, version2);
            }
            instance2.setVersion(version2);
        }

        private final void downloadKotlinJpsInBackground(Project project2, String version2) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, version2, project2, KotlinBasePluginBundle.INSTANCE.getMessage("progress.text.downloading.kotlinc.dist", new Object[0]), true){
                final /* synthetic */ Project $project;
                final /* synthetic */ String $version;

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    KotlinArtifactsDownloader.INSTANCE.lazyDownloadMissingJpsPluginDependencies(this.$project, this.$version, indicator, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
                        final /* synthetic */ downloadKotlinJpsInBackground.1 this$0;

                        public final void invoke(@NotNull String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            KotlinJpsPluginSettingsKt.access$showNotificationUnsupportedJpsPluginVersion(this.this$0.$project, KotlinBasePluginBundle.message("kotlin.dist.downloading.failed", new Object[0]), it);
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }));
                }
                {
                    this.$project = $captured_local_variable$0;
                    this.$version = $captured_local_variable$1;
                    super($super_call_param$2, $super_call_param$3, $super_call_param$4);
                }
            });
        }

        public final boolean shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$kotlin_base_plugin(@NotNull IdeKotlinVersion version2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
            boolean bl2 = bl = this.getJpsMinimumSupportedVersion().compareTo(IdeKotlinVersion.Companion.get("1.7.10").getKotlinVersion()) < 0;
            if (!bl) {
                boolean $i$a$-check-KotlinJpsPluginSettings$Companion$shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$22 = false;
                String $i$a$-check-KotlinJpsPluginSettings$Companion$shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$22 = "shouldImportKotlinJpsPluginVersionFromExternalBuildSystem" + " makes sense when minimum supported version is lower than 1.7.20. If minimum supported version is already 1.7.20 then you can drop this function.";
                throw new IllegalStateException($i$a$-check-KotlinJpsPluginSettings$Companion$shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$22.toString());
            }
            boolean bl3 = bl = version2.getKotlinVersion().compareTo(this.getJpsMinimumSupportedVersion()) >= 0;
            if (!bl) {
                boolean $i$a$-require-KotlinJpsPluginSettings$Companion$shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$32 = false;
                String $i$a$-require-KotlinJpsPluginSettings$Companion$shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$32 = version2.getKotlinVersion() + " is lower than " + Companion.getJpsMinimumSupportedVersion();
                throw new IllegalArgumentException($i$a$-require-KotlinJpsPluginSettings$Companion$shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$32.toString());
            }
            IdeKotlinVersion kt160 = IdeKotlinVersion.Companion.get("1.6.0");
            IdeKotlinVersion kt170 = IdeKotlinVersion.Companion.get("1.7.0");
            return version2.compareTo(kt170) > 0 || version2.compareTo(kt160) >= 0 && version2.isRelease() && version2.getBuildNumber() == null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

