/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.project;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.kotlin.caches.project.CacheUtilsKt;
import org.jetbrains.kotlin.caches.resolve.IdePlatformKindResolutionKt;
import org.jetbrains.kotlin.config.SourceKotlinRootType;
import org.jetbrains.kotlin.config.TestSourceKotlinRootType;
import org.jetbrains.kotlin.descriptors.ModuleCapability;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfosKt;
import org.jetbrains.kotlin.idea.caches.project.LibraryInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleOrigin;
import org.jetbrains.kotlin.idea.caches.project.ModuleProductionSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfoWithExpectedBy;
import org.jetbrains.kotlin.idea.caches.project.ModuleTestSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.MultiplatformUtilKt;
import org.jetbrains.kotlin.idea.caches.project.PlatformModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.SdkInfo;
import org.jetbrains.kotlin.idea.caches.project.SourceType;
import org.jetbrains.kotlin.idea.framework.LibraryEffectiveKindProviderKt;
import org.jetbrains.kotlin.idea.framework.LibraryKindsKt;
import org.jetbrains.kotlin.idea.klib.AbstractKlibLibraryInfo;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.platform.DefaultIdeTargetPlatformKindProvider;
import org.jetbrains.kotlin.platform.IdePlatformKindUtil;
import org.jetbrains.kotlin.platform.SimplePlatform;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.js.JsPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatform;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatforms;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000n\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\f\u001a\u001c\u0010\u001a\u001a\u00020\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001bH\u0000\u001a\u0012\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140\r*\u00020!H\u0000\u001a\f\u0010\"\u001a\u00020\u001b*\u00020!H\u0002\u001a\u0018\u0010#\u001a\u00020\u001b*\u00020!2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%H\u0002\u001a\f\u0010&\u001a\u00020\u001b*\u00020!H\u0002\u001a\n\u0010'\u001a\u00020\u001b*\u00020\u001e\u001a\f\u0010(\u001a\u0004\u0018\u00010)*\u00020!\u001a\u0012\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\r*\u00020\u001e\u001a\f\u0010+\u001a\u0004\u0018\u00010,*\u00020!\"\u0019\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"*\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0018\u0010\u0012\u001a\u00020\u0013*\u00020\u00148@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006-"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "OriginCapability", "Lorg/jetbrains/kotlin/descriptors/ModuleCapability;", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleOrigin;", "getOriginCapability", "()Lorg/jetbrains/kotlin/descriptors/ModuleCapability;", "libraryInfoCache", "", "Lcom/intellij/openapi/roots/libraries/Library;", "", "Lorg/jetbrains/kotlin/idea/caches/project/LibraryInfo;", "Lcom/intellij/openapi/project/Project;", "getLibraryInfoCache", "(Lcom/intellij/openapi/project/Project;)Ljava/util/Map;", "sourceType", "Lorg/jetbrains/kotlin/idea/caches/project/SourceType;", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleSourceInfo;", "getSourceType", "(Lorg/jetbrains/kotlin/idea/caches/project/ModuleSourceInfo;)Lorg/jetbrains/kotlin/idea/caches/project/SourceType;", "createLibraryInfo", "project", "library", "canDependOn", "", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "other", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "isHmppEnabled", "correspondingModuleInfos", "Lcom/intellij/openapi/module/Module;", "hasProductionRoots", "hasRootsOfType", "sourceRootType", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "hasTestRoots", "isLibraryClasses", "productionSourceInfo", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleProductionSourceInfo;", "projectSourceModules", "testSourceInfo", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleTestSourceInfo;", "kotlin.core"})
public final class IdeaModuleInfosKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final ModuleCapability<ModuleOrigin> OriginCapability;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    private static final Map<Library, List<LibraryInfo>> getLibraryInfoCache(Project $this$libraryInfoCache) {
        return (Map)CacheUtilsKt.cacheInvalidatingOnRootModifications($this$libraryInfoCache, (Function0)libraryInfoCache.1.INSTANCE);
    }

    @NotNull
    public static final List<LibraryInfo> createLibraryInfo(@NotNull Project project2, @NotNull Library library2) {
        List<LibraryInfo> list2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        Map<Library, List<LibraryInfo>> $this$getOrPut$iv = IdeaModuleInfosKt.getLibraryInfoCache(project2);
        boolean $i$f$getOrPut = false;
        List<LibraryInfo> value$iv = $this$getOrPut$iv.get(library2);
        if (value$iv == null) {
            boolean bl = false;
            TargetPlatform approximatePlatform = library2 instanceof LibraryEx && !((LibraryEx)library2).isDisposed() ? LibraryKindsKt.getPlatform(LibraryEffectiveKindProviderKt.effectiveKind((LibraryEx)library2, project2)) : DefaultIdeTargetPlatformKindProvider.Companion.getDefaultPlatform();
            List<LibraryInfo> answer$iv = IdePlatformKindResolutionKt.getResolution(IdePlatformKindUtil.getIdePlatformKind((TargetPlatform)approximatePlatform)).createLibraryInfo(project2, library2);
            $this$getOrPut$iv.put(library2, answer$iv);
            list2 = answer$iv;
        } else {
            list2 = value$iv;
        }
        return list2;
    }

    public static final boolean canDependOn(@NotNull TargetPlatform $this$canDependOn, @NotNull IdeaModuleInfo other, boolean isHmppEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$canDependOn, (String)"$this$canDependOn");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (isHmppEnabled) {
            boolean bl;
            block6: {
                if (NativePlatformKt.isNative((TargetPlatform)$this$canDependOn) && other instanceof AbstractKlibLibraryInfo && StringsKt.endsWith$default((String)((AbstractKlibLibraryInfo)other).getLibraryRoot(), (String)"stdlib", (boolean)false, (int)2, null)) {
                    return true;
                }
                Set platformsWhichAreNotContainedInOther = SetsKt.minus((Set)$this$canDependOn.getComponentPlatforms(), (Iterable)other.getPlatform().getComponentPlatforms());
                if (platformsWhichAreNotContainedInOther.isEmpty()) {
                    return true;
                }
                Iterable $this$all$iv = platformsWhichAreNotContainedInOther;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        SimplePlatform it = (SimplePlatform)element$iv;
                        boolean bl2 = false;
                        if (it instanceof NativePlatform) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            return bl && other.getPlatform().getComponentPlatforms().contains(CollectionsKt.single((Iterable)NativePlatforms.INSTANCE.getUnspecifiedNativePlatform().getComponentPlatforms()));
        }
        return JvmPlatformKt.isJvm((TargetPlatform)$this$canDependOn) && JvmPlatformKt.isJvm((TargetPlatform)other.getPlatform()) || JsPlatformKt.isJs((TargetPlatform)$this$canDependOn) && JsPlatformKt.isJs((TargetPlatform)other.getPlatform()) || NativePlatformKt.isNative((TargetPlatform)$this$canDependOn) && NativePlatformKt.isNative((TargetPlatform)other.getPlatform()) || TargetPlatformKt.isCommon((TargetPlatform)$this$canDependOn) && TargetPlatformKt.isCommon((TargetPlatform)other.getPlatform());
    }

    @Nullable
    public static final ModuleProductionSourceInfo productionSourceInfo(@NotNull Module $this$productionSourceInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$productionSourceInfo, (String)"$this$productionSourceInfo");
        return IdeaModuleInfosKt.hasProductionRoots($this$productionSourceInfo) ? new ModuleProductionSourceInfo($this$productionSourceInfo) : null;
    }

    @Nullable
    public static final ModuleTestSourceInfo testSourceInfo(@NotNull Module $this$testSourceInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$testSourceInfo, (String)"$this$testSourceInfo");
        return IdeaModuleInfosKt.hasTestRoots($this$testSourceInfo) ? new ModuleTestSourceInfo($this$testSourceInfo) : null;
    }

    @NotNull
    public static final List<ModuleSourceInfo> correspondingModuleInfos(@NotNull Module $this$correspondingModuleInfos) {
        Intrinsics.checkNotNullParameter((Object)$this$correspondingModuleInfos, (String)"$this$correspondingModuleInfos");
        return CollectionsKt.listOfNotNull((Object[])new ModuleSourceInfoWithExpectedBy[]{IdeaModuleInfosKt.testSourceInfo($this$correspondingModuleInfos), IdeaModuleInfosKt.productionSourceInfo($this$correspondingModuleInfos)});
    }

    private static final boolean hasProductionRoots(Module $this$hasProductionRoots) {
        JavaSourceRootType javaSourceRootType = JavaSourceRootType.SOURCE;
        Intrinsics.checkNotNullExpressionValue((Object)javaSourceRootType, (String)"JavaSourceRootType.SOURCE");
        return IdeaModuleInfosKt.hasRootsOfType($this$hasProductionRoots, (JpsModuleSourceRootType)javaSourceRootType) || IdeaModuleInfosKt.hasRootsOfType($this$hasProductionRoots, (JpsModuleSourceRootType)SourceKotlinRootType.INSTANCE) || MultiplatformUtilKt.isNewMPPModule($this$hasProductionRoots) && MultiplatformUtilKt.getSourceType($this$hasProductionRoots) == SourceType.PRODUCTION;
    }

    private static final boolean hasTestRoots(Module $this$hasTestRoots) {
        JavaSourceRootType javaSourceRootType = JavaSourceRootType.TEST_SOURCE;
        Intrinsics.checkNotNullExpressionValue((Object)javaSourceRootType, (String)"JavaSourceRootType.TEST_SOURCE");
        return IdeaModuleInfosKt.hasRootsOfType($this$hasTestRoots, (JpsModuleSourceRootType)javaSourceRootType) || IdeaModuleInfosKt.hasRootsOfType($this$hasTestRoots, (JpsModuleSourceRootType)TestSourceKotlinRootType.INSTANCE) || MultiplatformUtilKt.isNewMPPModule($this$hasTestRoots) && MultiplatformUtilKt.getSourceType($this$hasTestRoots) == SourceType.TEST;
    }

    private static final boolean hasRootsOfType(Module $this$hasRootsOfType, JpsModuleSourceRootType<?> sourceRootType) {
        boolean bl;
        block1: {
            ContentEntry[] contentEntryArray = ProjectRootsUtilKt.getRootManager($this$hasRootsOfType).getContentEntries();
            Intrinsics.checkNotNullExpressionValue((Object)contentEntryArray, (String)"rootManager.contentEntries");
            ContentEntry[] $this$any$iv = contentEntryArray;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                ContentEntry element$iv;
                ContentEntry it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                List list2 = it.getSourceFolders(sourceRootType);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"it.getSourceFolders(sourceRootType)");
                Collection collection = list2;
                if (!(!collection.isEmpty())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean isLibraryClasses(@NotNull IdeaModuleInfo $this$isLibraryClasses) {
        Intrinsics.checkNotNullParameter((Object)$this$isLibraryClasses, (String)"$this$isLibraryClasses");
        return $this$isLibraryClasses instanceof SdkInfo || $this$isLibraryClasses instanceof LibraryInfo;
    }

    @NotNull
    public static final ModuleCapability<ModuleOrigin> getOriginCapability() {
        return OriginCapability;
    }

    @Nullable
    public static final List<ModuleSourceInfo> projectSourceModules(@NotNull IdeaModuleInfo $this$projectSourceModules) {
        List<ModuleSourceInfo> list2;
        block6: {
            IdeaModuleInfo ideaModuleInfo;
            block5: {
                ModuleSourceInfo moduleSourceInfo;
                Intrinsics.checkNotNullParameter((Object)$this$projectSourceModules, (String)"$this$projectSourceModules");
                IdeaModuleInfo ideaModuleInfo2 = $this$projectSourceModules;
                if (!(ideaModuleInfo2 instanceof ModuleSourceInfo)) {
                    ideaModuleInfo2 = null;
                }
                if ((list2 = (ModuleSourceInfo)ideaModuleInfo2) == null) break block5;
                ModuleSourceInfo p1 = moduleSourceInfo = list2;
                boolean bl = false;
                list2 = CollectionsKt.listOf((Object)p1);
                if (list2 != null) break block6;
            }
            if (!((ideaModuleInfo = $this$projectSourceModules) instanceof PlatformModuleInfo)) {
                ideaModuleInfo = null;
            }
            PlatformModuleInfo platformModuleInfo = (PlatformModuleInfo)ideaModuleInfo;
            list2 = platformModuleInfo != null ? platformModuleInfo.getContainedModules() : null;
        }
        return list2;
    }

    @NotNull
    public static final SourceType getSourceType(@NotNull ModuleSourceInfo $this$sourceType) {
        Intrinsics.checkNotNullParameter((Object)$this$sourceType, (String)"$this$sourceType");
        return $this$sourceType instanceof ModuleTestSourceInfo ? SourceType.TEST : SourceType.PRODUCTION;
    }

    static {
        Logger logger = Logger.getInstance(IdeaModuleInfo.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(IdeaModuleInfo::class.java)");
        LOG = logger;
        OriginCapability = new ModuleCapability("MODULE_ORIGIN");
    }
}

