/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mpp.debugger;

import com.intellij.ide.plugins.PluginManagerCore;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.CidrPathManager;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import com.jetbrains.kotlin.commonNative.KonanHelper;
import com.jetbrains.mpp.debugger.GradleLLDBDriverConfiguration$WhenMappings;
import com.jetbrains.mpp.debugger.HostMachine;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.target.TargetSupportException;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0011H\u0014J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0011H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/mpp/debugger/GradleLLDBDriverConfiguration;", "Lcom/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriverConfiguration;", "lldbHome", "Ljava/io/File;", "(Ljava/io/File;)V", "framework", "", "frontend", "hostMachine", "Lcom/jetbrains/mpp/debugger/HostMachine;", "copyToKonan", "binaryInPlugin", "createDriver", "Lcom/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver;", "handler", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$Handler;", "architectureType", "Lcom/jetbrains/cidr/ArchitectureType;", "getLLDBFrameworkFile", "architecture", "getLLDBFrontendFile", "useSTLRenderers", "", "kotlin-ultimate.ultimate-native"})
public final class GradleLLDBDriverConfiguration
extends LLDBDriverConfiguration {
    private final HostMachine hostMachine;
    private final String framework;
    private final String frontend;
    private final File lldbHome;

    @NotNull
    protected File getLLDBFrameworkFile(@NotNull ArchitectureType architecture) {
        Intrinsics.checkNotNullParameter((Object)architecture, (String)"architecture");
        return FilesKt.resolve((File)this.lldbHome, (String)this.framework);
    }

    @NotNull
    protected File getLLDBFrontendFile(@NotNull ArchitectureType architecture) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)architecture, (String)"architecture");
        File file3 = CidrPathManager.getBinFile(GradleLLDBDriverConfiguration.class, (String)"cidr-debugger/bin/lldb", (String)this.frontend, null);
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"CidrPathManager.getBinFi\u2026           null\n        )");
        File binaryInPlugin = file3;
        switch (GradleLLDBDriverConfiguration$WhenMappings.$EnumSwitchMapping$2[this.hostMachine.ordinal()]) {
            case 1: {
                file2 = this.copyToKonan(binaryInPlugin);
                break;
            }
            case 2: 
            case 3: {
                file2 = binaryInPlugin;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return file2;
    }

    private final File copyToKonan(File binaryInPlugin) {
        File file2;
        File binaryInKonan = FilesKt.resolve((File)this.lldbHome, (String)"bin/LLDBFrontend");
        FilesKt.copyTo$default((File)binaryInPlugin, (File)binaryInKonan, (boolean)true, (int)0, (int)4, null);
        File $this$apply = file2 = binaryInKonan;
        boolean bl = false;
        $this$apply.setExecutable(true);
        return file2;
    }

    @NotNull
    public LLDBDriver createDriver(@NotNull DebuggerDriver.Handler handler, @NotNull ArchitectureType architectureType) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)architectureType, (String)"architectureType");
        LLDBDriver lLDBDriver = super.createDriver(handler, architectureType);
        Intrinsics.checkNotNullExpressionValue((Object)lLDBDriver, (String)"super.createDriver(handler, architectureType)");
        LLDBDriver driver = lLDBDriver;
        driver.setAutorunScriptName(KonanHelper.INSTANCE.getPythonHelpersPath());
        return driver;
    }

    public boolean useSTLRenderers() {
        return false;
    }

    public GradleLLDBDriverConfiguration(@NotNull File lldbHome) {
        String string;
        String string2;
        HostMachine hostMachine;
        Intrinsics.checkNotNullParameter((Object)lldbHome, (String)"lldbHome");
        this.lldbHome = lldbHome;
        KonanTarget konanTarget = HostManager.Companion.getHost();
        if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MACOS_X64.INSTANCE) || Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MACOS_ARM64.INSTANCE)) {
            hostMachine = HostMachine.Mac;
        } else if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.LINUX_X64.INSTANCE)) {
            hostMachine = HostMachine.Linux;
        } else if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MINGW_X64.INSTANCE)) {
            hostMachine = HostMachine.Windows;
        } else {
            throw (Throwable)new TargetSupportException("Unsupported host target: " + HostManager.Companion.hostOs() + " " + HostManager.Companion.hostArch(), null, 2, null);
        }
        this.hostMachine = hostMachine;
        switch (GradleLLDBDriverConfiguration$WhenMappings.$EnumSwitchMapping$0[this.hostMachine.ordinal()]) {
            case 1: {
                string2 = "LLDB.framework";
                break;
            }
            case 2: {
                string2 = "lib/liblldb.so";
                break;
            }
            case 3: {
                string2 = "bin/liblldb.dll";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.framework = string2;
        switch (GradleLLDBDriverConfiguration$WhenMappings.$EnumSwitchMapping$1[this.hostMachine.ordinal()]) {
            case 1: {
                if (PluginManagerCore.isRunningFromSources()) {
                    string = "mac/LLDBFrontend";
                    break;
                }
                string = "macos/LLDBFrontend";
                break;
            }
            case 2: {
                if (PluginManagerCore.isRunningFromSources()) {
                    string = "linux/bin/LLDBFrontend";
                    break;
                }
                string = "linux/LLDBFrontend";
                break;
            }
            case 3: {
                string = "windows/LLDBFrontend.exe";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.frontend = string;
    }
}

