/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.kotlin.commonNative.debugger;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XSourcePosition;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinFunctionBreakpointKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\f\u0010\t\u001a\u0004\u0018\u00010\u0001*\u00020\b\u00a8\u0006\n"}, d2={"calculateBreakpointPattern", "", "xSourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "project", "Lcom/intellij/openapi/project/Project;", "getClassPattern", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "getPackageName", "kotlin-ultimate.common-native"})
public final class KonanSymbolicBreakpointHandlerKt {
    @Nullable
    public static final String calculateBreakpointPattern(@Nullable XSourcePosition xSourcePosition, @NotNull Project project2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        SourcePosition sourcePosition2 = DebuggerUtilsEx.toSourcePosition((XSourcePosition)xSourcePosition, (Project)project2);
        if (sourcePosition2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sourcePosition2, (String)"DebuggerUtilsEx.toSource\u2026, project) ?: return null");
        SourcePosition sourcePosition3 = sourcePosition2;
        Object object = KotlinFunctionBreakpointKt.getMethodDescriptor(sourcePosition3, project2);
        if (object == null || (object = object.methodName) == null) {
            return null;
        }
        Object methodName2 = object;
        String string2 = KonanSymbolicBreakpointHandlerKt.getClassPattern(sourcePosition3, project2);
        if (string2 == null) {
            string2 = string = KonanSymbolicBreakpointHandlerKt.getPackageName(sourcePosition3);
        }
        if (string2 == null) {
            string = "";
        }
        String patternPrefix = string;
        return patternPrefix + "#" + (String)methodName2 + "\\(";
    }

    @Nullable
    public static final String getClassPattern(@NotNull SourcePosition sourcePosition2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)sourcePosition2, (String)"sourcePosition");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        KtClassOrObject ktClassOrObject = (KtClassOrObject)PositionUtil.getPsiElementAt((Project)project2, KtClassOrObject.class, (SourcePosition)sourcePosition2);
        return ktClassOrObject != null && (ktClassOrObject = ktClassOrObject.getFqName()) != null ? ktClassOrObject.asString() : null;
    }

    @Nullable
    public static final String getPackageName(@NotNull SourcePosition $this$getPackageName) {
        KtFile ktFile;
        Intrinsics.checkNotNullParameter((Object)$this$getPackageName, (String)"$this$getPackageName");
        PsiFile $this$safeAs$iv = $this$getPackageName.getFile();
        boolean $i$f$safeAs = false;
        PsiFile psiFile2 = $this$safeAs$iv;
        if (!(psiFile2 instanceof KtFile)) {
            psiFile2 = null;
        }
        return (ktFile = (KtFile)psiFile2) != null && (ktFile = ktFile.getPackageFqName()) != null ? ktFile.asString() : null;
    }
}

