/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.kotlin.commonNative;

import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.kotlin.commonNative.BinaryExecutable;
import com.jetbrains.kotlin.commonNative.RunParameters;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u001a\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u000fH\u0002\u001a\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u001a\u0012\u0010\u0016\u001a\u00020\u0017*\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000f\u001a\u0012\u0010\u0016\u001a\u00020\u0017*\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u000f\u001a\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u000fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"attributeExecName", "", "attributeFile", "attributeGradleTask", "attributeIsTest", "attributeName", "attributeProgramParameters", "attributeProjectPrefix", "attributeTarget", "attributeTargetName", "attributeWorkingDirectory", "nodeEnvVariables", "nodeVariant", "readBinaryExecutableFromXml", "Lcom/jetbrains/kotlin/commonNative/BinaryExecutable;", "Lorg/jdom/Element;", "projectDir", "Ljava/io/File;", "readRunParamsFromXml", "Lcom/jetbrains/kotlin/commonNative/RunParameters;", "readVariantFromXml", "Lcom/jetbrains/kotlin/commonNative/BinaryExecutable$Variant;", "writeToXml", "", "element", "kotlin-ultimate.common-native"})
public final class BinaryExecutableKt {
    private static final String nodeVariant = "variant";
    private static final String nodeEnvVariables = "envs";
    private static final String attributeTarget = "TARGET";
    private static final String attributeTargetName = "TARGET_NAME";
    private static final String attributeExecName = "EXECUTABLE_NAME";
    private static final String attributeProjectPrefix = "PROJECT_PREFIX";
    private static final String attributeIsTest = "IS_TEST";
    private static final String attributeName = "NAME";
    private static final String attributeGradleTask = "GRADLE_TASK";
    private static final String attributeFile = "FILE";
    @NotNull
    public static final String attributeWorkingDirectory = "WORKING_DIR";
    @NotNull
    public static final String attributeProgramParameters = "PROGRAM_PARAMS";

    public static final void writeToXml(@NotNull BinaryExecutable $this$writeToXml, @NotNull Element element3) {
        Intrinsics.checkNotNullParameter((Object)$this$writeToXml, (String)"$this$writeToXml");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        element3.setAttribute(attributeTarget, $this$writeToXml.getTarget().getName());
        element3.setAttribute(attributeTargetName, $this$writeToXml.getTargetName());
        element3.setAttribute(attributeExecName, $this$writeToXml.getExecName());
        element3.setAttribute(attributeProjectPrefix, $this$writeToXml.getProjectPrefix());
        element3.setAttribute(attributeIsTest, String.valueOf($this$writeToXml.isTest()));
        Iterable $this$forEach$iv = $this$writeToXml.getVariants();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BinaryExecutable.Variant variant = (BinaryExecutable.Variant)element$iv;
            boolean bl = false;
            Element e = new Element(nodeVariant);
            BinaryExecutableKt.writeToXml(variant, e);
            element3.addContent(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final BinaryExecutable readBinaryExecutableFromXml(@NotNull Element $this$readBinaryExecutableFromXml, @Nullable File projectDir) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$readBinaryExecutableFromXml, (String)"$this$readBinaryExecutableFromXml");
        List list2 = $this$readBinaryExecutableFromXml.getChildren(nodeVariant);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildren(nodeVariant)");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            BinaryExecutable.Variant variant;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Element it = (Element)element$iv$iv;
            boolean bl2 = false;
            Element element3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"it");
            if (BinaryExecutableKt.readVariantFromXml(element3, projectDir) == null) continue;
            BinaryExecutable.Variant it$iv$iv = variant;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List variants2 = (List)destination$iv$iv;
        if (variants2.isEmpty()) {
            return null;
        }
        String string = $this$readBinaryExecutableFromXml.getAttributeValue(attributeTarget);
        if (string == null) {
            return null;
        }
        String target2 = string;
        String string2 = $this$readBinaryExecutableFromXml.getAttributeValue(attributeTargetName);
        if (string2 == null) {
            return null;
        }
        String targetName2 = string2;
        String string3 = $this$readBinaryExecutableFromXml.getAttributeValue(attributeExecName);
        if (string3 == null) {
            return null;
        }
        String execName = string3;
        String string4 = $this$readBinaryExecutableFromXml.getAttributeValue(attributeProjectPrefix);
        if (string4 == null) {
            return null;
        }
        String projectPrefix = string4;
        KonanTarget konanTarget = (KonanTarget)KonanTarget.Companion.getPredefinedTargets().get(target2);
        if (konanTarget == null) {
            String string5 = "Unknown Konan target";
            throw new IllegalStateException(string5.toString());
        }
        String string6 = $this$readBinaryExecutableFromXml.getAttributeValue(attributeIsTest);
        return new BinaryExecutable(konanTarget, targetName2, execName, projectPrefix, Boolean.parseBoolean(string6), variants2);
    }

    public static final void writeToXml(@NotNull BinaryExecutable.Variant $this$writeToXml, @NotNull Element element3) {
        Intrinsics.checkNotNullParameter((Object)$this$writeToXml, (String)"$this$writeToXml");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        element3.setAttribute(attributeName, $this$writeToXml.getName());
        element3.setAttribute(attributeGradleTask, $this$writeToXml.getGradleTask());
        element3.setAttribute(attributeFile, FileUtil.toSystemIndependentName((String)$this$writeToXml.getFile().getPath()));
        BinaryExecutableKt.writeToXml($this$writeToXml.getParams(), element3);
    }

    @Nullable
    public static final BinaryExecutable.Variant readVariantFromXml(@NotNull Element $this$readVariantFromXml, @Nullable File projectDir) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)$this$readVariantFromXml, (String)"$this$readVariantFromXml");
        String string = $this$readVariantFromXml.getAttributeValue(attributeName);
        if (string == null) {
            return null;
        }
        String name2 = string;
        String string2 = $this$readVariantFromXml.getAttributeValue(attributeGradleTask);
        if (string2 == null) {
            return null;
        }
        String gradleTask = string2;
        String string3 = $this$readVariantFromXml.getAttributeValue(attributeFile);
        if (string3 == null) {
            return null;
        }
        String filePath = string3;
        RunParameters runParameters = BinaryExecutableKt.readRunParamsFromXml($this$readVariantFromXml);
        if (runParameters == null) {
            return null;
        }
        RunParameters params2 = runParameters;
        File f2 = file2 = new File(filePath);
        boolean bl = false;
        File file3 = !f2.isAbsolute() && projectDir != null ? FilesKt.resolve((File)projectDir, (File)f2) : f2;
        return StringsKt.contains((CharSequence)gradleTask, (CharSequence)"debug", (boolean)true) ? (BinaryExecutable.Variant)new BinaryExecutable.Variant.Debug(gradleTask, file3, params2, name2) : (BinaryExecutable.Variant)new BinaryExecutable.Variant.Release(gradleTask, file3, params2, name2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void writeToXml(RunParameters $this$writeToXml, Element element3) {
        element3.setAttribute(attributeWorkingDirectory, $this$writeToXml.getWorkingDirectory());
        element3.setAttribute(attributeProgramParameters, $this$writeToXml.getProgramParameters());
        Element envElement = new Element(nodeEnvVariables);
        Map<String, String> $this$forEach$iv = $this$writeToXml.getEnvironmentVariables();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void k;
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> $dstr$k$v = element$iv = iterator.next();
            boolean bl = false;
            Map.Entry<String, String> entry = $dstr$k$v;
            String string = entry.getKey();
            entry = $dstr$k$v;
            String v = entry.getValue();
            envElement.setAttribute((String)k, v);
        }
        element3.addContent(envElement);
    }

    /*
     * WARNING - void declaration
     */
    private static final RunParameters readRunParamsFromXml(Element $this$readRunParamsFromXml) {
        Map map2;
        String string = $this$readRunParamsFromXml.getAttributeValue(attributeWorkingDirectory);
        if (string == null) {
            return null;
        }
        String workingDirectory = string;
        String string2 = $this$readRunParamsFromXml.getAttributeValue(attributeProgramParameters);
        if (string2 == null) {
            return null;
        }
        String programParameters = string2;
        Object object = $this$readRunParamsFromXml.getChild(nodeEnvVariables);
        if (object != null && (object = object.getAttributes()) != null) {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = (Iterable)object;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map3 = destination$iv$iv;
                Attribute e = (Attribute)element$iv$iv;
                boolean bl = false;
                Attribute attribute = e;
                Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"e");
                Pair pair = TuplesKt.to((Object)attribute.getName(), (Object)e.getValue());
                map3.put(pair.getFirst(), pair.getSecond());
            }
            map2 = destination$iv$iv;
        } else {
            map2 = MapsKt.emptyMap();
        }
        Map envs = map2;
        return new RunParameters(workingDirectory, programParameters, envs);
    }
}

