/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.components.candidate.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.model.TypeVariableFromCallableDescriptor;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.LambdaKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionPart;
import org.jetbrains.kotlin.resolve.calls.model.SimpleTypeArgument;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/PostponedVariablesInitializerResolutionPart;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolutionPart;", "()V", "process", "", "Lorg/jetbrains/kotlin/resolve/calls/components/candidate/ResolutionCandidate;", "workIndex", "", "resolution"})
public final class PostponedVariablesInitializerResolutionPart
extends ResolutionPart {
    @NotNull
    public static final PostponedVariablesInitializerResolutionPart INSTANCE = new PostponedVariablesInitializerResolutionPart();

    private PostponedVariablesInitializerResolutionPart() {
    }

    @Override
    public void process(@NotNull ResolutionCandidate $this$process, int workIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$process, (String)"<this>");
        ConstraintSystemBuilder csBuilder = $this$process.getSystem().getBuilder();
        for (Map.Entry<KotlinCallArgument, ValueParameterDescriptor> entry : $this$process.getResolvedCall().getArgumentToCandidateParameter().entrySet()) {
            KotlinCallArgument argument2 = entry.getKey();
            ValueParameterDescriptor parameter = entry.getValue();
            if (!$this$process.getCallComponents().getStatelessCallbacks().isBuilderInferenceCall(argument2, parameter)) continue;
            KotlinType kotlinType = parameter.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"parameter.type");
            if (FunctionTypesKt.getReceiverTypeFromFunctionType(kotlinType) == null) continue;
            boolean dontUseBuilderInferenceIfPossible = $this$process.getCallComponents().getLanguageVersionSettings().supportsFeature(LanguageFeature.UseBuilderInferenceOnlyIfNeeded);
            if (argument2 instanceof LambdaKotlinCallArgument && !((LambdaKotlinCallArgument)argument2).getHasBuilderInferenceAnnotation()) {
                ((LambdaKotlinCallArgument)argument2).setHasBuilderInferenceAnnotation(true);
            }
            if (dontUseBuilderInferenceIfPossible) continue;
            for (TypeVariableFromCallableDescriptor freshVariable : $this$process.getResolvedCall().getFreshVariablesSubstitutor().getFreshVariables()) {
                KotlinType receiverType;
                if ($this$process.getResolvedCall().getTypeArgumentMappingByOriginal().getTypeArgument(freshVariable.getOriginalTypeParameter()) instanceof SimpleTypeArgument || csBuilder.isPostponedTypeVariable((TypeVariableMarker)freshVariable) || !TypeUtilsKt.contains(receiverType, (Function1<? super UnwrappedType, Boolean>)((Function1)new Function1<UnwrappedType, Boolean>(freshVariable){
                    final /* synthetic */ TypeVariableFromCallableDescriptor $freshVariable;
                    {
                        this.$freshVariable = $freshVariable;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull UnwrappedType it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Intrinsics.areEqual((Object)it.getConstructor(), (Object)this.$freshVariable.getOriginalTypeParameter().getTypeConstructor());
                    }
                }))) continue;
                csBuilder.markPostponedVariable((TypeVariableMarker)freshVariable);
            }
        }
    }
}

