/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.AstLoadingFilter;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolveUtilKt;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallExpressionElement;
import org.jetbrains.kotlin.resolve.calls.CallExpressionResolver;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArgumentsImpl;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.calls.util.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassifierQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.PackageQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00e2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 M2\u00020\u0001:\u0001MBM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001dJ4\u0010!\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'H\u0002J\u0016\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dJ@\u0010*\u001a\u0016\u0012\u0004\u0012\u00020,\u0012\f\u0012\n\u0012\u0004\u0012\u00020.\u0018\u00010-0+2\u0006\u0010/\u001a\u0002002\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u0003012\u0006\u00102\u001a\u0002032\u0006\u0010&\u001a\u00020'H\u0002J \u00104\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#2\u0006\u00105\u001a\u0002062\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J*\u00107\u001a\u00020\u00182\u0006\u00108\u001a\u0002092\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001c\u001a\u00020\u001dJ4\u00107\u001a\u00020\u00182\u0006\u00108\u001a\u0002092\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'H\u0002J4\u0010:\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'H\u0002J:\u0010=\u001a\u0010\u0012\u0004\u0012\u00020,\u0012\u0006\u0012\u0004\u0018\u00010>0+2\u0006\u00108\u001a\u0002092\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010?\u001a\u00020@2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010A\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\"\u0010B\u001a\u00020@2\u0006\u0010C\u001a\u00020D2\b\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J&\u0010E\u001a\b\u0012\u0004\u0012\u00020G0F2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010)\u001a\u0002092\u0006\u0010H\u001a\u00020IH\u0002J\u0010\u0010J\u001a\u00020@2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u001a\u0010K\u001a\b\u0012\u0004\u0012\u0002060L*\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CallExpressionResolver;", "", "callResolver", "Lorg/jetbrains/kotlin/resolve/calls/CallResolver;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "dataFlowAnalyzer", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "qualifiedExpressionResolver", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "kotlinTypeRefiner", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "(Lorg/jetbrains/kotlin/resolve/calls/CallResolver;Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;)V", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "checkSelectorTypeInfo", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "qualified", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "selectorTypeInfo", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "getCallExpressionTypeInfo", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getCallExpressionTypeInfoWithoutFinalTypeCheck", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;", "callOperationNode", "Lcom/intellij/lang/ASTNode;", "initialDataFlowInfoForArguments", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getQualifiedExpressionTypeInfo", "expression", "getResolvedCallForFunction", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "call", "Lorg/jetbrains/kotlin/psi/Call;", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "checkArguments", "Lorg/jetbrains/kotlin/resolve/calls/context/CheckArgumentTypesMode;", "getSafeOrUnsafeSelectorTypeInfo", "element", "Lorg/jetbrains/kotlin/resolve/calls/CallExpressionElement;", "getSimpleNameExpressionTypeInfo", "nameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "getUnsafeSelectorTypeInfo", "selectorExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getVariableType", "Lorg/jetbrains/kotlin/types/KotlinType;", "recordResultTypeInfo", "", "resultTypeInfo", "resolveDeferredReceiverInQualifiedExpression", "qualifier", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Qualifier;", "resolveSimpleName", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResults;", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "traceAndCache", "Lorg/jetbrains/kotlin/resolve/calls/context/TemporaryTraceAndCache;", "setExpressionTypingServices", "elementChain", "", "Companion", "frontend"})
public final class CallExpressionResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CallResolver callResolver;
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    @NotNull
    private final ArgumentTypeResolver argumentTypeResolver;
    @NotNull
    private final DataFlowAnalyzer dataFlowAnalyzer;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final QualifiedExpressionResolver qualifiedExpressionResolver;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;
    @NotNull
    private final KotlinTypeRefiner kotlinTypeRefiner;
    private ExpressionTypingServices expressionTypingServices;

    public CallExpressionResolver(@NotNull CallResolver callResolver, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull DataFlowAnalyzer dataFlowAnalyzer, @NotNull KotlinBuiltIns builtIns, @NotNull QualifiedExpressionResolver qualifiedExpressionResolver, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory dataFlowValueFactory, @NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)callResolver, (String)"callResolver");
        Intrinsics.checkNotNullParameter((Object)constantExpressionEvaluator, (String)"constantExpressionEvaluator");
        Intrinsics.checkNotNullParameter((Object)argumentTypeResolver, (String)"argumentTypeResolver");
        Intrinsics.checkNotNullParameter((Object)dataFlowAnalyzer, (String)"dataFlowAnalyzer");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)qualifiedExpressionResolver, (String)"qualifiedExpressionResolver");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)dataFlowValueFactory, (String)"dataFlowValueFactory");
        Intrinsics.checkNotNullParameter((Object)((Object)kotlinTypeRefiner), (String)"kotlinTypeRefiner");
        this.callResolver = callResolver;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.argumentTypeResolver = argumentTypeResolver;
        this.dataFlowAnalyzer = dataFlowAnalyzer;
        this.builtIns = builtIns;
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
        this.languageVersionSettings = languageVersionSettings;
        this.dataFlowValueFactory = dataFlowValueFactory;
        this.kotlinTypeRefiner = kotlinTypeRefiner;
    }

    @Inject
    public final void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        Intrinsics.checkNotNullParameter((Object)expressionTypingServices, (String)"expressionTypingServices");
        this.expressionTypingServices = expressionTypingServices;
    }

    private final Pair<Boolean, ResolvedCall<FunctionDescriptor>> getResolvedCallForFunction(Call call2, ResolutionContext<?> context, CheckArgumentTypesMode checkArguments, DataFlowInfo initialDataFlowInfoForArguments) {
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.callResolver.resolveFunctionCall(BasicCallResolutionContext.create(context, call2, checkArguments, new DataFlowInfoForArgumentsImpl(initialDataFlowInfoForArguments, call2)));
        Intrinsics.checkNotNullExpressionValue(overloadResolutionResults, (String)"callResolver.resolveFunc\u2026)\n            )\n        )");
        OverloadResolutionResults<FunctionDescriptor> results = overloadResolutionResults;
        return !results.isNothing() ? new Pair((Object)true, OverloadResolutionResultsUtil.getResultingCall(results, context)) : new Pair((Object)false, null);
    }

    private final Pair<Boolean, KotlinType> getVariableType(KtSimpleNameExpression nameExpression, Receiver receiver, ASTNode callOperationNode, ExpressionTypingContext context) {
        TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as local variable or property", (KtExpression)nameExpression);
        Call call2 = CallMaker.makePropertyCall(receiver, callOperationNode, nameExpression);
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"makePropertyCall(receive\u2026tionNode, nameExpression)");
        Call call3 = call2;
        BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(context.replaceTraceAndCache(temporaryForVariable), call3, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        Intrinsics.checkNotNullExpressionValue((Object)basicCallResolutionContext, (String)"create(\n            cont\u2026VALUE_ARGUMENTS\n        )");
        BasicCallResolutionContext contextForVariable = basicCallResolutionContext;
        OverloadResolutionResults<VariableDescriptor> overloadResolutionResults = this.callResolver.resolveSimpleProperty(contextForVariable);
        Intrinsics.checkNotNullExpressionValue(overloadResolutionResults, (String)"callResolver.resolveSimp\u2026perty(contextForVariable)");
        OverloadResolutionResults<VariableDescriptor> resolutionResult = overloadResolutionResults;
        boolean isLHSOfDot = KtPsiUtil.isLHSOfDot((KtExpression)((KtExpression)nameExpression));
        if (!resolutionResult.isNothing() && resolutionResult.getResultCode() != OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER) {
            boolean isQualifier;
            boolean bl = isQualifier = isLHSOfDot && resolutionResult.isSingleResult() && resolutionResult.getResultingDescriptor() instanceof FakeCallableDescriptorForObject;
            if (!isQualifier) {
                temporaryForVariable.commit();
                return new Pair((Object)true, resolutionResult.isSingleResult() ? resolutionResult.getResultingDescriptor().getReturnType() : null);
            }
        }
        temporaryForVariable.commit();
        return new Pair((Object)(!resolutionResult.isNothing() ? 1 : 0), resolutionResult.isSingleResult() ? resolutionResult.getResultingDescriptor().getReturnType() : null);
    }

    @NotNull
    public final KotlinTypeInfo getSimpleNameExpressionTypeInfo(@NotNull KtSimpleNameExpression nameExpression, @Nullable Receiver receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context) {
        Intrinsics.checkNotNullParameter((Object)nameExpression, (String)"nameExpression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"context.dataFlowInfo");
        return this.getSimpleNameExpressionTypeInfo(nameExpression, receiver, callOperationNode, context, dataFlowInfo);
    }

    private final KotlinTypeInfo getSimpleNameExpressionTypeInfo(KtSimpleNameExpression nameExpression, Receiver receiver, ASTNode callOperationNode, ExpressionTypingContext context, DataFlowInfo initialDataFlowInfoForArguments) {
        block5: {
            Unit unit;
            TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as variable", (KtExpression)nameExpression);
            Object Context2 = context.replaceTraceAndCache(temporaryForVariable);
            Intrinsics.checkNotNullExpressionValue(Context2, (String)"context.replaceTraceAndCache(temporaryForVariable)");
            Pair<Boolean, KotlinType> pair = this.getVariableType(nameExpression, receiver, callOperationNode, (ExpressionTypingContext)Context2);
            boolean notNothing = (Boolean)pair.component1();
            KotlinType type2 = (KotlinType)pair.component2();
            if (notNothing) {
                temporaryForVariable.commit();
                return TypeInfoFactoryKt.createTypeInfo(type2, initialDataFlowInfoForArguments);
            }
            Call call2 = CallMaker.makeCall((KtElement)nameExpression, receiver, callOperationNode, (KtExpression)nameExpression, CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"makeCall(nameExpression,\u2026eExpression, emptyList())");
            Call call3 = call2;
            TemporaryTraceAndCache temporaryForFunction = TemporaryTraceAndCache.create(context, "trace to resolve as function", (KtExpression)nameExpression);
            Object Context3 = context.replaceTraceAndCache(temporaryForFunction);
            Intrinsics.checkNotNullExpressionValue(Context3, (String)"context.replaceTraceAndCache(temporaryForFunction)");
            ExpressionTypingContext newContext = (ExpressionTypingContext)Context3;
            Pair<Boolean, ResolvedCall<FunctionDescriptor>> pair2 = this.getResolvedCallForFunction(call3, newContext, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, initialDataFlowInfoForArguments);
            boolean resolveResult = (Boolean)pair2.component1();
            ResolvedCall resolvedCall2 = (ResolvedCall)pair2.component2();
            if (resolveResult) {
                FunctionDescriptor functionDescriptor;
                ResolvedCall resolvedCall3 = resolvedCall2;
                FunctionDescriptor functionDescriptor2 = functionDescriptor = resolvedCall3 != null ? (FunctionDescriptor)resolvedCall3.getResultingDescriptor() : null;
                if (!(functionDescriptor instanceof ConstructorDescriptor)) {
                    temporaryForFunction.commit();
                    boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
                    context.trace.report(Errors.FUNCTION_CALL_EXPECTED.on((KtExpression)((PsiElement)nameExpression), (KtExpression)nameExpression, hasValueParameters));
                    FunctionDescriptor functionDescriptor3 = functionDescriptor;
                    return TypeInfoFactoryKt.createTypeInfo(functionDescriptor3 != null ? functionDescriptor3.getReturnType() : null, context);
                }
            }
            TemporaryTraceAndCache temporaryForQualifier = TemporaryTraceAndCache.create(context, "trace to resolve as qualifier", (KtExpression)nameExpression);
            Object Context4 = context.replaceTraceAndCache(temporaryForQualifier);
            Intrinsics.checkNotNullExpressionValue(Context4, (String)"context.replaceTraceAndC\u2026he(temporaryForQualifier)");
            ExpressionTypingContext contextForQualifier = (ExpressionTypingContext)Context4;
            Qualifier qualifier = this.qualifiedExpressionResolver.resolveNameExpressionAsQualifierForDiagnostics(nameExpression, receiver, contextForQualifier);
            if (qualifier != null) {
                Qualifier it = qualifier;
                boolean bl = false;
                QualifiedExpressionResolveUtilKt.resolveQualifierAsStandaloneExpression(it, contextForQualifier);
                temporaryForQualifier.commit();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block5;
            temporaryForVariable.commit();
        }
        return TypeInfoFactoryKt.noTypeInfo(context);
    }

    @NotNull
    public final KotlinTypeInfo getCallExpressionTypeInfo(@NotNull KtCallExpression callExpression, @NotNull ExpressionTypingContext context) {
        Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"context.dataFlowInfo");
        KotlinTypeInfo typeInfo = this.getCallExpressionTypeInfoWithoutFinalTypeCheck(callExpression, null, null, context, dataFlowInfo);
        if (context.contextDependency == ContextDependency.INDEPENDENT) {
            this.dataFlowAnalyzer.checkType(typeInfo.getType(), (KtExpression)callExpression, (ResolutionContext)context);
        }
        return typeInfo;
    }

    private final KotlinTypeInfo getCallExpressionTypeInfoWithoutFinalTypeCheck(KtCallExpression callExpression, Receiver receiver, ASTNode callOperationNode, ExpressionTypingContext context, DataFlowInfo initialDataFlowInfoForArguments) {
        Call call2 = CallMaker.makeCall(receiver, callOperationNode, (KtCallElement)callExpression);
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"makeCall(receiver, callO\u2026tionNode, callExpression)");
        Call call3 = call2;
        TemporaryTraceAndCache temporaryForFunction = TemporaryTraceAndCache.create(context, "trace to resolve as function call", (KtExpression)callExpression);
        Object Context2 = context.replaceTraceAndCache(temporaryForFunction);
        Intrinsics.checkNotNullExpressionValue(Context2, (String)"context.replaceTraceAndCache(temporaryForFunction)");
        Pair<Boolean, ResolvedCall<FunctionDescriptor>> pair = this.getResolvedCallForFunction(call3, (ResolutionContext<?>)Context2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, initialDataFlowInfoForArguments);
        boolean resolveResult = (Boolean)pair.component1();
        ResolvedCall resolvedCall2 = (ResolvedCall)pair.component2();
        if (resolveResult) {
            DataFlowInfo resultFlowInfo;
            ResolvedCall resolvedCall3 = resolvedCall2;
            FunctionDescriptor functionDescriptor = resolvedCall3 != null ? (FunctionDescriptor)resolvedCall3.getResultingDescriptor() : null;
            temporaryForFunction.commit();
            if (callExpression.getValueArgumentList() == null && callExpression.getLambdaArguments().isEmpty()) {
                boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
                context.trace.report(Errors.FUNCTION_CALL_EXPECTED.on((KtExpression)((PsiElement)callExpression), (KtExpression)callExpression, hasValueParameters));
            }
            if (functionDescriptor == null) {
                return TypeInfoFactoryKt.noTypeInfo(context);
            }
            if (functionDescriptor instanceof ConstructorDescriptor) {
                ClassDescriptor classDescriptor = ((ConstructorDescriptor)functionDescriptor).getConstructedClass();
                Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"functionDescriptor.constructedClass");
                ClassDescriptor constructedClass = classDescriptor;
                if (DescriptorUtils.isAnnotationClass(constructedClass)) {
                    BindingTrace bindingTrace = context.trace;
                    Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"context.trace");
                    if (!Companion.canInstantiateAnnotationClass(callExpression, bindingTrace)) {
                        boolean supported;
                        boolean bl = supported = context.languageVersionSettings.supportsFeature(LanguageFeature.InstantiationOfAnnotationClasses) && constructedClass.getDeclaredTypeParameters().isEmpty();
                        if (!supported) {
                            context.trace.report(Errors.ANNOTATION_CLASS_CONSTRUCTOR_CALL.on((KtCallExpression)((PsiElement)callExpression)));
                        }
                    }
                }
                if (DescriptorUtils.isEnumClass(constructedClass)) {
                    context.trace.report(Errors.ENUM_CLASS_CONSTRUCTOR_CALL.on((KtCallExpression)((PsiElement)callExpression)));
                }
                if (DescriptorUtils.isSealedClass(constructedClass)) {
                    context.trace.report(Errors.SEALED_CLASS_CONSTRUCTOR_CALL.on((KtCallExpression)((PsiElement)callExpression)));
                }
            }
            KotlinType type2 = functionDescriptor.getReturnType();
            List list2 = callExpression.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"callExpression.valueArguments");
            List arguments2 = list2;
            DataFlowInfo dataFlowInfo = resolvedCall2.getDataFlowInfoForArguments().getResultInfo();
            Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"resolvedCall.dataFlowInfoForArguments.resultInfo");
            DataFlowInfo jumpFlowInfo = resultFlowInfo = dataFlowInfo;
            boolean jumpOutPossible = false;
            for (KtValueArgument argument2 : arguments2) {
                KotlinTypeInfo argTypeInfo = (KotlinTypeInfo)context.trace.get(BindingContext.EXPRESSION_TYPE_INFO, argument2.getArgumentExpression());
                if (argTypeInfo == null || !argTypeInfo.getJumpOutPossible()) continue;
                jumpOutPossible = true;
                jumpFlowInfo = argTypeInfo.getJumpFlowInfo();
                break;
            }
            return TypeInfoFactoryKt.createTypeInfo(type2, resultFlowInfo, jumpOutPossible, jumpFlowInfo);
        }
        KtExpression calleeExpression = callExpression.getCalleeExpression();
        if (calleeExpression instanceof KtSimpleNameExpression && callExpression.getTypeArgumentList() == null) {
            TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as variable with 'invoke' call", (KtExpression)callExpression);
            KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)calleeExpression;
            Object Context3 = context.replaceTraceAndCache(temporaryForVariable);
            Intrinsics.checkNotNullExpressionValue(Context3, (String)"context.replaceTraceAndCache(temporaryForVariable)");
            Pair<Boolean, KotlinType> pair2 = this.getVariableType(ktSimpleNameExpression, receiver, callOperationNode, (ExpressionTypingContext)Context3);
            boolean notNothing = (Boolean)pair2.component1();
            KotlinType type3 = (KotlinType)pair2.component2();
            TemporaryBindingTrace temporaryBindingTrace = temporaryForVariable.trace;
            WritableSlice<KtExpression, Qualifier> writableSlice = BindingContext.QUALIFIER;
            Intrinsics.checkNotNullExpressionValue(writableSlice, (String)"QUALIFIER");
            Qualifier qualifier = (Qualifier)temporaryBindingTrace.get(writableSlice, calleeExpression);
            if (notNothing && (qualifier == null || !(qualifier instanceof PackageQualifier))) {
                ResolvedCall<? extends CallableDescriptor> it = CallUtilKt.getResolvedCall((KtElement)callExpression, temporaryForVariable.trace.getBindingContext());
                boolean bl = false;
                ResolvedCallImpl resolvedCallImpl = it instanceof ResolvedCallImpl ? (ResolvedCallImpl)it : null;
                if (resolvedCallImpl != null) {
                    resolvedCallImpl.addStatus(ResolutionStatus.OTHER_ERROR);
                }
                temporaryForVariable.commit();
                BindingTrace bindingTrace = context.trace;
                PsiElement psiElement = (PsiElement)calleeExpression;
                KotlinType kotlinType = type3;
                if (kotlinType == null) {
                    kotlinType = ErrorUtils.createErrorType(ErrorTypeKind.ERROR_EXPECTED_TYPE, new String[0]);
                }
                bindingTrace.report(Errors.FUNCTION_EXPECTED.on((KtExpression)psiElement, calleeExpression, kotlinType));
                this.argumentTypeResolver.analyzeArgumentsAndRecordTypes(BasicCallResolutionContext.create(context, call3, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, new DataFlowInfoForArgumentsImpl(initialDataFlowInfoForArguments, call3)), ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
                return TypeInfoFactoryKt.noTypeInfo(context);
            }
        }
        temporaryForFunction.commit();
        return TypeInfoFactoryKt.noTypeInfo(context);
    }

    private final List<CallExpressionElement> elementChain(KtQualifiedExpression $this$elementChain, ExpressionTypingContext context) {
        return this.qualifiedExpressionResolver.resolveQualifierInExpressionAndUnroll($this$elementChain, context, (Function1<? super KtSimpleNameExpression, Boolean>)((Function1)new Function1<KtSimpleNameExpression, Boolean>(context, this){
            final /* synthetic */ ExpressionTypingContext $context;
            final /* synthetic */ CallExpressionResolver this$0;
            {
                this.$context = $context;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtSimpleNameExpression nameExpression) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)nameExpression, (String)"nameExpression");
                TemporaryTraceAndCache temporaryTraceAndCache = TemporaryTraceAndCache.create(this.$context, "trace to resolve as local variable or property", (KtExpression)nameExpression);
                Intrinsics.checkNotNullExpressionValue((Object)temporaryTraceAndCache, (String)"temporaryTraceAndCache");
                OverloadResolutionResults resolutionResult = CallExpressionResolver.access$resolveSimpleName(this.this$0, this.$context, nameExpression, temporaryTraceAndCache);
                if (resolutionResult.isSingleResult() && resolutionResult.getResultingDescriptor() instanceof FakeCallableDescriptorForObject) {
                    bl = false;
                } else {
                    switch (elementChain.WhenMappings.$EnumSwitchMapping$0[resolutionResult.getResultCode().ordinal()]) {
                        case 1: 
                        case 2: {
                            bl = false;
                            break;
                        }
                        default: {
                            boolean success;
                            boolean newInferenceEnabled = this.$context.languageVersionSettings.supportsFeature(LanguageFeature.NewInference);
                            boolean bl2 = success = !newInferenceEnabled || resolutionResult.isSuccess();
                            if (newInferenceEnabled && success) {
                                temporaryTraceAndCache.commit();
                            }
                            bl = success;
                        }
                    }
                }
                return bl;
            }
        }));
    }

    private final OverloadResolutionResults<VariableDescriptor> resolveSimpleName(ExpressionTypingContext context, KtSimpleNameExpression expression2, TemporaryTraceAndCache traceAndCache) {
        Call call2 = CallMaker.makePropertyCall(null, null, expression2);
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"makePropertyCall(null, null, expression)");
        Call call3 = call2;
        BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(context.replaceTraceAndCache(traceAndCache), call3, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        Intrinsics.checkNotNullExpressionValue((Object)basicCallResolutionContext, (String)"create(\n            cont\u2026VALUE_ARGUMENTS\n        )");
        BasicCallResolutionContext contextForVariable = basicCallResolutionContext;
        OverloadResolutionResults<VariableDescriptor> overloadResolutionResults = this.callResolver.resolveSimpleProperty(contextForVariable);
        Intrinsics.checkNotNullExpressionValue(overloadResolutionResults, (String)"callResolver.resolveSimp\u2026perty(contextForVariable)");
        return overloadResolutionResults;
    }

    private final KotlinTypeInfo getUnsafeSelectorTypeInfo(Receiver receiver, ASTNode callOperationNode, KtExpression selectorExpression, ExpressionTypingContext context, DataFlowInfo initialDataFlowInfoForArguments) {
        KotlinTypeInfo kotlinTypeInfo;
        KtExpression ktExpression = selectorExpression;
        if (ktExpression instanceof KtCallExpression) {
            kotlinTypeInfo = this.getCallExpressionTypeInfoWithoutFinalTypeCheck((KtCallExpression)selectorExpression, receiver, callOperationNode, context, initialDataFlowInfoForArguments);
        } else if (ktExpression instanceof KtSimpleNameExpression) {
            kotlinTypeInfo = this.getSimpleNameExpressionTypeInfo((KtSimpleNameExpression)selectorExpression, receiver, callOperationNode, context, initialDataFlowInfoForArguments);
        } else if (ktExpression != null) {
            ExpressionTypingServices expressionTypingServices = this.expressionTypingServices;
            if (expressionTypingServices == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"expressionTypingServices");
                expressionTypingServices = null;
            }
            expressionTypingServices.getTypeInfo(selectorExpression, context);
            context.trace.report(Errors.ILLEGAL_SELECTOR.on((KtExpression)((PsiElement)selectorExpression)));
            kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        } else {
            kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        }
        return kotlinTypeInfo;
    }

    private final KotlinTypeInfo getSafeOrUnsafeSelectorTypeInfo(Receiver receiver, CallExpressionElement element, ExpressionTypingContext context) {
        KotlinType selectorType;
        KotlinTypeInfo kotlinTypeInfo;
        DataFlowValue dataFlowValue;
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"context.dataFlowInfo");
        DataFlowInfo initialDataFlowInfoForArguments = dataFlowInfo;
        ReceiverValue receiverValue = receiver instanceof ReceiverValue ? (ReceiverValue)receiver : null;
        if (receiverValue != null) {
            ReceiverValue it = receiverValue;
            boolean bl = false;
            dataFlowValue = this.dataFlowValueFactory.createDataFlowValue(it, context);
        } else {
            dataFlowValue = null;
        }
        DataFlowValue receiverDataFlowValue = dataFlowValue;
        boolean receiverCanBeNull = receiverDataFlowValue != null && initialDataFlowInfoForArguments.getStableNullability(receiverDataFlowValue).canBeNull();
        boolean shouldNullifySafeCallType = receiverCanBeNull || context.languageVersionSettings.supportsFeature(LanguageFeature.SafeCallsAreAlwaysNullable);
        ASTNode callOperationNode = (ASTNode)AstLoadingFilter.forceAllowTreeLoading((PsiFile)element.getQualified().getContainingFile(), () -> CallExpressionResolver.getSafeOrUnsafeSelectorTypeInfo$lambda-3(element));
        if (receiverDataFlowValue != null && element.getSafe()) {
            if (shouldNullifySafeCallType) {
                initialDataFlowInfoForArguments = initialDataFlowInfoForArguments.disequate(receiverDataFlowValue, DataFlowValue.Companion.nullValue(this.builtIns), this.languageVersionSettings);
            }
            if (!receiverCanBeNull) {
                BindingTrace bindingTrace = context.trace;
                Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"context.trace");
                KotlinType kotlinType = ((ReceiverValue)receiver).getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"receiver.type");
                KtQualifiedExpression ktQualifiedExpression = element.getQualified();
                Intrinsics.checkNotNullExpressionValue((Object)callOperationNode, (String)"callOperationNode");
                LanguageVersionSettings languageVersionSettings = context.languageVersionSettings;
                Intrinsics.checkNotNullExpressionValue((Object)languageVersionSettings, (String)"context.languageVersionSettings");
                Companion.reportUnnecessarySafeCall(bindingTrace, kotlinType, ktQualifiedExpression, callOperationNode, receiver, languageVersionSettings);
            }
        }
        KtExpression selector = element.getSelector();
        KotlinTypeInfo $this$getSafeOrUnsafeSelectorTypeInfo_u24lambda_u2d4 = this.getUnsafeSelectorTypeInfo(receiver, callOperationNode, selector, context, initialDataFlowInfoForArguments);
        boolean bl = false;
        KotlinType kotlinType = $this$getSafeOrUnsafeSelectorTypeInfo_u24lambda_u2d4.getType();
        if (kotlinType == null) {
            kotlinTypeInfo = $this$getSafeOrUnsafeSelectorTypeInfo_u24lambda_u2d4;
        } else {
            KotlinType type2 = kotlinType;
            kotlinTypeInfo = $this$getSafeOrUnsafeSelectorTypeInfo_u24lambda_u2d4.replaceType(this.kotlinTypeRefiner.refineType(type2));
        }
        KotlinTypeInfo selectorTypeInfo = kotlinTypeInfo;
        if (receiver instanceof Qualifier) {
            this.resolveDeferredReceiverInQualifiedExpression((Qualifier)receiver, selector, context);
        }
        if ((selectorType = selectorTypeInfo.getType()) != null) {
            if (element.getSafe() && shouldNullifySafeCallType) {
                selectorTypeInfo = selectorTypeInfo.replaceType(TypeUtils.makeNullable(selectorType));
            }
            if (selector != null) {
                context.trace.recordType(selector, selectorTypeInfo.getType());
            }
        }
        return selectorTypeInfo;
    }

    private final KotlinTypeInfo checkSelectorTypeInfo(KtQualifiedExpression qualified, KotlinTypeInfo selectorTypeInfo, ExpressionTypingContext context) {
        KotlinTypeInfo kotlinTypeInfo;
        CallExpressionResolver.Companion.checkNestedClassAccess(qualified, context);
        KtExpression ktExpression = (KtExpression)qualified;
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"context.trace");
        CompileTimeConstant value2 = ConstantExpressionEvaluator.evaluateExpression$default(this.constantExpressionEvaluator, ktExpression, bindingTrace, context.expectedType, false, 8, null);
        if (value2 != null && value2.isPure()) {
            KotlinTypeInfo kotlinTypeInfo2 = this.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(value2, (KtExpression)qualified, context);
            kotlinTypeInfo = kotlinTypeInfo2;
            Intrinsics.checkNotNullExpressionValue((Object)kotlinTypeInfo2, (String)"{\n            dataFlowAn\u2026ified, context)\n        }");
        } else {
            if (context.contextDependency == ContextDependency.INDEPENDENT) {
                this.dataFlowAnalyzer.checkType(selectorTypeInfo.getType(), (KtExpression)qualified, (ResolutionContext)context);
            }
            kotlinTypeInfo = selectorTypeInfo;
        }
        return kotlinTypeInfo;
    }

    private final void recordResultTypeInfo(KtQualifiedExpression qualified, KotlinTypeInfo resultTypeInfo, ExpressionTypingContext context) {
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"context.trace");
        BindingTrace trace = bindingTrace;
        if (!Intrinsics.areEqual(trace.get(BindingContext.PROCESSED, qualified), (Object)true)) {
            trace.record(BindingContext.PROCESSED, qualified);
            trace.record(BindingContext.EXPRESSION_TYPE_INFO, qualified, resultTypeInfo);
            LexicalScope lexicalScope = context.scope;
            Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"context.scope");
            BindingContextUtilsKt.recordScope(trace, lexicalScope, (KtElement)qualified);
            Object Context2 = context.replaceDataFlowInfo(resultTypeInfo.getDataFlowInfo());
            Intrinsics.checkNotNullExpressionValue(Context2, (String)"context.replaceDataFlowI\u2026ultTypeInfo.dataFlowInfo)");
            BindingContextUtilsKt.recordDataFlowInfo(Context2, (KtExpression)qualified);
        }
    }

    @NotNull
    public final KotlinTypeInfo getQualifiedExpressionTypeInfo(@NotNull KtQualifiedExpression expression2, @NotNull ExpressionTypingContext context) {
        KotlinTypeInfo receiverTypeInfo;
        KotlinTypeInfo kotlinTypeInfo;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object Context2 = ((ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        Intrinsics.checkNotNullExpressionValue(Context2, (String)"context.replaceExpectedT\u2026xtDependency(INDEPENDENT)");
        ExpressionTypingContext currentContext = (ExpressionTypingContext)Context2;
        BindingTrace bindingTrace = currentContext.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"currentContext.trace");
        BindingTrace trace = bindingTrace;
        List<CallExpressionElement> elementChain2 = this.elementChain(expression2, currentContext);
        KtExpression firstReceiver = ((CallExpressionElement)CollectionsKt.first(elementChain2)).getReceiver();
        if ((Qualifier)trace.get(BindingContext.QUALIFIER, firstReceiver) == null) {
            ExpressionTypingServices expressionTypingServices = this.expressionTypingServices;
            if (expressionTypingServices == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"expressionTypingServices");
                expressionTypingServices = null;
            }
            kotlinTypeInfo = expressionTypingServices.getTypeInfo(firstReceiver, currentContext);
        } else {
            DataFlowInfo dataFlowInfo = currentContext.dataFlowInfo;
            Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"currentContext.dataFlowInfo");
            kotlinTypeInfo = new KotlinTypeInfo(null, dataFlowInfo, false, null, 12, null);
        }
        KotlinTypeInfo kotlinTypeInfo2 = kotlinTypeInfo;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinTypeInfo2, (String)"when (trace.get(BindingC\u2026t.dataFlowInfo)\n        }");
        KotlinTypeInfo resultTypeInfo = receiverTypeInfo = kotlinTypeInfo2;
        boolean allUnsafe = true;
        DataFlowInfo branchPointDataFlowInfo = receiverTypeInfo.getDataFlowInfo();
        for (CallExpressionElement element : elementChain2) {
            Receiver receiver;
            KotlinType receiverType;
            String[] stringArray;
            KotlinType kotlinType = receiverTypeInfo.getType();
            if (kotlinType == null) {
                stringArray = new String[1];
                KtExpression receiver2 = element.getReceiver();
                String string2 = receiver2 instanceof KtNameReferenceExpression ? ((KtNameReferenceExpression)receiver2).getReferencedName() : receiver2.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"when (val receiver = ele\u2026ext\n                    }");
                stringArray[0] = string2;
                kotlinType = receiverType = (KotlinType)ErrorUtils.createErrorType(ErrorTypeKind.ERROR_RECEIVER_TYPE, stringArray);
            }
            if ((stringArray = (Qualifier)trace.get(BindingContext.QUALIFIER, element.getReceiver())) == null) {
                KtExpression ktExpression = element.getReceiver();
                BindingContext bindingContext = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
                receiver = ExpressionReceiver.Companion.create(ktExpression, receiverType, bindingContext);
            } else {
                receiver = (Receiver)stringArray;
            }
            Receiver receiver3 = receiver;
            KtQualifiedExpression qualifiedExpression = element.getQualified();
            boolean lastStage = qualifiedExpression == expression2;
            Object Context3 = (lastStage ? context : currentContext).replaceDataFlowInfo(receiver3 instanceof ReceiverValue && TypeUtils.isNullableType(((ReceiverValue)receiver3).getType()) && !element.getSafe() ? branchPointDataFlowInfo : receiverTypeInfo.getDataFlowInfo());
            Intrinsics.checkNotNullExpressionValue(Context3, (String)"if (lastStage) context e\u2026          }\n            )");
            ExpressionTypingContext contextForSelector = (ExpressionTypingContext)Context3;
            KotlinTypeInfo selectorTypeInfo = this.getSafeOrUnsafeSelectorTypeInfo(receiver3, element, contextForSelector);
            boolean bl = allUnsafe = allUnsafe && !element.getSafe();
            if (allUnsafe) {
                branchPointDataFlowInfo = selectorTypeInfo.getDataFlowInfo();
            }
            resultTypeInfo = this.checkSelectorTypeInfo(qualifiedExpression, selectorTypeInfo, contextForSelector).replaceDataFlowInfo(branchPointDataFlowInfo);
            if (!lastStage) {
                this.recordResultTypeInfo(qualifiedExpression, resultTypeInfo, contextForSelector);
            }
            receiverTypeInfo = selectorTypeInfo;
        }
        return resultTypeInfo;
    }

    private final void resolveDeferredReceiverInQualifiedExpression(Qualifier qualifier, KtExpression selectorExpression, ExpressionTypingContext context) {
        DeclarationDescriptor declarationDescriptor;
        KtExpression calleeExpression = KtPsiUtil.deparenthesize((KtExpression)CallUtilKt.getCalleeExpressionIfAny((KtElement)selectorExpression));
        KtReferenceExpression ktReferenceExpression = calleeExpression instanceof KtReferenceExpression ? (KtReferenceExpression)calleeExpression : null;
        if (ktReferenceExpression != null) {
            KtReferenceExpression it = ktReferenceExpression;
            boolean bl = false;
            declarationDescriptor = (DeclarationDescriptor)context.trace.get(BindingContext.REFERENCE_TARGET, it);
        } else {
            declarationDescriptor = null;
        }
        DeclarationDescriptor selectorDescriptor = declarationDescriptor;
        QualifiedExpressionResolveUtilKt.resolveQualifierAsReceiverInExpression(qualifier, selectorDescriptor, context);
    }

    private static final ASTNode getSafeOrUnsafeSelectorTypeInfo$lambda-3(CallExpressionElement $element) {
        Intrinsics.checkNotNullParameter((Object)$element, (String)"$element");
        return $element.getNode();
    }

    public static final /* synthetic */ OverloadResolutionResults access$resolveSimpleName(CallExpressionResolver $this, ExpressionTypingContext context, KtSimpleNameExpression expression2, TemporaryTraceAndCache traceAndCache) {
        return $this.resolveSimpleName(context, expression2, traceAndCache);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J8\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CallExpressionResolver$Companion;", "", "()V", "canInstantiateAnnotationClass", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkNestedClassAccess", "", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "isUnderAnnotationClassDeclaration", "parent", "Lcom/intellij/psi/PsiElement;", "reportUnnecessarySafeCall", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "callElement", "callOperationNode", "Lcom/intellij/lang/ASTNode;", "explicitReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean canInstantiateAnnotationClass(@NotNull KtCallExpression expression2, @NotNull BindingTrace trace) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            PsiElement psiElement = new Class[]{KtValueArgument.class, KtParameter.class};
            PsiElement parent2 = PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expression2), (Class[])psiElement);
            if (parent2 instanceof KtValueArgument) {
                PsiElement $this$getParentOfType$iv;
                psiElement = parent2;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtAnnotationEntry.class, (boolean)strict$iv) != null) {
                    return true;
                }
                $this$getParentOfType$iv = parent2;
                strict$iv = true;
                $i$f$getParentOfType = false;
                parent2 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtParameter.class, (boolean)strict$iv);
                if (parent2 != null) {
                    return this.isUnderAnnotationClassDeclaration(trace, parent2);
                }
            } else if (parent2 instanceof KtParameter) {
                return this.isUnderAnnotationClassDeclaration(trace, parent2);
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isUnderAnnotationClassDeclaration(BindingTrace trace, PsiElement parent2) {
            boolean bl;
            void $this$getParentOfType$iv;
            PsiElement psiElement = parent2;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            KtClass ktClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClass.class, (boolean)strict$iv);
            if (ktClass != null) {
                KtClass it = ktClass;
                boolean bl2 = false;
                bl = DescriptorUtils.isAnnotationClass(trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, it));
            } else {
                bl = false;
            }
            return bl;
        }

        public final void reportUnnecessarySafeCall(@NotNull BindingTrace trace, @NotNull KotlinType type2, @NotNull KtQualifiedExpression callElement, @NotNull ASTNode callOperationNode, @Nullable Receiver explicitReceiver, @NotNull LanguageVersionSettings languageVersionSettings) {
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Intrinsics.checkNotNullParameter((Object)callElement, (String)"callElement");
            Intrinsics.checkNotNullParameter((Object)callOperationNode, (String)"callOperationNode");
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
            if (explicitReceiver instanceof ExpressionReceiver && ((ExpressionReceiver)explicitReceiver).getExpression() instanceof KtSuperExpression) {
                trace.report(Errors.UNEXPECTED_SAFE_CALL.on(callOperationNode.getPsi()));
            } else if (!KotlinTypeKt.isError(type2)) {
                trace.report(Errors.UNNECESSARY_SAFE_CALL.on(callOperationNode.getPsi(), type2));
                if (!languageVersionSettings.supportsFeature(LanguageFeature.SafeCallsAreAlwaysNullable)) {
                    trace.report(Errors.SAFE_CALL_WILL_CHANGE_NULLABILITY.on((KtQualifiedExpression)((PsiElement)callElement)));
                }
            }
        }

        private final void checkNestedClassAccess(KtQualifiedExpression expression2, ExpressionTypingContext context) {
            KtExpression ktExpression = expression2.getSelectorExpression();
            if (ktExpression == null) {
                return;
            }
            KtExpression selectorExpression = ktExpression;
            Qualifier expressionQualifier = (Qualifier)context.trace.get(BindingContext.QUALIFIER, expression2);
            Qualifier receiverQualifier = (Qualifier)context.trace.get(BindingContext.QUALIFIER, expression2.getReceiverExpression());
            if (receiverQualifier == null && expressionQualifier != null) {
                boolean bl = expressionQualifier instanceof ClassifierQualifier;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl2 = false;
                    String string2 = "Only class can (package cannot) be accessed by instance reference: " + expressionQualifier;
                    throw new AssertionError((Object)string2);
                }
                ClassifierDescriptorWithTypeParameters descriptor2 = ((ClassifierQualifier)expressionQualifier).getDescriptor();
                context.trace.report(Errors.NESTED_CLASS_ACCESSED_VIA_INSTANCE_REFERENCE.on((KtExpression)((PsiElement)selectorExpression), descriptor2));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

