/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.extensions.DeclarationAttributeAltererExtension;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationUseSiteTargetChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.MissingSupertypesResolver;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.OperatorModifierChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.OptionalExpectationChecker;
import org.jetbrains.kotlin.resolve.checkers.PublishedApiUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.UnderscoreChecker;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;

public class ModifiersChecker {
    private final AnnotationChecker annotationChecker;
    private final Iterable<DeclarationChecker> declarationCheckers;
    private final LanguageVersionSettings languageVersionSettings;
    private final ExpectActualTracker expectActualTracker;
    private final DeprecationResolver deprecationResolver;
    private final ModuleDescriptor moduleDescriptor;
    private final MissingSupertypesResolver missingSupertypesResolver;

    @NotNull
    public static Modality resolveMemberModalityFromModifiers(@Nullable KtModifierListOwner modifierListOwner, @NotNull Modality defaultModality, @NotNull BindingContext bindingContext, @Nullable DeclarationDescriptor containingDescriptor) {
        if (defaultModality == null) {
            ModifiersChecker.$$$reportNull$$$0(0);
        }
        if (bindingContext == null) {
            ModifiersChecker.$$$reportNull$$$0(1);
        }
        return ModifiersChecker.resolveModalityFromModifiers(modifierListOwner, defaultModality, bindingContext, containingDescriptor, false);
    }

    @NotNull
    public static Modality resolveModalityFromModifiers(@Nullable KtModifierListOwner modifierListOwner, @NotNull Modality defaultModality, @NotNull BindingContext bindingContext, @Nullable DeclarationDescriptor containingDescriptor, boolean allowSealed) {
        if (defaultModality == null) {
            ModifiersChecker.$$$reportNull$$$0(2);
        }
        if (bindingContext == null) {
            ModifiersChecker.$$$reportNull$$$0(3);
        }
        KtModifierList modifierList = modifierListOwner != null ? modifierListOwner.getModifierList() : null;
        Modality modality = ModifiersChecker.resolveModalityFromModifiers(containingDescriptor, modifierList, defaultModality, allowSealed);
        if (modifierListOwner != null) {
            List extensions = DeclarationAttributeAltererExtension.Companion.getInstances(modifierListOwner.getProject());
            DeclarationDescriptor descriptor2 = bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, modifierListOwner);
            for (DeclarationAttributeAltererExtension extension : extensions) {
                Modality newModality = extension.refineDeclarationModality(modifierListOwner, descriptor2, containingDescriptor, modality, false);
                if (newModality == null) continue;
                modality = newModality;
                break;
            }
        }
        Modality modality2 = modality;
        if (modality2 == null) {
            ModifiersChecker.$$$reportNull$$$0(4);
        }
        return modality2;
    }

    @NotNull
    private static Modality resolveModalityFromModifiers(@Nullable DeclarationDescriptor containingDescriptor, @Nullable KtModifierList modifierList, @NotNull Modality defaultModality, boolean allowSealed) {
        if (defaultModality == null) {
            ModifiersChecker.$$$reportNull$$$0(5);
        }
        if (modifierList == null) {
            Modality modality = defaultModality;
            if (modality == null) {
                ModifiersChecker.$$$reportNull$$$0(6);
            }
            return modality;
        }
        boolean hasAbstractModifier = modifierList.hasModifier(KtTokens.ABSTRACT_KEYWORD);
        boolean hasOverrideModifier = modifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD);
        if (allowSealed && modifierList.hasModifier(KtTokens.SEALED_KEYWORD)) {
            Modality modality = Modality.SEALED;
            if (modality == null) {
                ModifiersChecker.$$$reportNull$$$0(7);
            }
            return modality;
        }
        if (modifierList.hasModifier(KtTokens.OPEN_KEYWORD)) {
            ClassDescriptor classOrInterface;
            if (containingDescriptor instanceof ClassDescriptor && (classOrInterface = (ClassDescriptor)containingDescriptor).getKind() == ClassKind.INTERFACE && classOrInterface.isExpect()) {
                Modality modality = Modality.OPEN;
                if (modality == null) {
                    ModifiersChecker.$$$reportNull$$$0(8);
                }
                return modality;
            }
            if (hasAbstractModifier || defaultModality == Modality.ABSTRACT) {
                Modality modality = Modality.ABSTRACT;
                if (modality == null) {
                    ModifiersChecker.$$$reportNull$$$0(9);
                }
                return modality;
            }
            Modality modality = Modality.OPEN;
            if (modality == null) {
                ModifiersChecker.$$$reportNull$$$0(10);
            }
            return modality;
        }
        if (hasAbstractModifier) {
            Modality modality = Modality.ABSTRACT;
            if (modality == null) {
                ModifiersChecker.$$$reportNull$$$0(11);
            }
            return modality;
        }
        boolean hasFinalModifier = modifierList.hasModifier(KtTokens.FINAL_KEYWORD);
        if (hasOverrideModifier && !hasFinalModifier && defaultModality != Modality.ABSTRACT) {
            Modality modality = Modality.OPEN;
            if (modality == null) {
                ModifiersChecker.$$$reportNull$$$0(12);
            }
            return modality;
        }
        if (hasFinalModifier) {
            Modality modality = Modality.FINAL;
            if (modality == null) {
                ModifiersChecker.$$$reportNull$$$0(13);
            }
            return modality;
        }
        Modality modality = defaultModality;
        if (modality == null) {
            ModifiersChecker.$$$reportNull$$$0(14);
        }
        return modality;
    }

    @NotNull
    public static DescriptorVisibility resolveVisibilityFromModifiers(@NotNull KtModifierListOwner modifierListOwner, @NotNull DescriptorVisibility defaultVisibility) {
        if (modifierListOwner == null) {
            ModifiersChecker.$$$reportNull$$$0(15);
        }
        if (defaultVisibility == null) {
            ModifiersChecker.$$$reportNull$$$0(16);
        }
        DescriptorVisibility descriptorVisibility = ModifiersChecker.resolveVisibilityFromModifiers(modifierListOwner.getModifierList(), defaultVisibility);
        if (descriptorVisibility == null) {
            ModifiersChecker.$$$reportNull$$$0(17);
        }
        return descriptorVisibility;
    }

    public static DescriptorVisibility resolveVisibilityFromModifiers(@Nullable KtModifierList modifierList, @NotNull DescriptorVisibility defaultVisibility) {
        if (defaultVisibility == null) {
            ModifiersChecker.$$$reportNull$$$0(18);
        }
        if (modifierList == null) {
            return defaultVisibility;
        }
        if (modifierList.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
            return DescriptorVisibilities.PRIVATE;
        }
        if (modifierList.hasModifier(KtTokens.PUBLIC_KEYWORD)) {
            return DescriptorVisibilities.PUBLIC;
        }
        if (modifierList.hasModifier(KtTokens.PROTECTED_KEYWORD)) {
            return DescriptorVisibilities.PROTECTED;
        }
        if (modifierList.hasModifier(KtTokens.INTERNAL_KEYWORD)) {
            return DescriptorVisibilities.INTERNAL;
        }
        return defaultVisibility;
    }

    public ModifiersChecker(@NotNull AnnotationChecker annotationChecker, @NotNull Iterable<DeclarationChecker> declarationCheckers, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull ExpectActualTracker expectActualTracker, @NotNull DeprecationResolver deprecationResolver, @NotNull ModuleDescriptor moduleDescriptor, @NotNull MissingSupertypesResolver missingSupertypesResolver) {
        if (annotationChecker == null) {
            ModifiersChecker.$$$reportNull$$$0(19);
        }
        if (declarationCheckers == null) {
            ModifiersChecker.$$$reportNull$$$0(20);
        }
        if (languageVersionSettings == null) {
            ModifiersChecker.$$$reportNull$$$0(21);
        }
        if (expectActualTracker == null) {
            ModifiersChecker.$$$reportNull$$$0(22);
        }
        if (deprecationResolver == null) {
            ModifiersChecker.$$$reportNull$$$0(23);
        }
        if (moduleDescriptor == null) {
            ModifiersChecker.$$$reportNull$$$0(24);
        }
        if (missingSupertypesResolver == null) {
            ModifiersChecker.$$$reportNull$$$0(25);
        }
        this.annotationChecker = annotationChecker;
        this.declarationCheckers = declarationCheckers;
        this.languageVersionSettings = languageVersionSettings;
        this.expectActualTracker = expectActualTracker;
        this.deprecationResolver = deprecationResolver;
        this.moduleDescriptor = moduleDescriptor;
        this.missingSupertypesResolver = missingSupertypesResolver;
    }

    @NotNull
    public ModifiersCheckingProcedure withTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            ModifiersChecker.$$$reportNull$$$0(26);
        }
        return new ModifiersCheckingProcedure(trace);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultModality";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/ModifiersChecker";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultVisibility";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationChecker";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationCheckers";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectActualTracker";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deprecationResolver";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDescriptor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missingSupertypesResolver";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/ModifiersChecker";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModalityFromModifiers";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveVisibilityFromModifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveMemberModalityFromModifiers";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveModalityFromModifiers";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                break;
            }
            case 15: 
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveVisibilityFromModifiers";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "withTrace";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public class ModifiersCheckingProcedure {
        private final BindingTrace trace;

        private ModifiersCheckingProcedure(BindingTrace trace) {
            if (trace == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(0);
            }
            this.trace = trace;
        }

        public void checkParameterHasNoValOrVar(@NotNull KtValVarKeywordOwner parameter, @NotNull DiagnosticFactory1<PsiElement, KtKeywordToken> diagnosticFactory) {
            PsiElement valOrVar;
            if (parameter == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(1);
            }
            if (diagnosticFactory == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(2);
            }
            if ((valOrVar = parameter.getValOrVarKeyword()) != null) {
                this.trace.report(diagnosticFactory.on(valOrVar, (KtKeywordToken)valOrVar.getNode().getElementType()));
            }
        }

        public void checkModifiersForDeclaration(@NotNull KtDeclaration modifierListOwner, @NotNull MemberDescriptor descriptor2) {
            if (modifierListOwner == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(3);
            }
            if (descriptor2 == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(4);
            }
            this.checkNestedClassAllowed(modifierListOwner, descriptor2);
            this.checkTypeParametersModifiers((KtModifierListOwner)modifierListOwner);
            this.checkModifierListCommon(modifierListOwner, descriptor2);
            this.checkIllegalHeader((KtModifierListOwner)modifierListOwner, descriptor2);
        }

        private void checkNestedClassAllowed(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2) {
            if (declaration == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(5);
            }
            if (descriptor2 == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(6);
            }
            if (!(declaration instanceof KtClassOrObject)) {
                return;
            }
            KtClassOrObject ktClassOrObject = (KtClassOrObject)declaration;
            if (!(descriptor2 instanceof ClassDescriptor)) {
                return;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)descriptor2;
            DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
            if (!(containingDeclaration instanceof ClassDescriptor)) {
                return;
            }
            ClassDescriptor containingClass = (ClassDescriptor)containingDeclaration;
            DetailedClassKind kind = DetailedClassKind.getClassKind(classDescriptor);
            if (kind == DetailedClassKind.ANONYMOUS_OBJECT || kind == DetailedClassKind.ENUM_ENTRY) {
                return;
            }
            if ((kind == DetailedClassKind.ENUM_CLASS || kind == DetailedClassKind.OBJECT || kind == DetailedClassKind.COMPANION_OBJECT) && DescriptorUtils.isLocal(classDescriptor)) {
                return;
            }
            if (DescriptorUtils.isEnumEntry(containingClass) && !classDescriptor.isInner() && kind != DetailedClassKind.COMPANION_OBJECT) {
                DiagnosticFactory1<KtClassOrObject, String> diagnostic = ModifiersChecker.this.languageVersionSettings.supportsFeature(LanguageFeature.NestedClassesInEnumEntryShouldBeInner) ? Errors.NESTED_CLASS_NOT_ALLOWED : Errors.NESTED_CLASS_DEPRECATED;
                this.trace.report(diagnostic.on(ktClassOrObject, kind.withCapitalFirstLetter));
                return;
            }
            if (!classDescriptor.isInner() && (containingClass.isInner() || DescriptorUtils.isLocal(containingClass))) {
                this.trace.report(Errors.NESTED_CLASS_NOT_ALLOWED.on(ktClassOrObject, kind.withCapitalFirstLetter));
            }
        }

        private void checkModifierListCommon(@NotNull KtDeclaration modifierListOwner, @NotNull DeclarationDescriptor descriptor2) {
            if (modifierListOwner == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(7);
            }
            if (descriptor2 == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(8);
            }
            AnnotationUseSiteTargetChecker.INSTANCE.check((KtAnnotated)modifierListOwner, descriptor2, this.trace, ModifiersChecker.this.languageVersionSettings);
            this.runDeclarationCheckers(modifierListOwner, descriptor2);
            ModifiersChecker.this.annotationChecker.check((KtAnnotated)modifierListOwner, this.trace, descriptor2);
            ModifierCheckerCore.INSTANCE.check((KtModifierListOwner)modifierListOwner, this.trace, descriptor2, ModifiersChecker.this.languageVersionSettings);
        }

        public void checkModifiersForLocalDeclaration(@NotNull KtDeclaration modifierListOwner, @NotNull DeclarationDescriptor descriptor2) {
            if (modifierListOwner == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(9);
            }
            if (descriptor2 == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(10);
            }
            this.checkModifierListCommon(modifierListOwner, descriptor2);
        }

        public void checkModifiersForDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration) {
            if (multiDeclaration == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(11);
            }
            ModifiersChecker.this.annotationChecker.check((KtAnnotated)multiDeclaration, this.trace, null);
            ModifierCheckerCore.INSTANCE.check((KtModifierListOwner)multiDeclaration, this.trace, null, ModifiersChecker.this.languageVersionSettings);
            for (KtDestructuringDeclarationEntry multiEntry : multiDeclaration.getEntries()) {
                ModifiersChecker.this.annotationChecker.check((KtAnnotated)multiEntry, this.trace, null);
                ModifierCheckerCore.INSTANCE.check((KtModifierListOwner)multiEntry, this.trace, null, ModifiersChecker.this.languageVersionSettings);
                UnderscoreChecker.INSTANCE.checkNamed((KtNamedDeclaration)multiEntry, this.trace, ModifiersChecker.this.languageVersionSettings, true);
            }
        }

        private void checkIllegalHeader(@NotNull KtModifierListOwner modifierListOwner, @NotNull DeclarationDescriptor descriptor2) {
            KtModifierList modifierList;
            PsiElement keyword;
            if (modifierListOwner == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(12);
            }
            if (descriptor2 == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(13);
            }
            PsiElement psiElement = keyword = (modifierList = modifierListOwner.getModifierList()) != null ? modifierList.getModifier(KtTokens.HEADER_KEYWORD) : null;
            if (keyword != null && descriptor2 instanceof ClassDescriptor && descriptor2.getContainingDeclaration() instanceof ClassDescriptor) {
                this.trace.report(Errors.WRONG_MODIFIER_TARGET.on(keyword, KtTokens.HEADER_KEYWORD, "nested class"));
            } else if (keyword == null && modifierList != null && (keyword = modifierList.getModifier(KtTokens.EXPECT_KEYWORD)) != null && descriptor2 instanceof ClassDescriptor && descriptor2.getContainingDeclaration() instanceof ClassDescriptor) {
                this.trace.report(Errors.WRONG_MODIFIER_TARGET.on(keyword, KtTokens.EXPECT_KEYWORD, "nested class"));
            }
        }

        @NotNull
        public Map<KtModifierKeywordToken, PsiElement> getTokensCorrespondingToModifiers(@NotNull KtModifierList modifierList, @NotNull Collection<KtModifierKeywordToken> possibleModifiers) {
            if (modifierList == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(14);
            }
            if (possibleModifiers == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(15);
            }
            HashMap<KtModifierKeywordToken, PsiElement> tokens = new HashMap<KtModifierKeywordToken, PsiElement>();
            for (KtModifierKeywordToken modifier : possibleModifiers) {
                if (!modifierList.hasModifier(modifier)) continue;
                tokens.put(modifier, modifierList.getModifier(modifier));
            }
            HashMap<KtModifierKeywordToken, PsiElement> hashMap = tokens;
            if (hashMap == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(16);
            }
            return hashMap;
        }

        public void runDeclarationCheckers(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2) {
            if (declaration == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(17);
            }
            if (descriptor2 == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(18);
            }
            DeclarationCheckerContext context = new DeclarationCheckerContext(this.trace, ModifiersChecker.this.languageVersionSettings, ModifiersChecker.this.deprecationResolver, ModifiersChecker.this.moduleDescriptor, ModifiersChecker.this.expectActualTracker, ModifiersChecker.this.missingSupertypesResolver);
            for (DeclarationChecker checker : ModifiersChecker.this.declarationCheckers) {
                ProgressManager.checkCanceled();
                checker.check(declaration, descriptor2, context);
            }
            OperatorModifierChecker.INSTANCE.check(declaration, descriptor2, this.trace, ModifiersChecker.this.languageVersionSettings);
            PublishedApiUsageChecker.INSTANCE.check(declaration, descriptor2, this.trace);
            OptionalExpectationChecker.INSTANCE.check(declaration, descriptor2, this.trace);
        }

        public void checkTypeParametersModifiers(@NotNull KtModifierListOwner modifierListOwner) {
            if (modifierListOwner == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(19);
            }
            if (!(modifierListOwner instanceof KtTypeParameterListOwner)) {
                return;
            }
            List typeParameters2 = ((KtTypeParameterListOwner)modifierListOwner).getTypeParameters();
            for (KtTypeParameter typeParameter : typeParameters2) {
                ModifierCheckerCore.INSTANCE.check((KtModifierListOwner)typeParameter, this.trace, null, ModifiersChecker.this.languageVersionSettings);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 16: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 16: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trace";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diagnosticFactory";
                    break;
                }
                case 3: 
                case 7: 
                case 9: 
                case 12: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifierListOwner";
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 13: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 5: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "multiDeclaration";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifierList";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "possibleModifiers";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTokensCorrespondingToModifiers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "checkParameterHasNoValOrVar";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "checkModifiersForDeclaration";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "checkNestedClassAllowed";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "checkModifierListCommon";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "checkModifiersForLocalDeclaration";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "checkModifiersForDestructuringDeclaration";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "checkIllegalHeader";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "getTokensCorrespondingToModifiers";
                    break;
                }
                case 16: {
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "runDeclarationCheckers";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "checkTypeParametersModifiers";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 16: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum DetailedClassKind {
        ENUM_CLASS("Enum class"),
        ENUM_ENTRY("Enum entry"),
        ANNOTATION_CLASS("Annotation class"),
        INTERFACE("Interface"),
        COMPANION_OBJECT("Companion object"),
        ANONYMOUS_OBJECT("Anonymous object"),
        OBJECT("Object"),
        CLASS("Class");

        public final String withCapitalFirstLetter;

        private DetailedClassKind(String withCapitalFirstLetter) {
            this.withCapitalFirstLetter = withCapitalFirstLetter;
        }

        @NotNull
        public static DetailedClassKind getClassKind(@NotNull ClassDescriptor descriptor2) {
            if (descriptor2 == null) {
                DetailedClassKind.$$$reportNull$$$0(0);
            }
            if (DescriptorUtils.isEnumEntry(descriptor2)) {
                DetailedClassKind detailedClassKind = ENUM_ENTRY;
                if (detailedClassKind == null) {
                    DetailedClassKind.$$$reportNull$$$0(1);
                }
                return detailedClassKind;
            }
            if (DescriptorUtils.isEnumClass(descriptor2)) {
                DetailedClassKind detailedClassKind = ENUM_CLASS;
                if (detailedClassKind == null) {
                    DetailedClassKind.$$$reportNull$$$0(2);
                }
                return detailedClassKind;
            }
            if (DescriptorUtils.isAnnotationClass(descriptor2)) {
                DetailedClassKind detailedClassKind = ANNOTATION_CLASS;
                if (detailedClassKind == null) {
                    DetailedClassKind.$$$reportNull$$$0(3);
                }
                return detailedClassKind;
            }
            if (DescriptorUtils.isInterface(descriptor2)) {
                DetailedClassKind detailedClassKind = INTERFACE;
                if (detailedClassKind == null) {
                    DetailedClassKind.$$$reportNull$$$0(4);
                }
                return detailedClassKind;
            }
            if (DescriptorUtils.isCompanionObject(descriptor2)) {
                DetailedClassKind detailedClassKind = COMPANION_OBJECT;
                if (detailedClassKind == null) {
                    DetailedClassKind.$$$reportNull$$$0(5);
                }
                return detailedClassKind;
            }
            if (DescriptorUtils.isAnonymousObject(descriptor2)) {
                DetailedClassKind detailedClassKind = ANONYMOUS_OBJECT;
                if (detailedClassKind == null) {
                    DetailedClassKind.$$$reportNull$$$0(6);
                }
                return detailedClassKind;
            }
            if (DescriptorUtils.isObject(descriptor2)) {
                DetailedClassKind detailedClassKind = OBJECT;
                if (detailedClassKind == null) {
                    DetailedClassKind.$$$reportNull$$$0(7);
                }
                return detailedClassKind;
            }
            DetailedClassKind detailedClassKind = CLASS;
            if (detailedClassKind == null) {
                DetailedClassKind.$$$reportNull$$$0(8);
            }
            return detailedClassKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/resolve/ModifiersChecker$DetailedClassKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/resolve/ModifiersChecker$DetailedClassKind";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getClassKind";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

