/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.utils.WasmArrayInfo;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0002\u001a\f\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010\b\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010\t\u001a\u00020\u0007*\u00020\u0002\u00a8\u0006\n"}, d2={"getJsFunAnnotation", "", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "getWasmArrayAnnotation", "Lorg/jetbrains/kotlin/backend/wasm/utils/WasmArrayInfo;", "getWasmOpAnnotation", "hasExcludedFromCodegenAnnotation", "", "hasWasmAutoboxedAnnotation", "hasWasmNoOpCastAnnotation", "backend.wasm"})
public final class AnnotationsKt {
    public static final boolean hasExcludedFromCodegenAnnotation(@NotNull IrAnnotationContainer $this$hasExcludedFromCodegenAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasExcludedFromCodegenAnnotation, (String)"<this>");
        return IrUtilsKt.hasAnnotation((IrAnnotationContainer)$this$hasExcludedFromCodegenAnnotation, (FqName)new FqName("kotlin.wasm.internal.ExcludedFromCodegen"));
    }

    @Nullable
    public static final String getWasmOpAnnotation(@NotNull IrAnnotationContainer $this$getWasmOpAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$getWasmOpAnnotation, (String)"<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation((IrAnnotationContainer)$this$getWasmOpAnnotation, (FqName)new FqName("kotlin.wasm.internal.WasmOp"));
        return irConstructorCall != null ? AnnotationUtilsKt.getSingleConstStringArgument(irConstructorCall) : null;
    }

    public static final boolean hasWasmNoOpCastAnnotation(@NotNull IrAnnotationContainer $this$hasWasmNoOpCastAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasWasmNoOpCastAnnotation, (String)"<this>");
        return IrUtilsKt.hasAnnotation((IrAnnotationContainer)$this$hasWasmNoOpCastAnnotation, (FqName)new FqName("kotlin.wasm.internal.WasmNoOpCast"));
    }

    public static final boolean hasWasmAutoboxedAnnotation(@NotNull IrAnnotationContainer $this$hasWasmAutoboxedAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasWasmAutoboxedAnnotation, (String)"<this>");
        return IrUtilsKt.hasAnnotation((IrAnnotationContainer)$this$hasWasmAutoboxedAnnotation, (FqName)new FqName("kotlin.wasm.internal.WasmAutoboxed"));
    }

    @Nullable
    public static final WasmArrayInfo getWasmArrayAnnotation(@NotNull IrAnnotationContainer $this$getWasmArrayAnnotation) {
        WasmArrayInfo wasmArrayInfo;
        Intrinsics.checkNotNullParameter((Object)$this$getWasmArrayAnnotation, (String)"<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation((IrAnnotationContainer)$this$getWasmArrayAnnotation, (FqName)new FqName("kotlin.wasm.internal.WasmArrayOf"));
        if (irConstructorCall != null) {
            IrConstructorCall it = irConstructorCall;
            boolean bl = false;
            IrExpression irExpression = it.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrClassReference");
            IrSymbolOwner irSymbolOwner = ((IrClassReference)irExpression).getSymbol().getOwner();
            Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            IrClass irClass = (IrClass)irSymbolOwner;
            IrExpression irExpression2 = it.getValueArgument(1);
            Intrinsics.checkNotNull((Object)irExpression2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst<*>");
            Object object = ((IrConst)irExpression2).getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            wasmArrayInfo = new WasmArrayInfo(irClass, (Boolean)object);
        } else {
            wasmArrayInfo = null;
        }
        return wasmArrayInfo;
    }

    @Nullable
    public static final String getJsFunAnnotation(@NotNull IrAnnotationContainer $this$getJsFunAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$getJsFunAnnotation, (String)"<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation((IrAnnotationContainer)$this$getJsFunAnnotation, (FqName)new FqName("kotlin.JsFun"));
        return irConstructorCall != null ? AnnotationUtilsKt.getSingleConstStringArgument(irConstructorCall) : null;
    }
}

