/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.ir.IrUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.DefaultArgumentStubGenerator;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredStatementOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0014J\u001c\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmDefaultArgumentStubGenerator;", "Lorg/jetbrains/kotlin/backend/common/lower/DefaultArgumentStubGenerator;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "defaultArgumentStubVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getOriginForCallToImplementation", "Lorg/jetbrains/kotlin/backend/jvm/JvmLoweredStatementOrigin$DEFAULT_STUB_CALL_TO_IMPLEMENTATION;", "useConstructorMarker", "", "generateSuperCallHandlerCheckIfNeeded", "", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder;", "irFunction", "newIrFunction", "backend.jvm.lower"})
public final class JvmDefaultArgumentStubGenerator
extends DefaultArgumentStubGenerator {
    @NotNull
    private final JvmBackendContext context;

    public JvmDefaultArgumentStubGenerator(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super((CommonBackendContext)context, false, false, false, 8, null);
        this.context = context;
    }

    @NotNull
    public JvmBackendContext getContext() {
        return this.context;
    }

    @NotNull
    protected DescriptorVisibility defaultArgumentStubVisibility(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return JvmIrUtilsKt.getJvmVisibilityOfDefaultArgumentStub(function2);
    }

    protected boolean useConstructorMarker(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return function2 instanceof IrConstructor || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)((Object)JvmLoweredDeclarationOrigin.STATIC_INLINE_CLASS_CONSTRUCTOR.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    protected void generateSuperCallHandlerCheckIfNeeded(@NotNull IrBlockBodyBuilder $this$generateSuperCallHandlerCheckIfNeeded, @NotNull IrFunction irFunction, @NotNull IrFunction newIrFunction) {
        void $this$generateSuperCallHandlerCheckIfNeeded_u24lambda_u2d0;
        IrDeclarationParent irDeclarationParent;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)$this$generateSuperCallHandlerCheckIfNeeded, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
                Intrinsics.checkNotNullParameter((Object)newIrFunction, (String)"newIrFunction");
                if (!(irFunction instanceof IrSimpleFunction) || !this.getContext().getIr().shouldGenerateHandlerParameterForDefaultBodyFun() || AdditionalIrUtilsKt.isTopLevelDeclaration((IrDeclaration)((IrDeclaration)irFunction))) break block3;
                irDeclarationParent = irFunction.getParent();
                IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
                boolean bl = irClass != null ? IrUtilsKt.isFinalClass((IrClass)irClass) : false;
                if (!bl) break block4;
            }
            return;
        }
        IrValueParameter handlerDeclaration = (IrValueParameter)CollectionsKt.last((List)newIrFunction.getValueParameters());
        IrDeclarationParent irDeclarationParent2 = irDeclarationParent = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$generateSuperCallHandlerCheckIfNeeded), (IrSimpleFunctionSymbol)this.getContext().getIr().getSymbols().getThrowUnsupportedOperationException());
        IrExpression irExpression = LowerUtilsKt.irNot((IrBuilderWithScope)((IrBuilderWithScope)$this$generateSuperCallHandlerCheckIfNeeded), (IrExpression)ExpressionHelpersKt.irEqualsNull((IrBuilderWithScope)((IrBuilderWithScope)$this$generateSuperCallHandlerCheckIfNeeded), (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$generateSuperCallHandlerCheckIfNeeded), (IrValueDeclaration)((IrValueDeclaration)handlerDeclaration)))));
        IrType irType = $this$generateSuperCallHandlerCheckIfNeeded.getContext().getIrBuiltIns().getUnitType();
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$generateSuperCallHandlerCheckIfNeeded;
        IrBlockBodyBuilder irBlockBodyBuilder = $this$generateSuperCallHandlerCheckIfNeeded;
        boolean bl = false;
        $this$generateSuperCallHandlerCheckIfNeeded_u24lambda_u2d0.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)((IrBuilderWithScope)$this$generateSuperCallHandlerCheckIfNeeded), (String)("Super calls with default arguments not supported in this target, function: " + irFunction.getName().asString())));
        Unit unit = Unit.INSTANCE;
        irBlockBodyBuilder.unaryPlus((IrStatement)ExpressionHelpersKt.irIfThen$default((IrBuilderWithScope)irBuilderWithScope, (IrType)irType, (IrExpression)irExpression, (IrExpression)((IrExpression)irDeclarationParent), null, (int)8, null));
    }

    @NotNull
    protected JvmLoweredStatementOrigin.DEFAULT_STUB_CALL_TO_IMPLEMENTATION getOriginForCallToImplementation() {
        return JvmLoweredStatementOrigin.DEFAULT_STUB_CALL_TO_IMPLEMENTATION.INSTANCE;
    }
}

