/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.eval;

import com.intellij.find.FindSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import org.intellij.plugins.xpathView.Config;
import org.intellij.plugins.xpathView.HistoryElement;
import org.intellij.plugins.xpathView.XPathBundle;
import org.intellij.plugins.xpathView.eval.EvalFormPanel;
import org.intellij.plugins.xpathView.ui.InputExpressionDialog;
import org.jetbrains.annotations.NotNull;

public class EvalExpressionDialog
extends InputExpressionDialog<EvalFormPanel> {
    public EvalExpressionDialog(Project project, Config settings, HistoryElement[] history) {
        super(project, settings, history, new EvalFormPanel());
        this.setTitle(XPathBundle.message("dialog.title.evaluate.xpath.expression", new Object[0]));
        this.setOKButtonText(XPathBundle.message("button.evaluate", new Object[0]));
    }

    @Override
    protected void init() {
        ToolWindow findWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Find");
        final boolean available = findWindow != null && findWindow.isAvailable();
        ((EvalFormPanel)this.myForm).getNewTabCheckbox().setEnabled(available);
        ((EvalFormPanel)this.myForm).getNewTabCheckbox().setSelected(FindSettings.getInstance().isShowResultsInSeparateView());
        ((EvalFormPanel)this.myForm).getHighlightCheckbox().setSelected(this.mySettings.HIGHLIGHT_RESULTS);
        ((EvalFormPanel)this.myForm).getHighlightCheckbox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EvalExpressionDialog.this.updateOkAction();
            }
        });
        ((EvalFormPanel)this.myForm).getUsageViewCheckbox().setSelected(this.mySettings.SHOW_USAGE_VIEW);
        ((EvalFormPanel)this.myForm).getUsageViewCheckbox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((EvalFormPanel)EvalExpressionDialog.this.myForm).getNewTabCheckbox().setEnabled(available && ((EvalFormPanel)EvalExpressionDialog.this.myForm).getUsageViewCheckbox().isSelected());
                EvalExpressionDialog.this.updateOkAction();
            }
        });
        super.init();
    }

    @Override
    protected boolean isOkEnabled() {
        EvalFormPanel form = (EvalFormPanel)this.getForm();
        boolean b = form.getHighlightCheckbox().isSelected() || form.getUsageViewCheckbox().isSelected();
        return b & super.isOkEnabled();
    }

    protected void doOKAction() {
        EvalFormPanel form = (EvalFormPanel)this.getForm();
        if (form.getNewTabCheckbox().isEnabled()) {
            FindSettings.getInstance().setShowResultsInSeparateView(form.getNewTabCheckbox().isSelected());
        }
        this.mySettings.HIGHLIGHT_RESULTS = form.getHighlightCheckbox().isSelected();
        this.mySettings.SHOW_USAGE_VIEW = form.getUsageViewCheckbox().isSelected();
        super.doOKAction();
    }

    @Override
    @NotNull
    protected String getPrivateDimensionServiceKey() {
        return "XPathView.InputDialog.DIMENSION_SERVICE_KEY";
    }
}

