/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.problem;

import com.intellij.analysis.problemsView.FileProblem;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileEditor.FileNavigator;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.actions.OpenProblemWithRevisionAction;
import org.jetbrains.qodana.problem.SarifFileProblemsProvider;
import org.jetbrains.qodana.problem.SarifProblem;
import org.jetbrains.qodana.report.QodanaReportsService;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B\u001f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001f\u001a\u00020\u0011H\u0016J\b\u0010 \u001a\u00020\u0011H\u0016J\u0013\u0010!\u001a\u00020\u00112\b\u0010\"\u001a\u0004\u0018\u00010#H\u0096\u0002J\b\u0010$\u001a\u00020\u000bH\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0011H\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\rR\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006)"}, d2={"Lorg/jetbrains/qodana/problem/SarifFileProblem;", "Lcom/intellij/analysis/problemsView/FileProblem;", "Lcom/intellij/pom/Navigatable;", "sarifProblem", "Lorg/jetbrains/qodana/problem/SarifProblem;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lorg/jetbrains/qodana/problem/SarifFileProblemsProvider;", "(Lorg/jetbrains/qodana/problem/SarifProblem;Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/qodana/problem/SarifFileProblemsProvider;)V", "column", "", "getColumn", "()I", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "isPresent", "", "()Z", "line", "getLine", "openFileDescriptor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "getOpenFileDescriptor", "()Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "getProvider", "()Lorg/jetbrains/qodana/problem/SarifFileProblemsProvider;", "text", "", "getText", "()Ljava/lang/String;", "canNavigate", "canNavigateToSource", "equals", "other", "", "hashCode", "navigate", "", "requestFocus", "Companion", "intellij.qodana"})
public final class SarifFileProblem
implements FileProblem,
Navigatable {
    private final SarifProblem sarifProblem;
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final SarifFileProblemsProvider provider;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final boolean isPresent() {
        Project $this$service$iv = this.getProvider().getProject();
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(QodanaReportsService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        return ((QodanaReportsService)object).isProblemPresent(this.sarifProblem);
    }

    public int getLine() {
        Integer n = this.sarifProblem.getLine();
        return n != null ? n : -1;
    }

    public int getColumn() {
        Integer n = this.sarifProblem.getColumn();
        return n != null ? n : -1;
    }

    @NotNull
    public String getText() {
        if (!this.isPresent()) {
            String string = QodanaBundle.message("qodana.problem.description.not.present.mark", this.sarifProblem.getDescription());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"QodanaBundle.message(\"qo\u2026sarifProblem.description)");
            return string;
        }
        return this.sarifProblem.getDescription();
    }

    private final OpenFileDescriptor getOpenFileDescriptor() {
        Project project = this.getProvider().getProject();
        if (this.getLine() < 0 || !this.isPresent()) {
            return new OpenFileDescriptor(project, this.getFile(), -1);
        }
        OpenFileDescriptor lineStartDescriptor = new OpenFileDescriptor(project, this.getFile(), this.getLine(), 0);
        OpenFileDescriptor nextLineStartDescriptor = new OpenFileDescriptor(project, this.getFile(), this.getLine() + 1, 0);
        int n = 0;
        int n2 = this.getColumn();
        int offset = lineStartDescriptor.getOffset() + Math.max(n, n2);
        OpenFileDescriptor problemLocationDescriptor = new OpenFileDescriptor(project, this.getFile(), offset);
        if (problemLocationDescriptor.compareTo(nextLineStartDescriptor) >= 0) {
            return lineStartDescriptor;
        }
        return problemLocationDescriptor;
    }

    public void navigate(boolean requestFocus) {
        block4: {
            Object object;
            block6: {
                block5: {
                    if (this.isPresent()) break block4;
                    object = this.sarifProblem.getLine();
                    if (object == null) break block5;
                    Integer n = object;
                    int line = ((Number)n).intValue();
                    boolean bl = false;
                    object = QodanaBundle.message("notification.content.problem.not.present.in.file.w.line", this.sarifProblem.getDescription(), line + 1, this.getFile().getName());
                    if (object != null) break block6;
                }
                object = QodanaBundle.message("notification.content.problem.not.present.in.file", this.sarifProblem.getDescription(), this.getFile().getName());
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sarifProblem.line?.let {\u2026m.description, file.name)");
            Object notificationContent = object;
            Notification notification = new Notification("Qodana Problems Tab", QodanaBundle.message("notification.title.cannot.navigate.to.problem", new Object[0]), (String)notificationContent, NotificationType.WARNING);
            OpenProblemWithRevisionAction openProblemWithRevisionAction = new OpenProblemWithRevisionAction(this.sarifProblem);
            if (openProblemWithRevisionAction.canBePerformed()) {
                notification.addAction((AnAction)openProblemWithRevisionAction);
            }
            notification.notify(this.getProvider().getProject());
            return;
        }
        FileNavigator.getInstance().navigate(this.getOpenFileDescriptor(), requestFocus);
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.qodana.problem.SarifFileProblem");
        }
        SarifFileProblem cfr_ignored_0 = (SarifFileProblem)object2;
        return Intrinsics.areEqual((Object)this.sarifProblem, (Object)((SarifFileProblem)other).sarifProblem);
    }

    public int hashCode() {
        return this.sarifProblem.hashCode();
    }

    @NotNull
    public VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public SarifFileProblemsProvider getProvider() {
        return this.provider;
    }

    private SarifFileProblem(SarifProblem sarifProblem, VirtualFile file, SarifFileProblemsProvider provider) {
        this.sarifProblem = sarifProblem;
        this.file = file;
        this.provider = provider;
    }

    @Nullable
    public String getDescription() {
        return FileProblem.DefaultImpls.getDescription((FileProblem)this);
    }

    @Nullable
    public String getGroup() {
        return FileProblem.DefaultImpls.getGroup((FileProblem)this);
    }

    @NotNull
    public Icon getIcon() {
        return FileProblem.DefaultImpls.getIcon((FileProblem)this);
    }

    public /* synthetic */ SarifFileProblem(SarifProblem sarifProblem, VirtualFile file, SarifFileProblemsProvider provider, DefaultConstructorMarker $constructor_marker) {
        this(sarifProblem, file, provider);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/qodana/problem/SarifFileProblem$Companion;", "", "()V", "fromSarifProblem", "Lorg/jetbrains/qodana/problem/SarifFileProblem;", "sarifProblem", "Lorg/jetbrains/qodana/problem/SarifProblem;", "provider", "Lorg/jetbrains/qodana/problem/SarifFileProblemsProvider;", "intellij.qodana"})
    public static final class Companion {
        @Nullable
        public final SarifFileProblem fromSarifProblem(@NotNull SarifProblem sarifProblem, @NotNull SarifFileProblemsProvider provider) {
            SarifFileProblem sarifFileProblem;
            Intrinsics.checkNotNullParameter((Object)sarifProblem, (String)"sarifProblem");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            VirtualFile virtualFile = sarifProblem.getFile();
            if (virtualFile != null) {
                VirtualFile virtualFile2;
                VirtualFile file = virtualFile2 = virtualFile;
                boolean bl = false;
                sarifFileProblem = new SarifFileProblem(sarifProblem, file, provider, null);
            } else {
                sarifFileProblem = null;
            }
            return sarifFileProblem;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

