/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.cloud.authorization;

import com.intellij.collaboration.auth.credentials.Credentials;
import com.intellij.collaboration.auth.services.OAuthCredentialsAcquirer;
import java.net.http.HttpRequest;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.cloud.RequestKt;
import org.jetbrains.qodana.cloud.RequestMethod;
import org.jetbrains.qodana.cloud.RequestResponse;
import org.jetbrains.qodana.cloud.authorization.OauthKt;
import org.jetbrains.qodana.cloud.authorization.QodanaCloudCredentials;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/qodana/cloud/authorization/QodanaCloudOAuthCredentialsAcquirer;", "Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer;", "Lorg/jetbrains/qodana/cloud/authorization/QodanaCloudCredentials;", "()V", "acquireCredentials", "Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer$AcquireCredentialsResult;", "code", "", "intellij.qodana"})
public final class QodanaCloudOAuthCredentialsAcquirer
implements OAuthCredentialsAcquirer<QodanaCloudCredentials> {
    @NotNull
    public OAuthCredentialsAcquirer.AcquireCredentialsResult<QodanaCloudCredentials> acquireCredentials(@NotNull String code) {
        OAuthCredentialsAcquirer.AcquireCredentialsResult acquireCredentialsResult;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        HttpRequest request = RequestKt.buildRequestToQodanaCloud$default("/v1/idea/auth/token/", new RequestMethod.POST(MapsKt.mapOf((Pair)TuplesKt.to((Object)"code", (Object)code))), null, null, 12, null);
        RequestResponse<QodanaCloudCredentials> response2 = OauthKt.getCredentialsByHttpRequest(request);
        if (response2 instanceof RequestResponse.Success) {
            acquireCredentialsResult = (OAuthCredentialsAcquirer.AcquireCredentialsResult)new OAuthCredentialsAcquirer.AcquireCredentialsResult.Success((Credentials)((RequestResponse.Success)response2).getResult());
        } else if (response2 instanceof RequestResponse.Error) {
            acquireCredentialsResult = (OAuthCredentialsAcquirer.AcquireCredentialsResult)new OAuthCredentialsAcquirer.AcquireCredentialsResult.Error("Can't acquire credentials, code " + ((RequestResponse.Error)response2).getResponseCode() + " message " + ((RequestResponse.Error)response2).getMessage());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return acquireCredentialsResult;
    }
}

