/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.ngrams.Probability;

public class SuggestionSorter {
    private LanguageModel lm;

    public SuggestionSorter(LanguageModel lm) {
        this.lm = Objects.requireNonNull(lm);
    }

    public List<String> sortSuggestions(List<String> suggestions) {
        ArrayList<RankedSuggestion> ranked = new ArrayList<RankedSuggestion>();
        for (String suggestion : suggestions) {
            Probability p2 = this.lm.getPseudoProbability(Collections.singletonList(suggestion));
            ranked.add(new RankedSuggestion(p2.getProb(), suggestion));
        }
        Collections.sort(ranked);
        return ranked.stream().map(k -> ((RankedSuggestion)k).suggestion).collect(Collectors.toList());
    }

    class RankedSuggestion
    implements Comparable<RankedSuggestion> {
        private final double prob;
        private final String suggestion;

        RankedSuggestion(double prob, String suggestion) {
            this.prob = prob;
            this.suggestion = suggestion;
        }

        @Override
        public int compareTo(@NotNull RankedSuggestion o) {
            return Double.compare(o.prob, this.prob);
        }
    }
}

