/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.Set;
import morfologik.fsa.FSA;
import morfologik.fsa.FSAFlags;

public final class CFSA2
extends FSA {
    public static final byte VERSION = -58;
    public static final int BIT_TARGET_NEXT = 128;
    public static final int BIT_LAST_ARC = 64;
    public static final int BIT_FINAL_ARC = 32;
    static final int LABEL_INDEX_BITS = 5;
    static final int LABEL_INDEX_MASK = 31;
    public static final int LABEL_INDEX_SIZE = 31;
    public byte[] arcs;
    private final EnumSet<FSAFlags> flags;
    public final byte[] labelMapping;
    private final boolean hasNumbers;
    private final int epsilon = 0;

    CFSA2(InputStream stream) throws IOException {
        DataInputStream in = new DataInputStream(stream);
        short flagBits = in.readShort();
        this.flags = EnumSet.noneOf(FSAFlags.class);
        for (FSAFlags f : FSAFlags.values()) {
            if (!f.isSet(flagBits)) continue;
            this.flags.add(f);
        }
        if (flagBits != FSAFlags.asShort(this.flags)) {
            throw new IOException("Unrecognized flags: 0x" + Integer.toHexString(flagBits));
        }
        this.hasNumbers = this.flags.contains((Object)FSAFlags.NUMBERS);
        int labelMappingSize = in.readByte() & 0xFF;
        this.labelMapping = new byte[labelMappingSize];
        in.readFully(this.labelMapping);
        this.arcs = CFSA2.readRemaining(in);
    }

    @Override
    public int getRootNode() {
        return this.getDestinationNodeOffset(this.getFirstArc(0));
    }

    @Override
    public final int getFirstArc(int node) {
        if (this.hasNumbers) {
            return this.skipVInt(node);
        }
        return node;
    }

    @Override
    public final int getNextArc(int arc) {
        if (this.isArcLast(arc)) {
            return 0;
        }
        return this.skipArc(arc);
    }

    @Override
    public int getArc(int node, byte label2) {
        int arc = this.getFirstArc(node);
        while (arc != 0) {
            if (this.getArcLabel(arc) == label2) {
                return arc;
            }
            arc = this.getNextArc(arc);
        }
        return 0;
    }

    @Override
    public int getEndNode(int arc) {
        int nodeOffset = this.getDestinationNodeOffset(arc);
        assert (nodeOffset != 0) : "Can't follow a terminal arc: " + arc;
        assert (nodeOffset < this.arcs.length) : "Node out of bounds.";
        return nodeOffset;
    }

    @Override
    public byte getArcLabel(int arc) {
        int index = this.arcs[arc] & 0x1F;
        if (index > 0) {
            return this.labelMapping[index];
        }
        return this.arcs[arc + 1];
    }

    @Override
    public int getRightLanguageCount(int node) {
        assert (this.getFlags().contains((Object)FSAFlags.NUMBERS)) : "This FSA was not compiled with NUMBERS.";
        return CFSA2.readVInt(this.arcs, node);
    }

    @Override
    public boolean isArcFinal(int arc) {
        return (this.arcs[arc] & 0x20) != 0;
    }

    @Override
    public boolean isArcTerminal(int arc) {
        return 0 == this.getDestinationNodeOffset(arc);
    }

    public boolean isArcLast(int arc) {
        return (this.arcs[arc] & 0x40) != 0;
    }

    public boolean isNextSet(int arc) {
        return (this.arcs[arc] & 0x80) != 0;
    }

    @Override
    public Set<FSAFlags> getFlags() {
        return this.flags;
    }

    final int getDestinationNodeOffset(int arc) {
        if (this.isNextSet(arc)) {
            while (!this.isArcLast(arc)) {
                arc = this.getNextArc(arc);
            }
            return this.skipArc(arc);
        }
        return CFSA2.readVInt(this.arcs, arc + ((this.arcs[arc] & 0x1F) == 0 ? 2 : 1));
    }

    private int skipArc(int offset) {
        byte flag;
        if (((flag = this.arcs[offset++]) & 0x1F) == 0) {
            ++offset;
        }
        if ((flag & 0x80) == 0) {
            offset = this.skipVInt(offset);
        }
        assert (offset < this.arcs.length);
        return offset;
    }

    static int readVInt(byte[] array, int offset) {
        byte b2 = array[offset];
        int value = b2 & 0x7F;
        int shift = 7;
        while (b2 < 0) {
            b2 = array[++offset];
            value |= (b2 & 0x7F) << shift;
            shift += 7;
        }
        return value;
    }

    static int vIntLength(int value) {
        assert (value >= 0) : "Can't v-code negative ints.";
        int bytes = 1;
        while (value >= 128) {
            value >>= 7;
            ++bytes;
        }
        return bytes;
    }

    private int skipVInt(int offset) {
        while (this.arcs[offset++] < 0) {
        }
        return offset;
    }
}

