/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.config;

import com.intellij.grazie.detection.ExtensionsKt;
import com.intellij.grazie.detector.ChainLanguageDetector;
import com.intellij.grazie.detector.LanguageDetector;
import com.intellij.grazie.detector.heuristics.list.ListDetector;
import com.intellij.grazie.detector.model.DetectedLanguage;
import com.intellij.grazie.detector.model.Language;
import com.intellij.grazie.detector.ngram.NgramDetector;
import com.intellij.util.xmlb.annotations.Property;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lcom/intellij/grazie/config/DetectionContext;", "", "()V", "Local", "State", "intellij.grazie.core"})
public final class DetectionContext {
    @NotNull
    public static final DetectionContext INSTANCE;

    private DetectionContext() {
    }

    static {
        DetectionContext detectionContext;
        INSTANCE = detectionContext = new DetectionContext();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0014\u0010\n\u001a\u00020\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fJ\u0014\u0010\r\u001a\u00020\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/grazie/config/DetectionContext$State;", "", "disabled", "", "Lcom/intellij/grazie/detector/model/Language;", "(Ljava/util/Set;)V", "getDisabled", "()Ljava/util/Set;", "component1", "copy", "disable", "langs", "", "enable", "equals", "", "other", "hashCode", "", "toString", "", "intellij.grazie.core"})
    public static final class State {
        @Property
        @NotNull
        private final Set<Language> disabled;

        @NotNull
        public final State disable(@NotNull Iterable<? extends Language> langs) {
            Intrinsics.checkNotNullParameter(langs, (String)"langs");
            return new State(SetsKt.plus(this.disabled, langs));
        }

        @NotNull
        public final State enable(@NotNull Iterable<? extends Language> langs) {
            Intrinsics.checkNotNullParameter(langs, (String)"langs");
            return new State(SetsKt.minus(this.disabled, langs));
        }

        @NotNull
        public final Set<Language> getDisabled() {
            return this.disabled;
        }

        public State(@NotNull Set<? extends Language> disabled) {
            Intrinsics.checkNotNullParameter(disabled, (String)"disabled");
            this.disabled = disabled;
        }

        public /* synthetic */ State(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                set = new HashSet();
            }
            this(set);
        }

        public State() {
            this(null, 1, null);
        }

        @NotNull
        public final Set<Language> component1() {
            return this.disabled;
        }

        @NotNull
        public final State copy(@NotNull Set<? extends Language> disabled) {
            Intrinsics.checkNotNullParameter(disabled, (String)"disabled");
            return new State(disabled);
        }

        public static /* synthetic */ State copy$default(State state, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                set = state.disabled;
            }
            return state.copy(set);
        }

        @NotNull
        public String toString() {
            return "State(disabled=" + this.disabled + ")";
        }

        public int hashCode() {
            Set<Language> set = this.disabled;
            return set != null ? ((Object)set).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof State)) break block3;
                    State state = (State)object;
                    if (!Intrinsics.areEqual(this.disabled, state.disabled)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001b\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\u0015\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\f\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u001e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001e"}, d2={"Lcom/intellij/grazie/config/DetectionContext$Local;", "", "counter", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/grazie/detector/model/Language;", "", "(Ljava/util/concurrent/ConcurrentHashMap;)V", "getCounter", "()Ljava/util/concurrent/ConcurrentHashMap;", "clear", "", "component1", "copy", "count", "size", "lang", "equals", "", "other", "getToNotify", "", "disabled", "hashCode", "toString", "", "update", "wordsTotal", "details", "Lcom/intellij/grazie/detector/ChainLanguageDetector$ChainDetectionResult;", "Companion", "intellij.grazie.core"})
    public static final class Local {
        @NotNull
        private final ConcurrentHashMap<Language, Integer> counter;
        public static final int SCORE_SIZE = 100;
        public static final double NOTIFICATION_PROPORTION_THRESHOLD = 0.2;
        public static final int NOTIFICATION_TOTAL_THRESHOLD = 3;
        public static final double NGRAM_CONFIDENCE_THRESHOLD = 0.98;
        public static final double LIST_CONFIDENCE_THRESHOLD = 0.51;
        public static final int TEXT_SIZE_THRESHOLD = 40;
        public static final int WORDS_SIZE_THRESHOLD = 4;
        @NotNull
        public static final Companion Companion = new Companion(null);

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<Language> getToNotify(@NotNull Set<? extends Language> disabled) {
            void $this$filterTo$iv$iv;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map.Entry $dstr$_u24__u24$myTotal;
            void $this$filterTo$iv$iv2;
            Intrinsics.checkNotNullParameter(disabled, (String)"disabled");
            Collection<Integer> collection = this.counter.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"counter.values");
            int total = CollectionsKt.sumOfInt((Iterable)collection);
            Map $this$filter$iv = this.counter;
            boolean $i$f$filter = false;
            Map map2 = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                $dstr$_u24__u24$myTotal = element$iv$iv = iterator.next();
                boolean bl = false;
                Map.Entry entry = $dstr$_u24__u24$myTotal;
                int myTotal = ((Number)entry.getValue()).intValue();
                if (!(myTotal > 3 && (double)myTotal / (double)total > 0.2)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                void it;
                $dstr$_u24__u24$myTotal = item$iv$iv;
                Object object = destination$iv$iv;
                boolean bl = false;
                Language language = (Language)((Object)it.getKey());
                object.add(language);
            }
            List filtered2 = (List)destination$iv$iv;
            Iterable $this$filter$iv2 = filtered2;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Language it = (Language)((Object)element$iv$iv);
                boolean bl = false;
                if (!(it != Language.UNKNOWN && !disabled.contains((Object)it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List langs = (List)destination$iv$iv2;
            return CollectionsKt.toSet((Iterable)langs);
        }

        public final void update(int size, int wordsTotal, @NotNull ChainLanguageDetector.ChainDetectionResult details2) {
            double v$iv;
            Object maxElem$iv;
            Iterator iterator$iv;
            boolean $i$f$maxByOrNull;
            Iterable $this$maxByOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)details2, (String)"details");
            LanguageDetector.DetectionResult result = details2.getResult();
            Language language = result.getPreferred();
            if (language == Language.UNKNOWN) {
                return;
            }
            if (size < 40) {
                return;
            }
            if (ExtensionsKt.getHasWhitespaces(language) && wordsTotal < 4) {
                return;
            }
            if (ListDetector.Companion.getSupported().contains((Object)language)) {
                Object v1;
                Object object = details2.get(LanguageDetector.Type.List);
                if (object == null || (object = ((LanguageDetector.DetectionResult)object).getDetected()) == null) {
                    return;
                }
                Object listResult = object;
                $this$maxByOrNull$iv = (Iterable)listResult;
                $i$f$maxByOrNull = false;
                iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v1 = null;
                } else {
                    maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v1 = maxElem$iv;
                    } else {
                        DetectedLanguage it = (DetectedLanguage)maxElem$iv;
                        boolean bl = false;
                        double maxValue$iv = it.getProbability();
                        do {
                            Object e$iv = iterator$iv.next();
                            DetectedLanguage it2 = (DetectedLanguage)e$iv;
                            $i$a$-maxByOrNull-DetectionContext$Local$update$maxList$1 = false;
                            v$iv = it2.getProbability();
                            if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v1 = maxElem$iv;
                    }
                }
                DetectedLanguage detectedLanguage = v1;
                if (detectedLanguage == null) {
                    return;
                }
                DetectedLanguage maxList = detectedLanguage;
                if (maxList.getProbability() < 0.51 || maxList.getLang() != result.getPreferred()) {
                    return;
                }
            }
            if (NgramDetector.Companion.getSupported().contains((Object)language)) {
                LinkedHashSet<DetectedLanguage> ngramResult;
                LanguageDetector.DetectionResult detectionResult = details2.get(LanguageDetector.Type.Ngram);
                LinkedHashSet<DetectedLanguage> linkedHashSet = ngramResult = detectionResult != null ? detectionResult.getDetected() : null;
                if (ngramResult != null) {
                    Object v5;
                    $this$maxByOrNull$iv = ngramResult;
                    $i$f$maxByOrNull = false;
                    iterator$iv = $this$maxByOrNull$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        v5 = null;
                    } else {
                        maxElem$iv = iterator$iv.next();
                        if (!iterator$iv.hasNext()) {
                            v5 = maxElem$iv;
                        } else {
                            DetectedLanguage it = (DetectedLanguage)maxElem$iv;
                            boolean bl = false;
                            double maxValue$iv = it.getProbability();
                            do {
                                Object e$iv = iterator$iv.next();
                                DetectedLanguage it3 = (DetectedLanguage)e$iv;
                                $i$a$-maxByOrNull-DetectionContext$Local$update$maxNgram$1 = false;
                                v$iv = it3.getProbability();
                                if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                                maxElem$iv = e$iv;
                                maxValue$iv = v$iv;
                            } while (iterator$iv.hasNext());
                            v5 = maxElem$iv;
                        }
                    }
                    DetectedLanguage detectedLanguage = v5;
                    if (detectedLanguage == null) {
                        return;
                    }
                    DetectedLanguage maxNgram = detectedLanguage;
                    if (maxNgram.getProbability() < 0.98 || maxNgram.getLang() != result.getPreferred()) {
                        return;
                    }
                }
            }
            this.count(size, language);
        }

        private final void count(int size, Language lang) {
            ((Map)this.counter).put(lang, ((Number)this.counter.getOrDefault((Object)lang, 0)).intValue() + (size / 100 + 1));
        }

        public final void clear() {
            this.counter.clear();
        }

        @NotNull
        public final ConcurrentHashMap<Language, Integer> getCounter() {
            return this.counter;
        }

        public Local(@NotNull ConcurrentHashMap<Language, Integer> counter) {
            Intrinsics.checkNotNullParameter(counter, (String)"counter");
            this.counter = counter;
        }

        public /* synthetic */ Local(ConcurrentHashMap concurrentHashMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                concurrentHashMap = new ConcurrentHashMap();
            }
            this(concurrentHashMap);
        }

        public Local() {
            this(null, 1, null);
        }

        @NotNull
        public final ConcurrentHashMap<Language, Integer> component1() {
            return this.counter;
        }

        @NotNull
        public final Local copy(@NotNull ConcurrentHashMap<Language, Integer> counter) {
            Intrinsics.checkNotNullParameter(counter, (String)"counter");
            return new Local(counter);
        }

        public static /* synthetic */ Local copy$default(Local local, ConcurrentHashMap concurrentHashMap, int n, Object object) {
            if ((n & 1) != 0) {
                concurrentHashMap = local.counter;
            }
            return local.copy(concurrentHashMap);
        }

        @NotNull
        public String toString() {
            return "Local(counter=" + this.counter + ")";
        }

        public int hashCode() {
            ConcurrentHashMap<Language, Integer> concurrentHashMap = this.counter;
            return concurrentHashMap != null ? ((Object)concurrentHashMap).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Local)) break block3;
                    Local local = (Local)object;
                    if (!Intrinsics.areEqual(this.counter, local.counter)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/grazie/config/DetectionContext$Local$Companion;", "", "()V", "LIST_CONFIDENCE_THRESHOLD", "", "NGRAM_CONFIDENCE_THRESHOLD", "NOTIFICATION_PROPORTION_THRESHOLD", "NOTIFICATION_TOTAL_THRESHOLD", "", "SCORE_SIZE", "TEXT_SIZE_THRESHOLD", "WORDS_SIZE_THRESHOLD", "intellij.grazie.core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

