/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.util.DictionaryLookup;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.ThreadLocalCachedValue;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CoverageIOUtil {
    public static final int GIGA = 1000000000;
    private static final int STRING_HEADER_SIZE = 1;
    private static final int STRING_LENGTH_THRESHOLD = 255;
    private static final String LONGER_THAN_64K_MARKER = "LONGER_THAN_64K";
    private static final ThreadLocalCachedValue<byte[]> ioBuffer = new ThreadLocalCachedValue<byte[]>(){

        @Override
        protected byte[] create() {
            return CoverageIOUtil.allocReadWriteUTFBuffer();
        }
    };
    private static final Pattern TYPE_PATTERN = Pattern.compile("L[^;]*;");

    private CoverageIOUtil() {
    }

    private static String readString(DataInput stream) throws IOException {
        int length = stream.readInt();
        if (length == -1) {
            return null;
        }
        char[] chars = new char[length];
        byte[] bytes = new byte[length * 2];
        stream.readFully(bytes);
        int i = 0;
        int i2 = 0;
        while (i < length) {
            chars[i] = (char)((bytes[i2] << 8) + (bytes[i2 + 1] & 0xFF));
            ++i;
            i2 += 2;
        }
        return new String(chars);
    }

    private static void writeString(DataOutput stream, String s) throws IOException {
        if (s == null) {
            stream.writeInt(-1);
            return;
        }
        char[] chars = s.toCharArray();
        byte[] bytes = new byte[chars.length * 2];
        stream.writeInt(chars.length);
        int i = 0;
        int i2 = 0;
        while (i < chars.length) {
            char aChar = chars[i];
            bytes[i2] = (byte)(aChar >>> 8 & 0xFF);
            bytes[i2 + 1] = (byte)(aChar & 0xFF);
            ++i;
            i2 += 2;
        }
        stream.write(bytes);
    }

    private static byte[] allocReadWriteUTFBuffer() {
        return new byte[256];
    }

    public static void writeUTF(DataOutput storage, String value) throws IOException {
        int len = value.length();
        if (len < 255 && CoverageIOUtil.isAscii(value)) {
            CoverageIOUtil.ioBuffer.getValue()[0] = (byte)len;
            for (int i = 0; i < len; ++i) {
                CoverageIOUtil.ioBuffer.getValue()[i + 1] = (byte)value.charAt(i);
            }
            storage.write(ioBuffer.getValue(), 0, len + 1);
        } else {
            storage.writeByte(-1);
            try {
                storage.writeUTF(value);
            }
            catch (UTFDataFormatException e) {
                storage.writeUTF(LONGER_THAN_64K_MARKER);
                CoverageIOUtil.writeString(storage, value);
            }
        }
    }

    public static String readUTFFast(DataInput storage) throws IOException {
        int len = 0xFF & storage.readByte();
        if (len == 255) {
            String result = storage.readUTF();
            if (LONGER_THAN_64K_MARKER.equals(result)) {
                return CoverageIOUtil.readString(storage);
            }
            return result;
        }
        char[] chars = new char[len];
        storage.readFully(ioBuffer.getValue(), 0, len);
        for (int i = 0; i < len; ++i) {
            chars[i] = (char)ioBuffer.getValue()[i];
        }
        return new String(chars);
    }

    private static boolean isAscii(String str) {
        for (int i = 0; i != str.length(); ++i) {
            char c = str.charAt(i);
            if (c < '\u0080') continue;
            return false;
        }
        return true;
    }

    public static int readINT(DataInput record) throws IOException {
        int val = record.readUnsignedByte();
        if (val < 192) {
            return val;
        }
        int res = val - 192;
        int sh = 6;
        while (true) {
            int next = record.readUnsignedByte();
            res |= (next & 0x7F) << sh;
            if ((next & 0x80) == 0) {
                return res;
            }
            sh += 7;
        }
    }

    public static void writeINT(DataOutput record, int val) throws IOException {
        if (0 <= val && val < 192) {
            record.writeByte(val);
        } else {
            record.writeByte(192 + (val & 0x3F));
            val >>>= 6;
            while (val >= 128) {
                record.writeByte(val & 0x7F | 0x80);
                val >>>= 7;
            }
            record.writeByte(val);
        }
    }

    public static String collapse(String methodSignature, final DictionaryLookup dictionaryLookup) {
        return CoverageIOUtil.processWithDictionary(methodSignature, new Consumer(){

            protected String consume(String type) {
                int dictionaryIndex = dictionaryLookup.getDictionaryIndex(type);
                return dictionaryIndex >= 0 ? String.valueOf(dictionaryIndex) : type;
            }
        });
    }

    static String processWithDictionary(String methodSignature, Consumer consumer) {
        Matcher matcher = TYPE_PATTERN.matcher(methodSignature);
        while (matcher.find()) {
            String type;
            String replacement;
            String s = matcher.group();
            if (!s.startsWith("L") || !s.endsWith(";") || (replacement = consumer.consume(type = s.substring(1, s.length() - 1))) == type) continue;
            methodSignature = methodSignature.replace(type, replacement);
        }
        return methodSignature;
    }

    public static DataOutputStream openFile(File file) throws FileNotFoundException {
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
    }

    public static void close(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static abstract class Consumer {
        protected abstract String consume(String var1);
    }

    public static final class FileLock {
        final File myLock;

        private FileLock(File target) {
            this.myLock = new File(target.getParentFile(), target.getName() + ".lck");
            if (this.myLock.getParentFile() != null) {
                this.myLock.getParentFile().mkdirs();
            }
        }

        private boolean isLocked() {
            return this.myLock.exists();
        }

        private boolean tryLock() {
            try {
                return this.myLock.createNewFile();
            }
            catch (IOException e) {
                return false;
            }
        }

        private boolean tryUnlock() {
            return this.myLock.delete();
        }

        public static FileLock lock(File targetFile) {
            return FileLock.lock(targetFile, 120000L, 100L);
        }

        public static FileLock lock(File targetFile, long totalTimeoutMS, long waitTimeMS) {
            FileLock lock = new FileLock(targetFile);
            if (lock.myLock.exists()) {
                long current = System.currentTimeMillis();
                long modified = lock.myLock.lastModified();
                if (modified != 0L && modified + totalTimeoutMS < current) {
                    lock.tryUnlock();
                }
            }
            for (long timePassed = 0L; timePassed < totalTimeoutMS; timePassed += waitTimeMS) {
                if (lock.tryLock()) {
                    return lock;
                }
                FileLock.wait(lock, waitTimeMS, "lock");
            }
            ErrorReporter.reportError("Failed to lock with file lock: " + lock.myLock.getAbsolutePath());
            return null;
        }

        public static void unlock(FileLock lock) {
            FileLock.unlock(lock, 5, 100L);
        }

        public static void unlock(FileLock lock, int retries, long waitTimeMS) {
            if (lock == null) {
                return;
            }
            for (int attempt = 0; attempt < retries; ++attempt) {
                if (!lock.isLocked()) {
                    return;
                }
                if (lock.tryUnlock()) {
                    return;
                }
                FileLock.wait(lock, waitTimeMS, "unlock");
            }
            ErrorReporter.reportError("Failed to unlock with file lock: " + lock.myLock.getAbsolutePath());
        }

        private static void wait(FileLock lock, long waitTimeMS, String action) {
            try {
                Thread.sleep(waitTimeMS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Failed to " + action + " with file lock: " + lock.myLock.getAbsolutePath(), e);
            }
        }
    }
}

