/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.wsl;

import com.intellij.build.events.MessageEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.target.LanguageRuntimeConfiguration;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.java.JavaLanguageRuntimeConfiguration;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.target.WslTargetEnvironmentConfiguration;
import com.intellij.execution.wsl.target.WslTargetEnvironmentRequest;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.pom.Navigatable;
import com.intellij.util.PathsList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.buildtool.quickfix.OpenMavenImportingSettingsQuickFix;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenServerCMDState;
import org.jetbrains.idea.maven.server.WslMavenDistribution;
import org.jetbrains.idea.maven.server.wsl.BuildIssueWslJdk;
import org.jetbrains.idea.maven.server.wsl.MavenWslProcessHandler;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenWslUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u0014\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0007H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0015H\u0002R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/idea/maven/server/wsl/WslMavenCmdState;", "Lorg/jetbrains/idea/maven/server/MavenServerCMDState;", "myWslDistribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "jdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "vmOptions", "", "mavenDistribution", "Lorg/jetbrains/idea/maven/server/WslMavenDistribution;", "debugPort", "", "myProject", "Lcom/intellij/openapi/project/Project;", "remoteHost", "(Lcom/intellij/execution/wsl/WSLDistribution;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Lorg/jetbrains/idea/maven/server/WslMavenDistribution;Ljava/lang/Integer;Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "getRemoteHost", "()Ljava/lang/String;", "createJavaParameters", "Lcom/intellij/execution/configurations/SimpleJavaParameters;", "getMavenOpts", "", "getWorkingDirectory", "startProcess", "Lcom/intellij/execution/process/ProcessHandler;", "toWslParameters", "parameters", "intellij.maven"})
public final class WslMavenCmdState
extends MavenServerCMDState {
    private final WSLDistribution myWslDistribution;
    @NotNull
    private final Project myProject;
    @NotNull
    private final String remoteHost;

    @Override
    @NotNull
    protected Map<String, String> getMavenOpts() {
        return MavenWslUtil.getPropertiesFromMavenOpts(this.myWslDistribution);
    }

    @Override
    @NotNull
    protected String getWorkingDirectory() {
        String string = this.myWslDistribution.getUserHome();
        if (string == null) {
            string = "/";
        }
        return string;
    }

    @Override
    @NotNull
    protected SimpleJavaParameters createJavaParameters() {
        SimpleJavaParameters parameters;
        SimpleJavaParameters simpleJavaParameters = parameters = super.createJavaParameters();
        Intrinsics.checkNotNullExpressionValue((Object)simpleJavaParameters, (String)"parameters");
        SimpleJavaParameters wslParams = this.toWslParameters(simpleJavaParameters);
        wslParams.getVMParametersList().add("-Djava.rmi.server.hostname=" + this.remoteHost);
        wslParams.getVMParametersList().add("-Didea.maven.wsl=true");
        return wslParams;
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleJavaParameters toWslParameters(SimpleJavaParameters parameters) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object item2;
        SimpleJavaParameters wslParams = new SimpleJavaParameters();
        wslParams.setMainClass(parameters.getMainClass());
        ParametersList parametersList = parameters.getVMParametersList();
        Intrinsics.checkNotNullExpressionValue((Object)parametersList, (String)"parameters.vmParametersList");
        for (Object item2 : parametersList.getParameters()) {
            wslParams.getVMParametersList().add((String)item2);
        }
        ParametersList parametersList2 = parameters.getProgramParametersList();
        Intrinsics.checkNotNullExpressionValue((Object)parametersList2, (String)"parameters.programParametersList");
        for (Object item2 : parametersList2.getParameters()) {
            wslParams.getProgramParametersList().add((String)item2);
        }
        wslParams.setCharset(parameters.getCharset());
        wslParams.getVMParametersList().add("-classpath");
        ParametersList parametersList3 = wslParams.getVMParametersList();
        PathsList pathsList = parameters.getClassPath();
        Intrinsics.checkNotNullExpressionValue((Object)pathsList, (String)"parameters.classPath");
        List list = pathsList.getPathList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parameters.classPath.pathList");
        item2 = list;
        WSLDistribution wSLDistribution = this.myWslDistribution;
        ParametersList parametersList4 = parametersList3;
        boolean $i$f$mapNotNull = false;
        void var6_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String p1 = (String)element$iv$iv;
            boolean bl2 = false;
            if (wSLDistribution.getWslPath(p1) == null) continue;
            String it$iv$iv = string;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        parametersList4.add(CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)":", null, null, (int)0, null, null, (int)62, null));
        return wslParams;
    }

    @Override
    @NotNull
    protected ProcessHandler startProcess() {
        String string;
        String wslPath;
        String string2;
        String projectJdkHomePath;
        WslTargetEnvironmentConfiguration wslConfig = new WslTargetEnvironmentConfiguration(this.myWslDistribution);
        WslTargetEnvironmentRequest request = new WslTargetEnvironmentRequest(wslConfig);
        SimpleJavaParameters wslParams = this.createJavaParameters();
        JavaLanguageRuntimeConfiguration languageRuntime = new JavaLanguageRuntimeConfiguration();
        Sdk sdk = this.myJdk;
        Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"myJdk");
        String jdkHomePath = sdk.getHomePath();
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(myProject)");
        Sdk sdk2 = projectRootManager.getProjectSdk();
        String string3 = projectJdkHomePath = sdk2 != null ? sdk2.getHomePath() : null;
        if (Intrinsics.areEqual((Object)MavenWslUtil.tryGetWslDistributionForPath(jdkHomePath), (Object)this.myWslDistribution) ^ true && Intrinsics.areEqual((Object)MavenWslUtil.tryGetWslDistributionForPath(projectJdkHomePath), (Object)this.myWslDistribution) ^ true) {
            MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(this.myProject);
            Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"MavenProjectsManager.getInstance(myProject)");
            mavenProjectsManager.getSyncConsole().addBuildIssue(new BuildIssueWslJdk(), MessageEvent.Kind.WARNING);
        } else if (Intrinsics.areEqual((Object)MavenWslUtil.tryGetWslDistributionForPath(jdkHomePath), (Object)this.myWslDistribution) ^ true && Intrinsics.areEqual((Object)MavenWslUtil.tryGetWslDistributionForPath(projectJdkHomePath), (Object)this.myWslDistribution)) {
            jdkHomePath = projectJdkHomePath;
            MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(this.myProject);
            Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"MavenProjectsManager.getInstance(myProject)");
            mavenProjectsManager.getSyncConsole().addBuildIssue(new BuildIssue(){
                @NotNull
                private final String title;
                @NotNull
                private final String description;
                @NotNull
                private final List<BuildIssueQuickFix> quickFixes;

                @NotNull
                public String getTitle() {
                    return this.title;
                }

                @NotNull
                public String getDescription() {
                    return this.description;
                }

                @NotNull
                public List<BuildIssueQuickFix> getQuickFixes() {
                    return this.quickFixes;
                }

                @Nullable
                public Navigatable getNavigatable(@NotNull Project project2) {
                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                    return null;
                }
                {
                    String string = SyncBundle.message("maven.sync.wsl.jdk.set.to.project", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SyncBundle.message(\"mave\u2026.wsl.jdk.set.to.project\")");
                    this.title = string;
                    this.description = SyncBundle.message("maven.sync.wsl.jdk.set.to.project", new Object[0]) + "\n<a href=\"open_maven_importing_settings_quick_fix\">" + SyncBundle.message("maven.sync.wsl.jdk.fix", new Object[0]) + "</a>";
                    this.quickFixes = CollectionsKt.listOf((Object)new OpenMavenImportingSettingsQuickFix());
                }
            }, MessageEvent.Kind.INFO);
        }
        String string4 = jdkHomePath;
        if (string4 != null) {
            String string5 = string4;
            WSLDistribution wSLDistribution = this.myWslDistribution;
            String p1 = string5;
            boolean bl = false;
            string2 = wSLDistribution.getWslPath(p1);
        } else {
            string2 = wslPath = null;
        }
        if (wslPath == null) {
            MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(this.myProject);
            Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"MavenProjectsManager.getInstance(myProject)");
            mavenProjectsManager.getSyncConsole().addBuildIssue(new BuildIssue(){
                @NotNull
                private final String title;
                @NotNull
                private final String description;
                @NotNull
                private final List<BuildIssueQuickFix> quickFixes;

                @NotNull
                public String getTitle() {
                    return this.title;
                }

                @NotNull
                public String getDescription() {
                    return this.description;
                }

                @NotNull
                public List<BuildIssueQuickFix> getQuickFixes() {
                    return this.quickFixes;
                }

                @Nullable
                public Navigatable getNavigatable(@NotNull Project project2) {
                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                    return null;
                }
                {
                    String string = SyncBundle.message("maven.sync.wsl.jdk.revert.usr", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SyncBundle.message(\"mave\u2026sync.wsl.jdk.revert.usr\")");
                    this.title = string;
                    this.description = SyncBundle.message("maven.sync.wsl.jdk", new Object[0]) + "\n<a href=\"open_maven_importing_settings_quick_fix\">" + SyncBundle.message("maven.sync.wsl.jdk.fix", new Object[0]) + "</a>";
                    this.quickFixes = CollectionsKt.listOf((Object)new OpenMavenImportingSettingsQuickFix());
                }
            }, MessageEvent.Kind.WARNING);
        }
        if ((string = wslPath) == null) {
            string = "/usr";
        }
        languageRuntime.setHomePath(string);
        request.getConfiguration().addLanguageRuntime((LanguageRuntimeConfiguration)languageRuntime);
        TargetedCommandLineBuilder targetedCommandLineBuilder = wslParams.toCommandLine((TargetEnvironmentRequest)request);
        Intrinsics.checkNotNullExpressionValue((Object)targetedCommandLineBuilder, (String)"wslParams.toCommandLine(request)");
        TargetedCommandLineBuilder builder = targetedCommandLineBuilder;
        builder.setWorkingDirectory(this.getWorkingDirectory());
        TargetProgressIndicator targetProgressIndicator = TargetProgressIndicator.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)targetProgressIndicator, (String)"TargetProgressIndicator.EMPTY");
        TargetEnvironment wslEnvironment = request.prepareEnvironment(targetProgressIndicator);
        MavenProjectsManager manager = MavenProjectsManager.getInstance(this.myProject);
        TargetedCommandLine targetedCommandLine = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)targetedCommandLine, (String)"builder.build()");
        TargetedCommandLine commandLine = targetedCommandLine;
        String commandPresentation = commandLine.getCommandPresentation(wslEnvironment);
        MavenLog.LOG.info("Staring maven server on WSL as " + commandPresentation);
        Function0 function0 = (Function0)new Function0<MavenSyncConsole>(manager){

            public final MavenSyncConsole invoke() {
                return ((MavenProjectsManager)this.receiver).getSyncConsole();
            }
        };
        ProgressIndicator progressIndicator = new MavenProgressIndicator(this.myProject, new Supplier(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ Object get() {
                return this.function.invoke();
            }
        }).getIndicator();
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"MavenProgressIndicator(m\u2026getSyncConsole).indicator");
        Process process2 = wslEnvironment.createProcess(commandLine, progressIndicator);
        return (ProcessHandler)new MavenWslProcessHandler(process2, commandPresentation, this.myWslDistribution);
    }

    @NotNull
    public final Project getMyProject() {
        return this.myProject;
    }

    @NotNull
    public final String getRemoteHost() {
        return this.remoteHost;
    }

    public WslMavenCmdState(@NotNull WSLDistribution myWslDistribution, @NotNull Sdk jdk2, @Nullable String vmOptions, @NotNull WslMavenDistribution mavenDistribution, @Nullable Integer debugPort, @NotNull Project myProject, @NotNull String remoteHost) {
        Intrinsics.checkNotNullParameter((Object)myWslDistribution, (String)"myWslDistribution");
        Intrinsics.checkNotNullParameter((Object)jdk2, (String)"jdk");
        Intrinsics.checkNotNullParameter((Object)mavenDistribution, (String)"mavenDistribution");
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)remoteHost, (String)"remoteHost");
        super(jdk2, vmOptions, mavenDistribution, debugPort);
        this.myWslDistribution = myWslDistribution;
        this.myProject = myProject;
        this.remoteHost = remoteHost;
    }
}

