/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.importing;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;

public class MavenImportUtil {
    private MavenImportUtil() {
    }

    public static Module createDummyModule(Project project2, VirtualFile contentRoot) {
        return (Module)WriteAction.compute(() -> {
            Module module = ModuleManager.getInstance((Project)project2).newModule(contentRoot.toNioPath(), ModuleTypeManager.getInstance().getDefaultModuleType().getId());
            ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            modifiableModel.addContentEntry(contentRoot);
            modifiableModel.commit();
            ExternalSystemModulePropertyManager.getInstance((Module)module).setMavenized(true);
            return module;
        });
    }

    private static void renameModuleToProjectName(Project project2, Module module) {
        try {
            ModifiableModuleModel moduleModel = ModuleManager.getInstance((Project)project2).getModifiableModel();
            moduleModel.renameModule(module, module.getName());
            moduleModel.commit();
        }
        catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
            // empty catch block
        }
    }
}

