/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.externalSystem.dependency.analyzer.AbstractDependencyAnalyzerAction;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAArtifact;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAModule;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerDependency;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.ui.treeStructure.SimpleTree;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.navigator.MavenProjectsStructure;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\u0002R\u00020\u0003H\u0016J\u001e\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\u0002R\u00020\u0003H\u0016J\u001e\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\u0002R\u00020\u0003H\u0016J\u0016\u0010\u000e\u001a\b\u0018\u00010\u0002R\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/maven/project/actions/ViewDependencyAnalyzerAction;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/AbstractDependencyAnalyzerAction;", "Lorg/jetbrains/idea/maven/navigator/MavenProjectsStructure$MavenSimpleNode;", "Lorg/jetbrains/idea/maven/navigator/MavenProjectsStructure;", "()V", "getDependencyData", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Data;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "selectedData", "getDependencyScope", "", "getModule", "Lcom/intellij/openapi/module/Module;", "getSelectedData", "getSystemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "intellij.maven"})
public final class ViewDependencyAnalyzerAction
extends AbstractDependencyAnalyzerAction<MavenProjectsStructure.MavenSimpleNode> {
    @NotNull
    public ProjectSystemId getSystemId(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ProjectSystemId projectSystemId = MavenUtil.SYSTEM_ID;
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"MavenUtil.SYSTEM_ID");
        return projectSystemId;
    }

    @Nullable
    public MavenProjectsStructure.MavenSimpleNode getSelectedData(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Component data = (Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        Component component = data;
        if (!(component instanceof SimpleTree)) {
            component = null;
        }
        SimpleTree simpleTree = (SimpleTree)component;
        Object object = simpleTree != null ? simpleTree.getSelectedNode() : null;
        if (!(object instanceof MavenProjectsStructure.MavenSimpleNode)) {
            object = null;
        }
        return (MavenProjectsStructure.MavenSimpleNode)((Object)object);
    }

    @Nullable
    public Module getModule(@NotNull AnActionEvent e, @NotNull MavenProjectsStructure.MavenSimpleNode selectedData) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)((Object)selectedData), (String)"selectedData");
        Project project2 = e.getProject();
        if (project2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"e.project ?: return null");
        Project project3 = project2;
        MavenProjectsStructure.ProjectNode projectNode = selectedData.findNode(MavenProjectsStructure.ProjectNode.class);
        if (projectNode == null) {
            return null;
        }
        MavenProjectsStructure.ProjectNode projectNode2 = projectNode;
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project3);
        return mavenProjectsManager.findModule(projectNode2.getMavenProject());
    }

    @Nullable
    public DependencyAnalyzerDependency.Data getDependencyData(@NotNull AnActionEvent e, @NotNull MavenProjectsStructure.MavenSimpleNode selectedData) {
        DependencyAnalyzerDependency.Data data;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)((Object)selectedData), (String)"selectedData");
        MavenProjectsStructure.MavenSimpleNode mavenSimpleNode = selectedData;
        if (mavenSimpleNode instanceof MavenProjectsStructure.DependencyNode) {
            MavenArtifact mavenArtifact = ((MavenProjectsStructure.DependencyNode)selectedData).getArtifact();
            Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact, (String)"selectedData.artifact");
            String string = mavenArtifact.getGroupId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"selectedData.artifact.groupId");
            MavenArtifact mavenArtifact2 = ((MavenProjectsStructure.DependencyNode)selectedData).getArtifact();
            Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact2, (String)"selectedData.artifact");
            String string2 = mavenArtifact2.getArtifactId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"selectedData.artifact.artifactId");
            MavenArtifact mavenArtifact3 = ((MavenProjectsStructure.DependencyNode)selectedData).getArtifact();
            Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact3, (String)"selectedData.artifact");
            String string3 = mavenArtifact3.getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"selectedData.artifact.version");
            data = (DependencyAnalyzerDependency.Data)new DAArtifact(string, string2, string3);
        } else if (mavenSimpleNode instanceof MavenProjectsStructure.ProjectNode) {
            MavenProject mavenProject2 = ((MavenProjectsStructure.ProjectNode)selectedData).getMavenProject();
            Intrinsics.checkNotNullExpressionValue((Object)mavenProject2, (String)"selectedData.mavenProject");
            String string = mavenProject2.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"selectedData.mavenProject.displayName");
            data = (DependencyAnalyzerDependency.Data)new DAModule(string);
        } else {
            data = null;
        }
        return data;
    }

    @Nullable
    public String getDependencyScope(@NotNull AnActionEvent e, @NotNull MavenProjectsStructure.MavenSimpleNode selectedData) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)((Object)selectedData), (String)"selectedData");
        if (selectedData instanceof MavenProjectsStructure.DependencyNode) {
            MavenArtifact mavenArtifact = ((MavenProjectsStructure.DependencyNode)selectedData).getArtifact();
            Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact, (String)"selectedData.artifact");
            return mavenArtifact.getScope();
        }
        return null;
    }
}

