/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenArtifactDownloader;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectReader;
import org.jetbrains.idea.maven.project.MavenProjectReaderResult;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenResolveResultProblemProcessor;
import org.jetbrains.idea.maven.project.ResolveContext;
import org.jetbrains.idea.maven.server.MavenConfigParseException;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenProjectResolver {
    public static final Key<Collection<MavenArtifact>> UNRESOLVED_ARTIFACTS = new Key("Unresolved Artifacts");
    private final MavenProjectsTree myTree;
    private final Project myProject;

    public MavenProjectResolver(@Nullable MavenProjectsTree tree) {
        this.myTree = tree;
        this.myProject = tree == null ? null : tree.getProject();
    }

    @TestOnly
    public void resolve(@NotNull Project project2, @NotNull MavenProject mavenProject2, @NotNull MavenGeneralSettings generalSettings, @NotNull MavenEmbeddersManager embeddersManager, @NotNull MavenConsole console2, @NotNull MavenProgressIndicator process2) throws MavenProcessCanceledException {
        if (project2 == null) {
            MavenProjectResolver.$$$reportNull$$$0(0);
        }
        if (mavenProject2 == null) {
            MavenProjectResolver.$$$reportNull$$$0(1);
        }
        if (generalSettings == null) {
            MavenProjectResolver.$$$reportNull$$$0(2);
        }
        if (embeddersManager == null) {
            MavenProjectResolver.$$$reportNull$$$0(3);
        }
        if (console2 == null) {
            MavenProjectResolver.$$$reportNull$$$0(4);
        }
        if (process2 == null) {
            MavenProjectResolver.$$$reportNull$$$0(5);
        }
        this.resolve(project2, Collections.singletonList(mavenProject2), generalSettings, embeddersManager, console2, new ResolveContext(), process2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(@NotNull Project project2, @NotNull Collection<MavenProject> mavenProjects, @NotNull MavenGeneralSettings generalSettings, @NotNull MavenEmbeddersManager embeddersManager, @NotNull MavenConsole console2, @NotNull ResolveContext context, @NotNull MavenProgressIndicator process2) throws MavenProcessCanceledException {
        if (project2 == null) {
            MavenProjectResolver.$$$reportNull$$$0(6);
        }
        if (mavenProjects == null) {
            MavenProjectResolver.$$$reportNull$$$0(7);
        }
        if (generalSettings == null) {
            MavenProjectResolver.$$$reportNull$$$0(8);
        }
        if (embeddersManager == null) {
            MavenProjectResolver.$$$reportNull$$$0(9);
        }
        if (console2 == null) {
            MavenProjectResolver.$$$reportNull$$$0(10);
        }
        if (context == null) {
            MavenProjectResolver.$$$reportNull$$$0(11);
        }
        if (process2 == null) {
            MavenProjectResolver.$$$reportNull$$$0(12);
        }
        MultiMap<Path, MavenProject> projectMultiMap = this.groupByBasedir(mavenProjects);
        for (Map.Entry entry : projectMultiMap.entrySet()) {
            block16: {
                String baseDir = ((Path)entry.getKey()).toString();
                MavenEmbedderWrapper embedder = embeddersManager.getEmbedder(MavenEmbeddersManager.FOR_DEPENDENCIES_RESOLVE, baseDir, baseDir);
                try {
                    Properties userProperties = new Properties();
                    for (MavenProject mavenProject2 : mavenProjects) {
                        mavenProject2.setConfigFileError(null);
                        for (MavenImporter mavenImporter : mavenProject2.getSuitableImporters()) {
                            mavenImporter.customizeUserProperties(project2, mavenProject2, userProperties);
                        }
                    }
                    boolean updateSnapshots = MavenProjectsManager.getInstance(project2).getForceUpdateSnapshots();
                    updateSnapshots = updateSnapshots ? updateSnapshots : generalSettings.isAlwaysUpdateSnapshots();
                    embedder.customizeForResolve(this.myTree.getWorkspaceMap(), console2, process2, updateSnapshots, userProperties);
                    this.doResolve(project2, (Collection)entry.getValue(), generalSettings, embedder, context, process2);
                }
                catch (Throwable t) {
                    MavenConfigParseException cause = MavenProjectResolver.findParseException(t);
                    if (cause != null) {
                        MavenLog.LOG.warn("Cannot parse maven config", (Throwable)cause);
                        break block16;
                    }
                    throw t;
                }
                finally {
                    embeddersManager.release(embedder);
                }
            }
            MavenUtil.restartConfigHighlightning(project2, mavenProjects);
        }
    }

    private static MavenConfigParseException findParseException(Throwable t) {
        Throwable target;
        MavenConfigParseException parseException = (MavenConfigParseException)ExceptionUtil.findCause((Throwable)t, MavenConfigParseException.class);
        if (parseException != null) {
            return parseException;
        }
        Throwable cause = ExceptionUtil.getRootCause((Throwable)t);
        if (cause instanceof InvocationTargetException && (target = ((InvocationTargetException)cause).getTargetException()) != null) {
            return (MavenConfigParseException)ExceptionUtil.findCause((Throwable)target, MavenConfigParseException.class);
        }
        return null;
    }

    private void doResolve(@NotNull Project project2, @NotNull Collection<MavenProject> mavenProjects, @NotNull MavenGeneralSettings generalSettings, @NotNull MavenEmbedderWrapper embedder, @NotNull ResolveContext context, @NotNull MavenProgressIndicator process2) throws MavenProcessCanceledException {
        if (project2 == null) {
            MavenProjectResolver.$$$reportNull$$$0(13);
        }
        if (mavenProjects == null) {
            MavenProjectResolver.$$$reportNull$$$0(14);
        }
        if (generalSettings == null) {
            MavenProjectResolver.$$$reportNull$$$0(15);
        }
        if (embedder == null) {
            MavenProjectResolver.$$$reportNull$$$0(16);
        }
        if (context == null) {
            MavenProjectResolver.$$$reportNull$$$0(17);
        }
        if (process2 == null) {
            MavenProjectResolver.$$$reportNull$$$0(18);
        }
        if (mavenProjects.isEmpty()) {
            return;
        }
        process2.checkCanceled();
        List names = ContainerUtil.mapNotNull(mavenProjects, p -> p.getDisplayName());
        String text = StringUtil.shortenPathWithEllipsis((String)StringUtil.join((Collection)names, (String)", "), (int)200);
        process2.setText(MavenProjectBundle.message("maven.resolving.pom", text));
        process2.setText2("");
        MavenExplicitProfiles explicitProfiles = this.myTree.getExplicitProfiles();
        List files = ContainerUtil.map(mavenProjects, p -> p.getFile());
        Collection<MavenProjectReaderResult> results = new MavenProjectReader(project2).resolveProject(generalSettings, embedder, files, explicitProfiles, this.myTree.getProjectLocator());
        MavenResolveResultProblemProcessor.MavenResolveProblemHolder problems = MavenResolveResultProblemProcessor.getProblems(results);
        MavenResolveResultProblemProcessor.notifySyncForProblem(project2, problems);
        context.putUserData(UNRESOLVED_ARTIFACTS, problems.unresolvedArtifacts);
        for (MavenProjectReaderResult result : results) {
            MavenProject mavenProjectCandidate = null;
            for (MavenProject mavenProject2 : mavenProjects) {
                MavenId mavenId = result.mavenModel.getMavenId();
                if (mavenProject2.getMavenId().equals((Object)mavenId)) {
                    mavenProjectCandidate = mavenProject2;
                    break;
                }
                if (!mavenProject2.getMavenId().equals(mavenId.getGroupId(), mavenId.getArtifactId())) continue;
                mavenProjectCandidate = mavenProject2;
            }
            if (mavenProjectCandidate == null) continue;
            MavenProjectChanges changes = mavenProjectCandidate.set(result, generalSettings, false, MavenProjectReaderResult.shouldResetDependenciesAndFolders(result), false);
            mavenProjectCandidate.getProblems();
            if (result.nativeMavenProject != null) {
                for (MavenImporter eachImporter : mavenProjectCandidate.getSuitableImporters()) {
                    eachImporter.resolve(project2, mavenProjectCandidate, result.nativeMavenProject, embedder, context);
                }
            }
            this.myTree.fireProjectResolved((Pair<MavenProject, MavenProjectChanges>)Pair.create((Object)mavenProjectCandidate, (Object)changes), result.nativeMavenProject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MavenPlugin> resolvePlugins(@NotNull MavenProject mavenProject2, @NotNull NativeMavenProjectHolder nativeMavenProject, @NotNull MavenEmbeddersManager embeddersManager, @NotNull MavenConsole console2, @NotNull MavenProgressIndicator process2, boolean reportUnresolvedToSyncConsole, boolean forceUpdateSnapshots) throws MavenProcessCanceledException {
        if (mavenProject2 == null) {
            MavenProjectResolver.$$$reportNull$$$0(19);
        }
        if (nativeMavenProject == null) {
            MavenProjectResolver.$$$reportNull$$$0(20);
        }
        if (embeddersManager == null) {
            MavenProjectResolver.$$$reportNull$$$0(21);
        }
        if (console2 == null) {
            MavenProjectResolver.$$$reportNull$$$0(22);
        }
        if (process2 == null) {
            MavenProjectResolver.$$$reportNull$$$0(23);
        }
        MavenEmbedderWrapper embedder = embeddersManager.getEmbedder(mavenProject2, MavenEmbeddersManager.FOR_PLUGINS_RESOLVE);
        embedder.customizeForResolve(console2, process2, forceUpdateSnapshots);
        embedder.clearCachesFor(mavenProject2.getMavenId());
        HashSet<Path> filesToRefresh = new HashSet<Path>();
        HashSet<MavenPlugin> unresolvedPlugins = new HashSet<MavenPlugin>();
        try {
            process2.setText(MavenProjectBundle.message("maven.downloading.pom.plugins", mavenProject2.getDisplayName()));
            for (MavenPlugin each : mavenProject2.getDeclaredPlugins()) {
                process2.checkCanceled();
                Collection<MavenArtifact> artifacts = embedder.resolvePlugin(each, mavenProject2.getRemoteRepositories(), nativeMavenProject, false);
                for (MavenArtifact artifact : artifacts) {
                    Path pluginJar = artifact.getFile().toPath();
                    Path pluginDir = pluginJar.getParent();
                    if (pluginDir == null) continue;
                    filesToRefresh.add(pluginDir);
                }
                if (!artifacts.isEmpty() || this.myProject == null) continue;
                unresolvedPlugins.add(each);
            }
            if (reportUnresolvedToSyncConsole) {
                this.reportUnresolvedPlugins(unresolvedPlugins);
            }
            mavenProject2.resetCache();
            this.myTree.firePluginsResolved(mavenProject2);
        }
        finally {
            if (filesToRefresh.size() > 0) {
                LocalFileSystem.getInstance().refreshNioFiles(filesToRefresh);
            }
            embeddersManager.release(embedder);
        }
        return unresolvedPlugins;
    }

    private void reportUnresolvedPlugins(Set<MavenPlugin> unresolvedPlugins) {
        if (!unresolvedPlugins.isEmpty()) {
            for (MavenPlugin mavenPlugin : unresolvedPlugins) {
                MavenProjectsManager.getInstance(this.myProject).getSyncConsole().getListener(MavenServerProgressIndicator.ResolveType.PLUGIN).showArtifactBuildIssue(mavenPlugin.getMavenId().getKey(), null);
            }
        }
    }

    public void resolveFolders(final @NotNull MavenProject mavenProject2, final @NotNull MavenImportingSettings importingSettings, @NotNull MavenEmbeddersManager embeddersManager, final @NotNull MavenConsole console2, final @NotNull MavenProgressIndicator process2) throws MavenProcessCanceledException {
        if (mavenProject2 == null) {
            MavenProjectResolver.$$$reportNull$$$0(24);
        }
        if (importingSettings == null) {
            MavenProjectResolver.$$$reportNull$$$0(25);
        }
        if (embeddersManager == null) {
            MavenProjectResolver.$$$reportNull$$$0(26);
        }
        if (console2 == null) {
            MavenProjectResolver.$$$reportNull$$$0(27);
        }
        if (process2 == null) {
            MavenProjectResolver.$$$reportNull$$$0(28);
        }
        this.executeWithEmbedder(mavenProject2, embeddersManager, MavenEmbeddersManager.FOR_FOLDERS_RESOLVE, console2, process2, new EmbedderTask(){

            @Override
            public void run(MavenEmbedderWrapper embedder) throws MavenProcessCanceledException {
                process2.checkCanceled();
                process2.setText(MavenProjectBundle.message("maven.updating.folders.pom", mavenProject2.getDisplayName()));
                process2.setText2("");
                Pair<Boolean, MavenProjectChanges> resolveResult = mavenProject2.resolveFolders(embedder, importingSettings, console2);
                if (((Boolean)resolveResult.first).booleanValue()) {
                    MavenProjectResolver.this.myTree.fireFoldersResolved((Pair<MavenProject, MavenProjectChanges>)Pair.create((Object)mavenProject2, (Object)((MavenProjectChanges)resolveResult.second)));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenArtifactDownloader.DownloadResult downloadSourcesAndJavadocs(@NotNull Project project2, @NotNull Collection<MavenProject> projects, @Nullable Collection<MavenArtifact> artifacts, boolean downloadSources, boolean downloadDocs, @NotNull MavenEmbeddersManager embeddersManager, @NotNull MavenConsole console2, @NotNull MavenProgressIndicator process2) throws MavenProcessCanceledException {
        if (project2 == null) {
            MavenProjectResolver.$$$reportNull$$$0(29);
        }
        if (projects == null) {
            MavenProjectResolver.$$$reportNull$$$0(30);
        }
        if (embeddersManager == null) {
            MavenProjectResolver.$$$reportNull$$$0(31);
        }
        if (console2 == null) {
            MavenProjectResolver.$$$reportNull$$$0(32);
        }
        if (process2 == null) {
            MavenProjectResolver.$$$reportNull$$$0(33);
        }
        MultiMap<Path, MavenProject> projectMultiMap = this.groupByBasedir(projects);
        MavenArtifactDownloader.DownloadResult result = new MavenArtifactDownloader.DownloadResult();
        for (Map.Entry entry : projectMultiMap.entrySet()) {
            String baseDir = ((Path)entry.getKey()).toString();
            MavenEmbedderWrapper embedder = embeddersManager.getEmbedder(MavenEmbeddersManager.FOR_DOWNLOAD, baseDir, baseDir);
            try {
                embedder.customizeForResolve(console2, process2);
                MavenArtifactDownloader.DownloadResult result1 = MavenArtifactDownloader.download(project2, this.myTree, projects, artifacts, downloadSources, downloadDocs, embedder, process2);
                for (MavenProject each : projects) {
                    this.myTree.fireArtifactsDownloaded(each);
                }
                result.resolvedDocs.addAll(result1.resolvedDocs);
                result.resolvedSources.addAll(result1.resolvedSources);
                result.unresolvedDocs.addAll(result1.unresolvedDocs);
                result.unresolvedSources.addAll(result1.unresolvedSources);
            }
            finally {
                embeddersManager.release(embedder);
            }
        }
        return result;
    }

    @NotNull
    private MultiMap<Path, MavenProject> groupByBasedir(@NotNull Collection<MavenProject> projects) {
        if (projects == null) {
            MavenProjectResolver.$$$reportNull$$$0(34);
        }
        MultiMap multiMap = ContainerUtil.groupBy(projects, p -> MavenUtil.getBaseDir(this.myTree.findRootProject((MavenProject)p).getDirectoryFile()));
        if (multiMap == null) {
            MavenProjectResolver.$$$reportNull$$$0(35);
        }
        return multiMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWithEmbedder(@NotNull MavenProject mavenProject2, @NotNull MavenEmbeddersManager embeddersManager, @NotNull Key embedderKind, @NotNull MavenConsole console2, @NotNull MavenProgressIndicator process2, @NotNull EmbedderTask task) throws MavenProcessCanceledException {
        if (mavenProject2 == null) {
            MavenProjectResolver.$$$reportNull$$$0(36);
        }
        if (embeddersManager == null) {
            MavenProjectResolver.$$$reportNull$$$0(37);
        }
        if (embedderKind == null) {
            MavenProjectResolver.$$$reportNull$$$0(38);
        }
        if (console2 == null) {
            MavenProjectResolver.$$$reportNull$$$0(39);
        }
        if (process2 == null) {
            MavenProjectResolver.$$$reportNull$$$0(40);
        }
        if (task == null) {
            MavenProjectResolver.$$$reportNull$$$0(41);
        }
        MavenEmbedderWrapper embedder = embeddersManager.getEmbedder(mavenProject2, embedderKind);
        embedder.customizeForResolve(this.myTree.getWorkspaceMap(), console2, process2, false);
        embedder.clearCachesFor(mavenProject2.getMavenId());
        try {
            task.run(embedder);
        }
        finally {
            embeddersManager.release(embedder);
        }
    }

    public static void showNotificationInvalidConfig(@NotNull Project project2, @Nullable MavenProject mavenProject2, String message) {
        VirtualFile configFile;
        if (project2 == null) {
            MavenProjectResolver.$$$reportNull$$$0(42);
        }
        VirtualFile virtualFile = configFile = mavenProject2 == null ? null : MavenUtil.getConfigFile(mavenProject2, "/.mvn/maven.config");
        if (configFile != null) {
            new Notification("Maven", RunnerBundle.message("maven.invalid.config.file.with.link", message), NotificationType.ERROR).setListener((notification, event) -> FileEditorManager.getInstance((Project)project2).openFile(configFile, true)).notify(project2);
        } else {
            new Notification("Maven", "", RunnerBundle.message("maven.invalid.config.file", message), NotificationType.ERROR).notify(project2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 19: 
            case 24: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 2: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generalSettings";
                break;
            }
            case 3: 
            case 9: 
            case 21: 
            case 26: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embeddersManager";
                break;
            }
            case 4: 
            case 10: 
            case 22: 
            case 27: 
            case 32: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 5: 
            case 12: 
            case 18: 
            case 23: 
            case 28: 
            case 33: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProjects";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embedder";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeMavenProject";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importingSettings";
                break;
            }
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenProjectResolver";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embedderKind";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProjectResolver";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByBasedir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doResolve";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolvePlugins";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resolveFolders";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "downloadSourcesAndJavadocs";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "groupByBasedir";
                break;
            }
            case 35: {
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "executeWithEmbedder";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "showNotificationInvalidConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface EmbedderTask {
        public void run(MavenEmbedderWrapper var1) throws MavenProcessCanceledException;
    }
}

