/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.model.SideEffectGuard;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.IndicesBundle;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenIndexHolder;
import org.jetbrains.idea.maven.indices.MavenIndices;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.indices.MavenSearchIndex;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenRehighlighter;

@ApiStatus.Internal
public final class MavenIndexUpdateManager
implements Disposable {
    private final Object myUpdatingIndicesLock = new Object();
    private final List<String> myWaitingIndicesUrl = new ArrayList<String>();
    private final BackgroundTaskQueue myUpdatingQueue = new BackgroundTaskQueue(null, IndicesBundle.message("maven.indices.updating", new Object[0]));
    private final MergingUpdateQueue myUpdateQueueList = new MergingUpdateQueue(this.getClass().getName(), 1000, true, null, (Disposable)this, null, false).usePassThroughInUnitTestMode();
    private volatile String myCurrentUpdateIndexUrl;

    CompletableFuture<?> scheduleUpdateContent(@NotNull Project project2, List<String> indicesUrl) {
        if (project2 == null) {
            MavenIndexUpdateManager.$$$reportNull$$$0(0);
        }
        return this.scheduleUpdateContent(project2, indicesUrl, true);
    }

    public void dispose() {
        this.myUpdatingQueue.clear();
    }

    void scheduleUpdateIndicesList(@NotNull Project project2, @Nullable Consumer<? super List<MavenIndex>> consumer) {
        if (project2 == null) {
            MavenIndexUpdateManager.$$$reportNull$$$0(1);
        }
        this.myUpdateQueueList.queue(Update.create((Object)this, () -> {
            MavenIndicesManager indicesManager = MavenIndicesManager.getInstance(project2);
            indicesManager.updateIndicesListSync();
            if (project2.isDisposed()) {
                return;
            }
            MavenIndexHolder indexHolder = indicesManager.getIndex();
            MavenIndex localIndex = indexHolder.getLocalIndex();
            if (localIndex != null && localIndex.getUpdateTimestamp() == -1L) {
                this.scheduleUpdateContent(project2, List.of(localIndex.getRepositoryPathOrUrl()));
            }
            if (consumer != null) {
                consumer.consume(indexHolder.getIndices());
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<?> scheduleUpdateContent(final @NotNull Project project2, List<String> indicesUrls, final boolean fullUpdate) {
        if (project2 == null) {
            MavenIndexUpdateManager.$$$reportNull$$$0(2);
        }
        SideEffectGuard.checkSideEffectAllowed((SideEffectGuard.EffectType)SideEffectGuard.EffectType.PROJECT_MODEL);
        final ArrayList<String> toSchedule = new ArrayList<String>();
        Object object = this.myUpdatingIndicesLock;
        synchronized (object) {
            for (String each : indicesUrls) {
                if (this.myWaitingIndicesUrl.contains(each)) continue;
                toSchedule.add(each);
            }
            this.myWaitingIndicesUrl.addAll(toSchedule);
        }
        if (toSchedule.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        final CompletableFuture promise = new CompletableFuture();
        this.myUpdatingQueue.run(new Task.Backgroundable(project2, IndicesBundle.message("maven.indices.updating", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    indicator.setIndeterminate(false);
                    MavenIndexUpdateManager.this.doUpdateIndicesContent(project2, toSchedule, fullUpdate, new MavenProgressIndicator(project2, indicator, null));
                }
                catch (MavenProcessCanceledException mavenProcessCanceledException) {
                }
                finally {
                    promise.complete(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/indices/MavenIndexUpdateManager$1", "run"));
            }
        });
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateIndicesContent(@NotNull Project project2, @NotNull List<String> indicesUrl, boolean fullUpdate, @NotNull MavenProgressIndicator indicator) throws MavenProcessCanceledException {
        Object object;
        if (project2 == null) {
            MavenIndexUpdateManager.$$$reportNull$$$0(3);
        }
        if (indicesUrl == null) {
            MavenIndexUpdateManager.$$$reportNull$$$0(4);
        }
        if (indicator == null) {
            MavenIndexUpdateManager.$$$reportNull$$$0(5);
        }
        List indices = ContainerUtil.filter(MavenIndicesManager.getInstance(project2).getIndex().getIndices(), index -> indicesUrl.contains(index.getRepositoryPathOrUrl()));
        ArrayList<String> remainingWaitingUrl = new ArrayList<String>(indicesUrl);
        try {
            for (MavenSearchIndex each : indices) {
                if (indicator.isCanceled()) {
                    return;
                }
                indicator.setText(IndicesBundle.message("maven.indices.updating.index", each.getRepositoryId(), each.getRepositoryPathOrUrl()));
                object = this.myUpdatingIndicesLock;
                synchronized (object) {
                    remainingWaitingUrl.remove(each.getRepositoryPathOrUrl());
                    this.myWaitingIndicesUrl.remove(each.getRepositoryPathOrUrl());
                    this.myCurrentUpdateIndexUrl = each.getRepositoryPathOrUrl();
                }
                try {
                    MavenIndices.updateOrRepair(each, fullUpdate, fullUpdate ? MavenIndexUpdateManager.getMavenSettings(project2, indicator) : null, indicator);
                    MavenRehighlighter.rehighlight(project2);
                }
                finally {
                    object = this.myUpdatingIndicesLock;
                    synchronized (object) {
                        this.myCurrentUpdateIndexUrl = null;
                    }
                }
            }
        }
        finally {
            object = this.myUpdatingIndicesLock;
            synchronized (object) {
                this.myWaitingIndicesUrl.removeAll(remainingWaitingUrl);
            }
        }
    }

    private static MavenGeneralSettings getMavenSettings(@NotNull Project project2, @NotNull MavenProgressIndicator indicator) throws MavenProcessCanceledException {
        MavenGeneralSettings settings;
        if (project2 == null) {
            MavenIndexUpdateManager.$$$reportNull$$$0(6);
        }
        if (indicator == null) {
            MavenIndexUpdateManager.$$$reportNull$$$0(7);
        }
        if ((settings = (MavenGeneralSettings)ReadAction.compute(() -> project2.isDisposed() ? null : MavenProjectsManager.getInstance(project2).getGeneralSettings().clone())) == null) {
            indicator.cancel();
            indicator.checkCanceled();
        }
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IndexUpdatingState getUpdatingState(@NotNull MavenSearchIndex index) {
        if (index == null) {
            MavenIndexUpdateManager.$$$reportNull$$$0(8);
        }
        Object object = this.myUpdatingIndicesLock;
        synchronized (object) {
            if (Objects.equals(this.myCurrentUpdateIndexUrl, index.getRepositoryPathOrUrl())) {
                return IndexUpdatingState.UPDATING;
            }
            if (this.myWaitingIndicesUrl.contains(index.getRepositoryPathOrUrl())) {
                return IndexUpdatingState.WAITING;
            }
            return IndexUpdatingState.IDLE;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicesUrl";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/indices/MavenIndexUpdateManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleUpdateContent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleUpdateIndicesList";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doUpdateIndicesContent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getMavenSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getUpdatingState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum IndexUpdatingState {
        IDLE,
        WAITING,
        UPDATING;

    }
}

