/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.IdeUIModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenModuleImporter;
import org.jetbrains.idea.maven.importing.MavenProjectImporter;
import org.jetbrains.idea.maven.importing.ModifiableModelsProviderProxy;
import org.jetbrains.idea.maven.importing.ModifiableModelsProviderProxyImpl;
import org.jetbrains.idea.maven.importing.ModifiableModelsProviderProxyWrapper;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.statistics.MavenImportCollector;
import org.jetbrains.idea.maven.utils.MavenArtifactUtilKt;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;

public abstract class MavenProjectImporterBase
implements MavenProjectImporter {
    protected final Project myProject;
    protected final MavenProjectsTree myProjectsTree;
    protected final MavenImportingSettings myImportingSettings;
    protected volatile Map<MavenProject, MavenProjectChanges> myProjectsToImportWithChanges;
    protected final IdeModifiableModelsProvider myIdeModifiableModelsProvider;
    protected final ModifiableModelsProviderProxy myModelsProvider;

    public MavenProjectImporterBase(Project project2, MavenProjectsTree projectsTree, MavenImportingSettings importingSettings, Map<MavenProject, MavenProjectChanges> projectsToImportWithChanges, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (modelsProvider == null) {
            MavenProjectImporterBase.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
        this.myProjectsTree = projectsTree;
        this.myImportingSettings = importingSettings;
        this.myProjectsToImportWithChanges = projectsToImportWithChanges;
        this.myIdeModifiableModelsProvider = modelsProvider;
        this.myModelsProvider = MavenUtil.newModelEnabled(this.myProject) && modelsProvider instanceof IdeModifiableModelsProviderImpl ? new ModifiableModelsProviderProxyImpl(this.myProject, ((IdeModifiableModelsProviderImpl)modelsProvider).getActualStorageBuilder()) : new ModifiableModelsProviderProxyWrapper(this.myIdeModifiableModelsProvider);
    }

    protected Set<MavenProject> selectProjectsToImport(Collection<MavenProject> originalProjects) {
        HashSet<MavenProject> result = new HashSet<MavenProject>();
        for (MavenProject each : originalProjects) {
            if (!this.shouldCreateModuleFor(each)) continue;
            result.add(each);
        }
        return result;
    }

    protected boolean shouldCreateModuleFor(MavenProject project2) {
        if (this.myProjectsTree.isIgnored(project2)) {
            return false;
        }
        return !project2.isAggregator() || this.myImportingSettings.isCreateModulesForAggregators();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configFacets(List<MavenModuleImporter> importers, List<MavenProjectsProcessorTask> postTasks) {
        if (!importers.isEmpty()) {
            IdeModifiableModelsProvider provider = this.myIdeModifiableModelsProvider instanceof IdeUIModifiableModelsProvider ? this.myIdeModifiableModelsProvider : ProjectDataManager.getInstance().createModifiableModelsProvider(this.myProject);
            try {
                List toRun = ContainerUtil.filter(importers, it -> !it.isModuleDisposed() && !it.isAggregatorMainTestModule());
                HashMap counters = new HashMap();
                toRun.forEach(importer -> importer.setModifiableModelsProvider(provider));
                toRun.forEach(importer -> importer.preConfigFacets(counters));
                toRun.forEach(importer -> importer.configFacets(postTasks, counters));
                toRun.forEach(importer -> importer.postConfigFacets(counters));
                for (Map.Entry each : counters.entrySet()) {
                    MavenImportCollector.IMPORTER_RUN.log(this.myProject, (Object)((Class)each.getKey()), (Object)((MavenModuleImporter.CountAndTime)each.getValue()).count, (Object)TimeUnit.NANOSECONDS.toMillis(((MavenModuleImporter.CountAndTime)each.getValue()).timeNano));
                }
            }
            finally {
                MavenUtil.invokeAndWaitWriteAction(this.myProject, () -> ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> provider.commit()));
            }
        }
    }

    protected void scheduleRefreshResolvedArtifacts(List<MavenProjectsProcessorTask> postTasks) {
        ArrayList<MavenArtifact> artifacts = new ArrayList<MavenArtifact>();
        for (MavenProject each : this.myProjectsToImportWithChanges.keySet()) {
            artifacts.addAll(each.getDependencies());
        }
        HashSet<File> files = new HashSet<File>();
        for (MavenArtifact each : artifacts) {
            if (!MavenArtifactUtilKt.resolved(each)) continue;
            files.add(each.getFile());
        }
        if (MavenUtil.isMavenUnitTestModeEnabled()) {
            MavenProjectImporterBase.doRefreshFiles(files);
        } else {
            postTasks.add(new RefreshingFilesTask(files));
        }
    }

    protected void removeOutdatedCompilerConfigSettings() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        JpsJavaCompilerOptions javacOptions = JavacConfiguration.getOptions((Project)this.myProject, JavacConfiguration.class);
        String options = javacOptions.ADDITIONAL_OPTIONS_STRING;
        javacOptions.ADDITIONAL_OPTIONS_STRING = options = options.replaceFirst("(-target (\\S+))", "");
    }

    protected boolean projectsToImportHaveChanges() {
        for (MavenProjectChanges each : this.myProjectsToImportWithChanges.values()) {
            if (!each.hasChanges()) continue;
            return true;
        }
        return false;
    }

    protected static void doRefreshFiles(Set<File> files) {
        LocalFileSystem.getInstance().refreshIoFiles(files);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/idea/maven/importing/MavenProjectImporterBase", "<init>"));
    }

    protected static class RefreshingFilesTask
    implements MavenProjectsProcessorTask {
        private final Set<File> myFiles;

        protected RefreshingFilesTask(Set<File> files) {
            this.myFiles = files;
        }

        @Override
        public void perform(Project project2, MavenEmbeddersManager embeddersManager, MavenConsole console2, MavenProgressIndicator indicator) {
            indicator.setText(MavenProjectBundle.message("progress.text.refreshing.files", new Object[0]));
            MavenProjectImporterBase.doRefreshFiles(this.myFiles);
        }
    }
}

