/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenImportStats;
import org.jetbrains.idea.maven.importing.MavenProjectImporterImpl;
import org.jetbrains.idea.maven.importing.tree.MavenProjectTreeLegacyImporter;
import org.jetbrains.idea.maven.importing.tree.workspace.MavenProjectTreeImporterToWorkspaceModel;
import org.jetbrains.idea.maven.importing.workspaceModel.MavenProjectImporterToWorkspaceModel;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenLog;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&J\u0010\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0003H&\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenProjectImporter;", "", "createdModules", "", "Lcom/intellij/openapi/module/Module;", "importProject", "Lorg/jetbrains/idea/maven/project/MavenProjectsProcessorTask;", "Companion", "intellij.maven"})
public interface MavenProjectImporter {
    @NotNull
    public static final Companion Companion = org.jetbrains.idea.maven.importing.MavenProjectImporter$Companion.$$INSTANCE;

    @Nullable
    public List<MavenProjectsProcessorTask> importProject();

    @NotNull
    public List<Module> createdModules();

    @JvmStatic
    @NotNull
    public static MavenProjectImporter createImporter(@NotNull Project project2, @NotNull MavenProjectsTree projectsTree, @NotNull Map<MavenProject, ? extends MavenProjectChanges> projectsToImportWithChanges, boolean importModuleGroupsRequired, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull MavenImportingSettings importingSettings, @Nullable Module dummyModule, @NotNull StructuredIdeActivity importingActivity) {
        return Companion.createImporter(project2, projectsTree, projectsToImportWithChanges, importModuleGroupsRequired, modelsProvider, importingSettings, dummyModule, importingActivity);
    }

    @JvmStatic
    public static boolean isImportToWorkspaceModelEnabled() {
        return Companion.isImportToWorkspaceModelEnabled();
    }

    @JvmStatic
    public static boolean isImportToTreeStructureEnabled(@Nullable Project project2) {
        return Companion.isImportToTreeStructureEnabled(project2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JN\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002JV\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0012\u0010\u0017\u001a\u00020\u000e2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\b\u0010\u0018\u001a\u00020\u000eH\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenProjectImporter$Companion;", "", "()V", "createImporter", "Lorg/jetbrains/idea/maven/importing/MavenProjectImporter;", "project", "Lcom/intellij/openapi/project/Project;", "projectsTree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "projectsToImportWithChanges", "", "Lorg/jetbrains/idea/maven/project/MavenProject;", "Lorg/jetbrains/idea/maven/project/MavenProjectChanges;", "importModuleGroupsRequired", "", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "importingSettings", "Lorg/jetbrains/idea/maven/project/MavenImportingSettings;", "dummyModule", "Lcom/intellij/openapi/module/Module;", "importingActivity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "isImportToTreeStructureEnabled", "isImportToWorkspaceModelEnabled", "intellij.maven"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        @JvmStatic
        @NotNull
        public final MavenProjectImporter createImporter(@NotNull Project project2, @NotNull MavenProjectsTree projectsTree, @NotNull Map<MavenProject, ? extends MavenProjectChanges> projectsToImportWithChanges, boolean importModuleGroupsRequired, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull MavenImportingSettings importingSettings, @Nullable Module dummyModule, @NotNull StructuredIdeActivity importingActivity) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)projectsTree, (String)"projectsTree");
            Intrinsics.checkNotNullParameter(projectsToImportWithChanges, (String)"projectsToImportWithChanges");
            Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
            Intrinsics.checkNotNullParameter((Object)importingSettings, (String)"importingSettings");
            Intrinsics.checkNotNullParameter((Object)importingActivity, (String)"importingActivity");
            MavenProjectImporter importer = this.createImporter(project2, projectsTree, projectsToImportWithChanges, importModuleGroupsRequired, modelsProvider, importingSettings, dummyModule);
            return new MavenProjectImporter(project2, importingActivity, importer){
                final /* synthetic */ Project $project;
                final /* synthetic */ StructuredIdeActivity $importingActivity;
                final /* synthetic */ MavenProjectImporter $importer;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Nullable
                public List<MavenProjectsProcessorTask> importProject() {
                    StructuredIdeActivity structuredIdeActivity = MavenImportStats.startApplyingModelsActivity(this.$project, this.$importingActivity);
                    Intrinsics.checkNotNullExpressionValue((Object)structuredIdeActivity, (String)"MavenImportStats.startAp\u2026oject, importingActivity)");
                    StructuredIdeActivity activity = structuredIdeActivity;
                    long startTime = System.currentTimeMillis();
                    try {
                        List<MavenProjectsProcessorTask> list = this.$importer.importProject();
                        return list;
                    }
                    finally {
                        StructuredIdeActivity.finished$default((StructuredIdeActivity)activity, null, (int)1, null);
                        MavenLog.LOG.info("[maven import] applying models to workspace model took " + (System.currentTimeMillis() - startTime) + "ms");
                    }
                }

                @NotNull
                public List<Module> createdModules() {
                    return this.$importer.createdModules();
                }
                {
                    this.$project = $captured_local_variable$0;
                    this.$importingActivity = $captured_local_variable$1;
                    this.$importer = $captured_local_variable$2;
                }
            };
        }

        private final MavenProjectImporter createImporter(Project project2, MavenProjectsTree projectsTree, Map<MavenProject, ? extends MavenProjectChanges> projectsToImportWithChanges, boolean importModuleGroupsRequired, IdeModifiableModelsProvider modelsProvider, MavenImportingSettings importingSettings, Module dummyModule) {
            if (this.isImportToWorkspaceModelEnabled()) {
                if (this.isImportToTreeStructureEnabled(project2)) {
                    return new MavenProjectTreeImporterToWorkspaceModel(projectsTree, projectsToImportWithChanges, importingSettings, modelsProvider, project2);
                }
                return new MavenProjectImporterToWorkspaceModel(projectsTree, projectsToImportWithChanges, importingSettings, modelsProvider, project2);
            }
            if (this.isImportToTreeStructureEnabled(project2)) {
                return new MavenProjectTreeLegacyImporter(project2, projectsTree, projectsToImportWithChanges, modelsProvider, importingSettings);
            }
            return new MavenProjectImporterImpl(project2, projectsTree, projectsToImportWithChanges, importModuleGroupsRequired, modelsProvider, importingSettings, dummyModule);
        }

        @JvmStatic
        public final boolean isImportToWorkspaceModelEnabled() {
            return Registry.is((String)"maven.import.to.workspace.model");
        }

        @JvmStatic
        public final boolean isImportToTreeStructureEnabled(@Nullable Project project2) {
            if (project2 == null) {
                return true;
            }
            if (MavenProjectTreeLegacyImporter.isAlwaysUseTreeImport()) {
                return true;
            }
            MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project2);
            Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"MavenProjectsManager.getInstance(project)");
            MavenImportingSettings mavenImportingSettings = mavenProjectsManager.getImportingSettings();
            Intrinsics.checkNotNullExpressionValue((Object)mavenImportingSettings, (String)"MavenProjectsManager.get\u2026roject).importingSettings");
            return mavenImportingSettings.isImportToTreeStructure();
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
        }
    }
}

