/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetectionUtil;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.NotNullList;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapterLegacyImpl;
import org.jetbrains.idea.maven.importing.ModifiableModelsProviderProxyWrapper;
import org.jetbrains.idea.maven.importing.tree.MavenModuleType;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class MavenFoldersImporter {
    private final MavenProject myMavenProject;
    private final MavenImportingSettings myImportingSettings;
    private final MavenRootModelAdapter myModel;

    public static void updateProjectFolders(Project project2, boolean updateTargetFoldersOnly) {
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project2);
        MavenImportingSettings settings = manager.getImportingSettings();
        WriteAction.run(() -> {
            ArrayList<ModifiableRootModel> rootModels = new ArrayList<ModifiableRootModel>();
            for (Module each : ModuleManager.getInstance((Project)project2).getModules()) {
                MavenProject mavenProject2 = manager.findProject(each);
                if (mavenProject2 == null) continue;
                MavenRootModelAdapter a = new MavenRootModelAdapter(new MavenRootModelAdapterLegacyImpl(mavenProject2, each, new ModifiableModelsProviderProxyWrapper(project2)));
                new MavenFoldersImporter(mavenProject2, settings, a).config(updateTargetFoldersOnly);
                ModifiableRootModel model2 = a.getRootModel();
                if (model2.isChanged()) {
                    rootModels.add(model2);
                    continue;
                }
                model2.dispose();
            }
            if (!rootModels.isEmpty()) {
                ModifiableModelCommitter.multiCommit(rootModels, (ModifiableModuleModel)ModuleManager.getInstance((Project)((ModifiableRootModel)rootModels.get(0)).getProject()).getModifiableModel());
            }
        });
    }

    public MavenFoldersImporter(@NotNull MavenProject mavenProject2, @NotNull MavenImportingSettings settings, MavenRootModelAdapter model2) {
        if (mavenProject2 == null) {
            MavenFoldersImporter.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            MavenFoldersImporter.$$$reportNull$$$0(1);
        }
        this.myMavenProject = mavenProject2;
        this.myImportingSettings = settings;
        this.myModel = model2;
    }

    public void config() {
        this.config(false);
    }

    private void config(boolean updateTargetFoldersOnly) {
        if (!updateTargetFoldersOnly) {
            if (!this.myImportingSettings.isKeepSourceFolders()) {
                this.myModel.clearSourceFolders();
            }
            this.configSourceFolders();
            this.configOutputFolders();
        }
        this.configGeneratedFolders();
        if (!updateTargetFoldersOnly) {
            if (!FileUtil.namesEqual((String)"pom", (String)this.myMavenProject.getFile().getNameWithoutExtension()) && MavenUtil.streamPomFiles(this.myModel.getModule().getProject(), this.myMavenProject.getDirectoryFile()).skip(1L).findAny().isPresent()) {
                this.generateNewContentRoots(false);
            } else {
                this.generateNewContentRoots(true);
            }
        }
        this.configExcludedFolders();
    }

    public void configMainAndTestAggregator() {
        this.myModel.clearSourceFolders();
        this.myModel.useModuleOutput(null, null);
        this.configExcludedAggregatorFolders();
    }

    public void configMainAndTest(MavenModuleType type2) {
        if (!this.myImportingSettings.isKeepSourceFolders()) {
            this.myModel.clearSourceFolders();
        }
        boolean isTest = type2 == MavenModuleType.TEST;
        Map<String, JpsModuleSourceRootType<?>> sourceFolders = isTest ? MavenFoldersImporter.getTestSourceFolders(this.myMavenProject) : MavenFoldersImporter.getMainSourceFolders(this.myMavenProject);
        Path contentRootPath = Path.of(this.myMavenProject.getDirectory(), "src", isTest ? "test" : "main");
        String defaultContentRoot = contentRootPath.toString();
        boolean containDefaultContentRoot = false;
        for (String path : sourceFolders.keySet()) {
            if (containDefaultContentRoot) continue;
            containDefaultContentRoot = path.contains(defaultContentRoot);
        }
        sourceFolders.forEach((p, t) -> this.myModel.addSourceFolder((String)p, t));
        this.configOutputFolders(isTest);
        this.configGeneratedFolders(isTest);
        this.generateNewContentRoots(containDefaultContentRoot ? contentRootPath : null);
    }

    private void configSourceFolders() {
        Map<String, JpsModuleSourceRootType<?>> sourceFolders = MavenFoldersImporter.getSourceFolders(this.myMavenProject);
        sourceFolders.forEach((p, t) -> this.myModel.addSourceFolder((String)p, t));
    }

    private static boolean alreadyAdded(String canonicalPath, Map<String, ?> addedPaths) {
        for (String existing : addedPaths.keySet()) {
            if (!VfsUtilCore.isEqualOrAncestor((String)existing, (String)canonicalPath) && !VfsUtilCore.isEqualOrAncestor((String)canonicalPath, (String)existing)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Map<String, JpsModuleSourceRootType<?>> getSourceFolders(MavenProject mavenProject2) {
        MultiMap roots = MultiMap.createLinked();
        MavenFoldersImporter.addMainSourcePath(mavenProject2, roots);
        MavenFoldersImporter.addTestSourcePath(mavenProject2, roots);
        return MavenFoldersImporter.getPathMap(mavenProject2, roots);
    }

    @NotNull
    public static Map<String, JpsModuleSourceRootType<?>> getMainSourceFolders(MavenProject mavenProject2) {
        MultiMap roots = MultiMap.createLinked();
        MavenFoldersImporter.addMainSourcePath(mavenProject2, roots);
        return MavenFoldersImporter.getPathMap(mavenProject2, roots);
    }

    @NotNull
    public static Map<String, JpsModuleSourceRootType<?>> getTestSourceFolders(MavenProject mavenProject2) {
        MultiMap roots = MultiMap.createLinked();
        MavenFoldersImporter.addTestSourcePath(mavenProject2, roots);
        return MavenFoldersImporter.getPathMap(mavenProject2, roots);
    }

    private static void addMainSourcePath(MavenProject mavenProject2, MultiMap<JpsModuleSourceRootType<?>, String> roots) {
        roots.putValues((Object)JavaSourceRootType.SOURCE, mavenProject2.getSources());
        for (MavenImporter mavenImporter : MavenImporter.getSuitableImporters(mavenProject2)) {
            mavenImporter.collectSourceRoots(mavenProject2, (s, type2) -> roots.putValue(type2, s));
        }
        for (MavenResource mavenResource : mavenProject2.getResources()) {
            roots.putValue((Object)JavaResourceRootType.RESOURCE, (Object)mavenResource.getDirectory());
        }
        MavenFoldersImporter.addBuilderHelperPaths(mavenProject2, "add-source", roots.getModifiable((Object)JavaSourceRootType.SOURCE));
        MavenFoldersImporter.addBuilderHelperResourcesPaths(mavenProject2, "add-resource", roots.getModifiable((Object)JavaResourceRootType.RESOURCE));
    }

    private static void addTestSourcePath(MavenProject mavenProject2, MultiMap<JpsModuleSourceRootType<?>, String> roots) {
        roots.putValues((Object)JavaSourceRootType.TEST_SOURCE, mavenProject2.getTestSources());
        for (MavenResource each : mavenProject2.getTestResources()) {
            roots.putValue((Object)JavaResourceRootType.TEST_RESOURCE, (Object)each.getDirectory());
        }
        MavenFoldersImporter.addBuilderHelperPaths(mavenProject2, "add-test-source", roots.getModifiable((Object)JavaSourceRootType.TEST_SOURCE));
        MavenFoldersImporter.addBuilderHelperResourcesPaths(mavenProject2, "add-test-resource", roots.getModifiable((Object)JavaResourceRootType.TEST_RESOURCE));
    }

    @NotNull
    private static Map<String, JpsModuleSourceRootType<?>> getPathMap(@NotNull MavenProject mavenProject2, @NotNull MultiMap<JpsModuleSourceRootType<?>, String> roots) {
        if (mavenProject2 == null) {
            MavenFoldersImporter.$$$reportNull$$$0(2);
        }
        if (roots == null) {
            MavenFoldersImporter.$$$reportNull$$$0(3);
        }
        LinkedHashMap addedPaths = new LinkedHashMap();
        for (JpsModuleSourceRootType type2 : roots.keySet()) {
            for (String path : roots.get((Object)type2)) {
                org.jetbrains.idea.maven.utils.Path nioPath;
                String canonicalPath;
                if (path == null || MavenFoldersImporter.alreadyAdded(canonicalPath = (nioPath = MavenUtil.toPath(mavenProject2, path)).getPath(), addedPaths)) continue;
                addedPaths.put(canonicalPath, type2);
            }
        }
        LinkedHashMap linkedHashMap = addedPaths;
        if (linkedHashMap == null) {
            MavenFoldersImporter.$$$reportNull$$$0(4);
        }
        return linkedHashMap;
    }

    private static void addBuilderHelperPaths(MavenProject mavenProject2, String goal, Collection<String> folders) {
        MavenPlugin plugin = mavenProject2.findPlugin("org.codehaus.mojo", "build-helper-maven-plugin");
        if (plugin != null) {
            for (MavenPlugin.Execution execution : plugin.getExecutions()) {
                Element sourcesElement;
                Element configurationElement;
                if (!execution.getGoals().contains(goal) || (configurationElement = execution.getConfigurationElement()) == null || (sourcesElement = configurationElement.getChild("sources")) == null) continue;
                for (Element element : sourcesElement.getChildren()) {
                    folders.add(element.getTextTrim());
                }
            }
        }
    }

    private static void addBuilderHelperResourcesPaths(MavenProject mavenProject2, String goal, Collection<String> folders) {
        MavenPlugin plugin = mavenProject2.findPlugin("org.codehaus.mojo", "build-helper-maven-plugin");
        if (plugin != null) {
            for (MavenPlugin.Execution execution : plugin.getExecutions()) {
                Element sourcesElement;
                Element configurationElement;
                if (!execution.getGoals().contains(goal) || (configurationElement = execution.getConfigurationElement()) == null || (sourcesElement = configurationElement.getChild("resources")) == null) continue;
                for (Element element : sourcesElement.getChildren()) {
                    Element directory = element.getChild("directory");
                    if (directory == null) continue;
                    folders.add(directory.getTextTrim());
                }
            }
        }
    }

    private void configOutputFolders() {
        String testOutputDirPath;
        String outputDirPath;
        String buildDirPath;
        if (this.myImportingSettings.isUseMavenOutput()) {
            this.myModel.useModuleOutput(this.myMavenProject.getOutputDirectory(), this.myMavenProject.getTestOutputDirectory());
        }
        if (!VfsUtilCore.isEqualOrAncestor((String)(buildDirPath = this.myModel.toPath(this.myMavenProject.getBuildDirectory()).getPath()), (String)(outputDirPath = this.myModel.toPath(this.myMavenProject.getOutputDirectory()).getPath()))) {
            this.myModel.addExcludedFolder(this.myMavenProject.getOutputDirectory());
        }
        if (!VfsUtilCore.isEqualOrAncestor((String)buildDirPath, (String)(testOutputDirPath = this.myModel.toPath(this.myMavenProject.getTestOutputDirectory()).getPath()))) {
            this.myModel.addExcludedFolder(this.myMavenProject.getTestOutputDirectory());
        }
    }

    private void configOutputFolders(boolean test) {
        if (this.myImportingSettings.isUseMavenOutput()) {
            if (test) {
                this.myModel.useModuleOutput("", this.myMavenProject.getTestOutputDirectory());
            } else {
                this.myModel.useModuleOutput(this.myMavenProject.getOutputDirectory(), "");
            }
        }
        String buildDirPath = this.myModel.toPath(this.myMavenProject.getBuildDirectory()).getPath();
        String outputDirPath = this.myModel.toPath(this.myMavenProject.getOutputDirectory()).getPath();
        if (test) {
            String testOutputDirPath = this.myModel.toPath(this.myMavenProject.getTestOutputDirectory()).getPath();
            if (!VfsUtilCore.isEqualOrAncestor((String)buildDirPath, (String)testOutputDirPath)) {
                this.myModel.addExcludedFolder(this.myMavenProject.getTestOutputDirectory());
            }
        } else if (!VfsUtilCore.isEqualOrAncestor((String)buildDirPath, (String)outputDirPath)) {
            this.myModel.addExcludedFolder(this.myMavenProject.getOutputDirectory());
        }
    }

    private void configGeneratedFolders() {
        File[] targetChildren;
        File targetDir = new File(this.myMavenProject.getBuildDirectory());
        String generatedDir = this.myMavenProject.getGeneratedSourcesDirectory(false);
        String generatedDirTest = this.myMavenProject.getGeneratedSourcesDirectory(true);
        this.myModel.unregisterAll(targetDir.getPath(), false, false);
        if (this.myImportingSettings.getGeneratedSourcesFolder() != MavenImportingSettings.GeneratedSourcesFolder.IGNORE) {
            this.myModel.addGeneratedJavaSourceFolder(this.myMavenProject.getAnnotationProcessorDirectory(true), JavaSourceRootType.TEST_SOURCE);
            this.myModel.addGeneratedJavaSourceFolder(this.myMavenProject.getAnnotationProcessorDirectory(false), JavaSourceRootType.SOURCE);
        }
        if ((targetChildren = targetDir.listFiles()) != null) {
            for (File f : targetChildren) {
                if (!f.isDirectory()) continue;
                if (FileUtil.pathsEqual((String)generatedDir, (String)f.getPath())) {
                    this.configGeneratedSourceFolder(f, JavaSourceRootType.SOURCE);
                    continue;
                }
                if (!FileUtil.pathsEqual((String)generatedDirTest, (String)f.getPath())) continue;
                this.configGeneratedSourceFolder(f, JavaSourceRootType.TEST_SOURCE);
            }
        }
    }

    private void configGeneratedFolders(boolean test) {
        File[] targetChildren;
        File targetDir = new File(this.myMavenProject.getBuildDirectory());
        String generatedDir = test ? this.myMavenProject.getGeneratedSourcesDirectory(true) : this.myMavenProject.getGeneratedSourcesDirectory(false);
        this.myModel.unregisterAll(targetDir.getPath(), false, false);
        if (this.myImportingSettings.getGeneratedSourcesFolder() != MavenImportingSettings.GeneratedSourcesFolder.IGNORE) {
            if (test) {
                this.myModel.addGeneratedJavaSourceFolder(this.myMavenProject.getAnnotationProcessorDirectory(true), JavaSourceRootType.TEST_SOURCE);
            } else {
                this.myModel.addGeneratedJavaSourceFolder(this.myMavenProject.getAnnotationProcessorDirectory(false), JavaSourceRootType.SOURCE);
            }
        }
        if ((targetChildren = targetDir.listFiles()) != null) {
            for (File f : targetChildren) {
                if (!f.isDirectory()) continue;
                if (!test && FileUtil.pathsEqual((String)generatedDir, (String)f.getPath())) {
                    this.configGeneratedSourceFolder(f, JavaSourceRootType.SOURCE);
                    continue;
                }
                if (!test || !FileUtil.pathsEqual((String)generatedDir, (String)f.getPath())) continue;
                this.configGeneratedSourceFolder(f, JavaSourceRootType.TEST_SOURCE);
            }
        }
    }

    private void generateNewContentRoots(boolean orphansOnly) {
        TreeMap<String, SourceFolder> sourceFoldersMap = new TreeMap<String, SourceFolder>(FileUtil::comparePaths);
        for (String sourceRootUrl : this.myModel.getSourceRootUrls(true)) {
            String sourceRootPath = FileUtil.toSystemDependentName((String)VfsUtil.urlToPath((String)sourceRootUrl));
            SourceFolder sourceFolder = this.myModel.getSourceFolder(new File(sourceRootPath));
            if (sourceFolder == null) continue;
            sourceFoldersMap.put(sourceRootUrl, sourceFolder);
        }
        ModifiableRootModel rootModel = this.myModel.getRootModel();
        if (orphansOnly) {
            for (ContentEntry contentEntry : rootModel.getContentEntries()) {
                sourceFoldersMap.keySet().removeIf(root -> FileUtil.isAncestor((String)contentEntry.getUrl(), (String)root, (boolean)false));
            }
        } else {
            for (ContentEntry contentEntry : rootModel.getContentEntries()) {
                rootModel.removeContentEntry(contentEntry);
            }
        }
        HashSet<String> topLevelSourceFolderUrls = new HashSet<String>();
        for (String sourceRoot : sourceFoldersMap.keySet()) {
            if (ContainerUtil.exists(topLevelSourceFolderUrls, root -> FileUtil.isAncestor((String)root, (String)sourceRoot, (boolean)false))) continue;
            topLevelSourceFolderUrls.add(sourceRoot);
        }
        MavenFoldersImporter.setContentRootData(topLevelSourceFolderUrls, rootModel, sourceFoldersMap);
    }

    private void generateNewContentRoots(@Nullable Path defaultContentRootPath) {
        TreeMap<String, SourceFolder> sourceFoldersMap = new TreeMap<String, SourceFolder>(FileUtil::comparePaths);
        for (String sourceRootUrl : this.myModel.getSourceRootUrls(true)) {
            String sourceRootPath = FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)sourceRootUrl));
            SourceFolder sourceFolder = this.myModel.getSourceFolder(new File(sourceRootPath));
            if (sourceFolder == null) continue;
            sourceFoldersMap.put(sourceRootUrl, sourceFolder);
        }
        ModifiableRootModel rootModel = this.myModel.getRootModel();
        for (ContentEntry contentEntry : rootModel.getContentEntries()) {
            rootModel.removeContentEntry(contentEntry);
        }
        HashSet<String> topLevelSourceFolderUrls = new HashSet<String>();
        if (defaultContentRootPath != null) {
            String defaultContentRootUrl = MavenUtil.toPath(this.myMavenProject, defaultContentRootPath.toString()).toUrl().getUrl();
            topLevelSourceFolderUrls.add(defaultContentRootUrl);
        }
        for (String sourceRoot : sourceFoldersMap.keySet()) {
            if (ContainerUtil.exists(topLevelSourceFolderUrls, root -> FileUtil.isAncestor((String)root, (String)sourceRoot, (boolean)false))) continue;
            topLevelSourceFolderUrls.add(sourceRoot);
        }
        MavenFoldersImporter.setContentRootData(topLevelSourceFolderUrls, rootModel, sourceFoldersMap);
    }

    private static void setContentRootData(Set<String> topLevelSourceFolderUrls, ModifiableRootModel rootModel, Map<String, SourceFolder> sourceFoldersMap) {
        for (String sourceFolderUrl : topLevelSourceFolderUrls) {
            if (MavenFoldersImporter.isAlreadyContentRoot(sourceFolderUrl, rootModel.getProject())) continue;
            ContentEntry contentEntry = rootModel.addContentEntry(sourceFolderUrl);
            for (Map.Entry<String, SourceFolder> entry : sourceFoldersMap.entrySet()) {
                if (!FileUtil.isAncestor((String)sourceFolderUrl, (String)entry.getKey(), (boolean)false)) continue;
                SourceFolder oldSourceFolder = entry.getValue();
                SourceFolder newSourceFolder = contentEntry.addSourceFolder(oldSourceFolder.getUrl(), oldSourceFolder.getRootType());
                newSourceFolder.setPackagePrefix(oldSourceFolder.getPackagePrefix());
            }
        }
    }

    private static boolean isAlreadyContentRoot(String sourceFolderUrl, Project project2) {
        URL url = VfsUtilCore.convertToURL((String)sourceFolderUrl);
        if (url == null) {
            return false;
        }
        VirtualFile sourceFolder = VfsUtil.findFileByURL((URL)url);
        if (sourceFolder == null) {
            return false;
        }
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project2);
        MavenProject containingProject = mavenProjectsManager.findContainingProject(sourceFolder);
        if (containingProject != null) {
            Module module = mavenProjectsManager.findModule(containingProject);
            if (module == null) {
                return false;
            }
            for (ContentEntry contentEntry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
                if (!contentEntry.getUrl().equals(sourceFolderUrl)) continue;
                return true;
            }
        }
        return false;
    }

    private void configExcludedFolders() {
        File targetDir = new File(this.myMavenProject.getBuildDirectory());
        String generatedDir = this.myMavenProject.getGeneratedSourcesDirectory(false);
        String generatedDirTest = this.myMavenProject.getGeneratedSourcesDirectory(true);
        File[] targetChildren = targetDir.listFiles();
        if (targetChildren != null) {
            for (File f : targetChildren) {
                if (!f.isDirectory() || FileUtil.pathsEqual((String)generatedDir, (String)f.getPath()) || FileUtil.pathsEqual((String)generatedDirTest, (String)f.getPath()) || !this.myImportingSettings.isExcludeTargetFolder() || this.myModel.hasRegisteredSourceSubfolder(f) || this.myModel.isAlreadyExcluded(f)) continue;
                this.myModel.addExcludedFolder(f.getPath());
            }
        }
        NotNullList facetExcludes = new NotNullList();
        for (MavenImporter each : MavenImporter.getSuitableImporters(this.myMavenProject)) {
            each.collectExcludedFolders(this.myMavenProject, (List<String>)facetExcludes);
        }
        for (String eachFolder : facetExcludes) {
            this.myModel.unregisterAll(eachFolder, true, true);
            this.myModel.addExcludedFolder(eachFolder);
        }
        if (this.myImportingSettings.isExcludeTargetFolder()) {
            this.myModel.addExcludedFolder(targetDir.getPath());
        }
    }

    private void configExcludedAggregatorFolders() {
        File targetDir = new File(this.myMavenProject.getBuildDirectory());
        NotNullList facetExcludes = new NotNullList();
        for (MavenImporter each : MavenImporter.getSuitableImporters(this.myMavenProject)) {
            each.collectExcludedFolders(this.myMavenProject, (List<String>)facetExcludes);
        }
        for (String eachFolder : facetExcludes) {
            this.myModel.unregisterAll(eachFolder, true, true);
            this.myModel.addExcludedFolder(eachFolder);
        }
        if (this.myImportingSettings.isExcludeTargetFolder()) {
            this.myModel.addExcludedFolder(targetDir.getPath());
        }
    }

    private void configGeneratedSourceFolder(@NotNull File targetDir, JavaSourceRootType rootType) {
        if (targetDir == null) {
            MavenFoldersImporter.$$$reportNull$$$0(5);
        }
        switch (this.myImportingSettings.getGeneratedSourcesFolder()) {
            case GENERATED_SOURCE_FOLDER: {
                this.myModel.addGeneratedJavaSourceFolder(targetDir.getPath(), rootType);
                break;
            }
            case SUBFOLDER: {
                this.addAllSubDirsAsGeneratedSources(targetDir, rootType);
                break;
            }
            case AUTODETECT: {
                Collection sourceRoots = JavaSourceRootDetectionUtil.suggestRoots((File)targetDir);
                for (JavaModuleSourceRoot root : sourceRoots) {
                    if (FileUtil.filesEqual((File)targetDir, (File)root.getDirectory())) {
                        this.myModel.addGeneratedJavaSourceFolder(targetDir.getPath(), rootType);
                        return;
                    }
                    this.addAsGeneratedSourceFolder(root.getDirectory(), rootType);
                }
                this.addAllSubDirsAsGeneratedSources(targetDir, rootType);
                break;
            }
        }
    }

    private void addAsGeneratedSourceFolder(@NotNull File dir2, JavaSourceRootType rootType) {
        if (dir2 == null) {
            MavenFoldersImporter.$$$reportNull$$$0(6);
        }
        SourceFolder folder = this.myModel.getSourceFolder(dir2);
        if (!this.myModel.hasRegisteredSourceSubfolder(dir2) || folder != null && !MavenFoldersImporter.isGenerated(folder)) {
            this.myModel.addGeneratedJavaSourceFolder(dir2.getPath(), rootType);
        }
    }

    private static boolean isGenerated(@NotNull SourceFolder folder) {
        JavaSourceRootProperties properties;
        if (folder == null) {
            MavenFoldersImporter.$$$reportNull$$$0(7);
        }
        return (properties = (JavaSourceRootProperties)folder.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES)) != null && properties.isForGeneratedSources();
    }

    private void addAllSubDirsAsGeneratedSources(@NotNull File dir2, JavaSourceRootType rootType) {
        if (dir2 == null) {
            MavenFoldersImporter.$$$reportNull$$$0(8);
        }
        for (File f : MavenFoldersImporter.getChildren(dir2)) {
            if (!f.isDirectory()) continue;
            this.addAsGeneratedSourceFolder(f, rootType);
        }
    }

    private static File[] getChildren(File dir2) {
        File[] result = dir2.listFiles();
        return result == null ? ArrayUtilRt.EMPTY_FILE_ARRAY : result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/importing/MavenFoldersImporter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/importing/MavenFoldersImporter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPathMap";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "configGeneratedSourceFolder";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAsGeneratedSourceFolder";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isGenerated";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addAllSubDirsAsGeneratedSources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

