/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.codeInsight.ExternalAnnotationsArtifactsResolver;
import com.intellij.codeInsight.externalAnnotation.location.AnnotationsLocation;
import com.intellij.codeInsight.externalAnnotation.location.AnnotationsLocationSearcher;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.tasks.TasksBundle;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/idea/maven/importing/ExternalAnnotationsImporter;", "Lorg/jetbrains/idea/maven/importing/MavenImporter;", "()V", "myProcessedLibraries", "Ljava/util/HashSet;", "Lorg/jetbrains/idea/maven/model/MavenArtifact;", "Lkotlin/collections/HashSet;", "postProcess", "", "module", "Lcom/intellij/openapi/module/Module;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "changes", "Lorg/jetbrains/idea/maven/project/MavenProjectChanges;", "modifiableModelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "processChangedModulesOnly", "", "shouldImportExternalAnnotations", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.maven"})
public final class ExternalAnnotationsImporter
extends MavenImporter {
    private final HashSet<MavenArtifact> myProcessedLibraries = new HashSet();
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    public boolean processChangedModulesOnly() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void postProcess(@NotNull Module module, @NotNull MavenProject mavenProject2, @NotNull MavenProjectChanges changes, @NotNull IdeModifiableModelsProvider modifiableModelsProvider) {
        void count;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)mavenProject2, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)modifiableModelsProvider, (String)"modifiableModelsProvider");
        ExtensionPointName extensionPointName = ExternalAnnotationsArtifactsResolver.EP_NAME;
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"ExternalAnnotationsArtifactsResolver.EP_NAME");
        List list = extensionPointName.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ExternalAnnotationsArtif\u2026ver.EP_NAME.extensionList");
        List resolvers = list;
        if (resolvers.isEmpty()) {
            return;
        }
        Project project2 = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        Project project3 = project2;
        Map librariesMap = new LinkedHashMap();
        if (!this.shouldImportExternalAnnotations(project3)) {
            return;
        }
        List<MavenArtifact> list2 = mavenProject2.getDependencies();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"mavenProject.dependencies");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MavenArtifact it = (MavenArtifact)element$iv;
            boolean bl = false;
            MavenArtifact mavenArtifact = it;
            Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact, (String)"it");
            Library library = modifiableModelsProvider.getLibraryByName(mavenArtifact.getLibraryName());
            if (library == null) continue;
            librariesMap.put(it, library);
        }
        Map $this$filterKeys$iv = librariesMap;
        boolean $i$f$filterKeys232 = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterKeys$iv.entrySet()) {
            MavenArtifact it = (MavenArtifact)entry.getKey();
            boolean bl = false;
            if (!this.myProcessedLibraries.add(it)) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        Map toProcess = result$iv;
        if (toProcess.isEmpty()) {
            return;
        }
        int totalSize = toProcess.size();
        Ref.IntRef $i$f$filterKeys232 = new Ref.IntRef();
        $i$f$filterKeys232.element = 0;
        Set locationsToSkip = new LinkedHashSet();
        String string = TasksBundle.message("maven.tasks.external.annotations.resolving.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TasksBundle.message(\"mav\u2026tations.resolving.title\")");
        String title$iv = string;
        boolean bl = true;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project3, title$iv, bl, project3, title$iv, bl, toProcess, project3, locationsToSkip, resolvers, (Ref.IntRef)count, totalSize){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;
            final /* synthetic */ boolean $cancellable;
            final /* synthetic */ Map $toProcess$inlined;
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ Set $locationsToSkip$inlined;
            final /* synthetic */ List $resolvers$inlined;
            final /* synthetic */ Ref.IntRef $count$inlined;
            final /* synthetic */ int $totalSize$inlined;
            {
                this.$project = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                this.$cancellable = $captured_local_variable$3;
                this.$toProcess$inlined = map2;
                this.$project$inlined = project2;
                this.$locationsToSkip$inlined = set;
                this.$resolvers$inlined = list;
                this.$count$inlined = intRef;
                this.$totalSize$inlined = n;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProgressIndicator indicator2 = indicator;
                boolean bl = false;
                indicator2.setIndeterminate(false);
                Map $this$forEach$iv = this.$toProcess$inlined;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    void mavenArtifact;
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> $dstr$mavenArtifact$library = element$iv = iterator.next();
                    boolean bl2 = false;
                    Map.Entry<K, V> entry = $dstr$mavenArtifact$library;
                    MavenArtifact mavenArtifact2 = (MavenArtifact)entry.getKey();
                    entry = $dstr$mavenArtifact$library;
                    Library library = (Library)entry.getValue();
                    if (indicator2.isCanceled()) continue;
                    indicator2.setText(TasksBundle.message("maven.tasks.external.annotations.looking.for", mavenArtifact.getLibraryName()));
                    Collection locations = AnnotationsLocationSearcher.Companion.findAnnotationsLocation(this.$project$inlined, library, mavenArtifact.getArtifactId(), mavenArtifact.getGroupId(), mavenArtifact.getVersion());
                    Iterable $this$forEach$iv2 = locations;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        void $this$fold$iv;
                        AnnotationsLocation location = (AnnotationsLocation)element$iv2;
                        boolean bl3 = false;
                        if (this.$locationsToSkip$inlined.contains(location)) continue;
                        Iterable iterable = this.$resolvers$inlined;
                        boolean initial$iv = false;
                        boolean $i$f$fold = false;
                        boolean accumulator$iv = initial$iv;
                        for (T element$iv3 : $this$fold$iv) {
                            void res;
                            ExternalAnnotationsArtifactsResolver externalAnnotationsArtifactsResolver = (ExternalAnnotationsArtifactsResolver)element$iv3;
                            boolean acc = accumulator$iv;
                            boolean bl4 = false;
                            accumulator$iv = acc || res.resolve(this.$project$inlined, library, location);
                        }
                        if (accumulator$iv) continue;
                        this.$locationsToSkip$inlined.add(location);
                    }
                    Ref.IntRef intRef = this.$count$inlined;
                    ++intRef.element;
                    indicator2.setFraction((double)intRef.element / (double)this.$totalSize$inlined);
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldImportExternalAnnotations(Project project2) {
        MavenProjectsManager mavenProjectsManager;
        MavenProjectsManager $this$run = mavenProjectsManager = MavenProjectsManager.getInstance(project2);
        boolean bl = false;
        MavenImportingSettings mavenImportingSettings = $this$run.getImportingSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenImportingSettings, (String)"importingSettings");
        if (!mavenImportingSettings.isDownloadAnnotationsAutomatically()) return false;
        MavenGeneralSettings mavenGeneralSettings = $this$run.getGeneralSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenGeneralSettings, (String)"generalSettings");
        if (mavenGeneralSettings.isWorkOffline()) return false;
        return true;
    }

    public ExternalAnnotationsImporter() {
        super("org.apache.maven.plugins", "maven-compiler-plugin");
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(ExternalAnnotationsImporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Exter\u2026ionsImporter::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/maven/importing/ExternalAnnotationsImporter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.maven"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

