/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes;

import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.build.issue.quickfix.OpenFileQuickFix;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/MavenJvmConfigOpenQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "jvmConfig", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "id", "", "getId", "()Ljava/lang/String;", "getJvmConfig", "()Lcom/intellij/openapi/vfs/VirtualFile;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.maven"})
public final class MavenJvmConfigOpenQuickFix
implements BuildIssueQuickFix {
    @NotNull
    private final String id;
    @NotNull
    private final VirtualFile jvmConfig;

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project2, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Path path = this.jvmConfig.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"jvmConfig.toNioPath()");
        OpenFileQuickFix.Companion.showFile(project2, path, null);
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.completedFuture<Any>(null)");
        return completableFuture;
    }

    @NotNull
    public final VirtualFile getJvmConfig() {
        return this.jvmConfig;
    }

    public MavenJvmConfigOpenQuickFix(@NotNull VirtualFile jvmConfig) {
        Intrinsics.checkNotNullParameter((Object)jvmConfig, (String)"jvmConfig");
        this.jvmConfig = jvmConfig;
        this.id = "open_maven_jvm_config_quick_fix_" + this.jvmConfig;
    }
}

