/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.i18n.I18nInspection;
import com.intellij.codeInspection.i18n.I18nizeConcatenationQuickFix;
import com.intellij.codeInspection.i18n.I18nizeQuickFix;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.codeInspection.i18n.NlsInfo;
import com.intellij.codeInspection.i18n.batch.I18nizeMultipleStringsDialog;
import com.intellij.codeInspection.i18n.batch.I18nizedPropertyData;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.ResourceBundleManager;
import com.intellij.lang.properties.references.I18nizeQuickFixDialog;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PartiallyKnownString;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.expressions.UInjectionHost;
import org.jetbrains.uast.expressions.UStringConcatenationsFacade;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.generate.UastElementFactory;

public class I18nizeBatchQuickFix
extends I18nizeQuickFix
implements BatchQuickFix {
    private static final Logger LOG = Logger.getInstance(I18nizeBatchQuickFix.class);

    public void applyFix(@NotNull Project project, CommonProblemDescriptor @NotNull [] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
        if (project == null) {
            I18nizeBatchQuickFix.$$$reportNull$$$0(0);
        }
        if (psiElementsToIgnore == null) {
            I18nizeBatchQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptors == null) {
            I18nizeBatchQuickFix.$$$reportNull$$$0(2);
        }
        LinkedHashMap keyValuePairs = new LinkedHashMap();
        LinkedHashSet contextFiles = new LinkedHashSet();
        ReadAction.nonBlocking(() -> {
            I18nizeBatchQuickFix.fillI18nizedPropertyDataMap(project, descriptors, contextFiles, keyValuePairs);
            if (keyValuePairs.isEmpty()) {
                return null;
            }
            return I18nizeMultipleStringsDialog.getResourceBundleManager(project, contextFiles);
        }).finishOnUiThread(ModalityState.NON_MODAL, bundleManager -> {
            if (keyValuePairs.isEmpty()) {
                return;
            }
            this.showI18nizeMultipleStringsDialog(project, keyValuePairs, contextFiles, (ResourceBundleManager)bundleManager);
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private static void fillI18nizedPropertyDataMap(@NotNull Project project, CommonProblemDescriptor @NotNull [] descriptors, @NotNull Set<PsiFile> contextFiles, @NotNull Map<String, I18nizedPropertyData<HardcodedStringContextData>> keyValuePairs) {
        if (project == null) {
            I18nizeBatchQuickFix.$$$reportNull$$$0(3);
        }
        if (contextFiles == null) {
            I18nizeBatchQuickFix.$$$reportNull$$$0(4);
        }
        if (keyValuePairs == null) {
            I18nizeBatchQuickFix.$$$reportNull$$$0(5);
        }
        if (descriptors == null) {
            I18nizeBatchQuickFix.$$$reportNull$$$0(6);
        }
        HashSet<PsiElement> distinct = new HashSet<PsiElement>();
        UniqueNameGenerator uniqueNameGenerator = new UniqueNameGenerator();
        for (CommonProblemDescriptor descriptor : descriptors) {
            String key;
            PsiElement psiElement = ((ProblemDescriptor)descriptor).getPsiElement();
            UPolyadicExpression polyadicExpression = I18nizeConcatenationQuickFix.getEnclosingLiteralConcatenation(psiElement);
            UStringConcatenationsFacade concatenation = UStringConcatenationsFacade.createFromTopConcatenation((UExpression)(polyadicExpression != null ? polyadicExpression : (UExpression)UastContextKt.toUElement((PsiElement)psiElement, UInjectionHost.class)));
            if (concatenation == null) continue;
            PartiallyKnownString pks = concatenation.asPartiallyKnownString();
            if (pks.getSegments().size() == 1) {
                String value = pks.getValueIfKnown();
                if (!distinct.add(psiElement) || value == null) continue;
                I18nizedPropertyData<HardcodedStringContextData> data = keyValuePairs.get(value);
                if (data != null) {
                    data.getContextData().getPsiElements().add(psiElement);
                    data.getContextData().getExpressions().add(concatenation.getRootUExpression());
                } else {
                    key = (String)ObjectUtils.notNull((Object)I18nizeBatchQuickFix.suggestKeyByPlace(value, concatenation.getRootUExpression()), (Object)I18nizeQuickFixDialog.suggestUniquePropertyKey((String)value, null, null));
                    ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
                    elements.add(psiElement);
                    ArrayList<UExpression> uExpressions = new ArrayList<UExpression>();
                    uExpressions.add(concatenation.getRootUExpression());
                    HardcodedStringContextData contextData = new HardcodedStringContextData(uExpressions, elements, Collections.emptyList());
                    keyValuePairs.put(value, new I18nizedPropertyData<HardcodedStringContextData>(uniqueNameGenerator.generateUniqueName(key), value, contextData));
                }
                ContainerUtil.addIfNotNull(contextFiles, (Object)psiElement.getContainingFile());
                continue;
            }
            if (!distinct.add(concatenation.getRootUExpression().getSourcePsi())) continue;
            ArrayList<UExpression> args = new ArrayList<UExpression>();
            String value = JavaI18nUtil.buildUnescapedFormatString(concatenation, args, project);
            key = (String)ObjectUtils.notNull((Object)I18nizeBatchQuickFix.suggestKeyByPlace(value, concatenation.getRootUExpression()), (Object)I18nizeQuickFixDialog.suggestUniquePropertyKey((String)value, null, null));
            HardcodedStringContextData contextData = new HardcodedStringContextData(Collections.singletonList(concatenation.getRootUExpression()), Collections.singletonList(concatenation.getRootUExpression().getSourcePsi()), args);
            keyValuePairs.put(value + concatenation.hashCode(), new I18nizedPropertyData<HardcodedStringContextData>(uniqueNameGenerator.generateUniqueName(key), value, contextData));
            ContainerUtil.addIfNotNull(contextFiles, (Object)psiElement.getContainingFile());
        }
    }

    private void showI18nizeMultipleStringsDialog(@NotNull Project project, @NotNull Map<String, I18nizedPropertyData<HardcodedStringContextData>> keyValuePairs, @NotNull Set<PsiFile> contextFiles, @Nullable ResourceBundleManager bundleManager) {
        ArrayList replacements;
        I18nizeMultipleStringsDialog<HardcodedStringContextData> dialog;
        if (project == null) {
            I18nizeBatchQuickFix.$$$reportNull$$$0(7);
        }
        if (keyValuePairs == null) {
            I18nizeBatchQuickFix.$$$reportNull$$$0(8);
        }
        if (contextFiles == null) {
            I18nizeBatchQuickFix.$$$reportNull$$$0(9);
        }
        if ((dialog = new I18nizeMultipleStringsDialog<HardcodedStringContextData>(project, replacements = new ArrayList(keyValuePairs.values()), contextFiles, bundleManager, data -> {
            List<PsiElement> elements = data.getPsiElements();
            return ContainerUtil.map(elements, element -> new UsageInfo(element.getParent()));
        }, null, true)).showAndGet()) {
            PropertiesFile propertiesFile = dialog.getPropertiesFile();
            HashSet<PsiFile> files = new HashSet<PsiFile>();
            for (I18nizedPropertyData pair : replacements) {
                for (PsiElement element : ((HardcodedStringContextData)pair.getContextData()).getPsiElements()) {
                    ContainerUtil.addIfNotNull(files, (Object)element.getContainingFile());
                }
            }
            if (files.isEmpty()) {
                return;
            }
            files.add(propertiesFile.getContainingFile());
            WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getFamilyName(), null, () -> {
                for (I18nizedPropertyData data : replacements) {
                    JavaI18nUtil.DEFAULT_PROPERTY_CREATION_HANDLER.createProperty(project, Collections.singletonList(propertiesFile), data.getKey(), data.getValue(), new UExpression[0]);
                    List<UExpression> uExpressions = ((HardcodedStringContextData)data.getContextData()).getExpressions();
                    List<PsiElement> psiElements = ((HardcodedStringContextData)data.getContextData()).getPsiElements();
                    for (int i = 0; i < psiElements.size(); ++i) {
                        PsiExpression expression;
                        Language language;
                        UExpression uExpression;
                        PsiElement psiElement;
                        block10: {
                            psiElement = psiElements.get(i);
                            uExpression = uExpressions.get(i);
                            language = psiElement.getLanguage();
                            String i18NText = dialog.getI18NText(data.getKey(), data.getValue(), JavaI18nUtil.composeParametersText(((HardcodedStringContextData)data.getContextData()).getArgs()));
                            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
                            try {
                                expression = elementFactory.createExpressionFromText(i18NText, psiElement);
                                if (language == JavaLanguage.INSTANCE) {
                                    JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(psiElement.replace((PsiElement)expression));
                                }
                                break block10;
                            }
                            catch (IncorrectOperationException e) {
                                LOG.debug((Throwable)e);
                                try {
                                    expression = elementFactory.createExpressionFromText(dialog.getI18NText(data.getKey(), data.getValue(), ""), psiElement);
                                }
                                catch (IncorrectOperationException exception) {}
                            }
                            continue;
                        }
                        @Nullable Couple<String> callDescriptor = I18nizeBatchQuickFix.getCallDescriptor(expression);
                        if (callDescriptor == null) {
                            LOG.debug("Templates are not supported for " + language.getDisplayName());
                            continue;
                        }
                        UastCodeGenerationPlugin generationPlugin = UastCodeGenerationPlugin.byLanguage((Language)language);
                        if (generationPlugin == null) {
                            LOG.debug("No UAST generation plugin exist for " + language.getDisplayName());
                            continue;
                        }
                        UastElementFactory pluginElementFactory = generationPlugin.getElementFactory(project);
                        ArrayList<Object> arguments = new ArrayList<Object>();
                        arguments.add(pluginElementFactory.createStringLiteralExpression(data.getKey(), psiElement));
                        arguments.addAll(((HardcodedStringContextData)data.getContextData()).getArgs());
                        UQualifiedReferenceExpression receiver = callDescriptor.first != null ? pluginElementFactory.createQualifiedReference((String)callDescriptor.first, uExpression.getSourcePsi()) : null;
                        UCallExpression callExpression = pluginElementFactory.createCallExpression((UExpression)receiver, (String)callDescriptor.second, arguments, null, UastCallKind.METHOD_CALL, psiElement);
                        if (callExpression != null) {
                            generationPlugin.replace((UElement)uExpression, (UElement)callExpression, UCallExpression.class);
                            continue;
                        }
                        LOG.debug("Null generated UAST call expression");
                    }
                }
            }, (PsiFile[])files.toArray(PsiFile.EMPTY_ARRAY));
        }
    }

    @Nullable
    private static Couple<String> getCallDescriptor(PsiExpression expression) {
        if (expression instanceof PsiMethodCallExpression) {
            PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)expression).getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            String qualifiedName = qualifierExpression != null ? qualifierExpression.getText() : null;
            String methodName = methodExpression.getReferenceName();
            if (methodName == null) {
                return null;
            }
            PsiExpression[] expressions = ((PsiMethodCallExpression)expression).getArgumentList().getExpressions();
            if (expressions.length == 0) {
                return null;
            }
            if (!(expressions[0] instanceof PsiLiteralExpression)) {
                return null;
            }
            return Couple.of((Object)qualifiedName, (Object)methodName);
        }
        return null;
    }

    @Nullable
    private static String suggestKeyByPlace(String value, @NotNull UExpression expression) {
        List<UExpression> usages;
        if (expression == null) {
            I18nizeBatchQuickFix.$$$reportNull$$$0(10);
        }
        if ((usages = I18nInspection.findIndirectUsages(expression, true)).isEmpty()) {
            usages = Collections.singletonList(expression);
        }
        for (UExpression usage : usages) {
            NlsInfo nlsInfo = NlsInfo.forExpression(usage);
            if (!(nlsInfo instanceof NlsInfo.Localized)) continue;
            return I18nizeQuickFix.getSuggestedName(value, (NlsInfo.Localized)nlsInfo);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementsToIgnore";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFiles";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValuePairs";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/i18n/I18nizeBatchQuickFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFix";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "fillI18nizedPropertyDataMap";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "showI18nizeMultipleStringsDialog";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "suggestKeyByPlace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class HardcodedStringContextData {
        private final List<UExpression> myExpressions;
        private final List<PsiElement> myPsiElements;
        private final List<UExpression> myArgs;

        private HardcodedStringContextData(@NotNull List<UExpression> expressions, @NotNull List<PsiElement> psiElements, @NotNull List<UExpression> args) {
            if (expressions == null) {
                HardcodedStringContextData.$$$reportNull$$$0(0);
            }
            if (psiElements == null) {
                HardcodedStringContextData.$$$reportNull$$$0(1);
            }
            if (args == null) {
                HardcodedStringContextData.$$$reportNull$$$0(2);
            }
            this.myExpressions = expressions;
            this.myPsiElements = psiElements;
            this.myArgs = args;
        }

        private List<UExpression> getExpressions() {
            return this.myExpressions;
        }

        private List<PsiElement> getPsiElements() {
            return this.myPsiElements;
        }

        private List<UExpression> getArgs() {
            return this.myArgs;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expressions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "psiElements";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "args";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/i18n/I18nizeBatchQuickFix$HardcodedStringContextData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

