/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger;

import com.intellij.diagnostic.logging.AdditionalTabComponent;
import com.intellij.diagnostic.logging.LogConsoleManagerBase;
import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.AdditionalTabComponentManager;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.RunTab;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SystemProperties;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.net.NetUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.UUID;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.impl.XsltChecker;
import org.intellij.lang.xpath.xslt.run.XsltRunConfiguration;
import org.intellij.lang.xpath.xslt.run.XsltRunnerExtension;
import org.intellij.plugins.xsltDebugger.DebugProcessListener;
import org.intellij.plugins.xsltDebugger.XsltDebuggerBundle;
import org.intellij.plugins.xsltDebugger.XsltDebuggerRunner;
import org.intellij.plugins.xsltDebugger.ui.OutputTabComponent;
import org.intellij.plugins.xsltDebugger.ui.StructureTabComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XsltDebuggerExtension
extends XsltRunnerExtension {
    private static final Logger LOG = Logger.getInstance((String)XsltDebuggerExtension.class.getName());
    public static final Key<XsltChecker.LanguageLevel> VERSION = Key.create((String)"VERSION");
    private static final Key<Integer> PORT = Key.create((String)"PORT");
    private static final Key<Manifest> MANIFEST = Key.create((String)"MANIFEST");
    private static final Key<String> ACCESS_TOKEN = Key.create((String)"access token");
    @NonNls
    private static final String SAXON_6_JAR = "saxon.jar";
    @NonNls
    private static final String SAXON_9_JAR = "saxon9he.jar";

    protected boolean supports(XsltRunConfiguration config, boolean debugger) {
        return (debugger || XsltDebuggerRunner.ACTIVE.get() == Boolean.TRUE) && config.getOutputType() == XsltRunConfiguration.OutputType.CONSOLE;
    }

    public ProcessListener createProcessListener(Project project, UserDataHolder extensionData) {
        Integer port = (Integer)extensionData.getUserData(PORT);
        assert (port != null);
        return new DebugProcessListener(project, port, (String)extensionData.getUserData(ACCESS_TOKEN));
    }

    public boolean createTabs(Project project, AdditionalTabComponentManager manager, @NotNull AdditionalTabComponent outputConsole, ProcessHandler process) {
        if (outputConsole == null) {
            XsltDebuggerExtension.$$$reportNull$$$0(0);
        }
        if (manager instanceof RunTab) {
            LogConsoleManagerBase runTab = ((RunTab)manager).getLogConsoleManager();
            runTab.addAdditionalTabComponent((AdditionalTabComponent)new OutputTabComponent(outputConsole), "XSLT-Output", AllIcons.Debugger.Console);
            runTab.addAdditionalTabComponent((AdditionalTabComponent)StructureTabComponent.create(process, (Disposable)outputConsole), "XSLT-Structure", PlatformIcons.FLATTEN_PACKAGES_ICON);
        } else {
            manager.addAdditionalTabComponent((AdditionalTabComponent)new OutputTabComponent(outputConsole), "XSLT-Output");
            manager.addAdditionalTabComponent((AdditionalTabComponent)StructureTabComponent.create(process, (Disposable)outputConsole), "XSLT-Structure");
        }
        return true;
    }

    public void patchParameters(SimpleJavaParameters parameters, XsltRunConfiguration configuration, UserDataHolder extensionData) throws CantRunException {
        Sdk jdk = configuration.getEffectiveJDK();
        assert (jdk != null);
        JavaVersion version = JavaVersion.tryParse((String)jdk.getVersionString());
        if (version == null || version.feature < 5) {
            throw new CantRunException(XsltDebuggerBundle.message("dialog.message.xslt.debugger.requires.java.to.run", new Object[0]));
        }
        if (configuration.getOutputType() != XsltRunConfiguration.OutputType.CONSOLE) {
            throw new CantRunException(XsltDebuggerBundle.message("dialog.message.xslt.debugger.requires.output.type.console", new Object[0]));
        }
        try {
            int port = NetUtils.findAvailableSocketPort();
            parameters.getVMParametersList().defineProperty("xslt.debugger.port", String.valueOf(port));
            extensionData.putUserData(PORT, (Object)port);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            throw new CantRunException(XsltDebuggerBundle.message("dialog.message.unable.to.find.free.network.port", new Object[0]));
        }
        String token = UUID.randomUUID().toString();
        parameters.getVMParametersList().defineProperty("xslt.debugger.token", token);
        extensionData.putUserData(ACCESS_TOKEN, (Object)token);
        Path xsltDebuggerClassesRoot = Paths.get(PathUtil.getJarPathForClass(((Object)((Object)this)).getClass()), new String[0]);
        if (!Files.isDirectory(xsltDebuggerClassesRoot, new LinkOption[0])) {
            Path libDirectory = xsltDebuggerClassesRoot.getParent();
            XsltDebuggerExtension.addPathToClasspath(parameters, libDirectory.resolve("xslt-debugger-rt.jar"));
            XsltDebuggerExtension.addPathToClasspath(parameters, libDirectory.resolve("rmi-stubs.jar"));
            XsltDebuggerExtension.addPathToClasspath(parameters, libDirectory.resolve("rt/xslt-debugger-impl-rt.jar"));
        } else {
            Path outProductionDir = xsltDebuggerClassesRoot.getParent();
            XsltDebuggerExtension.addPathToClasspath(parameters, outProductionDir.resolve("intellij.xslt.debugger.rt"));
            XsltDebuggerExtension.addPathToClasspath(parameters, outProductionDir.resolve("intellij.xslt.debugger.impl.rt"));
            XsltDebuggerExtension.addPathToClasspath(parameters, XsltDebuggerExtension.getPluginEngineDirInSources().resolve("lib/rmi-stubs.jar"));
        }
        String type = parameters.getVMParametersList().getPropertyValue("xslt.transformer.type");
        if ("saxon".equalsIgnoreCase(type)) {
            XsltDebuggerExtension.addPathToClasspath(parameters, XsltDebuggerExtension.findSaxonJar(xsltDebuggerClassesRoot, SAXON_6_JAR));
        } else if ("saxon9".equalsIgnoreCase(type)) {
            XsltDebuggerExtension.addPathToClasspath(parameters, XsltDebuggerExtension.findSaxonJar(xsltDebuggerClassesRoot, SAXON_9_JAR));
        } else if ("xalan".equalsIgnoreCase(type)) {
            Boolean xalanPresent = XsltDebuggerExtension.isValidXalanPresent(parameters);
            if (xalanPresent == null) {
                XsltDebuggerExtension.addXalan(parameters, xsltDebuggerClassesRoot);
            } else if (!xalanPresent.booleanValue()) {
                throw new CantRunException(XsltDebuggerBundle.message("dialog.message.unsupported.xalan.version.present.in.classpath", new Object[0]));
            }
        } else {
            if (type != null) {
                throw new CantRunException(XsltDebuggerBundle.message("dialog.message.unsupported.transformer.type", type));
            }
            if (StringUtil.toLowerCase((String)parameters.getClassPath().getPathsString()).contains("xalan") && XsltDebuggerExtension.isValidXalanPresent(parameters) == Boolean.TRUE) {
                parameters.getVMParametersList().defineProperty("xslt.transformer.type", "xalan");
            }
        }
        VirtualFile xsltFile = configuration.findXsltFile();
        PsiManager psiManager = PsiManager.getInstance((Project)configuration.getProject());
        XsltChecker.LanguageLevel level = xsltFile != null ? XsltSupport.getXsltLanguageLevel((PsiFile)psiManager.findFile(xsltFile)) : XsltChecker.LanguageLevel.V1;
        extensionData.putUserData(VERSION, (Object)level);
        if (!parameters.getVMParametersList().hasProperty("xslt.transformer.type")) {
            if (level == XsltChecker.LanguageLevel.V2) {
                parameters.getVMParametersList().defineProperty("xslt.transformer.type", "saxon9");
                XsltDebuggerExtension.addPathToClasspath(parameters, XsltDebuggerExtension.findSaxonJar(xsltDebuggerClassesRoot, SAXON_9_JAR));
            } else {
                parameters.getVMParametersList().defineProperty("xslt.transformer.type", "saxon");
                XsltDebuggerExtension.addPathToClasspath(parameters, XsltDebuggerExtension.findSaxonJar(xsltDebuggerClassesRoot, SAXON_6_JAR));
            }
        }
        parameters.getVMParametersList().defineProperty("xslt.main", "org.intellij.plugins.xsltDebugger.rt.XSLTDebuggerMain");
    }

    private static void addPathToClasspath(SimpleJavaParameters parameters, Path path) {
        Path absolutePath = path.toAbsolutePath();
        assert (Files.exists(absolutePath, new LinkOption[0])) : absolutePath.toString();
        parameters.getClassPath().addTail(absolutePath.toString());
    }

    @Nullable
    private static Boolean isValidXalanPresent(SimpleJavaParameters parameters) {
        List files = parameters.getClassPath().getVirtualFiles();
        for (VirtualFile file : files) {
            block10: {
                VirtualFile manifestFile;
                if (!file.getName().matches(".*xalan.*\\.jar")) continue;
                VirtualFile root = JarFileSystem.getInstance().getJarRootForLocalFile(file);
                VirtualFile virtualFile = manifestFile = root != null ? root.findFileByRelativePath("META-INF/MANIFEST.MF") : null;
                if (manifestFile != null) {
                    try {
                        Attributes attributes;
                        Manifest manifest = (Manifest)manifestFile.getUserData(MANIFEST);
                        if (manifest == null) {
                            manifest = new Manifest(manifestFile.getInputStream());
                            manifestFile.putUserData(MANIFEST, (Object)manifest);
                        }
                        if ((attributes = manifest.getAttributes("org/apache/xalan/")) == null) {
                            attributes = manifest.getAttributes("org/apache/xalan");
                        }
                        if (attributes == null) {
                            LOG.info("No manifest attributes for 'org/apache/xalan/' in " + manifestFile.getPresentableUrl());
                            continue;
                        }
                        String version = attributes.getValue("Implementation-Version");
                        if (version != null) {
                            String[] parts = version.split("\\.");
                            if (parts.length >= 2 && Integer.parseInt(parts[0]) >= 2 && Integer.parseInt(parts[1]) >= 6) {
                                return true;
                            }
                            LOG.info("Unsupported Xalan version: " + version);
                            break block10;
                        }
                        LOG.info("No Xalan version information in " + file.getPath());
                    }
                    catch (IOException e) {
                        LOG.warn("Unable to read manifest from " + file.getName(), (Throwable)e);
                    }
                } else {
                    LOG.info("No manifest file in " + file.getPath());
                }
            }
            return false;
        }
        return null;
    }

    private static void addXalan(SimpleJavaParameters parameters, Path xsltDebuggerClassesRoot) {
        if (!Files.isDirectory(xsltDebuggerClassesRoot, new LinkOption[0])) {
            Path rtDir = xsltDebuggerClassesRoot.getParent().resolve("rt");
            XsltDebuggerExtension.addPathToClasspath(parameters, rtDir.resolve("xalan-2.7.2.jar"));
            XsltDebuggerExtension.addPathToClasspath(parameters, rtDir.resolve("serializer-2.7.2.jar"));
        } else {
            Path xalanInM2 = Paths.get(SystemProperties.getUserHome(), ".m2", "repository", "xalan");
            XsltDebuggerExtension.addPathToClasspath(parameters, xalanInM2.resolve("xalan/2.7.2/xalan-2.7.2.jar"));
            XsltDebuggerExtension.addPathToClasspath(parameters, xalanInM2.resolve("serializer/2.7.2/serializer-2.7.2.jar"));
        }
    }

    private static Path findSaxonJar(Path xsltDebuggerClassesRoot, String jarFile) {
        Path transformerFile = xsltDebuggerClassesRoot.getParent().resolve("rt").resolve(jarFile);
        if (!Files.exists(transformerFile, new LinkOption[0])) {
            Path libDir = XsltDebuggerExtension.getPluginEngineDirInSources().resolve("impl/lib");
            transformerFile = libDir.resolve(jarFile);
            assert (Files.exists(transformerFile, new LinkOption[0])) : transformerFile.toAbsolutePath().toString();
        }
        return transformerFile;
    }

    @NotNull
    private static Path getPluginEngineDirInSources() {
        Path path = PluginPathManager.getPluginHome((String)"xslt-debugger").toPath().resolve("engine");
        assert (Files.isDirectory(path, new LinkOption[0])) : path.toString();
        Path path2 = path;
        if (path2 == null) {
            XsltDebuggerExtension.$$$reportNull$$$0(1);
        }
        return path2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputConsole";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/xsltDebugger/XsltDebuggerExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/xsltDebugger/XsltDebuggerExtension";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginEngineDirInSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTabs";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

