/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.intellij.codeWithMe.ClientId;
import com.intellij.indexing.shared.download.SharedIndexAuthHolder;
import com.intellij.indexing.shared.download.SharedIndexDownloadLoggerKt;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.indexing.shared.download.SharedIndexLookupResult;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.platform.impl.SharedIndexesFusCollector;
import com.intellij.indexing.shared.util.DownloadUtilKt;
import com.intellij.indexing.shared.util.zipFs.UncompressedZipFileSystem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.indexing.diagnostic.SharedIndexDiagnostic;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.progress.SubTaskProgressIndicator;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a$\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"toSpeedKBytesPerSecond", "", "size", "durationNano", "tryExtractMetadata", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata;", "targetFile", "Ljava/nio/file/Path;", "downloadChunk", "", "Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.indexing.shared"})
public final class SharedIndexLookupResultKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean downloadChunk(@NotNull SharedIndexLookupResult $this$downloadChunk, @NotNull Path targetFile, @Nullable Project project, @NotNull ProgressIndicator indicator) {
        boolean result2;
        SharedIndexMetadata metadata;
        Object downloadResult;
        Object $this$runCatching;
        Intrinsics.checkNotNullParameter((Object)$this$downloadChunk, (String)"$this$downloadChunk");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        String string = SharedIndexesBundle.message("downloading.shared.indexes", $this$downloadChunk.getRequest().getPresentableChunkName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SharedIndexesBundle.mess\u2026est.presentableChunkName)");
        String message = string;
        if (indicator instanceof SubTaskProgressIndicator) {
            ((SubTaskProgressIndicator)indicator).setText(message);
        } else {
            indicator.setText(message);
            indicator.setText2((String)null);
        }
        SharedIndexesFusCollector.INSTANCE.reportIndexDownloadStarted(project, $this$downloadChunk.getRequest().getKind(), $this$downloadChunk.getChunkUniqueId());
        boolean $i$f$service = false;
        Class<SharedIndexAuthHolder> serviceClass$iv = SharedIndexAuthHolder.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        Map<String, String> headers = ((SharedIndexAuthHolder)object).resolveHeaders($this$downloadChunk.getUrl(), $this$downloadChunk.getRequest(), indicator);
        AtomicLong downloadTime = new AtomicLong(System.nanoTime());
        Object object2 = $this$downloadChunk;
        try {
            Long request$iv;
            $this$runCatching = object2;
            boolean bl = false;
            try {
                Long l;
                block29: {
                    SharedIndexLookupRequest sharedIndexLookupRequest = ((SharedIndexLookupResult)$this$runCatching).getRequest();
                    String url$iv = ((SharedIndexLookupResult)$this$runCatching).getUrl();
                    boolean $i$f$handleHttpDownloadExceptions = false;
                    try {
                        boolean bl2 = false;
                        l = DownloadUtilKt.downloadUrlWithValidation(((SharedIndexLookupResult)$this$runCatching).getUrl(), targetFile, ((SharedIndexLookupResult)$this$runCatching).getSize(), ((SharedIndexLookupResult)$this$runCatching).getSha256(), headers, ((SharedIndexLookupResult)$this$runCatching).getCompression(), indicator);
                        break block29;
                    }
                    catch (ConnectException e$iv) {
                        SharedIndexDownloadLoggerKt.getDownloadLogger().debug("Cannot connect to the host for " + url$iv + " for " + request$iv + ". " + e$iv.getMessage(), (Throwable)e$iv);
                    }
                    catch (UnknownHostException e$iv) {
                        SharedIndexDownloadLoggerKt.getDownloadLogger().debug("Cannot resolve host for " + url$iv + " for " + request$iv + ". " + e$iv.getMessage(), (Throwable)e$iv);
                    }
                    catch (SocketTimeoutException e$iv) {
                        if (SharedIndexDownloadLoggerKt.getDownloadLogger().isDebugEnabled()) {
                            SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Connection expired by timeout at " + url$iv + " for " + request$iv + ". Error: " + e$iv.getMessage() + ".", (Throwable)e$iv);
                        } else {
                            SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Connection expired by timeout at " + url$iv + " for " + request$iv + ". Error: " + e$iv.getMessage() + ".");
                        }
                    }
                    catch (HttpRequests.HttpStatusException e$iv) {
                        if (e$iv.getStatusCode() < 500) {
                            SharedIndexDownloadLoggerKt.getDownloadLogger().debug("No data available for " + url$iv + " for " + request$iv + ". " + e$iv.getStatusCode(), (Throwable)e$iv);
                        } else {
                            SharedIndexDownloadLoggerKt.getDownloadLogger().info("No data available for " + url$iv + " for " + request$iv + ". " + e$iv.getStatusCode(), (Throwable)e$iv);
                        }
                    }
                    catch (IOException e$iv) {
                        if (SharedIndexDownloadLoggerKt.getDownloadLogger().isDebugEnabled()) {
                            Logger logger = SharedIndexDownloadLoggerKt.getDownloadLogger();
                            String string2 = e$iv.getMessage();
                            if (string2 == null) {
                                Throwable throwable = e$iv.getCause();
                                string2 = throwable != null ? throwable.getMessage() : null;
                            }
                            logger.warn("Failed to download " + url$iv + " for " + request$iv + ". Error: " + (string2 != null ? (Serializable)((Object)string2) : (Serializable)e$iv.getClass()), (Throwable)e$iv);
                        } else {
                            Logger logger = SharedIndexDownloadLoggerKt.getDownloadLogger();
                            String string3 = e$iv.getMessage();
                            if (string3 == null) {
                                Throwable throwable = e$iv.getCause();
                                string3 = throwable != null ? throwable.getMessage() : null;
                            }
                            logger.warn("Failed to download " + url$iv + " for " + request$iv + ". Error: " + (string3 != null ? (Serializable)((Object)string3) : (Serializable)e$iv.getClass()));
                        }
                    }
                    catch (Throwable t$iv) {
                        if (t$iv instanceof ControlFlowException) {
                            throw t$iv;
                        }
                        Logger logger = SharedIndexDownloadLoggerKt.getDownloadLogger();
                        Class<?> clazz = t$iv.getClass();
                        String string4 = t$iv.getMessage();
                        if (string4 == null) {
                            Throwable throwable = t$iv.getCause();
                            string4 = throwable != null ? throwable.getMessage() : null;
                        }
                        logger.warn("Failed to download " + url$iv + " due " + clazz + " for " + request$iv + ". Error: " + (string4 != null ? (Serializable)((Object)string4) : (Serializable)t$iv.getClass()));
                    }
                    l = null;
                }
                request$iv = l;
            }
            finally {
                downloadTime.set(System.nanoTime() - downloadTime.get());
            }
            $this$runCatching = Result.constructor-impl((Object)request$iv);
        }
        catch (Throwable bl) {
            $this$runCatching = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$runCatching;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object it = bl = ($this$runCatching = throwable);
            boolean bl = false;
            if (it instanceof ControlFlowException) {
                SharedIndexDownloadLoggerKt.getDownloadLogger().info("Shared index download interrupted because of " + it.getClass().getName());
                throw it;
            }
            SharedIndexDownloadLoggerKt.getDownloadLogger().error((Throwable)it);
        }
        $this$runCatching = downloadResult = object2;
        Long sharedIndexSize = (Long)(Result.isFailure-impl((Object)$this$runCatching) ? null : $this$runCatching);
        SharedIndexesFusCollector.FinishType finishType2 = Result.isFailure-impl((Object)downloadResult) && Result.exceptionOrNull-impl((Object)downloadResult) instanceof ControlFlowException ? SharedIndexesFusCollector.FinishType.CANCELLED : (Result.isFailure-impl((Object)downloadResult) ? SharedIndexesFusCollector.FinishType.ERROR : (sharedIndexSize == null || sharedIndexSize <= 0L ? SharedIndexesFusCollector.FinishType.ERROR : SharedIndexesFusCollector.FinishType.SUCCESS));
        Long l = sharedIndexSize;
        SharedIndexesFusCollector.INSTANCE.reportIndexDownloadFinished(project, finishType2, $this$downloadChunk.getRequest().getKind(), $this$downloadChunk.getChunkUniqueId(), TimeUnit.NANOSECONDS.toMillis(downloadTime.get()), $this$downloadChunk.getSize(), l != null ? l : 0L, SharedIndexLookupResultKt.toSpeedKBytesPerSecond($this$downloadChunk.getSize(), downloadTime.get()));
        SharedIndexMetadata sharedIndexMetadata = metadata = SharedIndexLookupResultKt.tryExtractMetadata(targetFile);
        ZonedDateTime generationStamp = sharedIndexMetadata != null ? sharedIndexMetadata.getGenerationTime() : null;
        Object object3 = metadata;
        if (object3 == null || (object3 = ((SharedIndexMetadata)object3).getIndexKind()) == null) {
            object3 = $this$downloadChunk.getRequest().getKind();
        }
        Object kind2 = object3;
        String string5 = $this$downloadChunk.getChunkUniqueId();
        String $i$f$handleHttpDownloadExceptions = finishType2.name();
        String string6 = $i$f$handleHttpDownloadExceptions.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).toLowerCase()");
        Long l2 = sharedIndexSize;
        SharedIndexDiagnostic.INSTANCE.onIndexDownloaded(project, (String)kind2, string5, string6, downloadTime.get(), $this$downloadChunk.getSize(), l2 != null ? l2 : 0L, generationStamp);
        boolean bl = result2 = finishType2 == SharedIndexesFusCollector.FinishType.SUCCESS;
        if (result2) {
            String string7 = StringUtil.formatFileSize((long)$this$downloadChunk.getSize());
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"StringUtil.formatFileSize(size)");
            String size = string7;
            String string8 = StringUtil.formatDuration((long)TimeUnit.NANOSECONDS.toMillis(downloadTime.get()));
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"StringUtil.formatDuratio\u2026llis(downloadTime.get()))");
            String duration = string8;
            SharedIndexDownloadLoggerKt.getDownloadLogger().info("Chunk " + $this$downloadChunk.getChunkUniqueId() + " is downloaded (" + size + " in " + duration + ")");
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final SharedIndexMetadata tryExtractMetadata(Path targetFile) {
        Object object;
        try {
            SharedIndexMetadata sharedIndexMetadata;
            boolean bl = false;
            Closeable closeable = UncompressedZipFileSystem.create(targetFile);
            Throwable throwable = null;
            try {
                UncompressedZipFileSystem it = (UncompressedZipFileSystem)closeable;
                boolean bl2 = false;
                UncompressedZipFileSystem uncompressedZipFileSystem = it;
                Intrinsics.checkNotNullExpressionValue((Object)uncompressedZipFileSystem, (String)"it");
                Path path = uncompressedZipFileSystem.getRootDirectory();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it.rootDirectory");
                sharedIndexMetadata = SharedIndexMetadata.Companion.readSharedIndexMetadata(path);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            object = Result.constructor-impl((Object)sharedIndexMetadata);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (SharedIndexMetadata)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static final long toSpeedKBytesPerSecond(long size, long durationNano) {
        long millis = TimeUnit.NANOSECONDS.toMillis(durationNano);
        if (millis == 0L) {
            return 0L;
        }
        double kbPerMs = (double)(size / (long)1024) / (double)millis;
        return (long)(kbPerMs * (double)1000);
    }
}

