/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.junit;

import com.intellij.rt.execution.junit.RepeatCount;
import com.intellij.rt.junit.IdeaTestRunner;
import com.intellij.rt.junit.JUnitForkedSplitter;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.textui.TestRunner;

public final class JUnitStarter {
    public static final int VERSION = 5;
    public static final String IDE_VERSION = "-ideVersion";
    public static final String JUNIT3_PARAMETER = "-junit3";
    public static final String JUNIT4_PARAMETER = "-junit4";
    public static final String JUNIT5_PARAMETER = "-junit5";
    private static final String JUNIT5_KEY = "idea.is.junit5";
    private static final String SOCKET = "-socket";
    private static final String JUNIT3_RUNNER_NAME = "com.intellij.junit3.JUnit3IdeaTestRunner";
    private static final String JUNIT4_RUNNER_NAME = "com.intellij.junit4.JUnit4IdeaTestRunner";
    private static final String JUNIT5_RUNNER_NAME = "com.intellij.junit5.JUnit5IdeaTestRunner";
    private static String ourForkMode;
    private static String ourCommandFileName;
    private static String ourWorkingDirs;
    static int ourCount;
    public static String ourRepeatCount;

    public static void main(String[] args) {
        String[] name;
        ArrayList<String> listeners;
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        String agentName = JUnitStarter.processParameters(argList, listeners = new ArrayList<String>(), name = new String[1]);
        if (!JUNIT5_RUNNER_NAME.equals(agentName) && !JUnitStarter.canWorkWithJUnitVersion(System.err, agentName)) {
            System.exit(-3);
        }
        if (!JUnitStarter.checkVersion(args, System.err)) {
            System.exit(-3);
        }
        String[] array = argList.toArray(new String[0]);
        int exitCode = JUnitStarter.prepareStreamsAndStart(array, agentName, listeners, name[0]);
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String processParameters(List<String> args, List<? super String> listeners, String[] params) {
        String agentName = JUnitStarter.isJUnit5Preferred() ? JUNIT5_RUNNER_NAME : JUNIT4_RUNNER_NAME;
        ArrayList<String> result = new ArrayList<String>(args.size());
        for (String arg : args) {
            if (arg.startsWith(IDE_VERSION)) continue;
            if (arg.equals(JUNIT3_PARAMETER)) {
                agentName = JUNIT3_RUNNER_NAME;
                continue;
            }
            if (arg.equals(JUNIT4_PARAMETER)) {
                agentName = JUNIT4_RUNNER_NAME;
                continue;
            }
            if (arg.equals(JUNIT5_PARAMETER)) {
                agentName = JUNIT5_RUNNER_NAME;
                continue;
            }
            if (arg.startsWith("@name")) {
                params[0] = arg.substring("@name".length());
                continue;
            }
            if (arg.startsWith("@w@")) {
                ourWorkingDirs = arg.substring(3);
                continue;
            }
            if (arg.startsWith("@@@")) {
                int pos = arg.indexOf(44);
                ourForkMode = arg.substring(3, pos);
                ourCommandFileName = arg.substring(pos + 1);
                continue;
            }
            if (arg.startsWith("@@")) {
                if (!new File(arg.substring(2)).exists()) continue;
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new FileReader(arg.substring(2)));
                    while ((line = reader.readLine()) != null) {
                        listeners.add(line);
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (arg.startsWith(SOCKET)) {
                int port;
                String host;
                String value = arg.substring(SOCKET.length());
                int index = value.lastIndexOf(58);
                if (index == -1) {
                    host = "127.0.0.1";
                    port = Integer.parseInt(value);
                } else {
                    host = value.substring(0, index);
                    port = Integer.parseInt(value.substring(index + 1));
                }
                try {
                    Socket socket = new Socket(InetAddress.getByName(host), port);
                    DataInputStream os = new DataInputStream(socket.getInputStream());
                    try {
                        os.readBoolean();
                    }
                    finally {
                        os.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            int count = RepeatCount.getCount((String)arg);
            if (count != 0) {
                ourRepeatCount = arg;
                ourCount = count;
                continue;
            }
            result.add(arg);
        }
        args.clear();
        args.addAll(result);
        if (JUNIT3_RUNNER_NAME.equals(agentName)) {
            try {
                Class.forName("org.junit.runner.Computer");
                agentName = JUNIT4_RUNNER_NAME;
            }
            catch (ClassNotFoundException e) {
                return JUNIT3_RUNNER_NAME;
            }
        }
        if (JUNIT4_RUNNER_NAME.equals(agentName)) {
            try {
                Class.forName("org.junit.Test");
            }
            catch (ClassNotFoundException e) {
                return JUNIT3_RUNNER_NAME;
            }
        }
        try {
            String forceJUnit3 = System.getProperty("idea.force.junit3");
            if (Boolean.parseBoolean(forceJUnit3)) {
                return JUNIT3_RUNNER_NAME;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return agentName;
    }

    private static boolean isJUnit5Preferred() {
        return Boolean.parseBoolean(System.getProperty(JUNIT5_KEY));
    }

    public static boolean checkVersion(String[] args, PrintStream printStream) {
        for (String arg : args) {
            if (!arg.startsWith(IDE_VERSION)) continue;
            int ideVersion = Integer.parseInt(arg.substring(IDE_VERSION.length()));
            if (ideVersion != 5) {
                printStream.println("Wrong agent version: 5. IDE expects version: " + ideVersion);
                printStream.flush();
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canWorkWithJUnitVersion(PrintStream printStream, String agentName) {
        try {
            JUnitStarter.junitVersionChecks(agentName);
        }
        catch (Throwable e) {
            printStream.println("!!! JUnit version 3.8 or later expected:");
            printStream.println();
            e.printStackTrace(printStream);
            printStream.flush();
            boolean bl = false;
            return bl;
        }
        finally {
            printStream.flush();
        }
        return true;
    }

    private static void junitVersionChecks(String agentName) throws ClassNotFoundException {
        Class.forName("junit.framework.ComparisonFailure");
        JUnitStarter.getAgentClass(agentName);
        new TestRunner().setPrinter(null);
    }

    private static int prepareStreamsAndStart(String[] args, String agentName, ArrayList<String> listeners, String name) {
        try {
            IdeaTestRunner testRunner = (IdeaTestRunner)JUnitStarter.getAgentClass(agentName).newInstance();
            if (ourCommandFileName != null && (!"none".equals(ourForkMode) || ourWorkingDirs != null && new File(ourWorkingDirs).length() > 0L)) {
                ArrayList<String> newArgs = new ArrayList<String>();
                newArgs.add(agentName);
                newArgs.addAll(listeners);
                return new JUnitForkedSplitter(ourWorkingDirs, ourForkMode, newArgs).startSplitting(args, name, ourCommandFileName, ourRepeatCount);
            }
            return IdeaTestRunner.Repeater.startRunnerWithArgs(testRunner, args, listeners, name, ourCount, true);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return -2;
        }
    }

    static Class<?> getAgentClass(String agentName) throws ClassNotFoundException {
        return Class.forName(agentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printClassesList(List<String> classNames, String packageName, String category, String filters, File tempFile) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), "UTF-8"));
        try {
            writer.println(packageName);
            writer.println(category);
            writer.println(filters);
            for (String name : classNames) {
                writer.println(name);
            }
        }
        finally {
            writer.close();
        }
    }

    static {
        ourCount = 1;
    }
}

