/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.config.FeatureConfig;
import org.jboss.galleon.config.FeatureGroupSupport;
import org.jboss.galleon.runtime.ConfigModelStack;
import org.jboss.galleon.runtime.ResolvedFeatureId;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.universe.FeaturePackLocation;

public class ResolvedFeatureGroupConfig {
    final ConfigModelStack configStack;
    final FeaturePackLocation.ProducerSpec producer;
    final FeatureGroupSupport fg;
    boolean inheritFeatures = true;
    Set<ResolvedSpecId> includedSpecs = Collections.emptySet();
    Map<ResolvedFeatureId, FeatureConfig> includedFeatures = Collections.emptyMap();
    Set<ResolvedSpecId> excludedSpecs = Collections.emptySet();
    Set<ResolvedFeatureId> excludedFeatures = Collections.emptySet();

    ResolvedFeatureGroupConfig(ConfigModelStack configStack, FeatureGroupSupport fg, FeaturePackLocation.ProducerSpec producer) {
        this.configStack = configStack;
        this.producer = producer;
        this.fg = fg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isSubsetOf(ResolvedFeatureGroupConfig other) {
        if (this.fg.getId() == null || other.fg.getId() == null) {
            throw new IllegalArgumentException("Can't compare group anonymous groups");
        }
        if (this.inheritFeatures) {
            if (!other.inheritFeatures) return false;
            if (!this.excludedSpecs.containsAll(other.excludedSpecs)) {
                return false;
            }
            if (!this.excludedFeatures.containsAll(other.excludedFeatures)) {
                return false;
            }
            if (this.includedFeatures.isEmpty()) return true;
            if (other.includedFeatures.isEmpty()) {
                return false;
            }
            for (Map.Entry<ResolvedFeatureId, FeatureConfig> entry : this.includedFeatures.entrySet()) {
                FeatureConfig otherFc = other.includedFeatures.get(entry.getKey());
                if (otherFc == null) {
                    return false;
                }
                if (otherFc.equals(entry.getValue())) continue;
                return false;
            }
            return true;
        } else if (other.inheritFeatures) {
            if (!this.includedSpecs.isEmpty() && !other.excludedSpecs.isEmpty()) {
                for (ResolvedSpecId resolvedSpecId : this.includedSpecs) {
                    if (!this.excludedSpecs.contains(resolvedSpecId)) continue;
                    return false;
                }
            }
            if (this.includedFeatures.isEmpty() || other.excludedFeatures.isEmpty()) return true;
            for (Map.Entry entry : this.includedFeatures.entrySet()) {
                if (!other.excludedFeatures.contains(entry.getKey())) continue;
                return false;
            }
            return true;
        } else {
            if (!other.includedSpecs.containsAll(this.includedSpecs)) {
                return false;
            }
            if (!this.includedFeatures.isEmpty()) {
                if (other.includedFeatures.isEmpty()) {
                    return false;
                }
                for (Map.Entry<ResolvedFeatureId, FeatureConfig> entry : this.includedFeatures.entrySet()) {
                    FeatureConfig otherFc = other.includedFeatures.get(entry.getKey());
                    if (otherFc == null) {
                        return false;
                    }
                    if (otherFc.equals(entry.getValue())) continue;
                    return false;
                }
            }
            if (this.excludedFeatures.containsAll(other.excludedFeatures)) return true;
            return false;
        }
    }
}

