/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.phase;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.elasticsearch.painless.DefBootstrap;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.Operation;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.ir.BinaryImplNode;
import org.elasticsearch.painless.ir.BinaryMathNode;
import org.elasticsearch.painless.ir.BlockNode;
import org.elasticsearch.painless.ir.BooleanNode;
import org.elasticsearch.painless.ir.BreakNode;
import org.elasticsearch.painless.ir.CastNode;
import org.elasticsearch.painless.ir.CatchNode;
import org.elasticsearch.painless.ir.ClassNode;
import org.elasticsearch.painless.ir.ComparisonNode;
import org.elasticsearch.painless.ir.ConditionalNode;
import org.elasticsearch.painless.ir.ConstantNode;
import org.elasticsearch.painless.ir.ContinueNode;
import org.elasticsearch.painless.ir.DeclarationBlockNode;
import org.elasticsearch.painless.ir.DeclarationNode;
import org.elasticsearch.painless.ir.DefInterfaceReferenceNode;
import org.elasticsearch.painless.ir.DoWhileLoopNode;
import org.elasticsearch.painless.ir.DupNode;
import org.elasticsearch.painless.ir.ElvisNode;
import org.elasticsearch.painless.ir.ExpressionNode;
import org.elasticsearch.painless.ir.FieldNode;
import org.elasticsearch.painless.ir.FlipArrayIndexNode;
import org.elasticsearch.painless.ir.FlipCollectionIndexNode;
import org.elasticsearch.painless.ir.FlipDefIndexNode;
import org.elasticsearch.painless.ir.ForEachLoopNode;
import org.elasticsearch.painless.ir.ForEachSubArrayNode;
import org.elasticsearch.painless.ir.ForEachSubIterableNode;
import org.elasticsearch.painless.ir.ForLoopNode;
import org.elasticsearch.painless.ir.FunctionNode;
import org.elasticsearch.painless.ir.IRNode;
import org.elasticsearch.painless.ir.IfElseNode;
import org.elasticsearch.painless.ir.IfNode;
import org.elasticsearch.painless.ir.InstanceofNode;
import org.elasticsearch.painless.ir.InvokeCallDefNode;
import org.elasticsearch.painless.ir.InvokeCallMemberNode;
import org.elasticsearch.painless.ir.InvokeCallNode;
import org.elasticsearch.painless.ir.ListInitializationNode;
import org.elasticsearch.painless.ir.LoadBraceDefNode;
import org.elasticsearch.painless.ir.LoadBraceNode;
import org.elasticsearch.painless.ir.LoadDotArrayLengthNode;
import org.elasticsearch.painless.ir.LoadDotDefNode;
import org.elasticsearch.painless.ir.LoadDotNode;
import org.elasticsearch.painless.ir.LoadDotShortcutNode;
import org.elasticsearch.painless.ir.LoadFieldMemberNode;
import org.elasticsearch.painless.ir.LoadListShortcutNode;
import org.elasticsearch.painless.ir.LoadMapShortcutNode;
import org.elasticsearch.painless.ir.LoadVariableNode;
import org.elasticsearch.painless.ir.LoopNode;
import org.elasticsearch.painless.ir.MapInitializationNode;
import org.elasticsearch.painless.ir.NewArrayNode;
import org.elasticsearch.painless.ir.NewObjectNode;
import org.elasticsearch.painless.ir.NullNode;
import org.elasticsearch.painless.ir.NullSafeSubNode;
import org.elasticsearch.painless.ir.ReferenceNode;
import org.elasticsearch.painless.ir.ReturnNode;
import org.elasticsearch.painless.ir.StatementExpressionNode;
import org.elasticsearch.painless.ir.StatementNode;
import org.elasticsearch.painless.ir.StaticNode;
import org.elasticsearch.painless.ir.StoreBraceDefNode;
import org.elasticsearch.painless.ir.StoreBraceNode;
import org.elasticsearch.painless.ir.StoreDotDefNode;
import org.elasticsearch.painless.ir.StoreDotNode;
import org.elasticsearch.painless.ir.StoreDotShortcutNode;
import org.elasticsearch.painless.ir.StoreFieldMemberNode;
import org.elasticsearch.painless.ir.StoreListShortcutNode;
import org.elasticsearch.painless.ir.StoreMapShortcutNode;
import org.elasticsearch.painless.ir.StoreNode;
import org.elasticsearch.painless.ir.StoreVariableNode;
import org.elasticsearch.painless.ir.StringConcatenationNode;
import org.elasticsearch.painless.ir.ThrowNode;
import org.elasticsearch.painless.ir.TryNode;
import org.elasticsearch.painless.ir.TypedCaptureReferenceNode;
import org.elasticsearch.painless.ir.TypedInterfaceReferenceNode;
import org.elasticsearch.painless.ir.UnaryMathNode;
import org.elasticsearch.painless.ir.WhileLoopNode;
import org.elasticsearch.painless.lookup.PainlessCast;
import org.elasticsearch.painless.lookup.PainlessClassBinding;
import org.elasticsearch.painless.lookup.PainlessField;
import org.elasticsearch.painless.lookup.PainlessInstanceBinding;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.ANode;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.EAssignment;
import org.elasticsearch.painless.node.EBinary;
import org.elasticsearch.painless.node.EBooleanComp;
import org.elasticsearch.painless.node.EBooleanConstant;
import org.elasticsearch.painless.node.EBrace;
import org.elasticsearch.painless.node.ECall;
import org.elasticsearch.painless.node.ECallLocal;
import org.elasticsearch.painless.node.EComp;
import org.elasticsearch.painless.node.EConditional;
import org.elasticsearch.painless.node.EDecimal;
import org.elasticsearch.painless.node.EDot;
import org.elasticsearch.painless.node.EElvis;
import org.elasticsearch.painless.node.EExplicit;
import org.elasticsearch.painless.node.EFunctionRef;
import org.elasticsearch.painless.node.EInstanceof;
import org.elasticsearch.painless.node.ELambda;
import org.elasticsearch.painless.node.EListInit;
import org.elasticsearch.painless.node.EMapInit;
import org.elasticsearch.painless.node.ENewArray;
import org.elasticsearch.painless.node.ENewArrayFunctionRef;
import org.elasticsearch.painless.node.ENewObj;
import org.elasticsearch.painless.node.ENull;
import org.elasticsearch.painless.node.ENumeric;
import org.elasticsearch.painless.node.ERegex;
import org.elasticsearch.painless.node.EString;
import org.elasticsearch.painless.node.ESymbol;
import org.elasticsearch.painless.node.EUnary;
import org.elasticsearch.painless.node.SBlock;
import org.elasticsearch.painless.node.SBreak;
import org.elasticsearch.painless.node.SCatch;
import org.elasticsearch.painless.node.SClass;
import org.elasticsearch.painless.node.SContinue;
import org.elasticsearch.painless.node.SDeclBlock;
import org.elasticsearch.painless.node.SDeclaration;
import org.elasticsearch.painless.node.SDo;
import org.elasticsearch.painless.node.SEach;
import org.elasticsearch.painless.node.SExpression;
import org.elasticsearch.painless.node.SFor;
import org.elasticsearch.painless.node.SFunction;
import org.elasticsearch.painless.node.SIf;
import org.elasticsearch.painless.node.SIfElse;
import org.elasticsearch.painless.node.SReturn;
import org.elasticsearch.painless.node.SThrow;
import org.elasticsearch.painless.node.STry;
import org.elasticsearch.painless.node.SWhile;
import org.elasticsearch.painless.phase.UserTreeVisitor;
import org.elasticsearch.painless.symbol.Decorations;
import org.elasticsearch.painless.symbol.FunctionTable;
import org.elasticsearch.painless.symbol.ScriptScope;
import org.elasticsearch.painless.symbol.SemanticScope;

public class DefaultUserTreeToIRTreePhase
implements UserTreeVisitor<ScriptScope> {
    protected ClassNode irClassNode;

    protected void injectBootstrapMethod(ScriptScope scriptScope) {
        Location internalLocation = new Location("$internal$injectStaticFields", 0);
        int modifiers = 9;
        FieldNode irFieldNode = new FieldNode(internalLocation);
        irFieldNode.setModifiers(modifiers);
        irFieldNode.setFieldType(PainlessLookup.class);
        irFieldNode.setName("$DEFINITION");
        this.irClassNode.addFieldNode(irFieldNode);
        irFieldNode = new FieldNode(internalLocation);
        irFieldNode.setModifiers(modifiers);
        irFieldNode.setFieldType(FunctionTable.class);
        irFieldNode.setName("$FUNCTIONS");
        this.irClassNode.addFieldNode(irFieldNode);
        irFieldNode = new FieldNode(internalLocation);
        irFieldNode.setModifiers(modifiers);
        irFieldNode.setFieldType(Map.class);
        irFieldNode.setName("$COMPILERSETTINGS");
        this.irClassNode.addFieldNode(irFieldNode);
        internalLocation = new Location("$internal$injectDefBootstrapMethod", 0);
        try {
            FunctionNode irFunctionNode = new FunctionNode(internalLocation);
            irFunctionNode.setReturnType(CallSite.class);
            irFunctionNode.setName("$bootstrapDef");
            irFunctionNode.getTypeParameters().addAll(Arrays.asList(MethodHandles.Lookup.class, String.class, MethodType.class, Integer.TYPE, Integer.TYPE, Object[].class));
            irFunctionNode.getParameterNames().addAll(Arrays.asList("methodHandlesLookup", "name", "type", "initialDepth", "flavor", "args"));
            irFunctionNode.setStatic(true);
            irFunctionNode.setVarArgs(true);
            irFunctionNode.setSynthetic(true);
            irFunctionNode.setMaxLoopCounter(0);
            this.irClassNode.addFunctionNode(irFunctionNode);
            BlockNode blockNode = new BlockNode(internalLocation);
            blockNode.setAllEscape(true);
            irFunctionNode.setBlockNode(blockNode);
            ReturnNode returnNode = new ReturnNode(internalLocation);
            blockNode.addStatementNode(returnNode);
            BinaryImplNode irBinaryImplNode = new BinaryImplNode(internalLocation);
            irBinaryImplNode.setExpressionType(CallSite.class);
            returnNode.setExpressionNode(irBinaryImplNode);
            StaticNode staticNode = new StaticNode(internalLocation);
            staticNode.setExpressionType(DefBootstrap.class);
            irBinaryImplNode.setLeftNode(staticNode);
            InvokeCallNode invokeCallNode = new InvokeCallNode(internalLocation);
            invokeCallNode.setExpressionType(CallSite.class);
            invokeCallNode.setMethod(new PainlessMethod(DefBootstrap.class.getMethod("bootstrap", PainlessLookup.class, FunctionTable.class, Map.class, MethodHandles.Lookup.class, String.class, MethodType.class, Integer.TYPE, Integer.TYPE, Object[].class), DefBootstrap.class, CallSite.class, Arrays.asList(PainlessLookup.class, FunctionTable.class, Map.class, MethodHandles.Lookup.class, String.class, MethodType.class, Integer.TYPE, Integer.TYPE, Object[].class), null, null, null));
            invokeCallNode.setBox(DefBootstrap.class);
            irBinaryImplNode.setRightNode(invokeCallNode);
            LoadFieldMemberNode irLoadFieldMemberNode = new LoadFieldMemberNode(internalLocation);
            irLoadFieldMemberNode.setExpressionType(PainlessLookup.class);
            irLoadFieldMemberNode.setName("$DEFINITION");
            irLoadFieldMemberNode.setStatic(true);
            invokeCallNode.addArgumentNode(irLoadFieldMemberNode);
            irLoadFieldMemberNode = new LoadFieldMemberNode(internalLocation);
            irLoadFieldMemberNode.setExpressionType(FunctionTable.class);
            irLoadFieldMemberNode.setName("$FUNCTIONS");
            irLoadFieldMemberNode.setStatic(true);
            invokeCallNode.addArgumentNode(irLoadFieldMemberNode);
            irLoadFieldMemberNode = new LoadFieldMemberNode(internalLocation);
            irLoadFieldMemberNode.setExpressionType(Map.class);
            irLoadFieldMemberNode.setName("$COMPILERSETTINGS");
            irLoadFieldMemberNode.setStatic(true);
            invokeCallNode.addArgumentNode(irLoadFieldMemberNode);
            LoadVariableNode irLoadVariableNode = new LoadVariableNode(internalLocation);
            irLoadVariableNode.setExpressionType(MethodHandles.Lookup.class);
            irLoadVariableNode.setName("methodHandlesLookup");
            invokeCallNode.addArgumentNode(irLoadVariableNode);
            irLoadVariableNode = new LoadVariableNode(internalLocation);
            irLoadVariableNode.setExpressionType(String.class);
            irLoadVariableNode.setName("name");
            invokeCallNode.addArgumentNode(irLoadVariableNode);
            irLoadVariableNode = new LoadVariableNode(internalLocation);
            irLoadVariableNode.setExpressionType(MethodType.class);
            irLoadVariableNode.setName("type");
            invokeCallNode.addArgumentNode(irLoadVariableNode);
            irLoadVariableNode = new LoadVariableNode(internalLocation);
            irLoadVariableNode.setExpressionType(Integer.TYPE);
            irLoadVariableNode.setName("initialDepth");
            invokeCallNode.addArgumentNode(irLoadVariableNode);
            irLoadVariableNode = new LoadVariableNode(internalLocation);
            irLoadVariableNode.setExpressionType(Integer.TYPE);
            irLoadVariableNode.setName("flavor");
            invokeCallNode.addArgumentNode(irLoadVariableNode);
            irLoadVariableNode = new LoadVariableNode(internalLocation);
            irLoadVariableNode.setExpressionType(Object[].class);
            irLoadVariableNode.setName("args");
            invokeCallNode.addArgumentNode(irLoadVariableNode);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    protected ExpressionNode injectCast(AExpression userExpressionNode, ScriptScope scriptScope) {
        ExpressionNode irExpressionNode = (ExpressionNode)this.visit(userExpressionNode, scriptScope);
        if (irExpressionNode == null) {
            return null;
        }
        Decorations.ExpressionPainlessCast expressionPainlessCast = scriptScope.getDecoration(userExpressionNode, Decorations.ExpressionPainlessCast.class);
        if (expressionPainlessCast == null) {
            return irExpressionNode;
        }
        PainlessCast painlessCast = expressionPainlessCast.getExpressionPainlessCast();
        Class<?> targetType = painlessCast.targetType;
        if (painlessCast.boxTargetType != null) {
            targetType = PainlessLookupUtility.typeToBoxedType(painlessCast.boxTargetType);
        } else if (painlessCast.unboxTargetType != null) {
            targetType = painlessCast.unboxTargetType;
        }
        CastNode irCastNode = new CastNode(irExpressionNode.getLocation());
        irCastNode.setExpressionType(targetType);
        irCastNode.setCast(painlessCast);
        irCastNode.setChildNode(irExpressionNode);
        return irCastNode;
    }

    protected ExpressionNode buildLoadStore(int accessDepth, Location location, boolean isNullSafe, ExpressionNode irPrefixNode, ExpressionNode irIndexNode, ExpressionNode irLoadNode, StoreNode irStoreNode) {
        ExpressionNode irExpressionNode;
        ExpressionNode expressionNode = irExpressionNode = irLoadNode != null ? irLoadNode : irStoreNode;
        if (irPrefixNode != null) {
            BinaryImplNode binaryImplNode;
            if (irIndexNode != null) {
                binaryImplNode = new BinaryImplNode(location);
                if (isNullSafe) {
                    binaryImplNode.setExpressionType(irExpressionNode.getExpressionType());
                    binaryImplNode.setLeftNode(irIndexNode);
                    binaryImplNode.setRightNode(irExpressionNode);
                    irExpressionNode = binaryImplNode;
                } else {
                    binaryImplNode.setExpressionType(Void.TYPE);
                    binaryImplNode.setLeftNode(irPrefixNode);
                    binaryImplNode.setRightNode(irIndexNode);
                    irPrefixNode = binaryImplNode;
                }
            }
            if (irLoadNode != null && irStoreNode != null) {
                DupNode dupNode = new DupNode(location);
                dupNode.setExpressionType(Void.TYPE);
                dupNode.setSize(accessDepth);
                dupNode.setDepth(0);
                dupNode.setChildNode(irPrefixNode);
                irPrefixNode = dupNode;
            }
            binaryImplNode = new BinaryImplNode(location);
            binaryImplNode.setExpressionType(irExpressionNode.getExpressionType());
            if (isNullSafe) {
                NullSafeSubNode irNullSafeSubNode = new NullSafeSubNode(location);
                irNullSafeSubNode.setExpressionType(irExpressionNode.getExpressionType());
                irNullSafeSubNode.setChildNode(irExpressionNode);
                binaryImplNode.setLeftNode(irPrefixNode);
                binaryImplNode.setRightNode(irNullSafeSubNode);
            } else {
                binaryImplNode.setLeftNode(irPrefixNode);
                binaryImplNode.setRightNode(irExpressionNode);
            }
            irExpressionNode = binaryImplNode;
        }
        if (irLoadNode != null && irStoreNode != null) {
            irStoreNode.setChildNode(irExpressionNode);
            irExpressionNode = irStoreNode;
        }
        return irExpressionNode;
    }

    protected IRNode visit(ANode userNode, ScriptScope scriptScope) {
        if (userNode == null) {
            return null;
        }
        userNode.visit(this, scriptScope);
        return scriptScope.getDecoration(userNode, Decorations.IRNodeDecoration.class).getIRNode();
    }

    @Override
    public void visitClass(SClass userClassNode, ScriptScope scriptScope) {
        this.irClassNode = new ClassNode(userClassNode.getLocation());
        for (SFunction userFunctionNode : userClassNode.getFunctionNodes()) {
            this.irClassNode.addFunctionNode((FunctionNode)this.visit(userFunctionNode, scriptScope));
        }
        this.irClassNode.setScriptScope(scriptScope);
        this.injectBootstrapMethod(scriptScope);
        scriptScope.putDecoration(userClassNode, new Decorations.IRNodeDecoration(this.irClassNode));
    }

    @Override
    public void visitFunction(SFunction userFunctionNode, ScriptScope scriptScope) {
        String functionName = userFunctionNode.getFunctionName();
        int functionArity = userFunctionNode.getCanonicalTypeNameParameters().size();
        FunctionTable.LocalFunction localFunction = scriptScope.getFunctionTable().getFunction(functionName, functionArity);
        Class<?> returnType = localFunction.getReturnType();
        boolean methodEscape = scriptScope.getCondition(userFunctionNode, Decorations.MethodEscape.class);
        BlockNode irBlockNode = (BlockNode)this.visit(userFunctionNode.getBlockNode(), scriptScope);
        if (!methodEscape) {
            ExpressionNode irExpressionNode;
            if (returnType == Void.TYPE) {
                irExpressionNode = null;
            } else if (userFunctionNode.isAutoReturnEnabled()) {
                if (returnType.isPrimitive()) {
                    ConstantNode irConstantNode = new ConstantNode(userFunctionNode.getLocation());
                    irConstantNode.setExpressionType(returnType);
                    if (returnType == Boolean.TYPE) {
                        irConstantNode.setConstant(false);
                    } else if (returnType == Byte.TYPE || returnType == Character.TYPE || returnType == Short.TYPE || returnType == Integer.TYPE) {
                        irConstantNode.setConstant(0);
                    } else if (returnType == Long.TYPE) {
                        irConstantNode.setConstant(0L);
                    } else if (returnType == Float.TYPE) {
                        irConstantNode.setConstant(Float.valueOf(0.0f));
                    } else if (returnType == Double.TYPE) {
                        irConstantNode.setConstant(0.0);
                    } else {
                        throw userFunctionNode.createError(new IllegalStateException("illegal tree structure"));
                    }
                    irExpressionNode = irConstantNode;
                } else {
                    irExpressionNode = new NullNode(userFunctionNode.getLocation());
                    irExpressionNode.setExpressionType(returnType);
                }
            } else {
                throw userFunctionNode.createError(new IllegalStateException("illegal tree structure"));
            }
            ReturnNode irReturnNode = new ReturnNode(userFunctionNode.getLocation());
            irReturnNode.setExpressionNode(irExpressionNode);
            irBlockNode.addStatementNode(irReturnNode);
        }
        FunctionNode irFunctionNode = new FunctionNode(userFunctionNode.getLocation());
        irFunctionNode.setBlockNode(irBlockNode);
        irFunctionNode.setName(userFunctionNode.getFunctionName());
        irFunctionNode.setReturnType(returnType);
        irFunctionNode.getTypeParameters().addAll(localFunction.getTypeParameters());
        irFunctionNode.getParameterNames().addAll(userFunctionNode.getParameterNames());
        irFunctionNode.setStatic(userFunctionNode.isStatic());
        irFunctionNode.setVarArgs(false);
        irFunctionNode.setSynthetic(userFunctionNode.isSynthetic());
        irFunctionNode.setMaxLoopCounter(scriptScope.getCompilerSettings().getMaxLoopCounter());
        scriptScope.putDecoration(userFunctionNode, new Decorations.IRNodeDecoration(irFunctionNode));
    }

    @Override
    public void visitBlock(SBlock userBlockNode, ScriptScope scriptScope) {
        BlockNode irBlockNode = new BlockNode(userBlockNode.getLocation());
        for (AStatement userStatementNode : userBlockNode.getStatementNodes()) {
            irBlockNode.addStatementNode((StatementNode)this.visit(userStatementNode, scriptScope));
        }
        irBlockNode.setAllEscape(scriptScope.getCondition(userBlockNode, Decorations.AllEscape.class));
        scriptScope.putDecoration(userBlockNode, new Decorations.IRNodeDecoration(irBlockNode));
    }

    @Override
    public void visitIf(SIf userIfNode, ScriptScope scriptScope) {
        IfNode irIfNode = new IfNode(userIfNode.getLocation());
        irIfNode.setConditionNode(this.injectCast(userIfNode.getConditionNode(), scriptScope));
        irIfNode.setBlockNode((BlockNode)this.visit(userIfNode.getIfBlockNode(), scriptScope));
        scriptScope.putDecoration(userIfNode, new Decorations.IRNodeDecoration(irIfNode));
    }

    @Override
    public void visitIfElse(SIfElse userIfElseNode, ScriptScope scriptScope) {
        IfElseNode irIfElseNode = new IfElseNode(userIfElseNode.getLocation());
        irIfElseNode.setConditionNode(this.injectCast(userIfElseNode.getConditionNode(), scriptScope));
        irIfElseNode.setBlockNode((BlockNode)this.visit(userIfElseNode.getIfBlockNode(), scriptScope));
        irIfElseNode.setElseBlockNode((BlockNode)this.visit(userIfElseNode.getElseBlockNode(), scriptScope));
        scriptScope.putDecoration(userIfElseNode, new Decorations.IRNodeDecoration(irIfElseNode));
    }

    @Override
    public void visitWhile(SWhile userWhileNode, ScriptScope scriptScope) {
        WhileLoopNode irWhileLoopNode = new WhileLoopNode(userWhileNode.getLocation());
        irWhileLoopNode.setConditionNode(this.injectCast(userWhileNode.getConditionNode(), scriptScope));
        irWhileLoopNode.setBlockNode((BlockNode)this.visit(userWhileNode.getBlockNode(), scriptScope));
        irWhileLoopNode.setContinuous(scriptScope.getCondition(userWhileNode, Decorations.ContinuousLoop.class));
        scriptScope.putDecoration(userWhileNode, new Decorations.IRNodeDecoration(irWhileLoopNode));
    }

    @Override
    public void visitDo(SDo userDoNode, ScriptScope scriptScope) {
        DoWhileLoopNode irDoWhileLoopNode = new DoWhileLoopNode(userDoNode.getLocation());
        irDoWhileLoopNode.setConditionNode(this.injectCast(userDoNode.getConditionNode(), scriptScope));
        irDoWhileLoopNode.setBlockNode((BlockNode)this.visit(userDoNode.getBlockNode(), scriptScope));
        irDoWhileLoopNode.setContinuous(scriptScope.getCondition(userDoNode, Decorations.ContinuousLoop.class));
        scriptScope.putDecoration(userDoNode, new Decorations.IRNodeDecoration(irDoWhileLoopNode));
    }

    @Override
    public void visitFor(SFor userForNode, ScriptScope scriptScope) {
        ForLoopNode irForLoopNode = new ForLoopNode(userForNode.getLocation());
        irForLoopNode.setInitialzerNode(this.visit(userForNode.getInitializerNode(), scriptScope));
        irForLoopNode.setConditionNode(this.injectCast(userForNode.getConditionNode(), scriptScope));
        irForLoopNode.setAfterthoughtNode((ExpressionNode)this.visit(userForNode.getAfterthoughtNode(), scriptScope));
        irForLoopNode.setBlockNode((BlockNode)this.visit(userForNode.getBlockNode(), scriptScope));
        irForLoopNode.setContinuous(scriptScope.getCondition(userForNode, Decorations.ContinuousLoop.class));
        scriptScope.putDecoration(userForNode, new Decorations.IRNodeDecoration(irForLoopNode));
    }

    @Override
    public void visitEach(SEach userEachNode, ScriptScope scriptScope) {
        LoopNode irConditionNode;
        SemanticScope.Variable variable = scriptScope.getDecoration(userEachNode, Decorations.SemanticVariable.class).getSemanticVariable();
        PainlessCast painlessCast = scriptScope.hasDecoration(userEachNode, Decorations.ExpressionPainlessCast.class) ? scriptScope.getDecoration(userEachNode, Decorations.ExpressionPainlessCast.class).getExpressionPainlessCast() : null;
        ExpressionNode irIterableNode = (ExpressionNode)this.visit(userEachNode.getIterableNode(), scriptScope);
        Class<?> iterableValueType = scriptScope.getDecoration(userEachNode.getIterableNode(), Decorations.ValueType.class).getValueType();
        BlockNode irBlockNode = (BlockNode)this.visit(userEachNode.getBlockNode(), scriptScope);
        if (iterableValueType.isArray()) {
            ForEachSubArrayNode irForEachSubArrayNode = new ForEachSubArrayNode(userEachNode.getLocation());
            irForEachSubArrayNode.setConditionNode(irIterableNode);
            irForEachSubArrayNode.setBlockNode(irBlockNode);
            irForEachSubArrayNode.setVariableType(variable.getType());
            irForEachSubArrayNode.setVariableName(variable.getName());
            irForEachSubArrayNode.setCast(painlessCast);
            irForEachSubArrayNode.setArrayType(iterableValueType);
            irForEachSubArrayNode.setArrayName("#array" + userEachNode.getLocation().getOffset());
            irForEachSubArrayNode.setIndexType(Integer.TYPE);
            irForEachSubArrayNode.setIndexName("#index" + userEachNode.getLocation().getOffset());
            irForEachSubArrayNode.setIndexedType(iterableValueType.getComponentType());
            irForEachSubArrayNode.setContinuous(false);
            irConditionNode = irForEachSubArrayNode;
        } else if (iterableValueType == def.class || Iterable.class.isAssignableFrom(iterableValueType)) {
            ForEachSubIterableNode irForEachSubIterableNode = new ForEachSubIterableNode(userEachNode.getLocation());
            irForEachSubIterableNode.setConditionNode(irIterableNode);
            irForEachSubIterableNode.setBlockNode(irBlockNode);
            irForEachSubIterableNode.setVariableType(variable.getType());
            irForEachSubIterableNode.setVariableName(variable.getName());
            irForEachSubIterableNode.setCast(painlessCast);
            irForEachSubIterableNode.setIteratorType(Iterator.class);
            irForEachSubIterableNode.setIteratorName("#itr" + userEachNode.getLocation().getOffset());
            irForEachSubIterableNode.setMethod(iterableValueType == def.class ? null : scriptScope.getDecoration(userEachNode, Decorations.IterablePainlessMethod.class).getIterablePainlessMethod());
            irForEachSubIterableNode.setContinuous(false);
            irConditionNode = irForEachSubIterableNode;
        } else {
            throw userEachNode.createError(new IllegalStateException("illegal tree structure"));
        }
        ForEachLoopNode irForEachLoopNode = new ForEachLoopNode(userEachNode.getLocation());
        irForEachLoopNode.setConditionNode(irConditionNode);
        scriptScope.putDecoration(userEachNode, new Decorations.IRNodeDecoration(irForEachLoopNode));
    }

    @Override
    public void visitDeclBlock(SDeclBlock userDeclBlockNode, ScriptScope scriptScope) {
        DeclarationBlockNode irDeclarationBlockNode = new DeclarationBlockNode(userDeclBlockNode.getLocation());
        for (SDeclaration userDeclarationNode : userDeclBlockNode.getDeclarationNodes()) {
            irDeclarationBlockNode.addDeclarationNode((DeclarationNode)this.visit(userDeclarationNode, scriptScope));
        }
        scriptScope.putDecoration(userDeclBlockNode, new Decorations.IRNodeDecoration(irDeclarationBlockNode));
    }

    @Override
    public void visitDeclaration(SDeclaration userDeclarationNode, ScriptScope scriptScope) {
        SemanticScope.Variable variable = scriptScope.getDecoration(userDeclarationNode, Decorations.SemanticVariable.class).getSemanticVariable();
        DeclarationNode irDeclarationNode = new DeclarationNode(userDeclarationNode.getLocation());
        irDeclarationNode.setExpressionNode(this.injectCast(userDeclarationNode.getValueNode(), scriptScope));
        irDeclarationNode.setDeclarationType(variable.getType());
        irDeclarationNode.setName(variable.getName());
        scriptScope.putDecoration(userDeclarationNode, new Decorations.IRNodeDecoration(irDeclarationNode));
    }

    @Override
    public void visitReturn(SReturn userReturnNode, ScriptScope scriptScope) {
        ReturnNode irReturnNode = new ReturnNode(userReturnNode.getLocation());
        irReturnNode.setExpressionNode(this.injectCast(userReturnNode.getValueNode(), scriptScope));
        scriptScope.putDecoration(userReturnNode, new Decorations.IRNodeDecoration(irReturnNode));
    }

    @Override
    public void visitExpression(SExpression userExpressionNode, ScriptScope scriptScope) {
        StatementNode irStatementNode;
        ExpressionNode irExpressionNode = this.injectCast(userExpressionNode.getStatementNode(), scriptScope);
        if (scriptScope.getCondition(userExpressionNode, Decorations.MethodEscape.class)) {
            ReturnNode irReturnNode = new ReturnNode(userExpressionNode.getLocation());
            irReturnNode.setExpressionNode(irExpressionNode);
            irStatementNode = irReturnNode;
        } else {
            StatementExpressionNode irStatementExpressionNode = new StatementExpressionNode(userExpressionNode.getLocation());
            irStatementExpressionNode.setExpressionNode(irExpressionNode);
            irStatementNode = irStatementExpressionNode;
        }
        scriptScope.putDecoration(userExpressionNode, new Decorations.IRNodeDecoration(irStatementNode));
    }

    @Override
    public void visitTry(STry userTryNode, ScriptScope scriptScope) {
        TryNode irTryNode = new TryNode(userTryNode.getLocation());
        for (SCatch userCatchNode : userTryNode.getCatchNodes()) {
            irTryNode.addCatchNode((CatchNode)this.visit(userCatchNode, scriptScope));
        }
        irTryNode.setBlockNode((BlockNode)this.visit(userTryNode.getBlockNode(), scriptScope));
        scriptScope.putDecoration(userTryNode, new Decorations.IRNodeDecoration(irTryNode));
    }

    @Override
    public void visitCatch(SCatch userCatchNode, ScriptScope scriptScope) {
        SemanticScope.Variable variable = scriptScope.getDecoration(userCatchNode, Decorations.SemanticVariable.class).getSemanticVariable();
        CatchNode irCatchNode = new CatchNode(userCatchNode.getLocation());
        irCatchNode.setExceptionType(variable.getType());
        irCatchNode.setSymbol(variable.getName());
        irCatchNode.setBlockNode((BlockNode)this.visit(userCatchNode.getBlockNode(), scriptScope));
        scriptScope.putDecoration(userCatchNode, new Decorations.IRNodeDecoration(irCatchNode));
    }

    @Override
    public void visitThrow(SThrow userThrowNode, ScriptScope scriptScope) {
        ThrowNode irThrowNode = new ThrowNode(userThrowNode.getLocation());
        irThrowNode.setExpressionNode(this.injectCast(userThrowNode.getExpressionNode(), scriptScope));
        scriptScope.putDecoration(userThrowNode, new Decorations.IRNodeDecoration(irThrowNode));
    }

    @Override
    public void visitContinue(SContinue userContinueNode, ScriptScope scriptScope) {
        ContinueNode irContinueNode = new ContinueNode(userContinueNode.getLocation());
        scriptScope.putDecoration(userContinueNode, new Decorations.IRNodeDecoration(irContinueNode));
    }

    @Override
    public void visitBreak(SBreak userBreakNode, ScriptScope scriptScope) {
        BreakNode irBreakNode = new BreakNode(userBreakNode.getLocation());
        scriptScope.putDecoration(userBreakNode, new Decorations.IRNodeDecoration(irBreakNode));
    }

    @Override
    public void visitAssignment(EAssignment userAssignmentNode, ScriptScope scriptScope) {
        ExpressionNode irAssignmentNode;
        boolean read = scriptScope.getCondition(userAssignmentNode, Decorations.Read.class);
        Class<?> compoundType = scriptScope.hasDecoration(userAssignmentNode, Decorations.CompoundType.class) ? scriptScope.getDecoration(userAssignmentNode, Decorations.CompoundType.class).getCompoundType() : null;
        ExpressionNode irValueNode = this.injectCast(userAssignmentNode.getRightNode(), scriptScope);
        if (compoundType != null) {
            PainlessCast upcast;
            PainlessCast downcast;
            ExpressionNode irCompoundNode;
            boolean concatenate = userAssignmentNode.getOperation() == Operation.ADD && compoundType == String.class;
            scriptScope.setCondition(userAssignmentNode.getLeftNode(), Decorations.Compound.class);
            StoreNode irStoreNode = (StoreNode)this.visit(userAssignmentNode.getLeftNode(), scriptScope);
            ExpressionNode irLoadNode = irStoreNode.getChildNode();
            if (concatenate) {
                StringConcatenationNode stringConcatenationNode = new StringConcatenationNode(irStoreNode.getLocation());
                stringConcatenationNode.setExpressionType(String.class);
                irCompoundNode = stringConcatenationNode;
                if (irLoadNode instanceof BinaryImplNode && WriterConstants.INDY_STRING_CONCAT_BOOTSTRAP_HANDLE == null) {
                    ((DupNode)((BinaryImplNode)irLoadNode).getLeftNode()).setDepth(1);
                }
            } else {
                BinaryMathNode irBinaryMathNode = new BinaryMathNode(irStoreNode.getLocation());
                irBinaryMathNode.setLeftNode(irLoadNode);
                irBinaryMathNode.setExpressionType(compoundType);
                irBinaryMathNode.setBinaryType(compoundType);
                irBinaryMathNode.setOperation(userAssignmentNode.getOperation());
                irBinaryMathNode.setFlags(2);
                irCompoundNode = irBinaryMathNode;
            }
            PainlessCast painlessCast = downcast = scriptScope.hasDecoration(userAssignmentNode, Decorations.DowncastPainlessCast.class) ? scriptScope.getDecoration(userAssignmentNode, Decorations.DowncastPainlessCast.class).getDowncastPainlessCast() : null;
            if (downcast == null) {
                irCompoundNode.setExpressionType(irStoreNode.getStoreType());
                irStoreNode.setChildNode(irCompoundNode);
            } else {
                CastNode irCastNode = new CastNode(irCompoundNode.getLocation());
                irCastNode.setExpressionType(downcast.targetType);
                irCastNode.setCast(downcast);
                irCastNode.setChildNode(irCompoundNode);
                irStoreNode.setChildNode(irCastNode);
            }
            if (read) {
                DupNode irDupNode;
                int accessDepth = scriptScope.getDecoration(userAssignmentNode.getLeftNode(), Decorations.AccessDepth.class).getAccessDepth();
                if (userAssignmentNode.postIfRead()) {
                    irDupNode = new DupNode(irLoadNode.getLocation());
                    irDupNode.setExpressionType(irLoadNode.getExpressionType());
                    irDupNode.setSize(MethodWriter.getType(irLoadNode.getExpressionType()).getSize());
                    irDupNode.setDepth(accessDepth);
                    irDupNode.setChildNode(irLoadNode);
                    irLoadNode = irDupNode;
                } else {
                    irDupNode = new DupNode(irStoreNode.getLocation());
                    irDupNode.setExpressionType(irStoreNode.getStoreType());
                    irDupNode.setSize(MethodWriter.getType(irStoreNode.getExpressionType()).getSize());
                    irDupNode.setDepth(accessDepth);
                    irDupNode.setChildNode(irStoreNode.getChildNode());
                    irStoreNode.setChildNode(irDupNode);
                }
            }
            PainlessCast painlessCast2 = upcast = scriptScope.hasDecoration(userAssignmentNode, Decorations.UpcastPainlessCast.class) ? scriptScope.getDecoration(userAssignmentNode, Decorations.UpcastPainlessCast.class).getUpcastPainlessCast() : null;
            if (upcast != null) {
                CastNode irCastNode = new CastNode(irLoadNode.getLocation());
                irCastNode.setExpressionType(upcast.targetType);
                irCastNode.setCast(upcast);
                irCastNode.setChildNode(irLoadNode);
                irLoadNode = irCastNode;
            }
            if (concatenate) {
                StringConcatenationNode irStringConcatenationNode = (StringConcatenationNode)irCompoundNode;
                irStringConcatenationNode.addArgumentNode(irLoadNode);
                irStringConcatenationNode.addArgumentNode(irValueNode);
            } else {
                BinaryMathNode irBinaryMathNode = (BinaryMathNode)irCompoundNode;
                irBinaryMathNode.setLeftNode(irLoadNode);
                irBinaryMathNode.setRightNode(irValueNode);
            }
            irAssignmentNode = irStoreNode;
        } else {
            irAssignmentNode = (ExpressionNode)this.visit(userAssignmentNode.getLeftNode(), scriptScope);
            if (read) {
                int accessDepth = scriptScope.getDecoration(userAssignmentNode.getLeftNode(), Decorations.AccessDepth.class).getAccessDepth();
                DupNode irDupNode = new DupNode(irValueNode.getLocation());
                irDupNode.setExpressionType(irValueNode.getExpressionType());
                irDupNode.setSize(MethodWriter.getType(irValueNode.getExpressionType()).getSize());
                irDupNode.setDepth(accessDepth);
                irDupNode.setChildNode(irValueNode);
                irValueNode = irDupNode;
            }
            if (irAssignmentNode instanceof BinaryImplNode) {
                ((StoreNode)((BinaryImplNode)irAssignmentNode).getRightNode()).setChildNode(irValueNode);
            } else {
                ((StoreNode)irAssignmentNode).setChildNode(irValueNode);
            }
        }
        scriptScope.putDecoration(userAssignmentNode, new Decorations.IRNodeDecoration(irAssignmentNode));
    }

    @Override
    public void visitUnary(EUnary userUnaryNode, ScriptScope scriptScope) {
        IRNode irNode;
        Class<?> unaryType;
        Class<?> clazz = unaryType = scriptScope.hasDecoration(userUnaryNode, Decorations.UnaryType.class) ? scriptScope.getDecoration(userUnaryNode, Decorations.UnaryType.class).getUnaryType() : null;
        if (scriptScope.getCondition(userUnaryNode.getChildNode(), Decorations.Negate.class)) {
            irNode = this.visit(userUnaryNode.getChildNode(), scriptScope);
        } else {
            UnaryMathNode irUnaryMathNode = new UnaryMathNode(userUnaryNode.getLocation());
            irUnaryMathNode.setExpressionType(scriptScope.getDecoration(userUnaryNode, Decorations.ValueType.class).getValueType());
            irUnaryMathNode.setUnaryType(unaryType);
            irUnaryMathNode.setOperation(userUnaryNode.getOperation());
            irUnaryMathNode.setOriginallyExplicit(scriptScope.getCondition(userUnaryNode, Decorations.Explicit.class));
            irUnaryMathNode.setChildNode(this.injectCast(userUnaryNode.getChildNode(), scriptScope));
            irNode = irUnaryMathNode;
        }
        scriptScope.putDecoration(userUnaryNode, new Decorations.IRNodeDecoration(irNode));
    }

    @Override
    public void visitBinary(EBinary userBinaryNode, ScriptScope scriptScope) {
        ExpressionNode irExpressionNode;
        Operation operation = userBinaryNode.getOperation();
        Class<?> valueType = scriptScope.getDecoration(userBinaryNode, Decorations.ValueType.class).getValueType();
        if (operation == Operation.ADD && valueType == String.class) {
            StringConcatenationNode stringConcatenationNode = new StringConcatenationNode(userBinaryNode.getLocation());
            stringConcatenationNode.addArgumentNode((ExpressionNode)this.visit(userBinaryNode.getLeftNode(), scriptScope));
            stringConcatenationNode.addArgumentNode((ExpressionNode)this.visit(userBinaryNode.getRightNode(), scriptScope));
            irExpressionNode = stringConcatenationNode;
        } else {
            Class<?> shiftType = scriptScope.hasDecoration(userBinaryNode, Decorations.ShiftType.class) ? scriptScope.getDecoration(userBinaryNode, Decorations.ShiftType.class).getShiftType() : null;
            BinaryMathNode irBinaryMathNode = new BinaryMathNode(userBinaryNode.getLocation());
            if (operation == Operation.MATCH || operation == Operation.FIND) {
                irBinaryMathNode.setRegexLimit(scriptScope.getCompilerSettings().getRegexLimitFactor());
            }
            irBinaryMathNode.setBinaryType(scriptScope.getDecoration(userBinaryNode, Decorations.BinaryType.class).getBinaryType());
            irBinaryMathNode.setShiftType(shiftType);
            irBinaryMathNode.setOperation(operation);
            if (scriptScope.getCondition(userBinaryNode, Decorations.Explicit.class)) {
                irBinaryMathNode.setFlags(4);
            }
            irBinaryMathNode.setLeftNode(this.injectCast(userBinaryNode.getLeftNode(), scriptScope));
            irBinaryMathNode.setRightNode(this.injectCast(userBinaryNode.getRightNode(), scriptScope));
            irExpressionNode = irBinaryMathNode;
        }
        irExpressionNode.setExpressionType(valueType);
        scriptScope.putDecoration(userBinaryNode, new Decorations.IRNodeDecoration(irExpressionNode));
    }

    @Override
    public void visitBooleanComp(EBooleanComp userBooleanCompNode, ScriptScope scriptScope) {
        BooleanNode irBooleanNode = new BooleanNode(userBooleanCompNode.getLocation());
        irBooleanNode.setExpressionType(scriptScope.getDecoration(userBooleanCompNode, Decorations.ValueType.class).getValueType());
        irBooleanNode.setOperation(userBooleanCompNode.getOperation());
        irBooleanNode.setLeftNode(this.injectCast(userBooleanCompNode.getLeftNode(), scriptScope));
        irBooleanNode.setRightNode(this.injectCast(userBooleanCompNode.getRightNode(), scriptScope));
        scriptScope.putDecoration(userBooleanCompNode, new Decorations.IRNodeDecoration(irBooleanNode));
    }

    @Override
    public void visitComp(EComp userCompNode, ScriptScope scriptScope) {
        ComparisonNode irComparisonNode = new ComparisonNode(userCompNode.getLocation());
        irComparisonNode.setExpressionType(scriptScope.getDecoration(userCompNode, Decorations.ValueType.class).getValueType());
        irComparisonNode.setComparisonType(scriptScope.getDecoration(userCompNode, Decorations.ComparisonType.class).getComparisonType());
        irComparisonNode.setOperation(userCompNode.getOperation());
        irComparisonNode.setLeftNode(this.injectCast(userCompNode.getLeftNode(), scriptScope));
        irComparisonNode.setRightNode(this.injectCast(userCompNode.getRightNode(), scriptScope));
        scriptScope.putDecoration(userCompNode, new Decorations.IRNodeDecoration(irComparisonNode));
    }

    @Override
    public void visitExplicit(EExplicit userExplicitNode, ScriptScope scriptScope) {
        scriptScope.putDecoration(userExplicitNode, new Decorations.IRNodeDecoration(this.injectCast(userExplicitNode.getChildNode(), scriptScope)));
    }

    @Override
    public void visitInstanceof(EInstanceof userInstanceofNode, ScriptScope scriptScope) {
        InstanceofNode irInstanceofNode = new InstanceofNode(userInstanceofNode.getLocation());
        irInstanceofNode.setExpressionType(scriptScope.getDecoration(userInstanceofNode, Decorations.ValueType.class).getValueType());
        irInstanceofNode.setInstanceType(scriptScope.getDecoration(userInstanceofNode, Decorations.InstanceType.class).getInstanceType());
        irInstanceofNode.setChildNode((ExpressionNode)this.visit(userInstanceofNode.getExpressionNode(), scriptScope));
        scriptScope.putDecoration(userInstanceofNode, new Decorations.IRNodeDecoration(irInstanceofNode));
    }

    @Override
    public void visitConditional(EConditional userConditionalNode, ScriptScope scriptScope) {
        ConditionalNode irConditionalNode = new ConditionalNode(userConditionalNode.getLocation());
        irConditionalNode.setExpressionType(scriptScope.getDecoration(userConditionalNode, Decorations.ValueType.class).getValueType());
        irConditionalNode.setConditionNode(this.injectCast(userConditionalNode.getConditionNode(), scriptScope));
        irConditionalNode.setLeftNode(this.injectCast(userConditionalNode.getTrueNode(), scriptScope));
        irConditionalNode.setRightNode(this.injectCast(userConditionalNode.getFalseNode(), scriptScope));
        scriptScope.putDecoration(userConditionalNode, new Decorations.IRNodeDecoration(irConditionalNode));
    }

    @Override
    public void visitElvis(EElvis userElvisNode, ScriptScope scriptScope) {
        ElvisNode irElvisNode = new ElvisNode(userElvisNode.getLocation());
        irElvisNode.setExpressionType(scriptScope.getDecoration(userElvisNode, Decorations.ValueType.class).getValueType());
        irElvisNode.setLeftNode(this.injectCast(userElvisNode.getLeftNode(), scriptScope));
        irElvisNode.setRightNode(this.injectCast(userElvisNode.getRightNode(), scriptScope));
        scriptScope.putDecoration(userElvisNode, new Decorations.IRNodeDecoration(irElvisNode));
    }

    @Override
    public void visitListInit(EListInit userListInitNode, ScriptScope scriptScope) {
        ListInitializationNode irListInitializationNode = new ListInitializationNode(userListInitNode.getLocation());
        irListInitializationNode.setExpressionType(scriptScope.getDecoration(userListInitNode, Decorations.ValueType.class).getValueType());
        irListInitializationNode.setConstructor(scriptScope.getDecoration(userListInitNode, Decorations.StandardPainlessConstructor.class).getStandardPainlessConstructor());
        irListInitializationNode.setMethod(scriptScope.getDecoration(userListInitNode, Decorations.StandardPainlessMethod.class).getStandardPainlessMethod());
        for (AExpression userValueNode : userListInitNode.getValueNodes()) {
            irListInitializationNode.addArgumentNode(this.injectCast(userValueNode, scriptScope));
        }
        scriptScope.putDecoration(userListInitNode, new Decorations.IRNodeDecoration(irListInitializationNode));
    }

    @Override
    public void visitMapInit(EMapInit userMapInitNode, ScriptScope scriptScope) {
        MapInitializationNode irMapInitializationNode = new MapInitializationNode(userMapInitNode.getLocation());
        irMapInitializationNode.setExpressionType(scriptScope.getDecoration(userMapInitNode, Decorations.ValueType.class).getValueType());
        irMapInitializationNode.setConstructor(scriptScope.getDecoration(userMapInitNode, Decorations.StandardPainlessConstructor.class).getStandardPainlessConstructor());
        irMapInitializationNode.setMethod(scriptScope.getDecoration(userMapInitNode, Decorations.StandardPainlessMethod.class).getStandardPainlessMethod());
        for (int i = 0; i < userMapInitNode.getKeyNodes().size(); ++i) {
            irMapInitializationNode.addArgumentNode(this.injectCast(userMapInitNode.getKeyNodes().get(i), scriptScope), this.injectCast(userMapInitNode.getValueNodes().get(i), scriptScope));
        }
        scriptScope.putDecoration(userMapInitNode, new Decorations.IRNodeDecoration(irMapInitializationNode));
    }

    @Override
    public void visitNewArray(ENewArray userNewArrayNode, ScriptScope scriptScope) {
        NewArrayNode irNewArrayNode = new NewArrayNode(userNewArrayNode.getLocation());
        irNewArrayNode.setExpressionType(scriptScope.getDecoration(userNewArrayNode, Decorations.ValueType.class).getValueType());
        irNewArrayNode.setInitialize(userNewArrayNode.isInitializer());
        for (AExpression userArgumentNode : userNewArrayNode.getValueNodes()) {
            irNewArrayNode.addArgumentNode(this.injectCast(userArgumentNode, scriptScope));
        }
        scriptScope.putDecoration(userNewArrayNode, new Decorations.IRNodeDecoration(irNewArrayNode));
    }

    @Override
    public void visitNewObj(ENewObj userNewObjectNode, ScriptScope scriptScope) {
        NewObjectNode irNewObjectNode = new NewObjectNode(userNewObjectNode.getLocation());
        irNewObjectNode.setExpressionType(scriptScope.getDecoration(userNewObjectNode, Decorations.ValueType.class).getValueType());
        irNewObjectNode.setRead(scriptScope.getCondition(userNewObjectNode, Decorations.Read.class));
        irNewObjectNode.setConstructor(scriptScope.getDecoration(userNewObjectNode, Decorations.StandardPainlessConstructor.class).getStandardPainlessConstructor());
        for (AExpression userArgumentNode : userNewObjectNode.getArgumentNodes()) {
            irNewObjectNode.addArgumentNode(this.injectCast(userArgumentNode, scriptScope));
        }
        scriptScope.putDecoration(userNewObjectNode, new Decorations.IRNodeDecoration(irNewObjectNode));
    }

    @Override
    public void visitCallLocal(ECallLocal callLocalNode, ScriptScope scriptScope) {
        FieldNode irFieldNode;
        String bindingName;
        InvokeCallMemberNode irInvokeCallMemberNode = new InvokeCallMemberNode(callLocalNode.getLocation());
        if (scriptScope.hasDecoration(callLocalNode, Decorations.StandardLocalFunction.class)) {
            irInvokeCallMemberNode.setLocalFunction(scriptScope.getDecoration(callLocalNode, Decorations.StandardLocalFunction.class).getLocalFunction());
        } else if (scriptScope.hasDecoration(callLocalNode, Decorations.StandardPainlessMethod.class)) {
            irInvokeCallMemberNode.setImportedMethod(scriptScope.getDecoration(callLocalNode, Decorations.StandardPainlessMethod.class).getStandardPainlessMethod());
        } else if (scriptScope.hasDecoration(callLocalNode, Decorations.StandardPainlessClassBinding.class)) {
            PainlessClassBinding painlessClassBinding = scriptScope.getDecoration(callLocalNode, Decorations.StandardPainlessClassBinding.class).getPainlessClassBinding();
            bindingName = scriptScope.getNextSyntheticName("class_binding");
            irFieldNode = new FieldNode(callLocalNode.getLocation());
            irFieldNode.setModifiers(2);
            irFieldNode.setFieldType(painlessClassBinding.javaConstructor.getDeclaringClass());
            irFieldNode.setName(bindingName);
            this.irClassNode.addFieldNode(irFieldNode);
            irInvokeCallMemberNode.setClassBinding(painlessClassBinding);
            irInvokeCallMemberNode.setClassBindingOffset((Integer)scriptScope.getDecoration(callLocalNode, Decorations.StandardConstant.class).getStandardConstant());
            irInvokeCallMemberNode.setBindingName(bindingName);
        } else if (scriptScope.hasDecoration(callLocalNode, Decorations.StandardPainlessInstanceBinding.class)) {
            PainlessInstanceBinding painlessInstanceBinding = scriptScope.getDecoration(callLocalNode, Decorations.StandardPainlessInstanceBinding.class).getPainlessInstanceBinding();
            bindingName = scriptScope.getNextSyntheticName("instance_binding");
            irFieldNode = new FieldNode(callLocalNode.getLocation());
            irFieldNode.setModifiers(9);
            irFieldNode.setFieldType(painlessInstanceBinding.targetInstance.getClass());
            irFieldNode.setName(bindingName);
            this.irClassNode.addFieldNode(irFieldNode);
            irInvokeCallMemberNode.setInstanceBinding(painlessInstanceBinding);
            irInvokeCallMemberNode.setBindingName(bindingName);
            scriptScope.addStaticConstant(bindingName, painlessInstanceBinding.targetInstance);
        } else {
            throw callLocalNode.createError(new IllegalStateException("illegal tree structure"));
        }
        for (AExpression userArgumentNode : callLocalNode.getArgumentNodes()) {
            irInvokeCallMemberNode.addArgumentNode(this.injectCast(userArgumentNode, scriptScope));
        }
        irInvokeCallMemberNode.setExpressionType(scriptScope.getDecoration(callLocalNode, Decorations.ValueType.class).getValueType());
        scriptScope.putDecoration(callLocalNode, new Decorations.IRNodeDecoration(irInvokeCallMemberNode));
    }

    @Override
    public void visitBooleanConstant(EBooleanConstant userBooleanConstantNode, ScriptScope scriptScope) {
        ConstantNode irConstantNode = new ConstantNode(userBooleanConstantNode.getLocation());
        irConstantNode.setExpressionType(scriptScope.getDecoration(userBooleanConstantNode, Decorations.ValueType.class).getValueType());
        irConstantNode.setConstant(scriptScope.getDecoration(userBooleanConstantNode, Decorations.StandardConstant.class).getStandardConstant());
        scriptScope.putDecoration(userBooleanConstantNode, new Decorations.IRNodeDecoration(irConstantNode));
    }

    @Override
    public void visitNumeric(ENumeric userNumericNode, ScriptScope scriptScope) {
        ConstantNode irConstantNode = new ConstantNode(userNumericNode.getLocation());
        irConstantNode.setExpressionType(scriptScope.getDecoration(userNumericNode, Decorations.ValueType.class).getValueType());
        irConstantNode.setConstant(scriptScope.getDecoration(userNumericNode, Decorations.StandardConstant.class).getStandardConstant());
        scriptScope.putDecoration(userNumericNode, new Decorations.IRNodeDecoration(irConstantNode));
    }

    @Override
    public void visitDecimal(EDecimal userDecimalNode, ScriptScope scriptScope) {
        ConstantNode irConstantNode = new ConstantNode(userDecimalNode.getLocation());
        irConstantNode.setExpressionType(scriptScope.getDecoration(userDecimalNode, Decorations.ValueType.class).getValueType());
        irConstantNode.setConstant(scriptScope.getDecoration(userDecimalNode, Decorations.StandardConstant.class).getStandardConstant());
        scriptScope.putDecoration(userDecimalNode, new Decorations.IRNodeDecoration(irConstantNode));
    }

    @Override
    public void visitString(EString userStringNode, ScriptScope scriptScope) {
        ConstantNode irConstantNode = new ConstantNode(userStringNode.getLocation());
        irConstantNode.setExpressionType(scriptScope.getDecoration(userStringNode, Decorations.ValueType.class).getValueType());
        irConstantNode.setConstant(scriptScope.getDecoration(userStringNode, Decorations.StandardConstant.class).getStandardConstant());
        scriptScope.putDecoration(userStringNode, new Decorations.IRNodeDecoration(irConstantNode));
    }

    @Override
    public void visitNull(ENull userNullNode, ScriptScope scriptScope) {
        NullNode irNullNode = new NullNode(userNullNode.getLocation());
        irNullNode.setExpressionType(scriptScope.getDecoration(userNullNode, Decorations.ValueType.class).getValueType());
        scriptScope.putDecoration(userNullNode, new Decorations.IRNodeDecoration(irNullNode));
    }

    @Override
    public void visitRegex(ERegex userRegexNode, ScriptScope scriptScope) {
        String memberFieldName = scriptScope.getNextSyntheticName("regex");
        FieldNode irFieldNode = new FieldNode(userRegexNode.getLocation());
        irFieldNode.setModifiers(26);
        irFieldNode.setFieldType(Pattern.class);
        irFieldNode.setName(memberFieldName);
        this.irClassNode.addFieldNode(irFieldNode);
        try {
            StatementExpressionNode irStatementExpressionNode = new StatementExpressionNode(userRegexNode.getLocation());
            BlockNode blockNode = this.irClassNode.getClinitBlockNode();
            blockNode.addStatementNode(irStatementExpressionNode);
            StoreFieldMemberNode irStoreFieldMemberNode = new StoreFieldMemberNode(userRegexNode.getLocation());
            irStoreFieldMemberNode.setExpressionType(Void.TYPE);
            irStoreFieldMemberNode.setStoreType(Pattern.class);
            irStoreFieldMemberNode.setName(memberFieldName);
            irStoreFieldMemberNode.setStatic(true);
            irStatementExpressionNode.setExpressionNode(irStoreFieldMemberNode);
            BinaryImplNode irBinaryImplNode = new BinaryImplNode(userRegexNode.getLocation());
            irBinaryImplNode.setExpressionType(Pattern.class);
            irStoreFieldMemberNode.setChildNode(irBinaryImplNode);
            StaticNode irStaticNode = new StaticNode(userRegexNode.getLocation());
            irStaticNode.setExpressionType(Pattern.class);
            irBinaryImplNode.setLeftNode(irStaticNode);
            InvokeCallNode invokeCallNode = new InvokeCallNode(userRegexNode.getLocation());
            invokeCallNode.setExpressionType(Pattern.class);
            invokeCallNode.setBox(Pattern.class);
            invokeCallNode.setMethod(new PainlessMethod(Pattern.class.getMethod("compile", String.class, Integer.TYPE), Pattern.class, Pattern.class, Arrays.asList(String.class, Integer.TYPE), null, null, null));
            irBinaryImplNode.setRightNode(invokeCallNode);
            ConstantNode irConstantNode = new ConstantNode(userRegexNode.getLocation());
            irConstantNode.setExpressionType(String.class);
            irConstantNode.setConstant(userRegexNode.getPattern());
            invokeCallNode.addArgumentNode(irConstantNode);
            irConstantNode = new ConstantNode(userRegexNode.getLocation());
            irConstantNode.setExpressionType(Integer.TYPE);
            irConstantNode.setConstant(scriptScope.getDecoration(userRegexNode, Decorations.StandardConstant.class).getStandardConstant());
            invokeCallNode.addArgumentNode(irConstantNode);
        }
        catch (Exception exception) {
            throw userRegexNode.createError(new IllegalStateException("illegal tree structure"));
        }
        LoadFieldMemberNode irLoadFieldMemberNode = new LoadFieldMemberNode(userRegexNode.getLocation());
        irLoadFieldMemberNode.setExpressionType(Pattern.class);
        irLoadFieldMemberNode.setName(memberFieldName);
        irLoadFieldMemberNode.setStatic(true);
        scriptScope.putDecoration(userRegexNode, new Decorations.IRNodeDecoration(irLoadFieldMemberNode));
    }

    @Override
    public void visitLambda(ELambda userLambdaNode, ScriptScope scriptScope) {
        ReferenceNode irReferenceNode;
        if (scriptScope.hasDecoration(userLambdaNode, Decorations.TargetType.class)) {
            TypedInterfaceReferenceNode typedInterfaceReferenceNode = new TypedInterfaceReferenceNode(userLambdaNode.getLocation());
            typedInterfaceReferenceNode.setReference(scriptScope.getDecoration(userLambdaNode, Decorations.ReferenceDecoration.class).getReference());
            irReferenceNode = typedInterfaceReferenceNode;
        } else {
            DefInterfaceReferenceNode defInterfaceReferenceNode = new DefInterfaceReferenceNode(userLambdaNode.getLocation());
            defInterfaceReferenceNode.setDefReferenceEncoding(scriptScope.getDecoration(userLambdaNode, Decorations.EncodingDecoration.class).getEncoding());
            irReferenceNode = defInterfaceReferenceNode;
        }
        FunctionNode irFunctionNode = new FunctionNode(userLambdaNode.getLocation());
        irFunctionNode.setBlockNode((BlockNode)this.visit(userLambdaNode.getBlockNode(), scriptScope));
        irFunctionNode.setName(scriptScope.getDecoration(userLambdaNode, Decorations.MethodNameDecoration.class).getMethodName());
        irFunctionNode.setReturnType(scriptScope.getDecoration(userLambdaNode, Decorations.ReturnType.class).getReturnType());
        irFunctionNode.getTypeParameters().addAll(scriptScope.getDecoration(userLambdaNode, Decorations.TypeParameters.class).getTypeParameters());
        irFunctionNode.getParameterNames().addAll(scriptScope.getDecoration(userLambdaNode, Decorations.ParameterNames.class).getParameterNames());
        irFunctionNode.setStatic(true);
        irFunctionNode.setVarArgs(false);
        irFunctionNode.setSynthetic(true);
        irFunctionNode.setMaxLoopCounter(scriptScope.getCompilerSettings().getMaxLoopCounter());
        this.irClassNode.addFunctionNode(irFunctionNode);
        irReferenceNode.setExpressionType(scriptScope.getDecoration(userLambdaNode, Decorations.ValueType.class).getValueType());
        List<SemanticScope.Variable> captures = scriptScope.getDecoration(userLambdaNode, Decorations.CapturesDecoration.class).getCaptures();
        for (SemanticScope.Variable capture : captures) {
            irReferenceNode.addCapture(capture.getName());
        }
        scriptScope.putDecoration(userLambdaNode, new Decorations.IRNodeDecoration(irReferenceNode));
    }

    @Override
    public void visitFunctionRef(EFunctionRef userFunctionRefNode, ScriptScope scriptScope) {
        ReferenceNode irReferenceNode;
        Decorations.TargetType targetType = scriptScope.getDecoration(userFunctionRefNode, Decorations.TargetType.class);
        Decorations.CapturesDecoration capturesDecoration = scriptScope.getDecoration(userFunctionRefNode, Decorations.CapturesDecoration.class);
        if (targetType == null) {
            DefInterfaceReferenceNode defInterfaceReferenceNode = new DefInterfaceReferenceNode(userFunctionRefNode.getLocation());
            defInterfaceReferenceNode.setDefReferenceEncoding(scriptScope.getDecoration(userFunctionRefNode, Decorations.EncodingDecoration.class).getEncoding());
            irReferenceNode = defInterfaceReferenceNode;
        } else if (capturesDecoration != null && capturesDecoration.getCaptures().get(0).getType() == def.class) {
            TypedCaptureReferenceNode typedCaptureReferenceNode = new TypedCaptureReferenceNode(userFunctionRefNode.getLocation());
            typedCaptureReferenceNode.setMethodName(userFunctionRefNode.getMethodName());
            irReferenceNode = typedCaptureReferenceNode;
        } else {
            TypedInterfaceReferenceNode typedInterfaceReferenceNode = new TypedInterfaceReferenceNode(userFunctionRefNode.getLocation());
            typedInterfaceReferenceNode.setReference(scriptScope.getDecoration(userFunctionRefNode, Decorations.ReferenceDecoration.class).getReference());
            irReferenceNode = typedInterfaceReferenceNode;
        }
        irReferenceNode.setExpressionType(scriptScope.getDecoration(userFunctionRefNode, Decorations.ValueType.class).getValueType());
        if (capturesDecoration != null) {
            irReferenceNode.addCapture(capturesDecoration.getCaptures().get(0).getName());
        }
        scriptScope.putDecoration(userFunctionRefNode, new Decorations.IRNodeDecoration(irReferenceNode));
    }

    @Override
    public void visitNewArrayFunctionRef(ENewArrayFunctionRef userNewArrayFunctionRefNode, ScriptScope scriptScope) {
        ReferenceNode irReferenceNode;
        if (scriptScope.hasDecoration(userNewArrayFunctionRefNode, Decorations.TargetType.class)) {
            TypedInterfaceReferenceNode typedInterfaceReferenceNode = new TypedInterfaceReferenceNode(userNewArrayFunctionRefNode.getLocation());
            typedInterfaceReferenceNode.setReference(scriptScope.getDecoration(userNewArrayFunctionRefNode, Decorations.ReferenceDecoration.class).getReference());
            irReferenceNode = typedInterfaceReferenceNode;
        } else {
            DefInterfaceReferenceNode defInterfaceReferenceNode = new DefInterfaceReferenceNode(userNewArrayFunctionRefNode.getLocation());
            defInterfaceReferenceNode.setDefReferenceEncoding(scriptScope.getDecoration(userNewArrayFunctionRefNode, Decorations.EncodingDecoration.class).getEncoding());
            irReferenceNode = defInterfaceReferenceNode;
        }
        Class<?> returnType = scriptScope.getDecoration(userNewArrayFunctionRefNode, Decorations.ReturnType.class).getReturnType();
        LoadVariableNode irLoadVariableNode = new LoadVariableNode(userNewArrayFunctionRefNode.getLocation());
        irLoadVariableNode.setExpressionType(Integer.TYPE);
        irLoadVariableNode.setName("size");
        NewArrayNode irNewArrayNode = new NewArrayNode(userNewArrayFunctionRefNode.getLocation());
        irNewArrayNode.setExpressionType(returnType);
        irNewArrayNode.setInitialize(false);
        irNewArrayNode.addArgumentNode(irLoadVariableNode);
        ReturnNode irReturnNode = new ReturnNode(userNewArrayFunctionRefNode.getLocation());
        irReturnNode.setExpressionNode(irNewArrayNode);
        BlockNode irBlockNode = new BlockNode(userNewArrayFunctionRefNode.getLocation());
        irBlockNode.setAllEscape(true);
        irBlockNode.addStatementNode(irReturnNode);
        FunctionNode irFunctionNode = new FunctionNode(userNewArrayFunctionRefNode.getLocation());
        irFunctionNode.setMaxLoopCounter(0);
        irFunctionNode.setName(scriptScope.getDecoration(userNewArrayFunctionRefNode, Decorations.MethodNameDecoration.class).getMethodName());
        irFunctionNode.setReturnType(returnType);
        irFunctionNode.addTypeParameter(Integer.TYPE);
        irFunctionNode.addParameterName("size");
        irFunctionNode.setStatic(true);
        irFunctionNode.setVarArgs(false);
        irFunctionNode.setSynthetic(true);
        irFunctionNode.setBlockNode(irBlockNode);
        this.irClassNode.addFunctionNode(irFunctionNode);
        irReferenceNode.setExpressionType(scriptScope.getDecoration(userNewArrayFunctionRefNode, Decorations.ValueType.class).getValueType());
        scriptScope.putDecoration(userNewArrayFunctionRefNode, new Decorations.IRNodeDecoration(irReferenceNode));
    }

    @Override
    public void visitSymbol(ESymbol userSymbolNode, ScriptScope scriptScope) {
        ExpressionNode irExpressionNode;
        if (scriptScope.hasDecoration(userSymbolNode, Decorations.StaticType.class)) {
            Class<?> staticType = scriptScope.getDecoration(userSymbolNode, Decorations.StaticType.class).getStaticType();
            StaticNode staticNode = new StaticNode(userSymbolNode.getLocation());
            staticNode.setExpressionType(staticType);
            irExpressionNode = staticNode;
        } else if (scriptScope.hasDecoration(userSymbolNode, Decorations.ValueType.class)) {
            boolean read = scriptScope.getCondition(userSymbolNode, Decorations.Read.class);
            boolean write = scriptScope.getCondition(userSymbolNode, Decorations.Write.class);
            boolean compound = scriptScope.getCondition(userSymbolNode, Decorations.Compound.class);
            Location location = userSymbolNode.getLocation();
            String symbol = userSymbolNode.getSymbol();
            Class<?> valueType = scriptScope.getDecoration(userSymbolNode, Decorations.ValueType.class).getValueType();
            StoreVariableNode irStoreNode = null;
            LoadVariableNode irLoadNode = null;
            if (write || compound) {
                StoreVariableNode irStoreVariableNode = new StoreVariableNode(location);
                irStoreVariableNode.setExpressionType(read ? valueType : Void.TYPE);
                irStoreVariableNode.setStoreType(valueType);
                irStoreVariableNode.setName(symbol);
                irStoreNode = irStoreVariableNode;
            }
            if (!write || compound) {
                LoadVariableNode irLoadVariableNode = new LoadVariableNode(location);
                irLoadVariableNode.setExpressionType(valueType);
                irLoadVariableNode.setName(symbol);
                irLoadNode = irLoadVariableNode;
            }
            scriptScope.putDecoration(userSymbolNode, new Decorations.AccessDepth(0));
            irExpressionNode = this.buildLoadStore(0, location, false, null, null, irLoadNode, irStoreNode);
        } else {
            throw userSymbolNode.createError(new IllegalStateException("illegal tree structure"));
        }
        scriptScope.putDecoration(userSymbolNode, new Decorations.IRNodeDecoration(irExpressionNode));
    }

    @Override
    public void visitDot(EDot userDotNode, ScriptScope scriptScope) {
        ExpressionNode irExpressionNode;
        if (scriptScope.hasDecoration(userDotNode, Decorations.StaticType.class)) {
            Class<?> staticType = scriptScope.getDecoration(userDotNode, Decorations.StaticType.class).getStaticType();
            StaticNode staticNode = new StaticNode(userDotNode.getLocation());
            staticNode.setExpressionType(staticType);
            irExpressionNode = staticNode;
        } else {
            int accessDepth;
            boolean read = scriptScope.getCondition(userDotNode, Decorations.Read.class);
            boolean write = scriptScope.getCondition(userDotNode, Decorations.Write.class);
            boolean compound = scriptScope.getCondition(userDotNode, Decorations.Compound.class);
            Location location = userDotNode.getLocation();
            String index = userDotNode.getIndex();
            Class<?> valueType = scriptScope.getDecoration(userDotNode, Decorations.ValueType.class).getValueType();
            Decorations.ValueType prefixValueType = scriptScope.getDecoration(userDotNode.getPrefixNode(), Decorations.ValueType.class);
            ExpressionNode irPrefixNode = (ExpressionNode)this.visit(userDotNode.getPrefixNode(), scriptScope);
            ConstantNode irIndexNode = null;
            StoreNode irStoreNode = null;
            ExpressionNode irLoadNode = null;
            if (prefixValueType != null && prefixValueType.getValueType().isArray()) {
                LoadDotArrayLengthNode irLoadDotArrayLengthNode = new LoadDotArrayLengthNode(location);
                irLoadDotArrayLengthNode.setExpressionType(Integer.TYPE);
                irLoadNode = irLoadDotArrayLengthNode;
                accessDepth = 1;
            } else if (prefixValueType != null && prefixValueType.getValueType() == def.class) {
                if (write || compound) {
                    StoreDotDefNode irStoreDotDefNode = new StoreDotDefNode(location);
                    irStoreDotDefNode.setExpressionType(read ? valueType : Void.TYPE);
                    irStoreDotDefNode.setStoreType(valueType);
                    irStoreDotDefNode.setValue(index);
                    irStoreNode = irStoreDotDefNode;
                }
                if (!write || compound) {
                    LoadDotDefNode irLoadDotDefNode = new LoadDotDefNode(location);
                    irLoadDotDefNode.setExpressionType(valueType);
                    irLoadDotDefNode.setValue(index);
                    irLoadNode = irLoadDotDefNode;
                }
                accessDepth = 1;
            } else if (scriptScope.hasDecoration(userDotNode, Decorations.StandardPainlessField.class)) {
                PainlessField painlessField = scriptScope.getDecoration(userDotNode, Decorations.StandardPainlessField.class).getStandardPainlessField();
                if (write || compound) {
                    StoreDotNode irStoreDotNode = new StoreDotNode(location);
                    irStoreDotNode.setExpressionType(read ? valueType : Void.TYPE);
                    irStoreDotNode.setStoreType(valueType);
                    irStoreDotNode.setField(painlessField);
                    irStoreNode = irStoreDotNode;
                }
                if (!write || compound) {
                    LoadDotNode irLoadDotNode = new LoadDotNode(location);
                    irLoadDotNode.setExpressionType(valueType);
                    irLoadDotNode.setField(painlessField);
                    irLoadNode = irLoadDotNode;
                }
                accessDepth = 1;
            } else if (scriptScope.getCondition(userDotNode, Decorations.Shortcut.class)) {
                if (write || compound) {
                    StoreDotShortcutNode irStoreDotShortcutNode = new StoreDotShortcutNode(location);
                    irStoreDotShortcutNode.setExpressionType(read ? valueType : Void.TYPE);
                    irStoreDotShortcutNode.setStoreType(valueType);
                    irStoreDotShortcutNode.setSetter(scriptScope.getDecoration(userDotNode, Decorations.SetterPainlessMethod.class).getSetterPainlessMethod());
                    irStoreNode = irStoreDotShortcutNode;
                }
                if (!write || compound) {
                    LoadDotShortcutNode irLoadDotShortcutNode = new LoadDotShortcutNode(location);
                    irLoadDotShortcutNode.setExpressionType(valueType);
                    irLoadDotShortcutNode.setGetter(scriptScope.getDecoration(userDotNode, Decorations.GetterPainlessMethod.class).getGetterPainlessMethod());
                    irLoadNode = irLoadDotShortcutNode;
                }
                accessDepth = 1;
            } else if (scriptScope.getCondition(userDotNode, Decorations.MapShortcut.class)) {
                ConstantNode irConstantNode = new ConstantNode(location);
                irConstantNode.setExpressionType(String.class);
                irConstantNode.setConstant(index);
                irIndexNode = irConstantNode;
                if (write || compound) {
                    StoreMapShortcutNode irStoreMapShortcutNode = new StoreMapShortcutNode(location);
                    irStoreMapShortcutNode.setExpressionType(read ? valueType : Void.TYPE);
                    irStoreMapShortcutNode.setStoreType(valueType);
                    irStoreMapShortcutNode.setSetter(scriptScope.getDecoration(userDotNode, Decorations.SetterPainlessMethod.class).getSetterPainlessMethod());
                    irStoreNode = irStoreMapShortcutNode;
                }
                if (!write || compound) {
                    LoadMapShortcutNode irLoadMapShortcutNode = new LoadMapShortcutNode(location);
                    irLoadMapShortcutNode.setExpressionType(valueType);
                    irLoadMapShortcutNode.setGetter(scriptScope.getDecoration(userDotNode, Decorations.GetterPainlessMethod.class).getGetterPainlessMethod());
                    irLoadNode = irLoadMapShortcutNode;
                }
                accessDepth = 2;
            } else if (scriptScope.getCondition(userDotNode, Decorations.ListShortcut.class)) {
                ConstantNode irConstantNode = new ConstantNode(location);
                irConstantNode.setExpressionType(Integer.TYPE);
                irConstantNode.setConstant(scriptScope.getDecoration(userDotNode, Decorations.StandardConstant.class).getStandardConstant());
                irIndexNode = irConstantNode;
                if (write || compound) {
                    StoreListShortcutNode irStoreListShortcutNode = new StoreListShortcutNode(location);
                    irStoreListShortcutNode.setExpressionType(read ? valueType : Void.TYPE);
                    irStoreListShortcutNode.setStoreType(valueType);
                    irStoreListShortcutNode.setSetter(scriptScope.getDecoration(userDotNode, Decorations.SetterPainlessMethod.class).getSetterPainlessMethod());
                    irStoreNode = irStoreListShortcutNode;
                }
                if (!write || compound) {
                    LoadListShortcutNode irLoadListShortcutNode = new LoadListShortcutNode(location);
                    irLoadListShortcutNode.setExpressionType(valueType);
                    irLoadListShortcutNode.setGetter(scriptScope.getDecoration(userDotNode, Decorations.GetterPainlessMethod.class).getGetterPainlessMethod());
                    irLoadNode = irLoadListShortcutNode;
                }
                accessDepth = 2;
            } else {
                throw userDotNode.createError(new IllegalStateException("illegal tree structure"));
            }
            scriptScope.putDecoration(userDotNode, new Decorations.AccessDepth(accessDepth));
            irExpressionNode = this.buildLoadStore(accessDepth, location, userDotNode.isNullSafe(), irPrefixNode, irIndexNode, irLoadNode, irStoreNode);
        }
        scriptScope.putDecoration(userDotNode, new Decorations.IRNodeDecoration(irExpressionNode));
    }

    @Override
    public void visitBrace(EBrace userBraceNode, ScriptScope scriptScope) {
        boolean read = scriptScope.getCondition(userBraceNode, Decorations.Read.class);
        boolean write = scriptScope.getCondition(userBraceNode, Decorations.Write.class);
        boolean compound = scriptScope.getCondition(userBraceNode, Decorations.Compound.class);
        Location location = userBraceNode.getLocation();
        Class<?> valueType = scriptScope.getDecoration(userBraceNode, Decorations.ValueType.class).getValueType();
        Class<?> prefixValueType = scriptScope.getDecoration(userBraceNode.getPrefixNode(), Decorations.ValueType.class).getValueType();
        ExpressionNode irPrefixNode = (ExpressionNode)this.visit(userBraceNode.getPrefixNode(), scriptScope);
        ExpressionNode irIndexNode = this.injectCast(userBraceNode.getIndexNode(), scriptScope);
        StoreNode irStoreNode = null;
        ExpressionNode irLoadNode = null;
        if (prefixValueType.isArray()) {
            FlipArrayIndexNode irFlipArrayIndexNode = new FlipArrayIndexNode(userBraceNode.getIndexNode().getLocation());
            irFlipArrayIndexNode.setExpressionType(Integer.TYPE);
            irFlipArrayIndexNode.setChildNode(irIndexNode);
            irIndexNode = irFlipArrayIndexNode;
            if (write || compound) {
                StoreBraceNode irStoreBraceNode = new StoreBraceNode(location);
                irStoreBraceNode.setExpressionType(read ? valueType : Void.TYPE);
                irStoreBraceNode.setStoreType(valueType);
                irStoreNode = irStoreBraceNode;
            }
            if (!write || compound) {
                LoadBraceNode irLoadBraceNode = new LoadBraceNode(location);
                irLoadBraceNode.setExpressionType(valueType);
                irLoadNode = irLoadBraceNode;
            }
        } else if (prefixValueType == def.class) {
            Class<?> indexType = scriptScope.getDecoration(userBraceNode.getIndexNode(), Decorations.ValueType.class).getValueType();
            FlipDefIndexNode irFlipDefIndexNode = new FlipDefIndexNode(userBraceNode.getIndexNode().getLocation());
            irFlipDefIndexNode.setExpressionType(indexType);
            irFlipDefIndexNode.setChildNode(irIndexNode);
            irIndexNode = irFlipDefIndexNode;
            if (write || compound) {
                StoreBraceDefNode irStoreBraceNode = new StoreBraceDefNode(location);
                irStoreBraceNode.setExpressionType(read ? valueType : Void.TYPE);
                irStoreBraceNode.setStoreType(valueType);
                irStoreBraceNode.setIndexType(indexType);
                irStoreNode = irStoreBraceNode;
            }
            if (!write || compound) {
                LoadBraceDefNode irLoadBraceDefNode = new LoadBraceDefNode(location);
                irLoadBraceDefNode.setExpressionType(valueType);
                irLoadBraceDefNode.setIndexType(indexType);
                irLoadNode = irLoadBraceDefNode;
            }
        } else if (scriptScope.getCondition(userBraceNode, Decorations.MapShortcut.class)) {
            if (write || compound) {
                StoreMapShortcutNode irStoreMapShortcutNode = new StoreMapShortcutNode(location);
                irStoreMapShortcutNode.setExpressionType(read ? valueType : Void.TYPE);
                irStoreMapShortcutNode.setStoreType(valueType);
                irStoreMapShortcutNode.setSetter(scriptScope.getDecoration(userBraceNode, Decorations.SetterPainlessMethod.class).getSetterPainlessMethod());
                irStoreNode = irStoreMapShortcutNode;
            }
            if (!write || compound) {
                LoadMapShortcutNode irLoadMapShortcutNode = new LoadMapShortcutNode(location);
                irLoadMapShortcutNode.setExpressionType(scriptScope.getDecoration(userBraceNode, Decorations.ValueType.class).getValueType());
                irLoadMapShortcutNode.setGetter(scriptScope.getDecoration(userBraceNode, Decorations.GetterPainlessMethod.class).getGetterPainlessMethod());
                irLoadNode = irLoadMapShortcutNode;
            }
        } else if (scriptScope.getCondition(userBraceNode, Decorations.ListShortcut.class)) {
            FlipCollectionIndexNode irFlipCollectionIndexNode = new FlipCollectionIndexNode(userBraceNode.getIndexNode().getLocation());
            irFlipCollectionIndexNode.setExpressionType(Integer.TYPE);
            irFlipCollectionIndexNode.setChildNode(irIndexNode);
            irIndexNode = irFlipCollectionIndexNode;
            if (write || compound) {
                StoreListShortcutNode irStoreListShortcutNode = new StoreListShortcutNode(location);
                irStoreListShortcutNode.setExpressionType(read ? valueType : Void.TYPE);
                irStoreListShortcutNode.setStoreType(valueType);
                irStoreListShortcutNode.setSetter(scriptScope.getDecoration(userBraceNode, Decorations.SetterPainlessMethod.class).getSetterPainlessMethod());
                irStoreNode = irStoreListShortcutNode;
            }
            if (!write || compound) {
                LoadListShortcutNode irLoadListShortcutNode = new LoadListShortcutNode(location);
                irLoadListShortcutNode.setExpressionType(scriptScope.getDecoration(userBraceNode, Decorations.ValueType.class).getValueType());
                irLoadListShortcutNode.setGetter(scriptScope.getDecoration(userBraceNode, Decorations.GetterPainlessMethod.class).getGetterPainlessMethod());
                irLoadNode = irLoadListShortcutNode;
            }
        } else {
            throw userBraceNode.createError(new IllegalStateException("illegal tree structure"));
        }
        scriptScope.putDecoration(userBraceNode, new Decorations.AccessDepth(2));
        scriptScope.putDecoration(userBraceNode, new Decorations.IRNodeDecoration(this.buildLoadStore(2, location, false, irPrefixNode, irIndexNode, irLoadNode, irStoreNode)));
    }

    @Override
    public void visitCall(ECall userCallNode, ScriptScope scriptScope) {
        ExpressionNode irExpressionNode;
        Decorations.ValueType prefixValueType = scriptScope.getDecoration(userCallNode.getPrefixNode(), Decorations.ValueType.class);
        if (prefixValueType != null && prefixValueType.getValueType() == def.class) {
            InvokeCallDefNode irCallSubDefNode = new InvokeCallDefNode(userCallNode.getLocation());
            for (AExpression userArgumentNode : userCallNode.getArgumentNodes()) {
                irCallSubDefNode.addArgumentNode((ExpressionNode)this.visit(userArgumentNode, scriptScope));
            }
            irCallSubDefNode.setExpressionType(scriptScope.getDecoration(userCallNode, Decorations.ValueType.class).getValueType());
            irCallSubDefNode.setName(userCallNode.getMethodName());
            irExpressionNode = irCallSubDefNode;
        } else {
            Class<?> boxType = prefixValueType != null ? prefixValueType.getValueType() : scriptScope.getDecoration(userCallNode.getPrefixNode(), Decorations.StaticType.class).getStaticType();
            InvokeCallNode irInvokeCallNode = new InvokeCallNode(userCallNode.getLocation());
            PainlessMethod method = scriptScope.getDecoration(userCallNode, Decorations.StandardPainlessMethod.class).getStandardPainlessMethod();
            Object[] injections = PainlessLookupUtility.buildInjections(method, scriptScope.getCompilerSettings().asMap());
            Class<?>[] parameterTypes = method.javaMethod.getParameterTypes();
            int augmentedOffset = method.javaMethod.getDeclaringClass() == method.targetClass ? 0 : 1;
            for (int i = 0; i < injections.length; ++i) {
                Class<?> parameterType = parameterTypes[i + augmentedOffset];
                Object injection = injections[i];
                if (parameterType != PainlessLookupUtility.typeToUnboxedType(injection.getClass())) {
                    throw new IllegalStateException("illegal tree structure");
                }
                ConstantNode constantNode = new ConstantNode(userCallNode.getLocation());
                constantNode.setExpressionType(parameterType);
                constantNode.setConstant(injection);
                irInvokeCallNode.addArgumentNode(constantNode);
            }
            for (AExpression userCallArgumentNode : userCallNode.getArgumentNodes()) {
                irInvokeCallNode.addArgumentNode(this.injectCast(userCallArgumentNode, scriptScope));
            }
            irInvokeCallNode.setExpressionType(scriptScope.getDecoration(userCallNode, Decorations.ValueType.class).getValueType());
            irInvokeCallNode.setMethod(scriptScope.getDecoration(userCallNode, Decorations.StandardPainlessMethod.class).getStandardPainlessMethod());
            irInvokeCallNode.setBox(boxType);
            irExpressionNode = irInvokeCallNode;
        }
        if (userCallNode.isNullSafe()) {
            NullSafeSubNode irNullSafeSubNode = new NullSafeSubNode(irExpressionNode.getLocation());
            irNullSafeSubNode.setChildNode(irExpressionNode);
            irNullSafeSubNode.setExpressionType(irExpressionNode.getExpressionType());
            irExpressionNode = irNullSafeSubNode;
        }
        BinaryImplNode irBinaryImplNode = new BinaryImplNode(irExpressionNode.getLocation());
        irBinaryImplNode.setLeftNode((ExpressionNode)this.visit(userCallNode.getPrefixNode(), scriptScope));
        irBinaryImplNode.setRightNode(irExpressionNode);
        irBinaryImplNode.setExpressionType(irExpressionNode.getExpressionType());
        scriptScope.putDecoration(userCallNode, new Decorations.IRNodeDecoration(irBinaryImplNode));
    }
}

