/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.operation.overlayng.OverlayEdge;
import org.locationtech.jts.operation.overlayng.OverlayGraph;
import org.locationtech.jts.operation.overlayng.OverlayLabel;

class IntersectionPointBuilder {
    private GeometryFactory geometryFactory;
    private OverlayGraph graph;
    private List<Point> points = new ArrayList<Point>();
    private boolean isAllowCollapseLines = true;

    public IntersectionPointBuilder(OverlayGraph graph, GeometryFactory geomFact) {
        this.graph = graph;
        this.geometryFactory = geomFact;
    }

    public void setStrictMode(boolean isStrictMode) {
        this.isAllowCollapseLines = !isStrictMode;
    }

    public List<Point> getPoints() {
        this.addResultPoints();
        return this.points;
    }

    private void addResultPoints() {
        for (OverlayEdge nodeEdge : this.graph.getNodeEdges()) {
            if (!this.isResultPoint(nodeEdge)) continue;
            Point pt = this.geometryFactory.createPoint(nodeEdge.getCoordinate().copy());
            this.points.add(pt);
        }
    }

    private boolean isResultPoint(OverlayEdge nodeEdge) {
        boolean isEdgeOfA = false;
        boolean isEdgeOfB = false;
        OverlayEdge edge = nodeEdge;
        do {
            if (edge.isInResult()) {
                return false;
            }
            OverlayLabel label = edge.getLabel();
            isEdgeOfA |= this.isEdgeOf(label, 0);
            isEdgeOfB |= this.isEdgeOf(label, 1);
        } while ((edge = (OverlayEdge)edge.oNext()) != nodeEdge);
        boolean isNodeInBoth = isEdgeOfA && isEdgeOfB;
        return isNodeInBoth;
    }

    private boolean isEdgeOf(OverlayLabel label, int i) {
        if (!this.isAllowCollapseLines && label.isBoundaryCollapse()) {
            return false;
        }
        return label.isBoundary(i) || label.isLine(i);
    }
}

