/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1;

public enum TagConstructed {
    PRIMITIVE(0, false),
    CONSTRUCTED(1, true);

    private final int intValue;
    private final boolean booleanValue;

    private TagConstructed(int intValue, boolean booleanValue) {
        this.intValue = intValue;
        this.booleanValue = booleanValue;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public boolean getBooleanValue() {
        return this.booleanValue;
    }

    public static TagConstructed fromIntValue(int intValue) {
        TagConstructed tagConstructed = PRIMITIVE;
        for (TagConstructed currentTagConstructed : TagConstructed.values()) {
            if (currentTagConstructed.getIntValue() != intValue) continue;
            tagConstructed = currentTagConstructed;
            break;
        }
        return tagConstructed;
    }

    public static TagConstructed fromBooleanValue(boolean booleanValue) {
        TagConstructed tagConstructed = PRIMITIVE;
        for (TagConstructed currentTagConstructed : TagConstructed.values()) {
            if (currentTagConstructed.getBooleanValue() != booleanValue) continue;
            tagConstructed = currentTagConstructed;
            break;
        }
        return tagConstructed;
    }

    public static TagConstructed fromIdentifierByte(byte identifierByte) {
        return TagConstructed.fromBooleanValue((identifierByte & 0x20) != 0);
    }
}

