/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.extraction;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.solr.handler.extraction.XLSXWriter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.RawResponseWriter;
import org.apache.solr.response.SolrQueryResponse;

public class XLSXResponseWriter
extends RawResponseWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream out, SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        XLSXWriter w = new XLSXWriter(new CharArrayWriter(), req, rsp);
        LinkedHashMap<String, String> reqNamesMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, Integer> reqWidthsMap = new LinkedHashMap<String, Integer>();
        Iterator paramNamesIter = req.getParams().getParameterNamesIterator();
        while (paramNamesIter.hasNext()) {
            String field;
            String nextParam = (String)paramNamesIter.next();
            if (nextParam.startsWith("colname.")) {
                field = nextParam.substring("colname.".length());
                reqNamesMap.put(field, req.getParams().get(nextParam));
                continue;
            }
            if (!nextParam.startsWith("colwidth.")) continue;
            field = nextParam.substring("colwidth.".length());
            reqWidthsMap.put(field, req.getParams().getInt(nextParam));
        }
        try {
            w.writeResponse(out, reqNamesMap, reqWidthsMap);
        }
        finally {
            w.close();
        }
    }

    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    }
}

