/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.tagger;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IntsRef;

class TermPrefixCursor {
    private static final byte SEPARATOR_CHAR = 31;
    private static final IntsRef EMPTY_INTSREF = new IntsRef();
    private final TermsEnum termsEnum;
    private final Bits liveDocs;
    private final Map<BytesRef, IntsRef> docIdsCache;
    private BytesRef prefixBuf;
    private BytesRefBuilder prefixBufBuilder = new BytesRefBuilder();
    private boolean prefixBufOnLoan;
    private PostingsEnum postingsEnum;
    private IntsRef docIds;

    TermPrefixCursor(TermsEnum termsEnum, Bits liveDocs, Map<BytesRef, IntsRef> docIdsCache) {
        this.termsEnum = termsEnum;
        this.liveDocs = liveDocs;
        this.docIdsCache = docIdsCache;
    }

    boolean advance(BytesRef word) throws IOException {
        if (this.prefixBuf == null) {
            this.prefixBuf = word;
            this.prefixBufOnLoan = true;
            if (this.seekPrefix()) {
                this.ensureBufIsACopy();
                return true;
            }
            this.prefixBuf = null;
            return false;
        }
        assert (!this.prefixBufOnLoan);
        this.prefixBufBuilder.append((byte)31);
        this.prefixBufBuilder.append(word);
        this.prefixBuf = this.prefixBufBuilder.get();
        if (this.seekPrefix()) {
            return true;
        }
        this.prefixBuf = null;
        return false;
    }

    private void ensureBufIsACopy() {
        if (!this.prefixBufOnLoan) {
            return;
        }
        this.prefixBufBuilder.clear();
        this.prefixBufBuilder.copyBytes(this.prefixBuf);
        this.prefixBuf = this.prefixBufBuilder.get();
        this.prefixBufOnLoan = false;
    }

    private boolean seekPrefix() throws IOException {
        TermsEnum.SeekStatus seekStatus = this.termsEnum.seekCeil(this.prefixBuf);
        this.docIds = null;
        switch (seekStatus) {
            case END: {
                return false;
            }
            case FOUND: {
                this.postingsEnum = this.termsEnum.postings(this.postingsEnum, 0);
                this.docIds = this.postingsEnumToIntsRef(this.postingsEnum, this.liveDocs);
                if (this.docIds.length > 0) {
                    return true;
                }
                this.docIds = null;
                if (this.termsEnum.next() == null) {
                    return false;
                }
            }
            case NOT_FOUND: {
                BytesRef teTerm = this.termsEnum.term();
                if (teTerm.length > this.prefixBuf.length) {
                    for (int i = 0; i < this.prefixBuf.length; ++i) {
                        if (this.prefixBuf.bytes[this.prefixBuf.offset + i] == teTerm.bytes[teTerm.offset + i]) continue;
                        return false;
                    }
                    return teTerm.bytes[teTerm.offset + this.prefixBuf.length] == 31;
                }
                return false;
            }
        }
        throw new IllegalStateException(seekStatus.toString());
    }

    private IntsRef postingsEnumToIntsRef(PostingsEnum postingsEnum, Bits liveDocs) throws IOException {
        int docId;
        if (this.docIdsCache != null) {
            this.docIds = this.docIdsCache.get(this.prefixBuf);
            if (this.docIds != null) {
                return this.docIds;
            }
        }
        this.docIds = new IntsRef(this.termsEnum.docFreq());
        while ((docId = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
            if (liveDocs != null && !liveDocs.get(postingsEnum.docID())) continue;
            this.docIds.ints[this.docIds.length++] = docId;
        }
        if (this.docIds.length == 0) {
            this.docIds = EMPTY_INTSREF;
        }
        if (this.docIdsCache != null) {
            this.ensureBufIsACopy();
            this.docIdsCache.put(this.prefixBuf.clone(), this.docIds);
        }
        return this.docIds;
    }

    IntsRef getDocIds() {
        assert (this.docIds == null || this.docIds.length != 0);
        return this.docIds;
    }
}

