/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.Format;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.Formatter$Tag;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.Indenter;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.Mode;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.NodeException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.OutputBuffer;
import java.io.BufferedWriter;
import java.io.Writer;

class Formatter {
    private static final char[] NAMESPACE = new char[]{'x', 'm', 'l', 'n', 's'};
    private static final char[] LESS = new char[]{'&', 'l', 't', ';'};
    private static final char[] GREATER = new char[]{'&', 'g', 't', ';'};
    private static final char[] DOUBLE = new char[]{'&', 'q', 'u', 'o', 't', ';'};
    private static final char[] SINGLE = new char[]{'&', 'a', 'p', 'o', 's', ';'};
    private static final char[] AND = new char[]{'&', 'a', 'm', 'p', ';'};
    private static final char[] OPEN = new char[]{'<', '!', '-', '-', ' '};
    private static final char[] CLOSE = new char[]{' ', '-', '-', '>'};
    private OutputBuffer buffer;
    private Indenter indenter;
    private Writer result;
    private String prolog;
    private Formatter$Tag last;

    public Formatter(Writer writer, Format format) {
        this.result = new BufferedWriter(writer, 1024);
        this.indenter = new Indenter(format);
        this.buffer = new OutputBuffer();
        this.prolog = format.getProlog();
    }

    public void writeProlog() {
        if (this.prolog != null) {
            this.write(this.prolog);
            this.write("\n");
        }
    }

    public void writeComment(String string) {
        String string2 = this.indenter.top();
        if (this.last == Formatter$Tag.START) {
            this.append('>');
        }
        if (string2 != null) {
            this.append(string2);
            this.append(OPEN);
            this.append(string);
            this.append(CLOSE);
        }
        this.last = Formatter$Tag.COMMENT;
    }

    public void writeStart(String string, String string2) {
        String string3 = this.indenter.push();
        if (this.last == Formatter$Tag.START) {
            this.append('>');
        }
        this.flush();
        this.append(string3);
        this.append('<');
        if (!this.isEmpty(string2)) {
            this.append(string2);
            this.append(':');
        }
        this.append(string);
        this.last = Formatter$Tag.START;
    }

    public void writeAttribute(String string, String string2, String string3) {
        if (this.last != Formatter$Tag.START) {
            throw new NodeException("Start element required");
        }
        this.write(' ');
        this.write(string, string3);
        this.write('=');
        this.write('\"');
        this.escape(string2);
        this.write('\"');
    }

    public void writeNamespace(String string, String string2) {
        if (this.last != Formatter$Tag.START) {
            throw new NodeException("Start element required");
        }
        this.write(' ');
        this.write(NAMESPACE);
        if (!this.isEmpty(string2)) {
            this.write(':');
            this.write(string2);
        }
        this.write('=');
        this.write('\"');
        this.escape(string);
        this.write('\"');
    }

    public void writeText(String string) {
        this.writeText(string, Mode.ESCAPE);
    }

    public void writeText(String string, Mode mode) {
        if (this.last == Formatter$Tag.START) {
            this.write('>');
        }
        if (mode == Mode.DATA) {
            this.data(string);
        } else {
            this.escape(string);
        }
        this.last = Formatter$Tag.TEXT;
    }

    public void writeEnd(String string, String string2) {
        String string3 = this.indenter.pop();
        if (this.last == Formatter$Tag.START) {
            this.write('/');
            this.write('>');
        } else {
            if (this.last != Formatter$Tag.TEXT) {
                this.write(string3);
            }
            if (this.last != Formatter$Tag.START) {
                this.write('<');
                this.write('/');
                this.write(string, string2);
                this.write('>');
            }
        }
        this.last = Formatter$Tag.END;
    }

    private void write(char c) {
        this.buffer.write(this.result);
        this.buffer.clear();
        this.result.write(c);
    }

    private void write(char[] cArray) {
        this.buffer.write(this.result);
        this.buffer.clear();
        this.result.write(cArray);
    }

    private void write(String string) {
        this.buffer.write(this.result);
        this.buffer.clear();
        this.result.write(string);
    }

    private void write(String string, String string2) {
        this.buffer.write(this.result);
        this.buffer.clear();
        if (!this.isEmpty(string2)) {
            this.result.write(string2);
            this.result.write(58);
        }
        this.result.write(string);
    }

    private void append(char c) {
        this.buffer.append(c);
    }

    private void append(char[] cArray) {
        this.buffer.append(cArray);
    }

    private void append(String string) {
        this.buffer.append(string);
    }

    private void data(String string) {
        this.write("<![CDATA[");
        this.write(string);
        this.write("]]>");
    }

    private void escape(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.escape(string.charAt(i));
        }
    }

    private void escape(char c) {
        char[] cArray = this.symbol(c);
        if (cArray != null) {
            this.write(cArray);
        } else {
            this.write(c);
        }
    }

    public void flush() {
        this.buffer.write(this.result);
        this.buffer.clear();
        this.result.flush();
    }

    private String unicode(char c) {
        return Integer.toString(c);
    }

    private boolean isEmpty(String string) {
        if (string != null) {
            return string.length() == 0;
        }
        return true;
    }

    private boolean isText(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        if (c > ' ' && c <= '~') {
            return c != '\u00f7';
        }
        return false;
    }

    private char[] symbol(char c) {
        switch (c) {
            case '<': {
                return LESS;
            }
            case '>': {
                return GREATER;
            }
            case '\"': {
                return DOUBLE;
            }
            case '\'': {
                return SINGLE;
            }
            case '&': {
                return AND;
            }
        }
        return null;
    }
}

