/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Context;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Converter;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Instance;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.PersistenceException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.PrimitiveFactory;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.Type;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.InputNode;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.OutputNode;

class Primitive
implements Converter {
    private final PrimitiveFactory factory;
    private final Context context;
    private final String empty;
    private final Class expect;
    private final Type type;

    public Primitive(Context context, Type type) {
        this(context, type, null);
    }

    public Primitive(Context context, Type type, String string) {
        this.factory = new PrimitiveFactory(context, type);
        this.expect = type.getType();
        this.context = context;
        this.empty = string;
        this.type = type;
    }

    public Object read(InputNode inputNode) {
        if (inputNode.isElement()) {
            return this.readElement(inputNode);
        }
        return this.read(inputNode, this.expect);
    }

    public Object read(InputNode inputNode, Object object) {
        if (object != null) {
            throw new PersistenceException("Can not read existing %s for %s", this.expect, this.type);
        }
        return this.read(inputNode);
    }

    public Object read(InputNode inputNode, Class clazz) {
        String string = inputNode.getValue();
        if (string == null) {
            return null;
        }
        if (this.empty != null && string.equals(this.empty)) {
            return this.empty;
        }
        return this.readTemplate(string, clazz);
    }

    private Object readElement(InputNode inputNode) {
        Instance instance = this.factory.getInstance(inputNode);
        if (!instance.isReference()) {
            return this.readElement(inputNode, instance);
        }
        return instance.getInstance();
    }

    private Object readElement(InputNode inputNode, Instance instance) {
        Object object = this.read(inputNode, this.expect);
        if (instance != null) {
            instance.setInstance(object);
        }
        return object;
    }

    private Object readTemplate(String string, Class clazz) {
        String string2 = this.context.getProperty(string);
        if (string2 != null) {
            return this.factory.getInstance(string2, clazz);
        }
        return null;
    }

    public boolean validate(InputNode inputNode) {
        if (inputNode.isElement()) {
            this.validateElement(inputNode);
        } else {
            inputNode.getValue();
        }
        return true;
    }

    private boolean validateElement(InputNode inputNode) {
        Instance instance = this.factory.getInstance(inputNode);
        if (!instance.isReference()) {
            instance.setInstance(null);
        }
        return true;
    }

    public void write(OutputNode outputNode, Object object) {
        String string = this.factory.getText(object);
        if (string != null) {
            outputNode.setValue(string);
        }
    }
}

