/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class SplitEvaluator
extends RecursiveObjectEvaluator
implements TwoValueWorker {
    protected static final long serialVersionUID = 1L;

    public SplitEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (2 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly 2 values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object value1, Object value2) {
        if (null == value1) {
            return null;
        }
        String s = value1.toString();
        String p = value2.toString();
        String[] tokens = s.split(p, -1);
        ArrayList<String> strings = new ArrayList<String>(tokens.length);
        for (String tok : tokens) {
            strings.add(tok);
        }
        return strings;
    }
}

