/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import java.util.ArrayList;
import java.util.List;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.BuiltinFunction;

@BuiltinFunction(value={"has/1"})
public class HasFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode keyName : args.get(0).apply(scope, in)) {
            if (in.isObject()) {
                if (!keyName.isTextual()) {
                    throw new JsonQueryException("argument 1 of has() must be string for object input");
                }
                out.add((JsonNode)BooleanNode.valueOf((boolean)in.has(keyName.asText())));
                continue;
            }
            if (in.isArray()) {
                if (!keyName.isIntegralNumber()) {
                    throw new JsonQueryException("argument 1 of has() must be int for array input");
                }
                out.add((JsonNode)BooleanNode.valueOf((boolean)in.has(keyName.asInt())));
                continue;
            }
            throw new JsonQueryException("has() is not applicable to " + in.getNodeType());
        }
        return out;
    }
}

