/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.Collections;
import java.util.List;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.JsonNodeComparator;
import net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.jackson.jq.internal.misc.Preconditions;

public abstract class AbstractMaxFunction
implements Function {
    protected static final JsonNodeComparator comparator = JsonNodeComparator.getInstance();
    private String fname;

    public AbstractMaxFunction(String fname) {
        this.fname = fname;
    }

    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputType(this.fname, in, JsonNodeType.ARRAY);
        NullNode maxItem = NullNode.getInstance();
        ArrayNode maxValue = null;
        for (JsonNode i : in) {
            ArrayNode value = JsonNodeUtils.asArrayNode(scope.getObjectMapper(), args.get(0).apply(scope, i));
            if (maxValue != null && this.isLarger((JsonNode)maxValue, (JsonNode)value)) continue;
            maxValue = value;
            maxItem = i;
        }
        return Collections.singletonList(maxItem);
    }

    protected abstract boolean isLarger(JsonNode var1, JsonNode var2);
}

