/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.net.InetAddress;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.server.ServerConstants;
import org.hsqldb.server.ServerProperties;

public final class ServerConfiguration
implements ServerConstants {
    private ServerConfiguration() {
    }

    public static int getDefaultPort(int n, boolean bl) {
        switch (n) {
            case 1: {
                return bl ? 554 : 9001;
            }
            case 0: {
                return bl ? 443 : 80;
            }
            case 2: {
                return bl ? -1 : 9101;
            }
        }
        return -1;
    }

    public static ServerProperties getPropertiesFromFile(int n, String string, String string2) {
        boolean bl;
        if (StringUtil.isEmpty(string)) {
            return null;
        }
        ServerProperties serverProperties = new ServerProperties(n, string, string2);
        try {
            bl = serverProperties.load();
        }
        catch (Exception exception) {
            return null;
        }
        return bl ? serverProperties : null;
    }

    public static String[] listLocalInetAddressNames() {
        InetAddress[] inetAddressArray;
        InetAddress inetAddress;
        HashSet hashSet = new HashSet();
        try {
            int n;
            inetAddress = InetAddress.getLocalHost();
            inetAddressArray = InetAddress.getAllByName(inetAddress.getHostAddress());
            for (n = 0; n < inetAddressArray.length; ++n) {
                hashSet.add(inetAddressArray[n].getHostAddress());
                hashSet.add(inetAddressArray[n].getHostName());
            }
            inetAddressArray = InetAddress.getAllByName(inetAddress.getHostName());
            for (n = 0; n < inetAddressArray.length; ++n) {
                hashSet.add(inetAddressArray[n].getHostAddress());
                hashSet.add(inetAddressArray[n].getHostName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n;
            inetAddress = InetAddress.getByName(null);
            inetAddressArray = InetAddress.getAllByName(inetAddress.getHostAddress());
            for (n = 0; n < inetAddressArray.length; ++n) {
                hashSet.add(inetAddressArray[n].getHostAddress());
                hashSet.add(inetAddressArray[n].getHostName());
            }
            inetAddressArray = InetAddress.getAllByName(inetAddress.getHostName());
            for (n = 0; n < inetAddressArray.length; ++n) {
                hashSet.add(inetAddressArray[n].getHostAddress());
                hashSet.add(inetAddressArray[n].getHostName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            hashSet.add(InetAddress.getByName("loopback").getHostAddress());
            hashSet.add(InetAddress.getByName("loopback").getHostName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object[] objectArray = new String[hashSet.size()];
        hashSet.toArray(objectArray);
        return objectArray;
    }

    public static ServerProperties newDefaultProperties(int n) {
        ServerProperties serverProperties = new ServerProperties(n);
        serverProperties.setProperty("server.restart_on_shutdown", false);
        serverProperties.setProperty("server.address", "0.0.0.0");
        serverProperties.setProperty("server.no_system_exit", true);
        serverProperties.setProperty("server.maxdatabases", 10);
        serverProperties.setProperty("server.silent", true);
        serverProperties.setProperty("server.tls", false);
        serverProperties.setProperty("server.trace", false);
        serverProperties.setProperty("server.default_page", "index.html");
        serverProperties.setProperty("server.root", ".");
        return serverProperties;
    }

    public static void translateAddressProperty(HsqlProperties hsqlProperties) {
        if (hsqlProperties == null) {
            return;
        }
        String string = hsqlProperties.getProperty("server.address");
        if (StringUtil.isEmpty(string)) {
            hsqlProperties.setProperty("server.address", "0.0.0.0");
        }
    }

    public static void translateDefaultDatabaseProperty(HsqlProperties hsqlProperties) {
        if (hsqlProperties == null) {
            return;
        }
        if (!hsqlProperties.isPropertyTrue("server.remote_open")) {
            if (hsqlProperties.getProperty("server.database.0") == null) {
                String string = hsqlProperties.getProperty("server.database");
                if (string == null) {
                    string = "test";
                } else {
                    hsqlProperties.removeProperty("server.database");
                }
                hsqlProperties.setProperty("server.database.0", string);
                hsqlProperties.setProperty("server.dbname.0", "");
            }
            if (hsqlProperties.getProperty("server.dbname.0") == null) {
                hsqlProperties.setProperty("server.dbname.0", "");
            }
        }
    }

    public static void translateDefaultNoSystemExitProperty(HsqlProperties hsqlProperties) {
        if (hsqlProperties == null) {
            return;
        }
        hsqlProperties.setPropertyIfNotExists("server.no_system_exit", "false");
    }
}

