/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.ContextImpl;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataSource;

public class BinContentStreamDataSource
extends DataSource<InputStream> {
    private ContextImpl context;
    private ContentStream contentStream;
    private InputStream in;

    @Override
    public void init(Context context, Properties initProps) {
        this.context = (ContextImpl)context;
    }

    @Override
    public InputStream getData(String query) {
        this.contentStream = this.context.getDocBuilder().getReqParams().getContentStream();
        if (this.contentStream == null) {
            throw new DataImportHandlerException(500, "No stream available. The request has no body");
        }
        try {
            this.in = this.contentStream.getStream();
            return this.in;
        }
        catch (IOException e) {
            DataImportHandlerException.wrapAndThrow(500, e);
            return null;
        }
    }

    @Override
    public void close() {
        if (this.contentStream != null) {
            try {
                if (this.in == null) {
                    this.in = this.contentStream.getStream();
                }
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

